/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;

public class CharAtom
extends CharSymbol {
    private final char c;
    private final String textStyle;

    public CharAtom(char c, String textStyle) {
        this.c = c;
        this.textStyle = textStyle;
    }

    public Box createBox(TeXEnvironment env) {
        Char ch = this.getChar(env.getTeXFont(), env.getStyle());
        return new CharBox(ch);
    }

    private Char getChar(TeXFont tf, int style) {
        if (this.textStyle == null) {
            return tf.getDefaultChar(this.c, style);
        }
        return tf.getChar(this.c, this.textStyle, style);
    }

    public CharFont getCharFont(TeXFont tf) {
        return this.getChar(tf, 0).getCharFont();
    }
}

