/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.scilab.forge.jlatexmath.Box;

public class FramedBox
extends Box {
    private Box box;
    private float thickness;
    private Color line = null;

    public FramedBox(Box box, float thickness) {
        this.box = box;
        this.width = box.width + 2.0f * (thickness += 0.0f);
        this.height = box.height + thickness;
        this.depth = box.depth + thickness;
        this.shift = box.shift;
        this.thickness = thickness;
    }

    public FramedBox(Box box, float thickness, Color line) {
        this(box, thickness);
        this.line = line;
    }

    public void draw(Graphics2D g2, float x, float y) {
        this.box.draw(g2, x, y);
        Stroke st = g2.getStroke();
        AffineTransform oldAt = g2.getTransform();
        g2.setStroke(new BasicStroke(this.thickness, 0, 0));
        if (this.line != null) {
            Color prev = g2.getColor();
            g2.setColor(this.line);
            g2.draw(new Rectangle2D.Float(x, y - this.box.getHeight(), this.box.getWidth(), this.box.getHeight() + this.box.getDepth()));
            g2.setColor(prev);
        } else {
            g2.draw(new Rectangle2D.Float(x, y - this.box.getHeight(), this.box.getWidth(), this.box.getHeight() + this.box.getDepth()));
        }
        g2.setStroke(st);
    }

    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

