/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.GlueSettingsParser;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TeXFormulaSettingsParser {
    public static final String RESOURCE_NAME = "TeXFormulaSettings.xml";
    public static final String CHARTODEL_MAPPING_EL = "Map";
    private Element root;

    public TeXFormulaSettingsParser() throws ResourceParseException {
        this(GlueSettingsParser.class.getResourceAsStream(RESOURCE_NAME), RESOURCE_NAME);
    }

    public TeXFormulaSettingsParser(InputStream file, String name) throws ResourceParseException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringElementContentWhitespace(true);
            factory.setIgnoringComments(true);
            this.root = factory.newDocumentBuilder().parse(file).getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLResourceParseException(name, e);
        }
    }

    public void parseSymbolToFormulaMappings(Atom[] mappings) throws ResourceParseException {
        Element charToSymbol = (Element)this.root.getElementsByTagName("CharacterToFormulaMappings").item(0);
        if (charToSymbol != null) {
            TeXFormulaSettingsParser.addFormulaToMap(charToSymbol.getElementsByTagName(CHARTODEL_MAPPING_EL), mappings);
        }
    }

    public Atom[] parseSymbolToFormulaMappings() throws ResourceParseException {
        Atom[] mappings = new Atom[65536];
        this.parseSymbolToFormulaMappings(mappings);
        return mappings;
    }

    public void parseSymbolMappings(String[] mappings) throws ResourceParseException {
        Element charToSymbol = (Element)this.root.getElementsByTagName("CharacterToSymbolMappings").item(0);
        if (charToSymbol != null) {
            TeXFormulaSettingsParser.addToMap(charToSymbol.getElementsByTagName(CHARTODEL_MAPPING_EL), mappings);
        }
    }

    public String[] parseSymbolMappings() throws ResourceParseException {
        String[] mappings = new String[65536];
        this.parseSymbolMappings(mappings);
        return mappings;
    }

    public String[] parseDelimiterMappings() throws ResourceParseException {
        String[] mappings = new String[256];
        Element charToDelimiter = (Element)this.root.getElementsByTagName("CharacterToDelimiterMappings").item(0);
        if (charToDelimiter != null) {
            TeXFormulaSettingsParser.addToMap(charToDelimiter.getElementsByTagName(CHARTODEL_MAPPING_EL), mappings);
        }
        return mappings;
    }

    private static void addToMap(NodeList mapList, String[] table) throws ResourceParseException {
        for (int i = 0; i < mapList.getLength(); ++i) {
            Element map = (Element)mapList.item(i);
            String ch = map.getAttribute("char");
            String symbol = map.getAttribute("symbol");
            if (ch.equals("")) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "char", null);
            }
            if (symbol.equals("")) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "symbol", null);
            }
            if (ch.length() != 1) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "char", "must have a value that contains exactly 1 character!");
            }
            table[ch.charAt((int)0)] = symbol;
        }
    }

    private static void addFormulaToMap(NodeList mapList, Atom[] table) throws ResourceParseException {
        for (int i = 0; i < mapList.getLength(); ++i) {
            Element map = (Element)mapList.item(i);
            String ch = map.getAttribute("char");
            String formula = map.getAttribute("formula");
            if (ch.equals("")) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "char", null);
            }
            if (formula.equals("")) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "formula", null);
            }
            if (ch.length() != 1) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getTagName(), "char", "must have a value that contains exactly 1 character!");
            }
            table[ch.charAt((int)0)] = new TeXFormula((String)formula).root;
        }
    }
}

