/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Parser;

public class JaguarReader
extends AtomSetCollectionReader {
    int atomCount;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("jaguar");
        try {
            while (this.readLine() != null) {
                if (this.line.startsWith("  final geometry:")) {
                    this.readAtoms();
                    continue;
                }
                if (!this.line.startsWith("  harmonic frequencies in")) continue;
                this.readFrequencies();
                break;
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void readAtoms() throws Exception {
        this.atomSetCollection.discardPreviousAtoms();
        this.discardLines(2);
        while (this.readLine() != null && this.line.length() >= 60 && this.line.charAt(2) != ' ') {
            String string = this.parseToken(this.line, 2, 7);
            float f = this.parseFloat(this.line, 8, 24);
            float f2 = this.parseFloat(this.line, 26, 42);
            float f3 = this.parseFloat(this.line, 44, 60);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) {
                return;
            }
            int n = string.length();
            if (n < 2) {
                return;
            }
            char c = string.charAt(1);
            String string2 = c >= 'a' && c <= 'z' ? string.substring(0, 2) : string.substring(0, 1);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string2;
            atom.atomName = string;
            atom.x = f;
            atom.y = f2;
            atom.z = f3;
        }
    }

    void readFrequencies() throws Exception {
        this.atomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
        int n = 1;
        while (this.readLine() != null && !this.line.startsWith("  intensities ") && !this.line.startsWith("  force ")) {
        }
        if (this.line == null) {
            return;
        }
        do {
            int n2 = Parser.countTokens(this.line, 0) - 1;
            while (this.readLine() != null && !this.line.startsWith("  intensities ")) {
            }
            for (int i = 0; i < this.atomCount; ++i) {
                String[] stringArray = AtomSetCollectionReader.getTokens(this.readLine());
                String[] stringArray2 = AtomSetCollectionReader.getTokens(this.readLine());
                String[] stringArray3 = AtomSetCollectionReader.getTokens(this.readLine());
                for (int j = 0; j < n2; ++j) {
                    this.recordAtomVector(n + j, i, this.parseFloat(stringArray[j + 2]), this.parseFloat(stringArray2[j + 2]), this.parseFloat(stringArray3[j + 2]));
                }
            }
            this.discardLines(1);
            n += n2;
        } while (this.readLine() != null && this.line.startsWith("  frequencies "));
    }

    void recordAtomVector(int n, int n2, float f, float f2, float f3) throws Exception {
        if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3) || n2 <= 0 || n2 > this.atomCount) {
            return;
        }
        if (n2 == 1 && n > 1) {
            this.atomSetCollection.cloneFirstAtomSet();
        }
        Atom atom = this.atomSetCollection.getAtom((n - 1) * this.atomCount + n2 - 1);
        atom.vectorX = f;
        atom.vectorY = f2;
        atom.vectorZ = f3;
    }
}

