/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.bspt.Tuple;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.CellInfo;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.util.TextFormat;
import org.jmol.vecmath.Point3fi;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

public final class Atom
extends Point3fi
implements Tuple {
    static final byte VIBRATION_VECTOR_FLAG = 2;
    static final byte IS_HETERO_FLAG = 4;
    static final byte FORMALCHARGE_FLAGS = 7;
    Group group;
    int atomIndex;
    BitSet atomSymmetry;
    int atomSite;
    public short screenDiameter;
    public float radius;
    short modelIndex;
    private short atomicAndIsotopeNumber;
    byte formalChargeAndFlags;
    byte alternateLocationID;
    short madAtom;
    short colixAtom;
    byte paletteID = 1;
    Bond[] bonds;
    int nBondsDisplayed = 0;
    int nBackbonesDisplayed = 0;
    int clickabilityFlags;
    int shapeVisibilityFlags;
    boolean isSimple = false;
    private static Hashtable htAtom = new Hashtable();

    public int getScreenRadius() {
        return this.screenDiameter / 2;
    }

    public short getMadAtom() {
        return this.madAtom;
    }

    public int getNBackbonesDisplayed() {
        return this.nBackbonesDisplayed;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public Atom(Point3f point3f) {
        this.isSimple = true;
        ((Tuple3f)this).x = point3f.x;
        ((Tuple3f)this).y = point3f.y;
        ((Tuple3f)this).z = point3f.z;
        this.formalChargeAndFlags = 0;
        this.madAtom = 0;
    }

    Atom(ModelLoader modelLoader, int n, int n2, BitSet bitSet, int n3, short s, String string, short s2, int n4, float f, int n5, float f2, float f3, float f4, float f5, boolean bl, int n6, char c, String string2, float f6, float f7, float f8, char c2, Object object, float f9) {
        byte by;
        this.group = modelLoader.nullGroup;
        this.modelIndex = (short)n;
        this.atomSymmetry = bitSet;
        this.atomSite = n3;
        this.atomIndex = n2;
        this.atomicAndIsotopeNumber = s;
        this.setFormalCharge(n4);
        this.colixAtom = modelLoader.viewer.getColixAtomPalette(this, (byte)1);
        this.alternateLocationID = (byte)c2;
        this.radius = f9;
        this.setMadAtom(s2);
        ((Tuple3f)this).x = f3;
        ((Tuple3f)this).y = f4;
        ((Tuple3f)this).z = f5;
        if (bl) {
            this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 4);
        }
        if (string != null) {
            if (modelLoader.atomNames == null) {
                modelLoader.atomNames = new String[modelLoader.atoms.length];
            }
            modelLoader.atomNames[n2] = string.intern();
        }
        if ((by = this.lookupSpecialAtomID(string)) == 2 && string2 != null && string2.equalsIgnoreCase("CA")) {
            by = 0;
        }
        if (by != 0) {
            if (modelLoader.specialAtomIDs == null) {
                modelLoader.specialAtomIDs = new byte[modelLoader.atoms.length];
            }
            modelLoader.specialAtomIDs[n2] = by;
        }
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 > 100) {
            n5 = 100;
        }
        if (n5 != 100) {
            if (modelLoader.occupancies == null) {
                modelLoader.occupancies = new byte[modelLoader.atoms.length];
            }
            modelLoader.occupancies[n2] = (byte)n5;
        }
        if (n6 != Integer.MIN_VALUE) {
            if (modelLoader.atomSerials == null) {
                modelLoader.atomSerials = new int[modelLoader.atoms.length];
            }
            modelLoader.atomSerials[n2] = n6;
        }
        if (!Float.isNaN(f)) {
            if (modelLoader.partialCharges == null) {
                modelLoader.partialCharges = new float[modelLoader.atoms.length];
            }
            modelLoader.partialCharges[n2] = f;
        }
        if (!Float.isNaN(f2) && f2 != 0.0f) {
            if (modelLoader.bfactor100s == null) {
                modelLoader.bfactor100s = new short[modelLoader.atoms.length];
            }
            modelLoader.bfactor100s[n2] = (short)(f2 * 100.0f);
        }
        if (!(Float.isNaN(f6) || Float.isNaN(f7) || Float.isNaN(f8))) {
            if (modelLoader.vibrationVectors == null) {
                modelLoader.vibrationVectors = new Vector3f[modelLoader.atoms.length];
            }
            modelLoader.vibrationVectors[n2] = new Vector3f(f6, f7, f8);
            this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags | 2);
        }
        if (object != null) {
            if (modelLoader.clientAtomReferences == null) {
                modelLoader.clientAtomReferences = new Object[modelLoader.atoms.length];
            }
            modelLoader.clientAtomReferences[n2] = object;
        }
    }

    static String generatePrimeAtomName(String string) {
        int n = string.indexOf(42);
        if (n < 0) {
            return string;
        }
        return string.replace('*', '\'');
    }

    byte lookupSpecialAtomID(String string) {
        Integer n;
        if (string != null && (n = (Integer)htAtom.get(string = Atom.generatePrimeAtomName(string))) != null) {
            return (byte)n.intValue();
        }
        return 0;
    }

    public final void setShapeVisibilityFlags(int n) {
        this.shapeVisibilityFlags = n;
    }

    public final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    void setFormalCharge(int n) {
        this.formalChargeAndFlags = (byte)(this.formalChargeAndFlags & 7 | n << 3);
    }

    public boolean isBonded(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(this) != atom) continue;
                return true;
            }
        }
        return false;
    }

    public Bond getBond(Atom atom) {
        if (this.bonds != null) {
            int n = this.bonds.length;
            while (--n >= 0) {
                if (this.bonds[n].getOtherAtom(atom) == null) continue;
                return this.bonds[n];
            }
        }
        return null;
    }

    void addDisplayedBond(int n, boolean bl) {
        this.nBondsDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, bl);
    }

    public void addDisplayedBackbone(int n, boolean bl) {
        this.nBackbonesDisplayed += bl ? 1 : -1;
        this.setShapeVisibility(n, bl);
    }

    void deleteBond(Bond bond) {
        int n = this.bonds.length;
        while (--n >= 0) {
            if (this.bonds[n] != bond) continue;
            this.deleteBond(n);
            return;
        }
    }

    private void deleteBond(int n) {
        int n2;
        int n3 = this.bonds.length - 1;
        if (n3 == 0) {
            this.bonds = null;
            return;
        }
        Bond[] bondArray = new Bond[n3];
        for (n2 = 0; n2 < n; ++n2) {
            bondArray[n2] = this.bonds[n2];
        }
        while (n2 < n3) {
            bondArray[n2] = this.bonds[n2 + 1];
            ++n2;
        }
        this.bonds = bondArray;
    }

    void clearBonds() {
        this.bonds = null;
    }

    int getBondedAtomIndex(int n) {
        return this.bonds[n].getOtherAtom((Atom)this).atomIndex;
    }

    public void setMadAtom(short s) {
        this.madAtom = this.convertEncodedMad(s);
    }

    public short convertEncodedMad(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == -1000) {
            int n2 = this.getBfactor100() * 10 * 2;
            if (n2 > 4000) {
                n2 = 4000;
            }
            n = n2;
        } else if (n == -1001) {
            n = this.getBondingMar() * 2;
        } else if (n == -100) {
            n = this.getVanderwaalsMar() * 2;
        } else if (n < 0) {
            if ((n = -n) > 200) {
                n = 200;
            }
            n = (int)((float)n / 100.0f * (float)this.getVanderwaalsMar() * 2.0f);
        } else if (n >= 10000) {
            n = n - 10000 + this.getVanderwaalsMar() * 2;
        }
        return (short)n;
    }

    public int getRasMolRadius() {
        return Math.abs(this.madAtom / 8);
    }

    public int getCovalentBondCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            if ((this.bonds[n2].order & 7) == 0) continue;
            ++n;
        }
        return n;
    }

    int getCovalentHydrogenCount() {
        if (this.bonds == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.bonds.length;
        while (--n2 >= 0) {
            if ((this.bonds[n2].order & 7) == 0 || this.bonds[n2].getOtherAtom(this).getElementNumber() != 1) continue;
            ++n;
        }
        return n;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public void setColixAtom(short s) {
        this.colixAtom = s;
    }

    public void setPaletteID(byte by) {
        this.paletteID = by;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colixAtom = Graphics3D.getColixTranslucent((short)this.colixAtom, (boolean)bl, (float)f);
    }

    public boolean isTranslucent() {
        return Graphics3D.isColixTranslucent((short)this.colixAtom);
    }

    public short getElementNumber() {
        return (short)(this.atomicAndIsotopeNumber % 128);
    }

    public short getIsotopeNumber() {
        return (short)(this.atomicAndIsotopeNumber >> 7);
    }

    public short getAtomicAndIsotopeNumber() {
        return this.atomicAndIsotopeNumber;
    }

    public String getElementSymbol() {
        return JmolConstants.elementSymbolFromNumber(this.atomicAndIsotopeNumber);
    }

    public byte getAlternateLocationID() {
        return this.alternateLocationID;
    }

    boolean isAlternateLocationMatch(String string) {
        if (string == null) {
            return this.alternateLocationID == 0;
        }
        if (string.length() != 1) {
            return false;
        }
        char c = string.charAt(0);
        return c == '*' || c == '?' && this.alternateLocationID != 0 || this.alternateLocationID == c;
    }

    public boolean isHetero() {
        return (this.formalChargeAndFlags & 4) != 0;
    }

    public int getFormalCharge() {
        return this.formalChargeAndFlags >> 3;
    }

    float getAtomX() {
        return ((Tuple3f)this).x;
    }

    float getAtomY() {
        return ((Tuple3f)this).y;
    }

    float getAtomZ() {
        return ((Tuple3f)this).z;
    }

    public float getDimensionValue(int n) {
        return n == 0 ? ((Tuple3f)this).x : (n == 1 ? ((Tuple3f)this).y : ((Tuple3f)this).z);
    }

    short getVanderwaalsMar() {
        return JmolConstants.vanderwaalsMars[this.atomicAndIsotopeNumber % 128];
    }

    public float getVanderwaalsRadiusFloat() {
        return Float.isNaN(this.radius) ? (float)JmolConstants.vanderwaalsMars[this.atomicAndIsotopeNumber % 128] / 1000.0f : this.radius;
    }

    short getBondingMar() {
        return JmolConstants.getBondingMar(this.atomicAndIsotopeNumber % 128, this.formalChargeAndFlags >> 3);
    }

    public float getBondingRadiusFloat() {
        return (float)this.getBondingMar() / 1000.0f;
    }

    int getCurrentBondCount() {
        return this.bonds == null ? 0 : this.bonds.length;
    }

    Bond getLongestBondToDiscard(Atom atom) {
        float f = this.distanceSquared((Point3f)atom);
        Bond bond = null;
        int n = this.bonds.length;
        while (--n >= 0) {
            Bond bond2 = this.bonds[n];
            float f2 = this.distanceSquared((Point3f)bond2.getOtherAtom(this));
            if (!(f2 > f)) continue;
            bond = bond2;
            f = f2;
        }
        return bond;
    }

    public short getColix() {
        return this.colixAtom;
    }

    public byte getPaletteID() {
        return this.paletteID;
    }

    public float getRadius() {
        return Math.abs((float)this.madAtom / 2000.0f);
    }

    public int getAtomIndex() {
        return this.atomIndex;
    }

    public int getAtomSite() {
        return this.atomSite;
    }

    public BitSet getAtomSymmetry() {
        return this.atomSymmetry;
    }

    boolean isInLatticeCell(Point3f point3f) {
        return this.isInLatticeCell(point3f, 0.02f);
    }

    boolean isInLatticeCell(Point3f point3f, float f) {
        Point3f point3f2 = this.getFractionalCoord();
        if (point3f2.x < point3f.x - 1.0f - f || point3f2.x > point3f.x + f) {
            return false;
        }
        if (point3f2.y < point3f.y - 1.0f - f || point3f2.y > point3f.y + f) {
            return false;
        }
        return !(point3f2.z < point3f.z - 1.0f - f) && !(point3f2.z > point3f.z + f);
    }

    void setGroup(Group group) {
        this.group = group;
    }

    public Group getGroup() {
        return this.group;
    }

    public Vector3f getVibrationVector() {
        Vector3f[] vector3fArray = this.group.chain.modelSet.vibrationVectors;
        return vector3fArray == null ? null : vector3fArray[this.atomIndex];
    }

    /*
     * Unable to fully structure code
     */
    public void transform(Viewer var1_1) {
        if ((this.formalChargeAndFlags & 2) == 0) ** GOTO lbl-1000
        var3_2 = this.group.chain.modelSet.vibrationVectors;
        if (this.group.chain.modelSet.vibrationVectors == null) lbl-1000:
        // 2 sources

        {
            var2_3 = var1_1.transformPoint((Point3f)this);
        } else {
            var2_3 = var1_1.transformPoint((Point3f)this, var3_2[this.atomIndex]);
        }
        this.screenX = var2_3.x;
        this.screenY = var2_3.y;
        this.screenZ = var2_3.z;
        this.screenDiameter = var1_1.scaleToScreen(this.screenZ, Math.abs(this.madAtom));
    }

    String getAtomNameOrNull() {
        String[] stringArray = this.group.chain.modelSet.atomNames;
        return stringArray == null ? null : stringArray[this.atomIndex];
    }

    String getAtomName() {
        String string = this.getAtomNameOrNull();
        return string != null ? string : this.getElementSymbol();
    }

    String getPdbAtomName4() {
        String string = this.getAtomNameOrNull();
        return string != null ? string : "";
    }

    boolean isAtomNameMatch(String string) {
        int n;
        String string2 = this.getAtomNameOrNull();
        int n2 = string2 == null ? 0 : string2.length();
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            if (c == '?' || n < n2 && c == Character.toUpperCase(string2.charAt(n))) continue;
            return false;
        }
        return n >= n2;
    }

    public int getAtomNumber() {
        int[] nArray = this.group.chain.modelSet.atomSerials;
        return nArray != null ? nArray[this.atomIndex] : this.atomIndex;
    }

    public boolean isModelVisible() {
        return (this.shapeVisibilityFlags & 1) != 0;
    }

    public int getShapeVisibilityFlags() {
        return this.shapeVisibilityFlags;
    }

    public boolean isShapeVisible(int n) {
        return this.isModelVisible() && (this.shapeVisibilityFlags & n) != 0;
    }

    public float getPartialCharge() {
        float[] fArray = this.group.chain.modelSet.partialCharges;
        return fArray == null ? 0.0f : fArray[this.atomIndex];
    }

    int getArgb() {
        return this.group.chain.modelSet.viewer.getColixArgb(this.colixAtom);
    }

    public int getOccupancy() {
        byte[] byArray = this.group.chain.modelSet.occupancies;
        return byArray == null ? 100 : byArray[this.atomIndex];
    }

    public int getBfactor100() {
        short[] sArray = this.group.chain.modelSet.bfactor100s;
        if (sArray == null) {
            return 0;
        }
        return sArray[this.atomIndex];
    }

    public int getSymmetryTranslation(int n, int[] nArray, int n2) {
        int n3 = n;
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.atomSymmetry.get(n3 += n2)) continue;
            return nArray[i];
        }
        return 0;
    }

    private String getSymmetryOperatorList() {
        int n;
        String string = "";
        ModelSet modelSet = this.group.chain.modelSet;
        if (this.atomSymmetry == null || modelSet.cellInfos == null || modelSet.cellInfos[this.modelIndex] == null) {
            return string;
        }
        int[] nArray = modelSet.getModelCellRange(this.modelIndex);
        int n2 = n = modelSet.getModelSymmetryCount(this.modelIndex);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!this.atomSymmetry.get(n2++)) continue;
                string = string + "," + (j + 1) + "" + nArray[i];
            }
        }
        return string.substring(1);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getMoleculeNumber() {
        return this.group.chain.modelSet.getMoleculeIndex(this.atomIndex) + 1;
    }

    String getClientAtomStringProperty(String string) {
        Object[] objectArray = this.group.chain.modelSet.clientAtomReferences;
        return objectArray == null || objectArray.length <= this.atomIndex ? null : this.group.chain.modelSet.viewer.getClientAtomStringProperty(objectArray[this.atomIndex], string);
    }

    public byte getSpecialAtomID() {
        byte[] byArray = this.group.chain.modelSet.specialAtomIDs;
        return byArray == null ? (byte)0 : byArray[this.atomIndex];
    }

    public float getFractionalCoord(char c) {
        Point3f point3f = this.getFractionalCoord();
        return c == 'X' ? point3f.x : (c == 'Y' ? point3f.y : point3f.z);
    }

    Point3f getFractionalCoord() {
        CellInfo[] cellInfoArray = this.group.chain.modelSet.cellInfos;
        if (cellInfoArray == null) {
            return this;
        }
        Point3f point3f = new Point3f((Point3f)this);
        cellInfoArray[this.modelIndex].toFractional(point3f);
        return point3f;
    }

    boolean isCursorOnTopOf(int n, int n2, int n3, Atom atom) {
        int n4;
        int n5;
        int n6;
        int n7 = this.screenDiameter / 2;
        if (n7 < n3) {
            n7 = n3;
        }
        if ((n6 = (n5 = this.screenX - n) * n5) > (n4 = n7 * n7)) {
            return false;
        }
        int n8 = this.screenY - n2;
        int n9 = n8 * n8;
        int n10 = n4 - (n6 + n9);
        if (n10 < 0) {
            return false;
        }
        if (atom == null) {
            return true;
        }
        int n11 = this.screenZ;
        int n12 = atom.screenZ;
        int n13 = atom.screenDiameter / 2;
        if (n11 < n12 - n13) {
            return true;
        }
        int n14 = atom.screenX - n;
        int n15 = n14 * n14;
        int n16 = atom.screenY - n2;
        int n17 = n16 * n16;
        int n18 = n13 * n13;
        int n19 = n18 - (n15 + n17);
        return (double)n11 - Math.sqrt(n10) < (double)n12 - Math.sqrt(n19);
    }

    public String getInfo() {
        return this.getIdentity();
    }

    String getInfoXYZ(boolean bl) {
        return this.getIdentity() + " " + ((Tuple3f)this).x + " " + ((Tuple3f)this).y + " " + ((Tuple3f)this).z + (bl ? " ### " + this.screenX + " " + this.screenY + " " + this.screenZ : "");
    }

    public String getIdentity() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getGroup3();
        String string3 = this.getSeqcodeString();
        char c = this.getChainID();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append("[");
            stringBuffer.append(string2);
            stringBuffer.append("]");
        }
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        if (c != '\u0000' && c != ' ') {
            stringBuffer.append(":");
            stringBuffer.append(c);
        }
        if ((string = this.getAtomNameOrNull()) != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(string);
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(this.getElementSymbol());
            stringBuffer.append(" ");
            stringBuffer.append(this.getAtomNumber());
        }
        if (this.alternateLocationID > 0) {
            stringBuffer.append("%");
            stringBuffer.append((char)this.alternateLocationID);
        }
        if (this.group.chain.modelSet.getModelCount() > 1) {
            stringBuffer.append("/");
            stringBuffer.append(this.getModelNumberDotted());
        }
        stringBuffer.append(" #");
        stringBuffer.append(this.getAtomNumber());
        return stringBuffer.toString();
    }

    String getGroup3() {
        return this.group.getGroup3();
    }

    String getGroup1() {
        char c = this.group.getGroup1();
        return c == '\u0000' ? "" : "" + c;
    }

    boolean isGroup3(String string) {
        return this.group.isGroup3(string);
    }

    boolean isGroup3Match(String string) {
        return this.group.isGroup3Match(string);
    }

    boolean isProtein() {
        return this.group.isProtein();
    }

    boolean isCarbohydrate() {
        return this.group.isCarbohydrate();
    }

    boolean isNucleic() {
        return this.group.isNucleic();
    }

    boolean isDna() {
        return this.group.isDna();
    }

    boolean isRna() {
        return this.group.isRna();
    }

    boolean isPurine() {
        return this.group.isPurine();
    }

    boolean isPyrimidine() {
        return this.group.isPyrimidine();
    }

    int getSeqcode() {
        return this.group.getSeqcode();
    }

    public int getResno() {
        return this.group.getResno();
    }

    boolean isGroup3OrNameMatch(String string) {
        return this.getGroup3().length() > 0 ? this.isGroup3Match(string) : this.isAtomNameMatch(string);
    }

    public boolean isClickable() {
        if (!this.isVisible()) {
            return false;
        }
        int n = this.shapeVisibilityFlags | this.group.shapeVisibilityFlags;
        return (n & this.clickabilityFlags) != 0;
    }

    public int getClickabilityFlags() {
        return this.clickabilityFlags;
    }

    public void setClickable(int n) {
        this.clickabilityFlags = n == 0 ? 0 : (this.clickabilityFlags |= n);
    }

    boolean isVisible() {
        if (!this.isModelVisible() || this.group.chain.modelSet.isAtomHidden(this.atomIndex)) {
            return false;
        }
        int n = this.shapeVisibilityFlags;
        return ((n |= this.group.shapeVisibilityFlags) & 0xFFFFFFFE) != 0;
    }

    public float getGroupPhi() {
        return this.group.phi;
    }

    public float getGroupPsi() {
        return this.group.psi;
    }

    public char getChainID() {
        return this.group.chain.chainID;
    }

    public int getSurfaceDistance100() {
        return this.group.chain.modelSet.getSurfaceDistance100(this.atomIndex);
    }

    public int getPolymerLength() {
        return this.group.getBioPolymerLength();
    }

    int getPolymerIndex() {
        return this.group.getBioPolymerIndex();
    }

    public int getSelectedGroupCountWithinChain() {
        return this.group.chain.getSelectedGroupCount();
    }

    public int getSelectedGroupIndexWithinChain() {
        return this.group.getSelectedGroupIndex();
    }

    public int getSelectedMonomerCountWithinPolymer() {
        return this.group.getSelectedMonomerCount();
    }

    public int getSelectedMonomerIndexWithinPolymer() {
        return this.group.getSelectedMonomerIndex();
    }

    Chain getChain() {
        return this.group.chain;
    }

    Model getModel() {
        return this.group.chain.model;
    }

    String getModelNumberDotted() {
        return this.group.chain.model.modelNumberDotted;
    }

    public int getModelNumber() {
        return this.group.chain.model.modelNumber;
    }

    public int getModelFileIndex() {
        return this.group.chain.model.fileIndex;
    }

    int getModelInFileIndex() {
        return this.group.chain.model.modelInFileIndex;
    }

    public int getModelFileNumber() {
        return this.group.chain.model.modelFileNumber;
    }

    public byte getProteinStructureType() {
        return this.group.getProteinStructureType();
    }

    public int getProteinStructureID() {
        return this.group.getProteinStructureID();
    }

    public int setProteinStructureType(byte by, int n) {
        return this.group.setProteinStructureType(by, n);
    }

    public short getGroupID() {
        return this.group.groupID;
    }

    String getSeqcodeString() {
        return this.group.getSeqcodeString();
    }

    int getSeqNumber() {
        return this.group.getSeqNumber();
    }

    public char getInsertionCode() {
        return this.group.getInsertionCode();
    }

    public String formatLabel(String string) {
        return this.formatLabel(string, '\u0000', null);
    }

    public String formatLabel(String string, char c, int[] nArray) {
        int n;
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = "";
        int n2 = string.length();
        int n3 = 0;
        while ((n = string.indexOf(37, n3)) != -1) {
            if (n3 != n) {
                string2 = string2 + string.substring(n3, n);
            }
            n3 = n + 1;
            try {
                char c2;
                String string3 = "";
                float f = Float.NaN;
                boolean bl = false;
                if (string.charAt(n3) == '-') {
                    bl = true;
                    ++n3;
                }
                boolean bl2 = false;
                if (string.charAt(n3) == '0') {
                    bl2 = true;
                    ++n3;
                }
                int n4 = 0;
                while ((c2 = string.charAt(n3)) >= '0' && c2 <= '9') {
                    n4 = 10 * n4 + (c2 - 48);
                    ++n3;
                }
                int n5 = Integer.MAX_VALUE;
                if (string.charAt(n3) == '.' && (c2 = string.charAt(++n3)) >= '0' && c2 <= '9') {
                    n5 = c2 - 48;
                }
                int n6 = ++n3;
                char c3 = c2 = string.charAt(n6);
                if (c != '\u0000' && ++n3 < n2 && c2 != 'v' && c2 != 'u') {
                    if (string.charAt(n3) != c) {
                        string2 = string2 + "%";
                        n3 = n + 1;
                        continue;
                    }
                    ++n3;
                }
                switch (c2) {
                    case 'i': {
                        string3 = "" + this.getAtomNumber();
                        break;
                    }
                    case 'A': {
                        string3 = this.alternateLocationID != 0 ? (char)this.alternateLocationID + "" : "";
                        break;
                    }
                    case 'a': {
                        string3 = this.getAtomName();
                        break;
                    }
                    case 'e': {
                        string3 = this.getElementSymbol();
                        break;
                    }
                    case 'E': {
                        c2 = this.getInsertionCode();
                        string3 = c2 == '\u0000' ? "" : "" + c2;
                        break;
                    }
                    case 'g': {
                        string3 = "" + this.getSelectedGroupIndexWithinChain();
                        break;
                    }
                    case 'x': {
                        f = ((Tuple3f)this).x;
                        break;
                    }
                    case 'y': {
                        f = ((Tuple3f)this).y;
                        break;
                    }
                    case 'z': {
                        f = ((Tuple3f)this).z;
                        break;
                    }
                    case 'X': 
                    case 'Y': 
                    case 'Z': {
                        f = this.getFractionalCoord(c2);
                        break;
                    }
                    case 'D': {
                        string3 = "" + (nArray == null ? this.atomIndex : nArray[this.atomIndex]);
                        break;
                    }
                    case 'C': {
                        int n7 = this.getFormalCharge();
                        if (n7 > 0) {
                            string3 = "" + n7 + "+";
                            break;
                        }
                        if (n7 < 0) {
                            string3 = "" + -n7 + "-";
                            break;
                        }
                        string3 = "0";
                        break;
                    }
                    case 'o': {
                        string3 = this.getSymmetryOperatorList();
                        break;
                    }
                    case 'P': {
                        f = this.getPartialCharge();
                        break;
                    }
                    case 'V': {
                        f = this.getVanderwaalsRadiusFloat();
                        break;
                    }
                    case 'I': {
                        f = this.getBondingRadiusFloat();
                        break;
                    }
                    case 'b': 
                    case 't': {
                        f = (float)this.getBfactor100() / 100.0f;
                        break;
                    }
                    case 'q': {
                        string3 = "" + this.getOccupancy();
                        break;
                    }
                    case 'Q': {
                        f = (float)this.getOccupancy() / 100.0f;
                        break;
                    }
                    case 'c': 
                    case 's': {
                        c2 = this.getChainID();
                        string3 = c2 == '\u0000' ? "" : "" + c2;
                        break;
                    }
                    case 'S': {
                        string3 = "" + this.atomSite;
                        break;
                    }
                    case 'L': {
                        string3 = "" + this.getPolymerLength();
                        break;
                    }
                    case 'M': {
                        string3 = this.getModelNumberDotted();
                        break;
                    }
                    case 'm': {
                        string3 = this.getGroup1();
                        break;
                    }
                    case 'n': {
                        string3 = this.getGroup3();
                        if (string3 != null && string3.length() != 0) break;
                        string3 = "UNK";
                        break;
                    }
                    case 'r': {
                        string3 = this.getSeqcodeString();
                        break;
                    }
                    case 'R': {
                        string3 = "" + this.getResno();
                        break;
                    }
                    case 'U': {
                        string3 = this.getIdentity();
                        break;
                    }
                    case 'u': {
                        f = (float)this.getSurfaceDistance100() / 100.0f;
                        break;
                    }
                    case 'N': {
                        string3 = "" + this.getMoleculeNumber();
                        break;
                    }
                    case '%': {
                        string3 = "%";
                        break;
                    }
                    case '{': {
                        int n8 = string.indexOf(125, n3);
                        if (n8 > n3) {
                            String string4 = string.substring(n3, n8);
                            f = Viewer.getDataFloat(string4, this.atomIndex);
                            if (Float.isNaN(f)) {
                                string3 = this.getClientAtomStringProperty(string4);
                            }
                            if (string3 != null || !Float.isNaN(f)) {
                                n3 = n8 + 1;
                                break;
                            }
                        }
                    }
                    default: {
                        string3 = "%" + c3;
                    }
                }
                if (!Float.isNaN(f)) {
                    string2 = string2 + TextFormat.format((float)f, (int)n4, (int)n5, (boolean)bl, (boolean)bl2);
                    continue;
                }
                if (string3 == null) continue;
                string2 = string2 + TextFormat.format((String)string3, (int)n4, (int)n5, (boolean)bl, (boolean)bl2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n3 = n;
                break;
            }
        }
        if ((string2 = string2 + string.substring(n3)).length() == 0) {
            return null;
        }
        return string2.intern();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.atomIndex;
    }

    static {
        int n = JmolConstants.specialAtomNames.length;
        while (--n >= 0) {
            String string = JmolConstants.specialAtomNames[n];
            if (string == null) continue;
            Integer n2 = new Integer(n);
            htAtom.put(string, n2);
        }
    }
}

