/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Bbcage;
import org.jmol.shape.ShapeRenderer;
import org.jmol.viewer.Viewer;

public class BbcageRenderer
extends ShapeRenderer {
    final Point3i[] screens = new Point3i[8];

    public BbcageRenderer() {
        int n = 8;
        while (--n >= 0) {
            this.screens[n] = new Point3i();
        }
    }

    protected void render() {
        short s = this.viewer.getObjectMad(4);
        if (s == 0 || !this.g3d.checkTranslucent(false)) {
            return;
        }
        this.g3d.setColix(this.viewer.getObjectColix(4));
        BbcageRenderer.render(this.viewer, this.g3d, s, this.modelSet.getBboxVertices(), this.screens, 0);
    }

    static void render(Viewer viewer, Graphics3D graphics3D, short s, Point3f[] point3fArray, Point3i[] point3iArray, int n) {
        int n2 = 0;
        int n3 = 8;
        while (--n3 >= 0) {
            viewer.transformPoint(point3fArray[n3], point3iArray[n3]);
            n2 += point3iArray[n3].z;
        }
        if (s > 0 && s < 2) {
            s = (short)2;
        }
        n3 = s;
        if (s >= 20) {
            n3 = viewer.scaleToScreen(n2 / 8, s);
        }
        for (int i = n * 2; i < 24; i += 2) {
            if (s < 0) {
                graphics3D.drawDottedLine(point3iArray[Bbcage.edges[i]], point3iArray[Bbcage.edges[i + 1]]);
                continue;
            }
            graphics3D.fillCylinder((byte)3, n3, point3iArray[Bbcage.edges[i]], point3iArray[Bbcage.edges[i + 1]]);
        }
    }
}

