/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.shape.ShapeRenderer;

public class SticksRenderer
extends ShapeRenderer {
    boolean showMultipleBonds;
    byte modeMultipleBond;
    byte endcaps;
    boolean ssbondsBackbone;
    boolean hbondsBackbone;
    boolean bondsBackbone;
    boolean hbondsSolid;
    Atom atomA;
    Atom atomB;
    Bond bond;
    int xA;
    int yA;
    int zA;
    int xB;
    int yB;
    int zB;
    int dx;
    int dy;
    int mag2d;
    short colixA;
    short colixB;
    int width;
    int bondOrder;
    short madBond;
    int xAxis1;
    int yAxis1;
    int xAxis2;
    int yAxis2;
    int dxStep;
    int dyStep;
    private static int wideWidthMilliAngstroms = 400;

    protected void render() {
        this.endcaps = (byte)3;
        this.showMultipleBonds = this.viewer.getShowMultipleBonds();
        this.modeMultipleBond = this.viewer.getModeMultipleBond();
        this.ssbondsBackbone = this.viewer.getSsbondsBackbone();
        this.hbondsBackbone = this.viewer.getHbondsBackbone();
        this.bondsBackbone = this.hbondsBackbone | this.ssbondsBackbone;
        this.hbondsSolid = this.viewer.getHbondsSolid();
        Bond[] bondArray = this.modelSet.getBonds();
        int n = this.modelSet.getBondCount();
        while (--n >= 0) {
            this.bond = bondArray[n];
            if ((this.bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0) continue;
            this.renderBond();
        }
    }

    void renderBond() {
        this.madBond = this.bond.getMad();
        short s = this.bond.getOrder();
        this.atomA = this.bond.getAtom1();
        this.atomB = this.bond.getAtom2();
        if (!this.atomA.isModelVisible() || !this.atomB.isModelVisible() || !this.g3d.isInDisplayRange(this.atomA.screenX, this.atomA.screenY) || !this.g3d.isInDisplayRange(this.atomB.screenX, this.atomB.screenY) || this.modelSet.isAtomHidden(this.atomA.getAtomIndex()) || this.modelSet.isAtomHidden(this.atomB.getAtomIndex())) {
            return;
        }
        short s2 = this.bond.getColix();
        this.colixA = Graphics3D.getColixInherited((short)s2, (short)this.atomA.getColix());
        this.colixB = Graphics3D.getColixInherited((short)s2, (short)this.atomB.getColix());
        if (this.bondsBackbone) {
            if (this.ssbondsBackbone && (s & 0x40) != 0) {
                this.atomA = this.atomA.getGroup().getLeadAtom(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtom(this.atomB);
            } else if (this.hbondsBackbone && (s & 0x780) != 0) {
                this.atomA = this.atomA.getGroup().getLeadAtom(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtom(this.atomB);
            }
        }
        this.xA = this.atomA.screenX;
        this.yA = this.atomA.screenY;
        this.zA = this.atomA.screenZ;
        this.xB = this.atomB.screenX;
        this.yB = this.atomB.screenY;
        this.zB = this.atomB.screenZ;
        if (this.zA == 1 || this.zB == 1) {
            return;
        }
        this.dx = this.xB - this.xA;
        this.dy = this.yB - this.yA;
        this.width = this.viewer.scaleToScreen((this.zA + this.zB) / 2, this.bond.getMad());
        this.bondOrder = this.getRenderBondOrder(this.bond.getOrder());
        switch (this.bondOrder) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.renderCylinder(0);
                break;
            }
            case 7: 
            case 2049: {
                this.bondOrder = 1;
                this.renderCylinder(1);
                break;
            }
            case 9: 
            case 4098: {
                this.bondOrder = 2;
                this.renderCylinder(this.getAromaticDottedBondMask(this.bond));
                break;
            }
            case 17: 
            case 34: {
                this.renderTriangle(this.bond);
                break;
            }
            default: {
                if ((this.bondOrder & 0x780) == 0) break;
                if (this.hbondsSolid) {
                    this.bondOrder = 1;
                    this.renderCylinder(0);
                    break;
                }
                this.renderHbondDashed();
            }
        }
    }

    int getRenderBondOrder(int n) {
        if ((n & 0x40) != 0) {
            n &= 0xFFFFFFBF;
        }
        if ((n & 0x1800) != 0) {
            return n;
        }
        if ((n & 7) != 0 && (n == 1 || !this.showMultipleBonds || this.modeMultipleBond == 0 || this.modeMultipleBond == 2 && this.madBond > 500)) {
            return 1;
        }
        return n;
    }

    private void renderCylinder(int n) {
        boolean bl;
        boolean bl2 = bl = this.width <= 1;
        if (this.dx == 0 && this.dy == 0) {
            if (!bl) {
                int n2 = this.width / 8 + 3;
                int n3 = this.width + n2;
                int n4 = this.yA - (this.bondOrder == 1 ? 0 : (this.bondOrder == 2 ? n3 / 2 : n3));
                do {
                    this.g3d.fillCylinder(this.colixA, this.colixA, this.endcaps, this.width, this.xA, n4, this.zA, this.xA, n4, this.zA);
                    n4 += n3;
                } while (--this.bondOrder > 0);
            }
            return;
        }
        if (this.bondOrder == 1) {
            if ((n & 1) != 0) {
                this.drawDashed(bl, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            } else if (bl) {
                this.g3d.drawLine(this.colixA, this.colixB, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            } else {
                this.g3d.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            }
            return;
        }
        int n5 = this.dx * this.dx;
        int n6 = this.dy * this.dy;
        int n7 = n5 + n6;
        if (this.bondOrder == 4) {
            n7 *= 4;
        }
        this.mag2d = (int)(Math.sqrt(n7) + 0.5);
        this.resetAxisCoordinates(bl);
        while (true) {
            if ((n & 1) != 0) {
                this.drawDashed(bl, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            } else if (bl) {
                this.g3d.drawLine(this.colixA, this.colixB, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            } else {
                this.g3d.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            }
            n >>= 1;
            if (--this.bondOrder == 0) break;
            this.stepAxisCoordinates();
        }
    }

    void resetAxisCoordinates(boolean bl) {
        int n = this.mag2d >> 3;
        int n2 = this.width + n;
        this.dxStep = n2 * this.dy / this.mag2d;
        this.dyStep = n2 * -this.dx / this.mag2d;
        this.xAxis1 = this.xA;
        this.yAxis1 = this.yA;
        this.xAxis2 = this.xB;
        this.yAxis2 = this.yB;
        if (this.bondOrder == 2) {
            this.xAxis1 -= this.dxStep / 2;
            this.yAxis1 -= this.dyStep / 2;
            this.xAxis2 -= this.dxStep / 2;
            this.yAxis2 -= this.dyStep / 2;
        } else if (this.bondOrder == 3) {
            this.xAxis1 -= this.dxStep;
            this.yAxis1 -= this.dyStep;
            this.xAxis2 -= this.dxStep;
            this.yAxis2 -= this.dyStep;
        } else if (this.bondOrder == 4) {
            this.xAxis1 = (int)((double)this.xAxis1 - (double)this.dxStep * 1.5);
            this.yAxis1 = (int)((double)this.yAxis1 - (double)this.dyStep * 1.5);
            this.xAxis2 = (int)((double)this.xAxis2 - (double)this.dxStep * 1.5);
            this.yAxis2 = (int)((double)this.yAxis2 - (double)this.dyStep * 1.5);
        }
    }

    void stepAxisCoordinates() {
        this.xAxis1 += this.dxStep;
        this.yAxis1 += this.dyStep;
        this.xAxis2 += this.dxStep;
        this.yAxis2 += this.dyStep;
    }

    private void renderTriangle(Bond bond) {
        int n;
        int n2;
        if (!this.g3d.checkTranslucent(false)) {
            return;
        }
        int n3 = (int)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        int n4 = this.viewer.scaleToScreen(this.zB, wideWidthMilliAngstroms);
        if (n3 == 0) {
            n2 = 0;
            n = n4;
        } else {
            n2 = n4 * -this.dy / n3;
            n = n4 * this.dx / n3;
        }
        int n5 = this.xB + n2 / 2;
        int n6 = n5 - n2;
        int n7 = this.yB + n / 2;
        int n8 = n7 - n;
        this.g3d.setColix(this.colixA);
        if (this.colixA == this.colixB) {
            this.g3d.drawfillTriangle(this.xA, this.yA, this.zA, n5, n7, this.zB, n6, n8, this.zB);
        } else {
            int n9 = (this.xA + n5) / 2;
            int n10 = (this.yA + n7) / 2;
            int n11 = (this.zA + this.zB) / 2;
            int n12 = (this.xA + n6) / 2;
            int n13 = (this.yA + n8) / 2;
            this.g3d.drawfillTriangle(this.xA, this.yA, this.zA, n9, n10, n11, n12, n13, n11);
            this.g3d.setColix(this.colixB);
            this.g3d.drawfillTriangle(n9, n10, n11, n12, n13, n11, n6, n8, this.zB);
            this.g3d.drawfillTriangle(n9, n10, n11, n5, n7, this.zB, n6, n8, this.zB);
        }
    }

    void drawDottedCylinder(short s, short s2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n5 - n2;
        int n9 = n6 - n3;
        int n10 = n7 - n4;
        boolean bl = this.g3d.setColix(s2);
        int n11 = 8;
        while (--n11 >= 0) {
            int n12 = n2 + n8 * n11 / 7;
            int n13 = n3 + n9 * n11 / 7;
            int n14 = n4 + n10 * n11 / 7;
            if (n11 == 3 && !(bl = this.g3d.setColix(s))) {
                return;
            }
            if (!bl) continue;
            this.g3d.fillSphereCentered(n, n12, n13, n14);
        }
    }

    private int getAromaticDottedBondMask(Bond bond) {
        Atom atom = this.findAromaticNeighbor();
        if (atom == null) {
            return 1;
        }
        int n = atom.screenY - this.yA;
        int n2 = atom.screenX - this.xA;
        return this.dx * n - this.dy * n2 >= 0 ? 2 : 1;
    }

    private Atom findAromaticNeighbor() {
        Bond[] bondArray = this.atomB.getBonds();
        int n = bondArray.length;
        while (--n >= 0) {
            Bond bond = bondArray[n];
            if ((bond.getOrder() & 9) == 0 || bond == this.bond) continue;
            if (bond.getAtom1() == this.atomB) {
                return bond.getAtom2();
            }
            if (bond.getAtom2() != this.atomB) continue;
            return bond.getAtom1();
        }
        return null;
    }

    void drawDashed(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n4 - n;
        int n8 = n5 - n2;
        int n9 = n6 - n3;
        for (int i = 2; i <= 9; i += 2) {
            int n10 = n + n7 * i / 12;
            int n11 = n2 + n8 * i / 12;
            int n12 = n3 + n9 * i / 12;
            int n13 = n + n7 * (i += 3) / 12;
            int n14 = n2 + n8 * i / 12;
            int n15 = n3 + n9 * i / 12;
            if (bl) {
                this.g3d.drawLine(this.colixA, this.colixB, n10, n11, n12, n13, n14, n15);
                continue;
            }
            this.g3d.fillCylinder(this.colixA, this.colixB, (byte)2, this.width, n10, n11, n12, n13, n14, n15);
        }
    }

    void renderHbondDashed() {
        boolean bl = this.width <= 1;
        int n = this.xB - this.xA;
        int n2 = this.yB - this.yA;
        int n3 = this.zB - this.zA;
        for (int i = 1; i < 10; ++i) {
            int n4 = this.xA + n * i / 10;
            int n5 = this.yA + n2 * i / 10;
            int n6 = this.zA + n3 * i / 10;
            short s = i < 5 ? this.colixA : this.colixB;
            int n7 = this.xA + n * (i += 2) / 10;
            int n8 = this.yA + n2 * i / 10;
            int n9 = this.zA + n3 * i / 10;
            short s2 = i < 5 ? this.colixA : this.colixB;
            if (bl) {
                this.g3d.drawLine(s, s2, n4, n5, n6, n7, n8, n9);
                continue;
            }
            this.g3d.fillCylinder(s, s2, (byte)2, this.width, n4, n5, n6, n7, n8, n9);
        }
    }
}

