/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ExpVectorInteger
extends ExpVector {
    final int[] a;
    public static long a = 0x3FFFFFFFL;
    public static long b = -1073741824L;

    public ExpVectorInteger(int n2) {
        this(new int[n2]);
    }

    public ExpVectorInteger(int n2, int n3, int n4) {
        this(n2);
        this.a[n3] = n4;
    }

    public ExpVectorInteger(int n2, int n3, long l2) {
        this(n2);
        if (l2 >= a || l2 <= b) {
            throw new IllegalArgumentException("exponent to large: " + l2);
        }
        this.a[n3] = (int)l2;
    }

    protected ExpVectorInteger(int[] nArray) {
        this.a = nArray;
    }

    public ExpVectorInteger(long[] lArray) {
        this(lArray.length);
        int n2 = 0;
        while (n2 < lArray.length) {
            if (lArray[n2] >= a || lArray[n2] <= b) {
                throw new IllegalArgumentException("exponent to large: " + lArray[n2]);
            }
            this.a[n2] = (int)lArray[n2];
            ++n2;
        }
    }

    public ExpVectorInteger(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        string = string.trim();
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41, n2 + 1);
        if (n2 >= 0 && n3 >= 0) {
            int n4;
            String string2;
            int n5;
            ++n2;
            while ((n5 = string.indexOf(44, n2)) >= 0) {
                string2 = string.substring(n2, n5);
                n4 = Integer.parseInt(string2);
                vector.add(new Integer(n4));
                n2 = n5 + 1;
            }
            if (n2 <= n3) {
                string2 = string.substring(n2, n3);
                n4 = Integer.parseInt(string2);
                vector.add(new Integer(n4));
            }
            int n6 = vector.size();
            this.a = new int[n6];
            int n7 = 0;
            while (n7 < n6) {
                this.a[n7] = (Integer)vector.elementAt(n7);
                ++n7;
            }
        } else {
            this.a = null;
        }
    }

    public ExpVectorInteger clone() {
        int[] nArray = new int[this.a.length];
        System.arraycopy(this.a, 0, nArray, 0, this.a.length);
        return new ExpVectorInteger(nArray);
    }

    long[] getVal() {
        long[] lArray = new long[this.a.length];
        int n2 = 0;
        while (n2 < this.a.length) {
            lArray[n2] = this.a[n2];
            ++n2;
        }
        return lArray;
    }

    public long getVal(int n2) {
        return this.a[n2];
    }

    protected long setVal(int n2, long l2) {
        int n3 = this.a[n2];
        if (l2 >= a || l2 <= b) {
            throw new IllegalArgumentException("exponent to large: " + l2);
        }
        this.a[n2] = (int)l2;
        this.a = (int[])false;
        return n3;
    }

    protected int setVal(int n2, int n3) {
        int n4 = this.a[n2];
        this.a[n2] = n3;
        this.a = (int[])false;
        return n4;
    }

    public int length() {
        return this.a.length;
    }

    public ExpVectorInteger extend(int n2, int n3, long l2) {
        int[] nArray = new int[this.a.length + n2];
        System.arraycopy(this.a, 0, nArray, n2, this.a.length);
        if (n3 >= n2) {
            throw new RuntimeException("i " + n2 + " <= j " + n3 + " invalid");
        }
        if (l2 >= a || l2 <= b) {
            throw new IllegalArgumentException("exponent to large: " + l2);
        }
        nArray[n3] = (int)l2;
        return new ExpVectorInteger(nArray);
    }

    public ExpVectorInteger extendLower(int n2, int n3, long l2) {
        int[] nArray = new int[this.a.length + n2];
        System.arraycopy(this.a, 0, nArray, 0, this.a.length);
        if (n3 >= n2) {
            throw new RuntimeException("i " + n2 + " <= j " + n3 + " invalid");
        }
        nArray[this.a.length + n3] = (int)l2;
        return new ExpVectorInteger(nArray);
    }

    public ExpVectorInteger contract(int n2, int n3) {
        if (n2 + n3 > this.a.length) {
            throw new RuntimeException("len " + n3 + " > val.len " + this.a.length);
        }
        int[] nArray = new int[n3];
        System.arraycopy(this.a, n2, nArray, 0, n3);
        return new ExpVectorInteger(nArray);
    }

    public ExpVectorInteger reverse() {
        int[] nArray = new int[this.a.length];
        int n2 = 0;
        while (n2 < this.a.length) {
            nArray[n2] = this.a[this.a.length - 1 - n2];
            ++n2;
        }
        return new ExpVectorInteger(nArray);
    }

    public ExpVectorInteger reverse(int n2) {
        if (n2 <= 0 || n2 > this.a.length) {
            return this;
        }
        int[] nArray = new int[this.a.length];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.a[n2 - 1 - n3];
            ++n3;
        }
        n3 = n2;
        while (n3 < this.a.length) {
            nArray[n3] = this.a[n3];
            ++n3;
        }
        return new ExpVectorInteger(nArray);
    }

    public ExpVectorInteger combine(ExpVector expVector) {
        if (expVector == null || expVector.length() == 0) {
            return this;
        }
        ExpVectorInteger expVectorInteger = (ExpVectorInteger)expVector;
        if (this.a.length == 0) {
            return expVectorInteger;
        }
        int[] nArray = new int[this.a.length + expVectorInteger.a.length];
        System.arraycopy(this.a, 0, nArray, 0, this.a.length);
        System.arraycopy(expVectorInteger.a, 0, nArray, this.a.length, expVectorInteger.a.length);
        return new ExpVectorInteger(nArray);
    }

    public String toString() {
        return String.valueOf(super.toString()) + ":int";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExpVectorInteger)) {
            return false;
        }
        ExpVectorInteger expVectorInteger = (ExpVectorInteger)object;
        int n2 = this.invLexCompareTo(expVectorInteger);
        return n2 == 0;
    }

    public ExpVectorInteger abs() {
        int[] nArray = this.a;
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = (long)nArray[n2] >= 0L ? nArray[n2] : -nArray[n2];
            ++n2;
        }
        return new ExpVectorInteger(nArray2);
    }

    public ExpVectorInteger negate() {
        int[] nArray = this.a;
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray2[n2] = -nArray[n2];
            ++n2;
        }
        return new ExpVectorInteger(nArray2);
    }

    public ExpVectorInteger sum(ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int[] nArray3 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray3[n2] = nArray[n2] + nArray2[n2];
            ++n2;
        }
        return new ExpVectorInteger(nArray3);
    }

    public ExpVectorInteger subtract(ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int[] nArray3 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray3[n2] = nArray[n2] - nArray2[n2];
            ++n2;
        }
        return new ExpVectorInteger(nArray3);
    }

    public ExpVectorInteger subst(int n2, long l2) {
        ExpVectorInteger expVectorInteger = this.clone();
        long l3 = expVectorInteger.setVal(n2, l2);
        return expVectorInteger;
    }

    public ExpVectorInteger subst(int n2, int n3) {
        ExpVectorInteger expVectorInteger = this.clone();
        long l2 = expVectorInteger.setVal(n2, n3);
        return expVectorInteger;
    }

    public int signum() {
        int n2 = 0;
        int[] nArray = this.a;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] < 0) {
                return -1;
            }
            if (nArray[n3] > 0) {
                n2 = 1;
            }
            ++n3;
        }
        return n2;
    }

    public long totalDeg() {
        long l2 = 0L;
        int[] nArray = this.a;
        int n2 = 0;
        while (n2 < nArray.length) {
            l2 += (long)nArray[n2];
            ++n2;
        }
        return l2;
    }

    public long maxDeg() {
        long l2 = 0L;
        int[] nArray = this.a;
        int n2 = 0;
        while (n2 < nArray.length) {
            if ((long)nArray[n2] > l2) {
                l2 = nArray[n2];
            }
            ++n2;
        }
        return l2;
    }

    public long weightDeg(long[][] lArray) {
        if (lArray == null || lArray.length == 0) {
            return this.totalDeg();
        }
        long l2 = 0L;
        int[] nArray = this.a;
        int n2 = 0;
        while (n2 < lArray.length) {
            long[] lArray2 = lArray[n2];
            int n3 = 0;
            while (n3 < nArray.length) {
                l2 += lArray2[n3] * (long)nArray[n3];
                ++n3;
            }
            ++n2;
        }
        return l2;
    }

    public ExpVectorInteger lcm(ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int[] nArray3 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray3[n2] = nArray[n2] >= nArray2[n2] ? nArray[n2] : nArray2[n2];
            ++n2;
        }
        return new ExpVectorInteger(nArray3);
    }

    public ExpVectorInteger gcd(ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int[] nArray3 = new int[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray3[n2] = nArray[n2] <= nArray2[n2] ? nArray[n2] : nArray2[n2];
            ++n2;
        }
        return new ExpVectorInteger(nArray3);
    }

    public int[] dependencyOnVariables() {
        int[] nArray = this.a;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] > 0) {
                ++n2;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        if (n2 == 0) {
            return nArray2;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            if (nArray[n5] > 0) {
                nArray2[n4] = n5;
                ++n4;
            }
            ++n5;
        }
        return nArray2;
    }

    public boolean multipleOf(ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return bl2;
    }

    public int compareTo(ExpVector expVector) {
        return this.invLexCompareTo(expVector);
    }

    public int invLexCompareTo(ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] > nArray2[n3]) {
                return 1;
            }
            if (nArray[n3] < nArray2[n3]) {
                return -1;
            }
            ++n3;
        }
        return n2;
    }

    public int invLexCompareTo(ExpVector expVector, int n2, int n3) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            if (nArray[n5] > nArray2[n5]) {
                return 1;
            }
            if (nArray[n5] < nArray2[n5]) {
                return -1;
            }
            ++n5;
        }
        return n4;
    }

    public int invGradCompareTo(ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] > nArray2[n3]) {
                n2 = 1;
                break;
            }
            if (nArray[n3] < nArray2[n3]) {
                n2 = -1;
                break;
            }
            ++n3;
        }
        if (n2 == 0) {
            return n2;
        }
        long l2 = 0L;
        long l3 = 0L;
        int n4 = n3;
        while (n4 < nArray.length) {
            l2 += (long)nArray[n4];
            l3 += (long)nArray2[n4];
            ++n4;
        }
        if (l2 > l3) {
            n2 = 1;
        } else if (l2 < l3) {
            n2 = -1;
        }
        return n2;
    }

    public int invGradCompareTo(ExpVector expVector, int n2, int n3) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            if (nArray[n5] > nArray2[n5]) {
                n4 = 1;
                break;
            }
            if (nArray[n5] < nArray2[n5]) {
                n4 = -1;
                break;
            }
            ++n5;
        }
        if (n4 == 0) {
            return n4;
        }
        long l2 = 0L;
        long l3 = 0L;
        int n6 = n5;
        while (n6 < n3) {
            l2 += (long)nArray[n6];
            l3 += (long)nArray2[n6];
            ++n6;
        }
        if (l2 > l3) {
            n4 = 1;
        } else if (l2 < l3) {
            n4 = -1;
        }
        return n4;
    }

    public int revInvLexCompareTo(ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n2 = 0;
        int n3 = nArray.length - 1;
        while (n3 >= 0) {
            if (nArray[n3] > nArray2[n3]) {
                return 1;
            }
            if (nArray[n3] < nArray2[n3]) {
                return -1;
            }
            --n3;
        }
        return n2;
    }

    public int revInvLexCompareTo(ExpVector expVector, int n2, int n3) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n4 = 0;
        int n5 = n3 - 1;
        while (n5 >= n2) {
            if (nArray[n5] > nArray2[n5]) {
                return 1;
            }
            if (nArray[n5] < nArray2[n5]) {
                return -1;
            }
            --n5;
        }
        return n4;
    }

    public int revInvGradCompareTo(ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n2 = 0;
        int n3 = nArray.length - 1;
        while (n3 >= 0) {
            if (nArray[n3] > nArray2[n3]) {
                n2 = 1;
                break;
            }
            if (nArray[n3] < nArray2[n3]) {
                n2 = -1;
                break;
            }
            --n3;
        }
        if (n2 == 0) {
            return n2;
        }
        long l2 = 0L;
        long l3 = 0L;
        int n4 = n3;
        while (n4 >= 0) {
            l2 += (long)nArray[n4];
            l3 += (long)nArray2[n4];
            --n4;
        }
        if (l2 > l3) {
            n2 = 1;
        } else if (l2 < l3) {
            n2 = -1;
        }
        return n2;
    }

    public int revInvGradCompareTo(ExpVector expVector, int n2, int n3) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n4 = 0;
        int n5 = n3 - 1;
        while (n5 >= n2) {
            if (nArray[n5] > nArray2[n5]) {
                n4 = 1;
                break;
            }
            if (nArray[n5] < nArray2[n5]) {
                n4 = -1;
                break;
            }
            --n5;
        }
        if (n4 == 0) {
            return n4;
        }
        long l2 = 0L;
        long l3 = 0L;
        int n6 = n5;
        while (n6 >= n2) {
            l2 += (long)nArray[n6];
            l3 += (long)nArray2[n6];
            --n6;
        }
        if (l2 > l3) {
            n4 = 1;
        } else if (l2 < l3) {
            n4 = -1;
        }
        return n4;
    }

    public int invWeightCompareTo(long[][] lArray, ExpVector expVector) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] > nArray2[n3]) {
                n2 = 1;
                break;
            }
            if (nArray[n3] < nArray2[n3]) {
                n2 = -1;
                break;
            }
            ++n3;
        }
        if (n2 == 0) {
            return n2;
        }
        int n4 = 0;
        while (n4 < lArray.length) {
            long[] lArray2 = lArray[n4];
            long l2 = 0L;
            long l3 = 0L;
            int n5 = n3;
            while (n5 < nArray.length) {
                l2 += lArray2[n5] * (long)nArray[n5];
                l3 += lArray2[n5] * (long)nArray2[n5];
                ++n5;
            }
            if (l2 > l3) {
                return 1;
            }
            if (l2 < l3) {
                return -1;
            }
            ++n4;
        }
        return n2;
    }

    public int invWeightCompareTo(long[][] lArray, ExpVector expVector, int n2, int n3) {
        int[] nArray = this.a;
        int[] nArray2 = ((ExpVectorInteger)expVector).a;
        int n4 = 0;
        int n5 = n2;
        while (n5 < n3) {
            if (nArray[n5] > nArray2[n5]) {
                n4 = 1;
                break;
            }
            if (nArray[n5] < nArray2[n5]) {
                n4 = -1;
                break;
            }
            ++n5;
        }
        if (n4 == 0) {
            return n4;
        }
        int n6 = 0;
        while (n6 < lArray.length) {
            long[] lArray2 = lArray[n6];
            long l2 = 0L;
            long l3 = 0L;
            int n7 = n5;
            while (n7 < n3) {
                l2 += lArray2[n7] * (long)nArray[n7];
                l3 += lArray2[n7] * (long)nArray2[n7];
                ++n7;
            }
            if (l2 > l3) {
                return 1;
            }
            if (l2 < l3) {
                return -1;
            }
            ++n6;
        }
        return n4;
    }
}

