/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.d.c;
import edu.jas.d.d;
import edu.jas.e.k;
import edu.jas.e.p;
import edu.jas.e.s;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyIterator;
import edu.jas.poly.TermOrder;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.a.b.a;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GenPolynomial
implements p,
Iterable {
    public final GenPolynomialRing a;
    protected final SortedMap a;
    private static final a a = org.a.b.a.a(GenPolynomial.class);
    private static final boolean a = a.a();

    private GenPolynomial(GenPolynomialRing genPolynomialRing, TreeMap treeMap) {
        this.a = genPolynomialRing;
        this.a = treeMap;
        if (this.a.b && Thread.currentThread().isInterrupted()) {
            a.a("throw PreemptingException");
            throw new c();
        }
    }

    public GenPolynomial(GenPolynomialRing genPolynomialRing) {
        this(genPolynomialRing, new TreeMap(genPolynomialRing.a.getDescendComparator()));
    }

    public GenPolynomial(GenPolynomialRing genPolynomialRing, p p2, ExpVector expVector) {
        this(genPolynomialRing);
        if (!p2.isZERO()) {
            this.a.put(expVector, p2);
        }
    }

    public GenPolynomial(GenPolynomialRing genPolynomialRing, p p2) {
        this(genPolynomialRing, p2, genPolynomialRing.a);
    }

    protected GenPolynomial(GenPolynomialRing genPolynomialRing, SortedMap sortedMap) {
        this(genPolynomialRing);
        this.a.putAll(sortedMap);
    }

    public GenPolynomialRing factory() {
        return this.a;
    }

    public GenPolynomial clone() {
        return new GenPolynomial(this.a, this.a);
    }

    public int length() {
        return this.a.size();
    }

    public SortedMap getMap() {
        return Collections.unmodifiableSortedMap(this.a);
    }

    public void doPutToMap(ExpVector expVector, p p2) {
        if (!p2.isZERO()) {
            this.a.put(expVector, p2);
        }
    }

    public String toString() {
        if (this.a.a != null) {
            return this.toString(this.a.a);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.getClass().getSimpleName()) + ":");
        stringBuffer.append(this.a.a.getClass().getSimpleName());
        if (!this.a.a.characteristic().equals(BigInteger.ZERO)) {
            stringBuffer.append("(" + this.a.a.characteristic() + ")");
        }
        stringBuffer.append("[ ");
        boolean bl2 = true;
        for (Map.Entry entry : this.a.entrySet()) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(((p)entry.getValue()).toString());
            stringBuffer.append(" ");
            stringBuffer.append(((ExpVector)entry.getKey()).toString());
        }
        stringBuffer.append(" ] ");
        return stringBuffer.toString();
    }

    public String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (d.a()) {
            if (this.a.size() == 0) {
                stringBuffer.append("0");
            } else {
                boolean bl2 = true;
                for (Map.Entry entry : this.a.entrySet()) {
                    p p2 = (p)entry.getValue();
                    if (bl2) {
                        bl2 = false;
                    } else if (p2.signum() < 0) {
                        stringBuffer.append(" - ");
                        p2 = (p)p2.negate();
                    } else {
                        stringBuffer.append(" + ");
                    }
                    ExpVector expVector = (ExpVector)entry.getKey();
                    if (!p2.isONE() || expVector.isZERO()) {
                        if (p2 instanceof GenPolynomial || p2 instanceof AlgebraicNumber) {
                            stringBuffer.append("{ ");
                        }
                        stringBuffer.append(p2.toString());
                        if (p2 instanceof GenPolynomial || p2 instanceof AlgebraicNumber) {
                            stringBuffer.append(" }");
                        }
                        stringBuffer.append(" ");
                    }
                    if (expVector != null && stringArray != null) {
                        stringBuffer.append(expVector.toString(stringArray));
                        continue;
                    }
                    stringBuffer.append(expVector);
                }
            }
        } else {
            stringBuffer.append(String.valueOf(this.getClass().getSimpleName()) + "[ ");
            if (this.a.size() == 0) {
                stringBuffer.append("0");
            } else {
                boolean bl3 = true;
                for (Map.Entry entry : this.a.entrySet()) {
                    p p3 = (p)entry.getValue();
                    if (bl3) {
                        bl3 = false;
                    } else if (p3.signum() < 0) {
                        stringBuffer.append(" - ");
                        p3 = (p)p3.negate();
                    } else {
                        stringBuffer.append(" + ");
                    }
                    ExpVector expVector = (ExpVector)entry.getKey();
                    if (!p3.isONE() || expVector.isZERO()) {
                        stringBuffer.append(p3.toString());
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(expVector.toString(stringArray));
                }
            }
            stringBuffer.append(" ] ");
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        String[] stringArray;
        if (this.isZERO()) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.size() > 1) {
            stringBuffer.append("( ");
        }
        if ((stringArray = this.a.a) == null) {
            stringArray = GenPolynomialRing.newVars("x", this.a.a);
        }
        boolean bl2 = false;
        if (!(this.a.a instanceof GenPolynomialRing)) {
            boolean cfr_ignored_0 = this.a.a instanceof AlgebraicNumberRing;
        }
        boolean bl3 = true;
        for (Map.Entry entry : this.a.entrySet()) {
            p p2 = (p)entry.getValue();
            if (bl3) {
                bl3 = false;
            } else if (p2.signum() < 0) {
                stringBuffer.append(" - ");
                p2 = (p)p2.negate();
            } else {
                stringBuffer.append(" + ");
            }
            ExpVector expVector = (ExpVector)entry.getKey();
            if (!p2.isONE() || expVector.isZERO()) {
                if (bl2) {
                    stringBuffer.append("( ");
                }
                stringBuffer.append(p2.toScript());
                if (bl2) {
                    stringBuffer.append(" )");
                }
                if (!expVector.isZERO()) {
                    stringBuffer.append(" * ");
                }
            }
            stringBuffer.append(expVector.toScript(stringArray));
        }
        if (this.a.size() > 1) {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    public String toScriptFactory() {
        return this.factory().toScript();
    }

    public boolean isZERO() {
        return this.a.size() == 0;
    }

    public boolean isONE() {
        if (this.a.size() != 1) {
            return false;
        }
        p p2 = (p)this.a.get(this.a.a);
        if (p2 == null) {
            return false;
        }
        return p2.isONE();
    }

    public boolean isUnit() {
        if (this.a.size() != 1) {
            return false;
        }
        p p2 = (p)this.a.get(this.a.a);
        if (p2 == null) {
            return false;
        }
        return p2.isUnit();
    }

    public boolean isConstant() {
        if (this.a.size() != 1) {
            return false;
        }
        p p2 = (p)this.a.get(this.a.a);
        return p2 != null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GenPolynomial)) {
            return false;
        }
        GenPolynomial genPolynomial = null;
        try {
            genPolynomial = (GenPolynomial)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (genPolynomial == null) {
            return false;
        }
        return this.subtract(genPolynomial).isZERO();
    }

    public int hashCode() {
        int n2 = this.a.hashCode() << 27;
        return n2 += this.a.hashCode();
    }

    public int compareTo(GenPolynomial genPolynomial) {
        if (genPolynomial == null) {
            return 1;
        }
        SortedMap sortedMap = this.a;
        SortedMap sortedMap2 = genPolynomial.a;
        Iterator iterator = sortedMap.keySet().iterator();
        Iterator iterator2 = sortedMap2.keySet().iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext() && iterator2.hasNext()) {
            ExpVector expVector;
            ExpVector expVector2 = (ExpVector)iterator.next();
            n2 = expVector2.compareTo(expVector = (ExpVector)iterator2.next());
            if (n2 != 0) {
                return n2;
            }
            if (n3 != 0) continue;
            p p2 = (p)sortedMap.get(expVector2);
            p p3 = (p)sortedMap2.get(expVector);
            n3 = p2.compareTo(p3);
        }
        if (iterator.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return n3;
    }

    public int signum() {
        if (this.isZERO()) {
            return 0;
        }
        ExpVector expVector = (ExpVector)this.a.firstKey();
        p p2 = (p)this.a.get(expVector);
        return p2.signum();
    }

    public int numberOfVariables() {
        return this.a.a;
    }

    public Map.Entry leadingMonomial() {
        if (this.a.size() == 0) {
            return null;
        }
        Iterator iterator = this.a.entrySet().iterator();
        return iterator.next();
    }

    public ExpVector leadingExpVector() {
        if (this.a.size() == 0) {
            return null;
        }
        return (ExpVector)this.a.firstKey();
    }

    public ExpVector trailingExpVector() {
        if (this.a.size() == 0) {
            return null;
        }
        return (ExpVector)this.a.lastKey();
    }

    public p leadingBaseCoefficient() {
        if (this.a.size() == 0) {
            return (p)this.a.a.getZERO();
        }
        return (p)this.a.get(this.a.firstKey());
    }

    public p trailingBaseCoefficient() {
        p p2 = (p)this.a.get(this.a.a);
        if (p2 == null) {
            return (p)this.a.a.getZERO();
        }
        return p2;
    }

    public p coefficient(ExpVector expVector) {
        p p2 = (p)this.a.get(expVector);
        if (p2 == null) {
            p2 = (p)this.a.a.getZERO();
        }
        return p2;
    }

    public GenPolynomial reductum() {
        if (this.a.size() <= 1) {
            return this.a.getZERO();
        }
        Iterator iterator = this.a.keySet().iterator();
        ExpVector expVector = (ExpVector)iterator.next();
        expVector = (ExpVector)iterator.next();
        SortedMap sortedMap = this.a.tailMap(expVector);
        return new GenPolynomial(this.a, sortedMap);
    }

    public long degree(int n2) {
        if (this.a.size() == 0) {
            return 0L;
        }
        int n3 = this.a.a - 1 - n2;
        long l2 = 0L;
        for (ExpVector expVector : this.a.keySet()) {
            long l3 = expVector.getVal(n3);
            if (l3 <= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    public long degree() {
        if (this.a.size() == 0) {
            return 0L;
        }
        long l2 = 0L;
        for (ExpVector expVector : this.a.keySet()) {
            long l3 = expVector.maxDeg();
            if (l3 <= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    public ExpVector degreeVector() {
        ExpVector expVector = this.a.a;
        if (this.a.size() == 0) {
            return expVector;
        }
        for (ExpVector expVector2 : this.a.keySet()) {
            expVector = expVector.lcm(expVector2);
        }
        return expVector;
    }

    public p maxNorm() {
        p p2 = this.a.getZEROCoefficient();
        for (p p3 : this.a.values()) {
            p p4 = (p)p3.abs();
            if (p2.compareTo(p4) >= 0) continue;
            p2 = p4;
        }
        return p2;
    }

    public p sumNorm() {
        p p2 = this.a.getZEROCoefficient();
        for (p p3 : this.a.values()) {
            p p4 = (p)p3.abs();
            p2 = (p)p2.sum(p4);
        }
        return p2;
    }

    public GenPolynomial sum(GenPolynomial genPolynomial) {
        if (genPolynomial == null) {
            return this;
        }
        if (genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genPolynomial;
        }
        assert (this.a.a == genPolynomial.a.a);
        GenPolynomial genPolynomial2 = this.clone();
        SortedMap sortedMap = genPolynomial2.a;
        SortedMap sortedMap2 = genPolynomial.a;
        for (ExpVector expVector : sortedMap2.keySet()) {
            p p2 = (p)sortedMap.get(expVector);
            p p3 = (p)sortedMap2.get(expVector);
            if (p2 != null) {
                if (!(p2 = (p)p2.sum(p3)).isZERO()) {
                    sortedMap.put(expVector, p2);
                    continue;
                }
                sortedMap.remove(expVector);
                continue;
            }
            sortedMap.put(expVector, p3);
        }
        return genPolynomial2;
    }

    public GenPolynomial sum(p p2, ExpVector expVector) {
        if (p2 == null) {
            return this;
        }
        if (p2.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = this.clone();
        SortedMap sortedMap = genPolynomial.a;
        p p3 = (p)sortedMap.get(expVector);
        if (p3 != null) {
            if (!(p3 = (p)p3.sum(p2)).isZERO()) {
                sortedMap.put(expVector, p3);
            } else {
                sortedMap.remove(expVector);
            }
        } else {
            sortedMap.put(expVector, p2);
        }
        return genPolynomial;
    }

    public GenPolynomial sum(p p2) {
        return this.sum(p2, this.a.a);
    }

    public GenPolynomial subtract(GenPolynomial genPolynomial) {
        if (genPolynomial == null) {
            return this;
        }
        if (genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genPolynomial.negate();
        }
        assert (this.a.a == genPolynomial.a.a);
        GenPolynomial genPolynomial2 = this.clone();
        SortedMap sortedMap = genPolynomial2.a;
        SortedMap sortedMap2 = genPolynomial.a;
        for (ExpVector expVector : sortedMap2.keySet()) {
            p p2 = (p)sortedMap.get(expVector);
            p p3 = (p)sortedMap2.get(expVector);
            if (p2 != null) {
                if (!(p2 = (p)p2.subtract(p3)).isZERO()) {
                    sortedMap.put(expVector, p2);
                    continue;
                }
                sortedMap.remove(expVector);
                continue;
            }
            sortedMap.put(expVector, (p)p3.negate());
        }
        return genPolynomial2;
    }

    public GenPolynomial subtract(p p2, ExpVector expVector) {
        if (p2 == null) {
            return this;
        }
        if (p2.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = this.clone();
        SortedMap sortedMap = genPolynomial.a;
        p p3 = (p)sortedMap.get(expVector);
        if (p3 != null) {
            if (!(p3 = (p)p3.subtract(p2)).isZERO()) {
                sortedMap.put(expVector, p3);
            } else {
                sortedMap.remove(expVector);
            }
        } else {
            sortedMap.put(expVector, (p)p2.negate());
        }
        return genPolynomial;
    }

    public GenPolynomial subtract(p p2) {
        return this.subtract(p2, this.a.a);
    }

    public GenPolynomial negate() {
        GenPolynomial genPolynomial = this.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial.a;
        for (Map.Entry entry : this.a.entrySet()) {
            p p2 = (p)entry.getValue();
            sortedMap.put((ExpVector)entry.getKey(), (p)p2.negate());
        }
        return genPolynomial;
    }

    public GenPolynomial abs() {
        if (this.leadingBaseCoefficient().signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public GenPolynomial multiply(GenPolynomial genPolynomial) {
        if (genPolynomial == null) {
            return this.a.getZERO();
        }
        if (genPolynomial.isZERO()) {
            return this.a.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        assert (this.a.a == genPolynomial.a.a);
        GenPolynomial genPolynomial2 = this.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : this.a.entrySet()) {
            p p2 = (p)entry.getValue();
            ExpVector expVector = (ExpVector)entry.getKey();
            for (Map.Entry entry2 : genPolynomial.a.entrySet()) {
                p p3 = (p)entry2.getValue();
                ExpVector expVector2 = (ExpVector)entry2.getKey();
                p p4 = (p)p2.multiply(p3);
                if (p4.isZERO()) continue;
                ExpVector expVector3 = expVector.sum(expVector2);
                p p5 = (p)sortedMap.get(expVector3);
                if (p5 == null) {
                    sortedMap.put(expVector3, p4);
                    continue;
                }
                if (!(p5 = (p)p5.sum(p4)).isZERO()) {
                    sortedMap.put(expVector3, p5);
                    continue;
                }
                sortedMap.remove(expVector3);
            }
        }
        return genPolynomial2;
    }

    public GenPolynomial multiply(p p2) {
        if (p2 == null) {
            return this.a.getZERO();
        }
        if (p2.isZERO()) {
            return this.a.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = this.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial.a;
        for (Map.Entry entry : this.a.entrySet()) {
            p p3 = (p)entry.getValue();
            ExpVector expVector = (ExpVector)entry.getKey();
            p p4 = (p)p3.multiply(p2);
            if (p4.isZERO()) continue;
            sortedMap.put(expVector, p4);
        }
        return genPolynomial;
    }

    public GenPolynomial monic() {
        if (this.isZERO()) {
            return this;
        }
        p p2 = this.leadingBaseCoefficient();
        if (!p2.isUnit()) {
            return this;
        }
        p p3 = (p)p2.inverse();
        return this.multiply(p3);
    }

    public GenPolynomial multiply(p p2, ExpVector expVector) {
        if (p2 == null) {
            return this.a.getZERO();
        }
        if (p2.isZERO()) {
            return this.a.getZERO();
        }
        if (this.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = this.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial.a;
        for (Map.Entry entry : this.a.entrySet()) {
            p p3 = (p)entry.getValue();
            ExpVector expVector2 = (ExpVector)entry.getKey();
            p p4 = (p)p3.multiply(p2);
            if (p4.isZERO()) continue;
            ExpVector expVector3 = expVector2.sum(expVector);
            sortedMap.put(expVector3, p4);
        }
        return genPolynomial;
    }

    public GenPolynomial multiply(ExpVector expVector) {
        if (this.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = this.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial.a;
        for (Map.Entry entry : this.a.entrySet()) {
            p p2 = (p)entry.getValue();
            ExpVector expVector2 = (ExpVector)entry.getKey();
            ExpVector expVector3 = expVector2.sum(expVector);
            sortedMap.put(expVector3, p2);
        }
        return genPolynomial;
    }

    public GenPolynomial multiply(Map.Entry entry) {
        if (entry == null) {
            return this.a.getZERO();
        }
        return this.multiply((p)entry.getValue(), (ExpVector)entry.getKey());
    }

    public GenPolynomial divide(p p2) {
        if (p2 == null || p2.isZERO()) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " division by zero");
        }
        if (this.isZERO()) {
            return this;
        }
        GenPolynomial genPolynomial = this.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial.a;
        for (Map.Entry entry : this.a.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            p p3 = (p)entry.getValue();
            p p4 = (p)p3.divide(p2);
            if (p4.isZERO()) {
                throw new RuntimeException(String.valueOf(this.getClass().getName()) + " no exact division: " + p3 + "/" + p2 + ", in " + this);
            }
            sortedMap.put(expVector, p4);
        }
        return genPolynomial;
    }

    public GenPolynomial[] divideAndRemainder(GenPolynomial genPolynomial) {
        Object object;
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " division by zero");
        }
        p p2 = genPolynomial.leadingBaseCoefficient();
        if (!p2.isUnit()) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " lbcf not invertible " + p2);
        }
        p p3 = (p)p2.inverse();
        assert (this.a.a == genPolynomial.a.a);
        ExpVector expVector = genPolynomial.leadingExpVector();
        GenPolynomial genPolynomial2 = this.a.getZERO().clone();
        GenPolynomial genPolynomial3 = this.clone();
        while (!genPolynomial3.isZERO()) {
            object = genPolynomial3.leadingExpVector();
            if (!((ExpVector)object).multipleOf(expVector)) break;
            p p4 = genPolynomial3.leadingBaseCoefficient();
            object = ((ExpVector)object).subtract(expVector);
            p4 = (p)p4.multiply(p3);
            genPolynomial2 = genPolynomial2.sum(p4, (ExpVector)object);
            GenPolynomial genPolynomial4 = genPolynomial.multiply(p4, (ExpVector)object);
            genPolynomial3 = genPolynomial3.subtract(genPolynomial4);
        }
        object = new GenPolynomial[]{genPolynomial2, genPolynomial3};
        return object;
    }

    public GenPolynomial divide(GenPolynomial genPolynomial) {
        return this.divideAndRemainder(genPolynomial)[0];
    }

    public GenPolynomial remainder(GenPolynomial genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " division by zero");
        }
        p p2 = genPolynomial.leadingBaseCoefficient();
        if (!p2.isUnit()) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " lbc not invertible " + p2);
        }
        p p3 = (p)p2.inverse();
        assert (this.a.a == genPolynomial.a.a);
        ExpVector expVector = genPolynomial.leadingExpVector();
        GenPolynomial genPolynomial2 = this.clone();
        while (!genPolynomial2.isZERO()) {
            ExpVector expVector2 = genPolynomial2.leadingExpVector();
            if (!expVector2.multipleOf(expVector)) break;
            p p4 = genPolynomial2.leadingBaseCoefficient();
            expVector2 = expVector2.subtract(expVector);
            p4 = (p)p4.multiply(p3);
            GenPolynomial genPolynomial3 = genPolynomial.multiply(p4, expVector2);
            genPolynomial2 = genPolynomial2.subtract(genPolynomial3);
        }
        return genPolynomial2;
    }

    public GenPolynomial gcd(GenPolynomial genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this;
        }
        if (this.isZERO()) {
            return genPolynomial;
        }
        if (this.a.a != 1) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " not univariate polynomials" + this.a);
        }
        GenPolynomial genPolynomial2 = this;
        GenPolynomial genPolynomial3 = genPolynomial;
        while (!genPolynomial3.isZERO()) {
            GenPolynomial genPolynomial4 = genPolynomial2.remainder(genPolynomial3);
            genPolynomial2 = genPolynomial3;
            genPolynomial3 = genPolynomial4;
        }
        return genPolynomial2.monic();
    }

    public GenPolynomial[] egcd(GenPolynomial genPolynomial) {
        GenPolynomial[] genPolynomialArray = new GenPolynomial[]{null, null, null};
        if (genPolynomial == null || genPolynomial.isZERO()) {
            genPolynomialArray[0] = this;
            genPolynomialArray[1] = this.a.getONE();
            genPolynomialArray[2] = this.a.getZERO();
            return genPolynomialArray;
        }
        if (this.isZERO()) {
            genPolynomialArray[0] = genPolynomial;
            genPolynomialArray[1] = this.a.getZERO();
            genPolynomialArray[2] = this.a.getONE();
            return genPolynomialArray;
        }
        if (this.a.a != 1) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " not univariate polynomials" + this.a);
        }
        GenPolynomial genPolynomial2 = this;
        GenPolynomial genPolynomial3 = genPolynomial;
        GenPolynomial genPolynomial4 = this.a.getONE().clone();
        GenPolynomial genPolynomial5 = this.a.getZERO().clone();
        GenPolynomial genPolynomial6 = this.a.getZERO().clone();
        GenPolynomial genPolynomial7 = this.a.getONE().clone();
        while (!genPolynomial3.isZERO()) {
            GenPolynomial[] genPolynomialArray2 = genPolynomial2.divideAndRemainder(genPolynomial3);
            genPolynomial2 = genPolynomialArray2[0];
            GenPolynomial genPolynomial8 = genPolynomial4.subtract(genPolynomial2.multiply(genPolynomial5));
            GenPolynomial genPolynomial9 = genPolynomial6.subtract(genPolynomial2.multiply(genPolynomial7));
            genPolynomial4 = genPolynomial5;
            genPolynomial6 = genPolynomial7;
            genPolynomial5 = genPolynomial8;
            genPolynomial7 = genPolynomial9;
            genPolynomial2 = genPolynomial3;
            genPolynomial3 = genPolynomialArray2[1];
        }
        p p2 = genPolynomial2.leadingBaseCoefficient();
        if (p2.isUnit()) {
            p p3 = (p)p2.inverse();
            genPolynomial2 = genPolynomial2.multiply(p3);
            genPolynomial4 = genPolynomial4.multiply(p3);
            genPolynomial6 = genPolynomial6.multiply(p3);
        }
        genPolynomialArray[0] = genPolynomial2;
        genPolynomialArray[1] = genPolynomial4;
        genPolynomialArray[2] = genPolynomial6;
        return genPolynomialArray;
    }

    public GenPolynomial[] hegcd(GenPolynomial genPolynomial) {
        GenPolynomial[] genPolynomialArray = new GenPolynomial[]{null, null};
        if (genPolynomial == null || genPolynomial.isZERO()) {
            genPolynomialArray[0] = this;
            genPolynomialArray[1] = this.a.getONE();
            return genPolynomialArray;
        }
        if (this.isZERO()) {
            genPolynomialArray[0] = genPolynomial;
            return genPolynomialArray;
        }
        if (this.a.a != 1) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + " not univariate polynomials" + this.a);
        }
        GenPolynomial genPolynomial2 = this;
        GenPolynomial genPolynomial3 = genPolynomial;
        GenPolynomial genPolynomial4 = this.a.getONE().clone();
        GenPolynomial genPolynomial5 = this.a.getZERO().clone();
        while (!genPolynomial3.isZERO()) {
            GenPolynomial[] genPolynomialArray2 = genPolynomial2.divideAndRemainder(genPolynomial3);
            genPolynomial2 = genPolynomialArray2[0];
            GenPolynomial genPolynomial6 = genPolynomial4.subtract(genPolynomial2.multiply(genPolynomial5));
            genPolynomial4 = genPolynomial5;
            genPolynomial5 = genPolynomial6;
            genPolynomial2 = genPolynomial3;
            genPolynomial3 = genPolynomialArray2[1];
        }
        p p2 = genPolynomial2.leadingBaseCoefficient();
        if (p2.isUnit()) {
            p p3 = (p)p2.inverse();
            genPolynomial2 = genPolynomial2.multiply(p3);
            genPolynomial4 = genPolynomial4.multiply(p3);
        }
        genPolynomialArray[0] = genPolynomial2;
        genPolynomialArray[1] = genPolynomial4;
        return genPolynomialArray;
    }

    public GenPolynomial inverse() {
        if (this.isUnit()) {
            p p2 = (p)this.leadingBaseCoefficient().inverse();
            return this.a.getONE().multiply(p2);
        }
        throw new k("element not invertible " + this);
    }

    public GenPolynomial modInverse(GenPolynomial genPolynomial) {
        if (this.isZERO()) {
            throw new k("zero is not invertible");
        }
        GenPolynomial[] genPolynomialArray = this.hegcd(genPolynomial);
        GenPolynomial genPolynomial2 = genPolynomialArray[0];
        if (!genPolynomial2.isUnit()) {
            throw new k("element not invertible, gcd != 1");
        }
        GenPolynomial genPolynomial3 = genPolynomialArray[1];
        if (genPolynomial3.isZERO()) {
            throw new k("element not invertible, divisible by modul");
        }
        return genPolynomial3;
    }

    public GenPolynomial extend(GenPolynomialRing genPolynomialRing, int n2, long l2) {
        GenPolynomial genPolynomial = genPolynomialRing.getZERO().clone();
        if (this.isZERO()) {
            return genPolynomial;
        }
        int n3 = genPolynomialRing.a - this.a.a;
        SortedMap sortedMap = genPolynomial.a;
        SortedMap sortedMap2 = this.a;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            p p2 = (p)entry.getValue();
            ExpVector expVector2 = expVector.extend(n3, n2, l2);
            sortedMap.put(expVector2, p2);
        }
        return genPolynomial;
    }

    public GenPolynomial extendLower(GenPolynomialRing genPolynomialRing, int n2, long l2) {
        GenPolynomial genPolynomial = genPolynomialRing.getZERO().clone();
        if (this.isZERO()) {
            return genPolynomial;
        }
        int n3 = genPolynomialRing.a - this.a.a;
        SortedMap sortedMap = genPolynomial.a;
        SortedMap sortedMap2 = this.a;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            p p2 = (p)entry.getValue();
            ExpVector expVector2 = expVector.extendLower(n3, n2, l2);
            sortedMap.put(expVector2, p2);
        }
        return genPolynomial;
    }

    public Map contract(GenPolynomialRing genPolynomialRing) {
        GenPolynomial genPolynomial = genPolynomialRing.getZERO();
        TermOrder termOrder = new TermOrder(2);
        TreeMap<ExpVector, GenPolynomial> treeMap = new TreeMap<ExpVector, GenPolynomial>(termOrder.getAscendComparator());
        if (this.isZERO()) {
            return treeMap;
        }
        int n2 = this.a.a - genPolynomialRing.a;
        SortedMap sortedMap = this.a;
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            p p2 = (p)entry.getValue();
            ExpVector expVector2 = expVector.contract(0, n2);
            ExpVector expVector3 = expVector.contract(n2, expVector.length() - n2);
            GenPolynomial genPolynomial2 = (GenPolynomial)treeMap.get(expVector2);
            if (genPolynomial2 == null) {
                genPolynomial2 = genPolynomial;
            }
            genPolynomial2 = genPolynomial2.sum(p2, expVector3);
            treeMap.put(expVector2, genPolynomial2);
        }
        return treeMap;
    }

    public GenPolynomial contractCoeff(GenPolynomialRing genPolynomialRing) {
        Map map = this.contract(genPolynomialRing);
        GenPolynomial genPolynomial = genPolynomialRing.getZERO();
        for (Map.Entry entry : map.entrySet()) {
            if (((ExpVector)entry.getKey()).isZERO()) {
                genPolynomial = (GenPolynomial)entry.getValue();
                continue;
            }
            throw new RuntimeException("wrong coefficient contraction " + entry + ", pol =  " + genPolynomial);
        }
        return genPolynomial;
    }

    public GenPolynomial extendUnivariate(GenPolynomialRing genPolynomialRing, int n2) {
        if (n2 < 0 || genPolynomialRing.a < n2) {
            throw new IllegalArgumentException("index " + n2 + "out of range " + genPolynomialRing.a);
        }
        if (this.a.a != 1) {
            throw new IllegalArgumentException("polynomial not univariate " + this.a.a);
        }
        if (this.isONE()) {
            return genPolynomialRing.getONE();
        }
        int n3 = genPolynomialRing.a - 1 - n2;
        GenPolynomial genPolynomial = genPolynomialRing.getZERO().clone();
        if (this.isZERO()) {
            return genPolynomial;
        }
        SortedMap sortedMap = genPolynomial.a;
        SortedMap sortedMap2 = this.a;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            long l2 = expVector.getVal(0);
            p p2 = (p)entry.getValue();
            ExpVector expVector2 = ExpVector.create(genPolynomialRing.a, n3, l2);
            sortedMap.put(expVector2, p2);
        }
        return genPolynomial;
    }

    public GenPolynomial reverse(GenPolynomialRing genPolynomialRing) {
        GenPolynomial genPolynomial = genPolynomialRing.getZERO().clone();
        if (this.isZERO()) {
            return genPolynomial;
        }
        int n2 = -1;
        if (genPolynomialRing.a.getEvord2() != 0 && genPolynomialRing.a) {
            n2 = genPolynomialRing.a.getSplit();
        }
        SortedMap sortedMap = genPolynomial.a;
        SortedMap sortedMap2 = this.a;
        for (Map.Entry entry : sortedMap2.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            ExpVector expVector2 = n2 >= 0 ? expVector.reverse(n2) : expVector.reverse();
            p p2 = (p)entry.getValue();
            sortedMap.put(expVector2, p2);
        }
        return genPolynomial;
    }

    public Iterator coefficientIterator() {
        return this.a.values().iterator();
    }

    public Iterator exponentIterator() {
        return this.a.keySet().iterator();
    }

    public Iterator iterator() {
        return new PolyIterator(this.a);
    }

    public GenPolynomial map(s s2) {
        GenPolynomial genPolynomial = this.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial.a;
        for (Monomial monomial : this) {
            p p2 = (p)s2.eval(monomial.a);
            if (p2 == null || p2.isZERO()) continue;
            sortedMap.put(monomial.a, p2);
        }
        return genPolynomial;
    }
}

