/*
 * Decompiled with CFR 0.152.
 */
package org.mathpiper.builtin.javareflection;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mathpiper.builtin.javareflection.E;
import org.mathpiper.builtin.javareflection.Importer;
import org.mathpiper.builtin.javareflection.SingleImporter;
import org.mathpiper.builtin.javareflection.WildImporter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Import {
    private static ClassLoader a = Import.class.getClassLoader();
    public static final Vector a;
    public static final Vector b;
    public static final Hashtable a;

    static {
        try {
            Thread.currentThread().setContextClassLoader(Import.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        a = new Vector(50);
        b = new Vector(50);
        a = new Hashtable(200);
        Import.addImport("java.lang.Object");
        Import.addImport("java.lang.*");
        Import.addImport("java.lang.reflect.*");
        Import.addImport("java.util.*");
        Import.addImport("jsint.*");
    }

    public static synchronized ClassLoader getClassLoader() {
        return a;
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        a = classLoader;
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public static synchronized void addImport(String string) {
        if (string.endsWith("*")) {
            Import.addNew(b, new WildImporter(string));
            a.clear();
        } else {
            Import.addNew(a, new SingleImporter(string));
        }
    }

    private static void addNew(Vector vector, Object object) {
        if (object != null && !vector.contains(object)) {
            vector.addElement(object);
        }
    }

    public static Class classNamed(String string) {
        Class clazz = Import.maybeClassNamed(string);
        return clazz == null ? (Class)E.error("Can't find class " + string + ".") : clazz;
    }

    public static synchronized Class maybeClassNamed(String string) {
        Class clazz = (Class)a.get(string);
        if (clazz != null) {
            return clazz;
        }
        clazz = Import.classNamedLookup(string);
        if (clazz != null) {
            a.put(string, clazz);
        }
        return clazz;
    }

    private static Class classNamedLookup(String string) {
        if (string.endsWith("[]")) {
            return Import.classNamedArray(string.substring(0, string.length() - "[]".length()));
        }
        Class clazz = Import.classNamedImported(string);
        if (clazz != null) {
            return clazz;
        }
        return Import.primitiveClassNamed(string);
    }

    private static Class classNamedImported(String string) {
        Vector vector = Import.find(a, string, new Vector(5));
        if (string.lastIndexOf(".") == -1) {
            if (vector.size() == 0) {
                vector = Import.classNamedNoPackage(string, vector);
            }
            if (vector.size() == 0) {
                vector = Import.find(b, string, vector);
            }
        } else {
            Import.addNew(vector, Import.forName(string));
        }
        return Import.returnClass(string, vector);
    }

    private static Class returnClass(String string, Vector vector) {
        int n2 = vector.size();
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return (Class)vector.elementAt(0);
        }
        return (Class)E.warn("Class " + string + " is ambiguous " + vector + " choosing " + (Class)vector.elementAt(0));
    }

    private static Vector classNamedNoPackage(String string, Vector vector) {
        Import.addNew(vector, Import.forName(string.startsWith("$") ? string.substring(1, string.length()) : string));
        return vector;
    }

    public static Vector find(Vector vector, String string, Vector vector2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Import.addNew(vector2, ((Importer)enumeration.nextElement()).classNamed(string));
        }
        return vector2;
    }

    private static Class classNamedArray(String string) {
        Class clazz = Import.classNamed(string);
        if (clazz.isPrimitive()) {
            return Import.classNamedArrayPrimitive(clazz);
        }
        if (clazz.isArray()) {
            return Import.forName("[" + clazz.getName());
        }
        return Import.forName("[L" + clazz.getName() + ";");
    }

    public static Class forName(String string) {
        ClassLoader classLoader = Import.getClassLoader();
        if (classLoader == null) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    private static Class primitiveClassNamed(String string) {
        return string.equals("void") ? Void.TYPE : (string.equals("boolean") ? Boolean.TYPE : (string.equals("byte") ? Byte.TYPE : (string.equals("char") ? Character.TYPE : (string.equals("short") ? Short.TYPE : (string.equals("int") ? Integer.TYPE : (string.equals("long") ? Long.TYPE : (string.equals("float") ? Float.TYPE : (string.equals("double") ? Double.TYPE : null))))))));
    }

    private static Class classNamedArrayPrimitive(Class clazz) {
        return clazz == Boolean.TYPE ? boolean[].class : (clazz == Byte.TYPE ? byte[].class : (clazz == Character.TYPE ? char[].class : (clazz == Short.TYPE ? short[].class : (clazz == Integer.TYPE ? int[].class : (clazz == Long.TYPE ? long[].class : (clazz == Float.TYPE ? float[].class : (clazz == Double.TYPE ? double[].class : null)))))));
    }

    private Import() {
    }
}

