/*
 * Decompiled with CFR 0.152.
 */
package org.mathpiper.builtin.javareflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mathpiper.builtin.javareflection.E;
import org.mathpiper.builtin.javareflection.Import;
import org.mathpiper.builtin.javareflection.Invoke;
import org.mathpiper.builtin.javareflection.Reflector;
import org.mathpiper.builtin.javareflection.U;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JavaField
extends Reflector {
    static final Hashtable a = new Hashtable(20);
    static final Hashtable b = new Hashtable(20);
    String a;
    transient Field a;
    boolean a = false;
    transient Hashtable c;

    static Hashtable fieldTable0(boolean bl2) {
        if (bl2) {
            return b;
        }
        return a;
    }

    public static Field getField(Class clazz, String string, boolean bl2) {
        try {
            return bl2 ? JavaField.getDeclaredField(clazz, string) : clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return (Field)E.error("no such field: " + clazz + "." + string);
        }
        catch (Exception exception) {
            return (Field)E.error("error accessing field: " + clazz + "." + string + " is " + exception);
        }
    }

    private static Hashtable getFieldClassTable(String string, boolean bl2) {
        Hashtable hashtable = JavaField.fieldTable0(bl2);
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable(3);
            hashtable.put(string, hashtable2);
        }
        return hashtable2;
    }

    private static Field getDeclaredField(Class clazz, String string) {
        try {
            Field[] fieldArray = (Field[])Invoke.makeAccessible(clazz.getDeclaredFields());
            int n2 = 0;
            while (n2 < fieldArray.length) {
                if (fieldArray[n2].getName().equals(string)) {
                    return fieldArray[n2];
                }
                ++n2;
            }
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                return JavaField.getDeclaredField(clazz2, string);
            }
            return (Field)E.error("\n\nERROR: no field: \"" + string + "\" for class \"" + clazz + "\"");
        }
        catch (Exception exception) {
            return clazz.getField(string);
        }
    }

    public JavaField(String string, Class clazz) {
        this(string, clazz, false);
    }

    public JavaField(String string, Class clazz, boolean bl2) {
        this.b = string;
        this.b = (Hashtable)bl2;
        if (clazz != null) {
            this.a = clazz.getName();
        }
        this.reset();
    }

    protected synchronized void reset() {
        Class clazz;
        Class clazz2 = clazz = this.a == null ? null : Import.classNamed(this.a);
        if (clazz != null) {
            this.a = JavaField.getField(clazz, (String)((Object)this.b), (boolean)this.b);
            this.a = Modifier.isStatic(this.a.getModifiers());
            this.a = (Hashtable)(!this.a ? 1 : 0);
            this.b = Modifier.isFinal(this.a.getModifiers()) ? this.a : this.a + true;
        } else {
            this.c = JavaField.getFieldClassTable((String)((Object)this.b), (boolean)this.b);
            this.a = (Hashtable)true;
            this.b = (Hashtable)2;
        }
    }

    public Object apply(Object[] objectArray) {
        int n2 = objectArray.length;
        if (this.a) {
            if (n2 == 1) {
                return this.setStaticFieldValue(this.a, objectArray[0]);
            }
            return this.getStaticFieldValue(this.a);
        }
        if (n2 == 1) {
            return this.getFieldValue(objectArray[0], this.getTargetField(objectArray[0]));
        }
        return this.setFieldValue(objectArray[0], this.getTargetField(objectArray[0]), objectArray[1]);
    }

    public Field getTargetField(Object object) {
        if (this.a != null) {
            return this.a;
        }
        Class<?> clazz = object.getClass();
        Field field = (Field)this.c.get(clazz);
        if (field != null) {
            return field;
        }
        field = JavaField.getField(clazz, (String)((Object)this.b), (boolean)this.b);
        if (field == null) {
            return (Field)E.error(String.valueOf(U.stringify(object)) + " does not have a field " + (String)((Object)this.b));
        }
        this.c.put(clazz, field);
        return field;
    }

    public Object getFieldValue(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            return E.error("Illegal Access to field: " + field + " in " + U.stringify(object));
        }
    }

    public Object setFieldValue(Object object, Field field, Object object2) {
        try {
            Object object3 = field.get(object);
            field.set(object, object2);
            return object3;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public Object getStaticFieldValue(Field field) {
        try {
            return field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public Object setStaticFieldValue(Field field, Object object) {
        try {
            Object object2 = field.get(null);
            field.set(null, object);
            return object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }
}

