# The LearningOnline Network with CAPA
# rank style response
#
# $Id: rankresponse.pm,v 1.64 2010/12/19 00:48:50 raeburn Exp $
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::rankresponse;
use strict;
use HTML::Entities();
use Apache::optionresponse();
use Apache::lonlocal;
use Apache::lonxml;
use Apache::lonnet;

BEGIN {
    &Apache::lonxml::register('Apache::rankresponse',('rankresponse'));
}

sub start_rankresponse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    #when in a rank response use these
    &Apache::lonxml::register('Apache::rankresponse',
			      ('foilgroup','foil','conceptgroup'));
    push (@Apache::lonxml::namespace,'rankresponse');
    my $id = &Apache::response::start_response($parstack,$safeeval);
    %Apache::hint::rank=();
    undef(%Apache::response::foilnames);
    if ($target eq 'meta') {
	$result=&Apache::response::meta_package_write('rankresponse');
    } elsif ($target eq 'edit' ) {
	$result.=&Apache::edit::start_table($token)
           .'<tr><td>'.&Apache::lonxml::description($token).'</td>'
           .'<td><span class="LC_nobreak">'.&mt('Delete?').' '
           .&Apache::edit::deletelist($target,$token)
           .'</span></td>'
           .'<td>&nbsp;'.&Apache::edit::end_row()
           .&Apache::edit::start_spanning_row();
	
	$result.=
	    &Apache::edit::text_arg('Max Number Of Shown Foils:','max',$token,'4').
	    &Apache::edit::select_arg('Randomize Foil Order:','randomize',
				      ['yes','no'],$token).
	    &Apache::edit::end_row().&Apache::edit::start_spanning_row()."\n";
    } elsif ($target eq 'modified') {
	my $constructtag=&Apache::edit::get_new_args($token,$parstack,
						     $safeeval,'max',
						     'randomize');
	if ($constructtag) { $result = &Apache::edit::rebuild_tag($token); }
    } elsif ($target eq 'analyze') {
	my $part_id="$Apache::inputtags::part.$id";
        $Apache::lonhomework::analyze{"$part_id.type"} = 'rankresponse';
	push (@{ $Apache::lonhomework::analyze{"parts"} },$part_id);
	push (@{ $Apache::lonhomework::analyze{"$part_id.bubble_lines"} }, 1);

    }
    return $result;
}

sub end_rankresponse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'edit') { $result=&Apache::edit::end_table(); }
    &Apache::response::end_response;
    pop @Apache::lonxml::namespace;
    &Apache::lonxml::deregister('Apache::rankresponse',
				('foilgroup','foil','conceptgroup'));
    undef(%Apache::response::foilnames);
    return $result;
}

%Apache::response::foilgroup=();
sub start_foilgroup {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    %Apache::response::foilgroup=();
    $Apache::rankresponse::conceptgroup=0;
    &Apache::response::pushrandomnumber(undef,$target);
    return $result;
}

sub end_foilgroup {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    if ($target eq 'grade' || $target eq 'web' || $target eq 'answer' ||
	$target eq 'tex' || $target eq 'analyze') {
	my $max = &Apache::lonxml::get_param('max',$parstack,$safeeval,'-2');
	my $randomize = &Apache::lonxml::get_param('randomize',$parstack,
						   $safeeval,'-2');
	my $tol = &Apache::lonxml::get_param('tol',$parstack,$safeeval,'-2');
	if (!defined($tol)) { $tol=0; }
	if ($target eq 'web' || $target eq 'tex') {
	    $result=&displayfoils($target,$max,$randomize,$tol);
	    $Apache::lonxml::post_evaluate=0;
	} elsif ($target eq 'answer' ) {
	    $result=&displayanswers($max,$randomize,$tol);
	} elsif ( $target eq 'grade') {
	    &grade_response($max,$randomize,$tol);
	} elsif ( $target eq 'analyze') {
	    my @shown = &whichfoils($max,$randomize);
	    &Apache::response::analyze_store_foilgroup(\@shown,
						  ['text','value','location']);
	    my $part_id=
		"$Apache::inputtags::part.$Apache::inputtags::response[-1]";
	    $Apache::lonhomework::analyze{"$part_id.tol"}=$tol;
	}
	my $part = $Apache::inputtags::part;
	my $id   = $Apache::inputtags::response[-1];
	&Apache::lonxml::increment_counter(&getfoilcounts($max),
					   "$part.$id");
	if ($target eq 'analyze') {
	    &Apache::lonhomework::set_bubble_lines();
	}
    } elsif ($target eq 'edit') {
	$result=&Apache::edit::end_table();
    }
    &Apache::response::poprandomnumber();
    return $result;
}

sub get_correct_order {
    my ($tol,@foils) =@_;
    my @correctorder;
    my @value_names;
    foreach my $name (@foils) {
	my @pair=($Apache::response::foilgroup{$name.'.value'},$name);
	push(@value_names,\@pair);
    }
    @value_names =
	sort {
	    if (abs($a->[0] - $b->[0]) > $tol) {return ($a->[0] <=> $b->[0]);}
	    return 0;
	} @value_names;
    my @value_names_tmp=@value_names;
    my $firstpair=shift(@value_names_tmp);
    my $order=1;
    my %order;
    my $count=1;
    my $lastvalue=$firstpair->[0];
    $order{$firstpair->[1]}=$order;
    foreach my $pair (@value_names_tmp) {
	$count++;
	if (abs($pair->[0]-$lastvalue) > $tol ) {
	    $order=$count;
	}
	$order{$pair->[1]}=$order;
	$lastvalue=$pair->[0];
    }
    foreach my $name (@foils) {
	push(@correctorder,$order{$name});
    }
    &Apache::lonhomework::showhash('b' => \@value_names);
    &Apache::lonhomework::showhash('b' => \@correctorder);
    return @correctorder;
}

sub displayanswers {
    my ($max,$randomize,$tol,@opt)=@_;
    if (!defined(@{ $Apache::response::foilgroup{'names'} })) { return; }
    my @names = @{ $Apache::response::foilgroup{'names'} };
    my @whichfoils = &whichfoils($max,$randomize);
    my @correctorder=&get_correct_order($tol,@whichfoils);
    my $result;
    if ($Apache::lonhomework::type eq 'exam') {
	my @alphabet = ('A'..'Z');
	my $i=0;
	foreach my $order (@correctorder) {
	    $result.=&Apache::response::answer_header('rankresponse',$i++);
	    $result.=&Apache::response::answer_part('rankresponse',
						    $alphabet[$order-1]);
	    $result.=&Apache::response::answer_part('rankresponse',$order);
	    $result.=&Apache::response::answer_footer('rankresponse');
	}
    } else {
	$result=&Apache::response::answer_header('rankresponse');
	foreach my $order (@correctorder) {
	    $result.=&Apache::response::answer_part('rankresponse',$order);
	}
	$result.=&Apache::response::answer_footer('rankresponse');
    }
    return $result;
}

sub check_response_order {
    my (%responsehash)=@_;
    my @order=sort( {$a <=> $b} values(%responsehash));
    my $lastvalue=0;
    my $expected=1;
    my $malformed=0;
    foreach my $current (@order) {
	&Apache::lonxml::debug("$lastvalue $expected $malformed");
	if (!($current == $lastvalue || $current == $expected)) {
	    $malformed=1;
	}
	$expected++;
	$lastvalue=$current;
    }
    return $malformed;
}

sub grade_response {
    my ($max,$randomize,$tol)=@_;
    my (@whichfoils)=&whichfoils($max,$randomize);
    if (!&Apache::response::submitted()) { return; }
    my %responsehash;
    my %grade;
    my ($temp,$right,$wrong,$ignored)=(1,0,0,0);
    my @correctorder=&get_correct_order($tol,@whichfoils);
    foreach my $name (@whichfoils) {
	my $response = &Apache::response::getresponse($temp,'A is 1');
	my $value=shift(@correctorder);
	if ( $response =~ /[^\s]/) {
	    $responsehash{$name}=$response;
	    &Apache::lonxml::debug("submitted a $response for $value<br />\n");
	    if ($value eq $response) {
		$grade{$name}='1'; $right++;
	    } else {
		$grade{$name}='0'; $wrong++;
	    }
	} else {
	    $ignored++;
	}
	$temp++;
    }
    my $malformed=&check_response_order(%responsehash);
    my $part=$Apache::inputtags::part;
    my $id = $Apache::inputtags::response['-1'];
    my $responsestr=&Apache::lonnet::hash2str(%responsehash);
    my $gradestr   =&Apache::lonnet::hash2str(%grade);
    my %previous=&Apache::response::check_for_previous($responsestr,
						       $part,$id);
    &Apache::lonxml::debug("Got $right right and $wrong wrong, and $ignored were ignored and was $malformed malformed");
    my $ad;
    if ($malformed) {
	$ad='MISORDERED_RANK';
    } elsif ($wrong==0 && $ignored==0) {
	$ad='EXACT_ANS';
    } elsif ($wrong==0 && $right==0) {
	#nothing submitted
    } else {
	if ($ignored==0) {
	    $ad='INCORRECT';
	} else {
	    $ad='MISSING_ANSWER';
	}
    }
    if (($ad eq 'INCORRECT' || $ad eq 'EXACT_ANS')) {
        if ($Apache::lonhomework::type eq 'survey') {
            $ad='SUBMITTED';
        } elsif ($Apache::lonhomework::type eq 'surveycred') {
	    $ad='SUBMITTED_CREDIT';
        } elsif ($Apache::lonhomework::type eq 'anonsurvey') {
            $ad='ANONYMOUS';
        } elsif ($Apache::lonhomework::type eq 'anonsurveycred') {
            $ad='ANONYMOUS_CREDIT';
        } else {
            $Apache::lonhomework::results{"resource.$part.$id.submissiongrading"}=$gradestr;
        }
    } else {
	$Apache::lonhomework::results{"resource.$part.$id.submissiongrading"}=$gradestr;
    }
    if ($Apache::lonhomework::type eq 'randomizetry') {
        if ($Apache::lonhomework::type eq 'randomizetry') {
            $Apache::lonhomework::results{"resource.$part.$id.foilorder"} = &Apache::lonnet::array2str(@whichfoils);
        }
    }
    $Apache::lonhomework::results{"resource.$part.$id.submission"}=
	$responsestr;
    $Apache::lonhomework::results{"resource.$part.$id.awarddetail"}=$ad;
    &Apache::response::handle_previous(\%previous,$ad);
}

sub format_prior_answer {
    my ($mode,$answer,$other_data) = @_;
    my %lastresponse=&Apache::lonnet::str2hash($answer);
    my $foil_order  =$other_data->[0];
    my %grading     =&Apache::lonnet::str2hash($other_data->[1]);
    my $output;
    foreach my $name (@{ $foil_order }) {
	next if (!defined($lastresponse{$name}));
	$output .= '<tr><td>'.$lastresponse{$name}.'</td></tr>';
    }
    return if (!defined($output));
    $output =
	'<table class="LC_prior_rank">'.$output.'</table>';
    return $output;
}

sub displayfoils {
    my ($target,$max,$randomize,$tol)=@_;
    my $result;
    my @alphabet=('A'..'Z');
    my (@whichfoils)=&whichfoils($max,$randomize);
    my $part=$Apache::inputtags::part;
    my $solved=$Apache::lonhomework::history{"resource.$part.solved"};
    my @whichopt=(1..($#whichfoils+1));
    my @correctorder=&get_correct_order($tol,@whichfoils);
    if ( &Apache::response::show_answer() && ($target ne 'tex')) {
	foreach my $name (@whichfoils) {
	    my $text=$Apache::response::foilgroup{$name.'.text'};
	    my $value=shift(@correctorder);
	    if ($target eq 'web') {
		$result.='<br /><b>'.$value.':</b> '.$text;
	    } else {
		$result.=' \strut\\\\\strut '.$value.':'.$text;
	    }
	}
    } else {
	my $i = 0;
	my $temp=1;
	my $id=$Apache::inputtags::response[-1];
	my $part=$Apache::inputtags::part;
        my ($lastresponse,$newvariation);
        if ((($Apache::lonhomework::history{"resource.$part.type"} eq 'randomizetry') ||
             ($Apache::lonhomework::type eq 'randomizetry')) &&
        ($Apache::inputtags::status[-1] eq 'CAN_ANSWER')) {
            if ($env{'form.'.$part.'.rndseed'} ne
                $Apache::lonhomework::history{"resource.$part.rndseed"}) {
                $newvariation = 1;
            }
        }
        unless (((($Apache::lonhomework::history{"resource.$part.type"} eq 'anonsurvey') || ($Apache::lonhomework::history{"resource.$part.type"} eq 'anonsurveycred')) && (defined($env{'form.grade_symb'}))) || $newvariation) {
            $lastresponse=$Apache::lonhomework::history{"resource.$part.$id.submission"};
        }
	my %lastresponse=&Apache::lonnet::str2hash($lastresponse); 
	my @alp = splice @alphabet, 0, $#whichopt + 1;
	my $internal_counter=$Apache::lonxml::counter;
        if($target eq 'tex' && $env{'form.pdfFormFields'} eq 'yes') {
            $result .= '\strut \\\\ \strut \\\\' ;
        }
        foreach my $name (@whichfoils) {
	    my $lastopt=$lastresponse{$name};
	    my $optionlist='';
	    if ($target ne 'tex') {
                $optionlist = "<option></option>\n";
            } 
            if ($target eq 'tex' && $env{'form.pdfFormFields'} eq 'yes') {
                my $fieldname = $env{'request.symb'}.'&part_'.$Apache::inputtags::part.'&rankresponse'.'&HWVAL_'.$Apache::inputtags::response['-1'].':'.$temp;
                $optionlist =  &Apache::lonxml::print_pdf_start_combobox($fieldname);
            }
	    my $option;
	    foreach $option (@whichopt) {
		if ($option eq $lastopt) {
		    if ($target ne 'tex' ) {
                        $optionlist.="<option selected=\"selected\">$option</option>\n";
                    } elsif ($target eq 'tex' && $env{'form.pdfFormFields'} eq 'yes') {
                        $optionlist .= &Apache::lonxml::print_pdf_add_combobox_option($option); 
                    }
		} else {
		    if ($target ne 'tex') {
                        $optionlist.="<option>$option</option>\n";
                    } elsif ($target eq 'tex' && $env{'form.pdfFormFields'} eq 'yes') {
                        $optionlist .= &Apache::lonxml::print_pdf_add_combobox_option($option); 
                    }
		} 
	    }
	    if ($target ne 'tex' && $Apache::lonhomework::type ne 'exam') {
		$optionlist='<select onchange="javascript:setSubmittedPart(\''.
		  $part.'\');" name="HWVAL_'.
		    $Apache::inputtags::response[-1].':'.$temp.'">'.
		        $optionlist."</select>\n";
	    } elsif ($env{'form.pdfFormFields'} eq 'yes') {
                #do nothing
            } else {
		$optionlist=' '.$temp.' '.$optionlist.' ';
	    }
	    my $text=$Apache::response::foilgroup{$name.'.text'};
	    if ($target ne 'tex') {
		if ($Apache::lonhomework::type ne 'exam') {
		    $result.='<br />'.$optionlist.$text."\n";
		} else {
		    $result.='<br />'.$text."\n";
		}
		if ($Apache::lonhomework::type eq 'exam') {
		    my @values=(1..scalar(@whichopt));
		    $result.=&Apache::optionresponse::webbubbles(\@values,\@whichopt,$temp,$lastopt);
		}
	    } else {
		if ($Apache::lonhomework::type eq 'exam') {
		    $result .= '\vskip 0 mm '.$text.' \vskip 0 mm '."\n";
		    $result .= '\vskip -1 mm';
		    $result .= '\begin{enumerate}\item[\textbf{'.$internal_counter.'}.]';
		    $result .= &Apache::optionresponse::bubbles(\@alp,\@whichopt,'rankresponse');
		    $result .= '\end{enumerate} \vskip -8 mm \strut ';
		    $internal_counter++;
		} else {
                    if($env{'form.pdfFormFields'} ne 'yes') {
		        $result.=' \vskip 0mm \framebox[5 mm][s]{\tiny\strut} '.$text."\n";
                    } else {
                        $result.= $optionlist.' '. &Apache::lonxml::print_pdf_end_combobox($text).'\strut \\\\';
                    }
		}
	    }
	    $temp++;
	}
    }
    if ($target eq 'web') {
        my $questiontype;
        if ($Apache::lonhomework::type eq 'randomizetry') {
            $questiontype = $Apache::lonhomework::type;
        }
	&Apache::response::setup_prior_tries_hash(\&format_prior_answer,
						  [\@whichfoils,
						   'submissiongrading'],
                                                  $questiontype);
    }
    if ($target ne 'tex') {$result.="<br />";} else {$result.=' \vskip 0 mm ';}
    return $result;
}

sub getfoilcounts {
    my ($max)=@_;
    # +1 since instructors will count from 1
    my $count = $#{ $Apache::response::foilgroup{'names'} }+1;
    if (&Apache::response::showallfoils()) { $max=$count; }
    if ($count>$max) { $count=$max } 
    &Apache::lonxml::debug("Count is $count from $max");
    return $count;
}

sub whichfoils {
    my ($max,$randomize)=@_;
    return &Apache::response::whichorder($max,$randomize,
					 &Apache::response::showallfoils(),
					 \%Apache::response::foilgroup);
}

sub start_conceptgroup {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    $Apache::rankresponse::conceptgroup=1;
    %Apache::response::conceptgroup=();
    my $result;
    if ($target eq 'edit') {
	$result.=&Apache::edit::tag_start($target,$token,
					  "Concept Grouped Foils");
	$result.=&Apache::edit::text_arg('Concept:','concept',$token,'50').
	    &Apache::edit::end_row().&Apache::edit::start_spanning_row();
    }
    if ($target eq 'modified') {
	my $constructtag=&Apache::edit::get_new_args($token,$parstack,
						     $safeeval,'concept');
	if ($constructtag) { $result = &Apache::edit::rebuild_tag($token); }
    }
    return $result;
}

sub end_conceptgroup {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    $Apache::rankresponse::conceptgroup=0;
    my $result='';
    if ($target eq 'web' || $target eq 'grade' || $target eq 'answer' ||
	$target eq 'tex' || $target eq 'analyze') {
	#if not there aren't any foils to display and thus no question
	&Apache::response::pick_foil_for_concept($target,
						 ['value','text','location'],
						 \%Apache::hint::rank,
						 $parstack,$safeeval);
    } elsif ($target eq 'edit') {
	$result=&Apache::edit::end_table();
    }
    return $result;
}

sub insert_conceptgroup {
    my $result="\n\t\t<conceptgroup concept=\"\">".&insert_foil()."\n\t\t</conceptgroup>\n";
    return $result;
}

sub start_foil {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result='';
    if ($target eq 'web' || $target eq 'tex' || $target eq 'analyze') {
	&Apache::lonxml::startredirection;
	if ($target eq 'analyze') {
	    &Apache::response::check_if_computed($token,$parstack,$safeeval,'value');
	}
    } elsif ($target eq 'edit') {
	$result=&Apache::edit::tag_start($target,$token,"Foil");
	my $level='-2';
	if ($$tagstack[-2] eq 'conceptgroup') { $level = '-3'; }
	$result.=&Apache::edit::text_arg('Name:','name',$token);
	$result.= &Apache::edit::text_arg('Rank Value:','value',$token,'15');
	my $randomize=&Apache::lonxml::get_param('randomize',$parstack,
						 $safeeval,'-3');
	if ($randomize ne 'no') {
	    $result.=&Apache::edit::select_arg('Location:','location',
					     ['random','top','bottom'],$token);
	}
	$result .=&Apache::edit::end_row().&Apache::edit::start_spanning_row();
    } elsif ($target eq 'modified') {
	my $constructtag=&Apache::edit::get_new_args($token,$parstack,
						     $safeeval,'value',
						     'name','location');
	if ($constructtag) { $result = &Apache::edit::rebuild_tag($token); }
    }
    return $result;
}

sub end_foil {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $text ='';
    my $result = '';
    if ($target eq 'web' || $target eq 'tex' || $target eq 'analyze') {
	$text=&Apache::lonxml::endredirection;
    }
    if ($target eq 'web' || $target eq 'grade' || $target eq 'answer' ||
	$target eq 'tex' || $target eq 'analyze') {
	my $value = &Apache::lonxml::get_param('value',$parstack,$safeeval);
	if ($target eq 'tex' && $Apache::lonhomework::type eq 'exam') {
	    $text='\vskip 5mm $\triangleright$ '.$text;
	}
	if ($value ne 'unused') {
	    my $name = &Apache::lonxml::get_param('name',$parstack,$safeeval);
	    &Apache::lonxml::debug("Got a name of :$name:");
	    if ($name eq "") {
		&Apache::lonxml::warning(&mt('Foils without names exist. This can cause problems to malfunction.'));
		$name=$Apache::lonxml::curdepth;
	    }
	    &Apache::lonxml::debug("Using a name of :$name:");
	    if (defined($Apache::response::foilnames{$name})) {
		&Apache::lonxml::error(&mt('Foil name [_1] appears more than once. Foil names need to be unique.','<b><tt>'.$name.'</tt></b>'));
	    }
	    $Apache::response::foilnames{$name}++;
	    my $location =&Apache::lonxml::get_param('location',$parstack,
						     $safeeval);
	    if ( $Apache::rankresponse::conceptgroup
		 && !&Apache::response::showallfoils() ) {
		push @{ $Apache::response::conceptgroup{'names'} }, $name;
		$Apache::response::conceptgroup{"$name.value"} = $value;
		$Apache::response::conceptgroup{"$name.text"} = $text;
		$Apache::response::conceptgroup{"$name.location"} = $location;
	    } else {
		push @{ $Apache::response::foilgroup{'names'} }, $name;
		$Apache::response::foilgroup{"$name.value"} = $value;
		$Apache::response::foilgroup{"$name.text"} = $text;
		$Apache::response::foilgroup{"$name.location"} = $location;
	    }
	}
    }
    if ($target eq 'edit') {
	$result.= &Apache::edit::tag_end($target,$token,'');
    }
    return $result;
}

sub insert_foil {
    return '
<foil name="" value="unused">
<startouttext />
<endouttext />
</foil>';
}
1;
__END__
