// The LearningOnline Network with CAPA
// bookmarklib.js
// 
// $Id: bookmarklib.js,v 1.23 2009/04/23 10:31:28 bisitz Exp $
// 
// Copyright Michigan State University Board of Trustees
// 
// This file is part of the LearningOnline Network with CAPA (LON-CAPA).
// 
// LON-CAPA is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// LON-CAPA is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with LON-CAPA; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// /home/httpd/html/adm/gpl.txt
//
// http://www.lon-capa.org/ 
//
//
// This is a rewritten version of bookmarklib.js
//
// Functions to be combined with the HTML code found in
// admbookmarks.pm. The combination will provide a complete
// functionality for the bookmarkmenu in accordance to defined
// requirements.
//
// For further information and documentation regarding this program,
// please refer to bookmarkmenu_OOD.txt, the design documentation for
// bookmarkmenu.
//
//
//
// The perl module admbookmarks.pm interacts with this library by
// generating a page that includes bookmarklib.js and a JavaScript
// function initializeTree() that builds the the tree using successive
// newLink() and newFolder() calls and one cache=new newCache() call.
// The entire newLink()/newFolder() succession is the string that is
// stored in the userspace on Lon-Capa as bookmarks.
//
//
//                          Created on: 12-28-2000   by Benjamin Tyszka
//                              Edited: 12-29-2000   by Benjamin Tyszka
//                                      mm-dd-yyyy   by Xxxxxxxx Xxxxxx


//clienttitle="Enter title here";//debug
//clienthref="Enter url here"; //debug

//function ugh_oh( msg, url, ln ) {
//   alert("Error: "+msg+" in "+url+" at line: "+ln);
//   return true; 
//}

//alert("Does alert even work?");

//window.onerror=ugh_oh;
//this.onerror=ugh_oh;



//---------------------------------------------------------------------
// Tree object
//---------------------------------------------------------------------
// Basis for user's bookmarks and folders - All properties and methods
// pertaining to a user in general are found here. Refer to
// bookmarkmenu_OOD.txt for further documenation.
function newTree() {
	this.redraw = redraw;
	this.treeSave = treeSave;
	this.bookmarks = new newFolder("bookmarks",true);
	this.cache = new newCache();
}

//------------------------------------------refresh folder/link display
function redraw() {
   image_num = -1; // reset to before (-1 not 0) the first image
   with(frames[4].document) {
      open();                        //--------for 'compliant' browsers
      clear();                       //----------for Mozilla (Netscape6)
      write("<html>\n"                                            );
      write("<body link=\"#000000\" vlink=\"000000\" " );
      write("style=\"background-color: #DDDDDD; color: #000000; margin: 0px;\">\n"                   );
      write("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n"   );
   }
//   bendebugger=window.open('','HTML_DUMP','scrollbars');  //debug
//   bendebugger.document.clear(); //debug
//   bendebugger.document.write('TEXT DOCUMENT: NONE OF THE TAGS SHOULD WORK\n'); //debug
   var objPath="top.tree.bookmarks";
   depth=0;
   for(var i=0;i<this.bookmarks.p.length;i++) {
      if (this.bookmarks.p[i].exists) {
         if (this.bookmarks.p[i].state=="folder") {
            var tmpObjPath=objPath+".p["+i+"]";
            this.bookmarks.p[i].folderDraw(depth+1,tmpObjPath);
         } else {
	    this.bookmarks.p[i].linkDraw(depth+1,objPath,i); // ----- Can't use
	                        // tmpObjPath because of later 'bump'
         }
      }
   }
//   this.bookmarks.folderDraw(0,"top.tree.bookmarks");
   top.frames[4].document.write("</table>\n</body>\n</html>");
   top.frames[4].document.close();
//   bendebugger.document.close(); //debug
//   return false; //debug
}

//-----------------generate 'save-string' and submit to admbookmarks.pm
function treeSave() {
   saveStrng="";
   var objPath="window.tree.bookmarks";
   var n=0;
   for(var i=0;i<this.bookmarks.p.length;i++) {
      if (this.bookmarks.p[i].exists) {
         if (this.bookmarks.p[i].state=="folder") {
	    this.bookmarks.p[i].folderWriteSave("window.tree.bookmarks",n);
         } else {
	    this.bookmarks.p[i].linkWriteSave("window.tree.bookmarks");
         }
         n++;
      }
   }
   
//   this.bookmarks.folderWriteSave("window.tree.bookmarks",0);
// THE FOLLOWING IS DEBUG INFORMATION
//   bendebugger=window.open('','HTML_DUMP','scrollbars');  //debug
//   bendebugger.document.clear(); //debug
//   bendebugger.document.write("THE FOLLOWING STRING WILL BE POSTED TO THE PERL MOD:<br>\n"+saveStrng); //debug
//   bendebugger.document.close();
// END OF DEBUG STUFF
// NOW SUBMIT THE STRING TO PERL MODULE -CHECK ADDRESS CHECK ADDRESS
   top.frames[7].document.saveBookmarks.hiddenbookmarks.value=saveStrng;
   top.frames[7].document.saveBookmarks.submit;
}


//---------------------------------------------------------------------
// Folder object
//---------------------------------------------------------------------
// Pertains to a userdefined folder. Refer to
// bookmarkmenu_OOD.txt for further documentation.
function newFolder(name,opened) {
 // Folder Properties
      this.state       = "folder";
      this.name        = name;
      this.opened      = opened;
	if (this.opened) {
	   this.icon   = "/res/adm/pages/bookmarkmenu/folder_open.gif";
	} else {
	   this.icon   = "/res/adm/pages/bookmarkmenu/folder_close.gif";
	}
      this.exists      = true;
      this.highlited   = false;
      this.p           = new Array(); // ---- ordered folder contents
 // Folder Methods
      this.addLink     = addLink;
      this.addFolder   = addFolder;
      this.insertLink  = insertLink;
      this.swapState   = swapState;
      this.moveTo      = moveTo;
      this.bump        = bump;
      this.folderEdit  = folderEdit;
      this.folderDraw  = folderDraw;
      this.folderWriteSave = folderWriteSave;
      this.folderHover = folderHover;
      this.folderClick = folderClick;
      this.linkClick   = linkClick;//--Folder method, because of 'bump'
}

//------------------------------Add link to last position within folder
function addLink(name,url) {
//   if (this.length!=0) {
      var location=this.p.length;
//      alert("THE ADD link:"+name+", location:"+location);
//   }
   this.p[location]=new newLink(name,url);
//   var location=this.length+1;
//   tree.treeRedraw(); //commented so that we can make tree. one more below
}

//----------------------Add empty folder to last position within folder
function addFolder(name,opened) {
//   if (this.length!=0) {
      var location=this.p.length;
//      alert("THE ADD FOLDER:"+name+", location:"+location);
//   }
   this.p[location]=new newFolder(name,opened);
//   var location=this.length+1;
//   tree.treeRedraw();
}

//----------------------------------------Places folder within a folder
function insertLink(location,name,url) {
   this.bump(location);
   this.p[location]=new newLink(name,url);
   tree.redraw();
}

//----------------------------------Swap folder between open and closed
function swapState() {
   this.opened=(!this.opened);
   if (this.opened) {
      this.icon = "/res/adm/pages/bookmarkmenu/folder_open.gif";
   } else {
      this.icon = "/res/adm/pages/bookmarkmenu/folder_close.gif";
   }
   top.tree.redraw();
}

//-------------------recursive, Moves folder and contents to new object
//                        Don't forget to 'bump' before calling moveTo!
function moveTo(object1) {
   object1=new newFolder(this.name,this.opened);
   for (var i=0;i<this.p.length;i++) {
     if (this.p[i].exists) {
         if (this.p[i].state=="folder") {
            object1.p[i]=this.p[i].moveTo(object1.p[i]);
         } else {
            object1.p[i]=new newLink(this.p[i].name,this.p[i].url);        
         }
         object1.p[i].exists=this.p[i].exists;
      }
   }
   return object1;
}

//---------------------------------------bump all folder/links within a
//                                     folder up one from 'location' up
function bump(location) {
   for (var i=this.p.length-1;i>=location;i--) {
      if (this.p[i].exists) { //saves time by not moving non-existing items
         if (this.p[i].state=="folder") {
            this.p[i+1]=this.p[i].moveTo(this.p[i+1]);
         } else {
            var name=this.p[i].name;
            var url =this.p[i].url;
            this.p[i+1]=new newLink(name,url);
            this.p[i+1].exists=this.p[i].exists;
         }
//         this.p[i].exists=false; // may not be neccessary if I'm careful
      } else {
         if (i!=this.p.length-1) {
	    this.p[i+1].exists=false;
	 }
      }
   }
}

function folderEdit() {

}

//------------------generates folder HTML and recurses through contents
function folderDraw(depth,objPath) {
   image_num+=3;
   if (this.opened) {
      with (parent.frames[4].document) {
	 write("<tr><td><a href=JavaScript:"+objPath+".swapState();>"   );
         write("<img src=\"/res/adm/pages/bookmarkmenu/folder_pointer_opened.gif\" border=\"0\"></a>");
	 write("<a href='JavaScript:"+objPath+".folderClick();'"        );
	 write("onmouseover="+objPath+".folderHover("+image_num+");>"   );
	 write("<img src=\"/res/adm/pages/bookmarkmenu/pix.gif\" height=\"25\" width=\""+20*(depth)+"\" border=\"0\"></a>");
	 write("<a href='javaScript:"+objPath+".folderClick();'"        );
         write("onmouseover='"+objPath+".folderHover("+image_num+");'>" );
	 write("<img src=\""+this.icon+"\" border=\"0\"></a>"           );
	 write( this.name+"</td></tr>"                                  );
      }
//       with (bendebugger.document) {
//	 write("<p>|-tr-||-td-||-a href=JavaScript:"+objPath+".swapState();-|\n"   );
//         write("|-img src=/res/adm/pages/bookmarkmenu/folder_pointer_opened.gif border=0-||-/a-|\n"       );
//	 write("|-a href='JavaScript:"+objPath+".folderClick();'\n"        );
//	 write("onmouseover="+objPath+".folderHover("+image_num+");-|\n"   );
//	 write("|-img src=/res/adm/pages/bookmarkmenu/pix.gif height=25 width="+20*(depth)+" border=0-||-/a-|\n");
//	 write("|-a href='javaScript:"+objPath+".folderClick();'"        );
//         write("onmouseover='"+objPath+".folderHover("+image_num+");'-|\n" );
//	 write("|-img src="+this.icon+" border=0-||-/a-|\n"                   );
//	 write( this.name                                               );
//	 write("|-/td-||-/tr-|\n"                                             );
//      }             //whole thing is a debug
      for(var i=0;i<this.p.length;i++) {
	 if (this.p[i].exists) {                                            // PROGRAM DIED HERE ONCE
            if (this.p[i].state=="folder") {
               var tmpObjPath=objPath+".p["+i+"]";
               this.p[i].folderDraw(depth+1,tmpObjPath);
	    } else {
	       this.p[i].linkDraw(depth+1,objPath,i); // ----- Can't use
		                   // tmpObjPath because of later 'bump'
            }
	 }
      }
   } else {
      with (parent.frames[4].document) {
	 write("<tr><td><a href=JavaScript:"+objPath+".swapState();>"   );
         write("<img src=\"/res/adm/pages/bookmarkmenu/folder_pointer_closed.gif\" border=\"0\"></a>"       );
	 write("<a href='JavaScript:"+objPath+".folderClick();'"        );
	 write(" onmouseover="+objPath+".folderHover("+image_num+");>"  );
	 write("<img src=\"/res/adm/pages/bookmarkmenu/pix.gif\" height=\"25\" width=\""+20*(depth)+"\" border=\"0\"></a>");
	 write("<a href=JavaScript:"+objPath+".folderClick();>"         );
	 write("<img src=\""+this.icon+"\" border=\"0\"></a>"           );
	 write( this.name+"</td></tr>"                                  );
      }
//      with (bendebugger.document) {
//	 write("<p>|-tr-||-td-||-a href=JavaScript:"+objPath+".swapState();-|\n"   );
//         write("|-img src=/res/adm/pages/bookmarkmenu/folder_pointer_closed.gif border=0-||-/a-|\n"       );
//	 write("|-a href='JavaScript:"+objPath+".folderClick();'"        );
//	 write(" onmouseover="+objPath+".folderHover("+image_num+");-|\n"  );
//	 write("|-img src=/res/adm/pages/bookmarkmenu/pix.gif height=25 width="+20*(depth)+" border=0-||-/a-|\n");
//	 write("|-a href=JavaScript:"+objPath+".folderClick();-|\n"         );
//	 write("|-img src="+this.icon+" border=0-||-/a-|\n"                   );
//	 write( this.name                                               );
//	 write("|-/td-||-/tr-|\n"                                             );
//     }
   }
}

//-------------generate folder save string and recurse through contents
function folderWriteSave(objPath,pos) {
   saveStrng += objPath+".addFolder('"+this.name+"',"+this.opened+");\n";
   var n=0;        //-----alt. counter doesn't count non-exists links/marks
//   alert(saveStrng+" with a length: "+this.p.length); //DEBUG
   for(var i=0;i<this.p.length;i++) {
      if (this.p[i].exists) {
//        alert("something exists"); //DEBUG
        var tmpObjPath=objPath+".p["+pos+"]";
        if (this.p[i].state=="folder") {
           this.p[i].folderWriteSave(tmpObjPath,n);
	} else {
           this.p[i].linkWriteSave(tmpObjPath);
        } 
	n++;
      }
   }
}

//------------------------swaps icons around when hovering folder image
function folderHover(image_num) {
   if (window.tree.cache.isLoaded) {
      if (window.tree.cache.lastImg==-2) {
	frames[7].document.images[1].src='/res/adm/pages/bookmarkmenu/folder_trash.gif';
      } else {
          if (typeof(window.tree.cache.lastImg)!='undefined') {
             if (window.tree.cache.lastImg>=0) {
                frames[4].document.images[window.tree.cache.lastImg].src=window.tree.cache.icon;
             }
          }
      }
      window.tree.cache.lastImg=image_num;
      window.tree.cache.icon=this.icon;
      frames[4].document.images[image_num].src="/res/adm/pages/bookmarkmenu/folder_drag.gif";
   }
}

//------------------------insert's cache into folder or picks up folder
function folderClick() {
   if (window.tree.cache.isLoaded) {
      window.tree.cache.cacheEmpty(this,0);
 //     var location=this.p.length+1;      // empties cache into folder 
 //     this.p[location]=new newFolder('name');
 //     tree.cache.p[1].moveTo(this.p[location]);
 //     tree.cache.isLoaded = false;
   } else {
      window.tree.cache.cacheLoad(this);
   }
}

function linkClick(pstn) {
   if (window.tree.cache.isLoaded) {
      window.tree.cache.cacheEmpty(this,pstn)
   } else {
      window.tree.cache.cacheLoad(this.p[pstn]);
   }
}


//---------------------------------------------------------------------
// Link object
//---------------------------------------------------------------------
// Pertains to a userdefined link. Refer to
// bookmarkmenu_OOD.txt for further documentation.
function newLink(name, url) {
 // Link Properties
      this.state     = "link";
      this.name      = name;
      this.url       = url;
      this.exists    = true;
      this.highlited = false;
	this.icon    = "/res/adm/pages/bookmarkmenu/link.gif";
 // Link Methods
      this.linkGoto  = linkGoto;
      this.linkEdit  = linkEdit;
      this.linkDraw  = linkDraw;
      this.linkWriteSave = linkWriteSave;
      this.linkHover = linkHover;
// this.linkClick = linkClick; --not a link method, now a folder method
}

function linkGoto() {
   if (typeof(self.opener.clientwindow) != 'undefined') {
       self.opener.clientwindow.location.href=this.url;
   } else {
       self.opener.location.href=this.url;
   }
}

function linkEdit() {

}

//------------------------------------generate HTML for individual link
function linkDraw(depth,objPath,pstn) {
   var tmpObjPath = objPath+".p["+pstn+"]";
   image_num+=2;
   with (parent.frames[4].document) {
      write("<tr><td><a href='javaScript:"+objPath+".linkClick("+pstn+");'" );
      write(" onmouseover='"+objPath+".p["+pstn+"].linkHover("+image_num+");'>");
      write("<img src=\"/res/adm/pages/bookmarkmenu/pix.gif\" height=\"25\" width=\""+(20*(depth)+15)+"\" border=\"0\"></a>");
      write("<a href='javaScript:"+objPath+".linkClick("+pstn+");'");
      write(" onmouseover='"+objPath+".p["+pstn+"].linkHover("+image_num+");'>");
      write("<img src=\"/res/adm/pages/bookmarkmenu/link.gif\" border=\"0\"></a>");
      write("<a href='javaScript:"+objPath+".p["+pstn+"].linkGoto();'" );
      write(" onmouseover='"+objPath+".p["+pstn+"].linkHover("+image_num+");'>");
      write(this.name+"</td></tr>"                                );
   }
//   with (bendebugger.document) {
//      write("<P>|-tr-||-td-||-a href='javaScript:"+objPath+".linkClick("+pstn+");'\n" );
//      write(" onmouseover='"+objPath+".p["+pstn+"].linkHover("+image_num+");'-|\n");
//      write("|-img src=/res/adm/pages/bookmarkmenu/pix.gif height=25 width="+(20*(depth)+15)+" border=0-||-/a-|\n");
//      write("|-a href='javaScript:"+objPath+".linkClick("+pstn+");'");
//      write(" onmouseover='"+objPath+".p["+pstn+"].linkHover("+image_num+");'-|\n");
//      write("|-img src=/res/adm/pages/bookmarkmenu/link.gif border=0-||-/a-|"); //this.icon replaced with link.gif
//      write("|-a href='javaScript:"+objPath+".p["+pstn+"].linkGoto();'" );
//      write(" onmouseover='"+objPath+".p["+pstn+"].linkHover("+image_num+");'-|\n");
//      write(this.name+"|-/td-||-/tr-|\n"                                );
//   } //debug
}

//---------------------------generate link information for saving links
function linkWriteSave(objPath) {
   saveStrng+= objPath+".addLink('"+this.name+"','"+this.url+"');\n";
}

//--------------------------swaps icons around when hovering link image
function linkHover(img_num) {
   if (window.tree.cache.isLoaded) {
      if (window.tree.cache.lastImg==-2) {
         frames[7].document.images[1].src='/res/adm/pages/bookmarkmenu/folder_trash.gif';
      } else {
         if (typeof(window.tree.cache.lastImg)!='undefined') {
            if (window.tree.cache.lastImg>=0) {
	 frames[4].document.images[window.tree.cache.lastImg].src=window.tree.cache.icon;
            }
         }
      }
      window.tree.cache.lastImg=img_num;
      window.tree.cache.icon=this.icon;
      frames[4].document.images[img_num].src="/res/adm/pages/bookmarkmenu/link_drag.gif";
   }
}


//---------------------------------------------------------------------
// Cache object
//---------------------------------------------------------------------
// Contains everything related to dragging/dropping folers and links.
// Refer to bookmarkmenu_OOD.txt for further documentation.
function newCache() {
 // Cache Properties
      this.isLoaded = false;
      this.state = "";
      this.lastImg = -1; //I don't know if I can do this yet. 
                         //It doesn't seem to cause errors.
      this.Icon = "";
      this.folder = new newFolder('cache',false);
 // Cache Methods
      this.cacheLoad = cacheLoad;
      this.cacheEmpty = cacheEmpty;
}

//----------------------------------------------Load cache for dragging
function cacheLoad(object1) {
   if (object1.state=="folder") {
//alert('cacheLoad11 '+object1.name+' is now: '+this.folder.name);
      frames[7].document.images[0].src = '/res/adm/pages/bookmarkmenu/folder_anim.gif';
      object2=object1.moveTo(this.folder);
      this.folder=object2;
//alert('cacheLoad22 '+object1.name+' is now: '+this.folder.name);
   } else {
      frames[7].document.images[0].src = '/res/adm/pages/bookmarkmenu/link_anim.gif';
      this.folder = new newLink(object1.name,object1.url);
   }
   this.isLoaded  = true;
   object1.exists = false;
}

//---------------------------Places Cache's contents in front of a link
function cacheEmpty(object1,position) {
   object1.bump(position);
   if (this.folder.state=="folder") {
//alert('cacheEmpty11 is emptying named: '+this.folder.name+' to: '+object1.p[position].name);
      object2=this.folder.moveTo(object1.p[position]);
      object1.p[position]=object2;
//alert('cacheEmpty22 is emptying named: '+this.folder.name+' to:'+object1.p[position].name);
   } else {
      object1.p[position] = new newLink(this.folder.name,this.folder.url);
   }
   frames[7].document.images[0].src = '/res/adm/pages/bookmarkmenu/folder_static.gif';
   this.isLoaded = false;
   this.lastImg  = -1;  //I don't know if I can do this yet. 
                        //It doesn't seem to cause errors
   tree.redraw();
}






//---------------------------------------------------------------------
// Functions not associated with an object
//---------------------------------------------------------------------

function clickTrash() {
   if (tree.cache.isLoaded) {
      tree.cache.isLoaded = false;
      tree.cache.lastImg   = -1; // I don't know if this works yet
      tree.redraw();
      frames[7].document.images[0].src = '/res/adm/pages/bookmarkmenu/folder_static.gif';
      frames[7].document.images[1].src = '/res/adm/pages/bookmarkmenu/folder_trash.gif';
   }
}

function hoverTrash() {
   if (window.tree.cache.isLoaded) {         
      if (typeof(window.tree.cache.lastImg)!='undefined') {
         if (window.tree.cache.lastImg>=0) {
            frames[4].document.images[window.tree.cache.lastImg].src=window.tree.cache.icon;
         }
      }
      window.tree.cache.lastImg=-2;
      window.tree.cache.icon='/res/adm/pages/bookmarkmenu/folder_trash.gif';
      frames[7].document.images[1].src = '/res/adm/pages/bookmarkmenu/folder_trash_hover.gif';
   }
}


//-----------------------------------------Generates HTML in each frame
function buildBookmarkMenu() {
   var frmHTML1 = "<html>\n<body background=";
   var frmHTML2 = ">\n</body>\n</html>";
   frames[0].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/ul_corner.gif"+frmHTML2 );
   frames[1].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/upper_bar.gif"+frmHTML2 );
   frames[2].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/ur_corner.gif"+frmHTML2 );
   frames[3].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/left_bar.gif"+frmHTML2 );
   frames[5].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/right_bar.gif"+frmHTML2 );
   frames[6].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/left_bar.gif"+frmHTML2 );
   frames[8].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/right_bar.gif"+frmHTML2 );
   frames[9].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/ll_corner.gif"+frmHTML2 );
   frames[10].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/lower_bar.gif"+frmHTML2);
   frames[11].document.write(frmHTML1+"/res/adm/pages/bookmarkmenu/lr_corner.gif"+frmHTML2);
}



//----------------------------
function queryNewLink() {
   add_link=window.open('','Link','width=360,height=165');
   clienthref="[ENTER ADDRESS HERE]";
   clienttitle="[ENTER NAME HERE]";
//   this.onerror=ugh_oh; // this doesn't seem to work properly
//   clienthref=this.opener.clientwindow.window.location.pathname;
//   clienttitle=this.opener.clientwindow.title;
   with(add_link.document) {
      open();
      clear();
      write("<html><body bgcolor=\"#BBBBBB\"><center>"                );
      write("<form method='post' name='newLink' onSubmit='javascript:opener.addNewLink(newLink.title.value,newLink.address.value);'>\n");
      write("<table width=\"340\" height=\"150\" bgcolor=\"#FFFFFF\" ");
      write("align=\"center\"><tr><td>Link Name:<br />"               );
      write("<input type='text' name='title' size=\"45\""             );
      write("value=\""+clienttitle+"\"><br />Address:<br />"          );
      write("<input type=\"text\" name=\"address\" size=\"45\" "      );
      write("value='"+clienthref+"'>");
      write("<br /><center><input type=\"submit\" value=\"Save\"> "   );
      write("<input type=\"button\" value=\"Close\" title=\"Close without saving\" ");
      write("onclick=\"javascript:window.close();\"></center></td>"   );
      write("</tr></table></form></center></body></html>"             );
      close();
   }
}

//----------------------------
function queryNewFolder() {
   add_link=window.open('','Link','width=360,height=165');
   with(add_link.document) {
      open();
      clear();
      write("<html><body bgcolor=\"#BBBBBB\"><center>"                   );
      write("<form method=\"post\" name=\"newLink\" onSubmit=\"javascript:opener.addNewFolder(newLink.title.value);\">\n");
      write("<table width=\"340\" height=\"150\" bgcolor=\"#FFFFFF\" "   );
      write("align=\"center\"><tr><td>Folder Name:<br />"                );
      write("<input type=\"text\" name=\"title\" size=\"45\" value=\"\">");
      write("<br /><center><input type=\"submit\" value=\"Save\">"       );
      write("<input type=\"button\" value=\"Cancel\" "                   );
      write("onclick=\"javascript:window.close();\"></center></td>"      );
      write("</tr></table></form></center></body></html>"                );
      close();
   }
}

//---------------------------
function addNewLink(title,address) {
   tree.bookmarks.addLink(title,address);
   add_link.close();
   tree.redraw();
   return true;
}

//---------------------------
function addNewFolder(title) {
   tree.bookmarks.addFolder(title);
   add_link.close();
   tree.redraw();
   return true;
}


