# The LearningOnline Network
#
# $Id: imsexport.pm,v 1.7 2009/08/28 17:17:25 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::imsexport;

use strict;
use Apache::lonnet;
use LONCAPA;

sub simpleproblem  {
    my ($symb) = @_;
    my $output;
    my %qparms = &Apache::lonnet::dump('resourcedata',
                  $env{'course.'.$env{'request.course.id'}.'.domain'},
                  $env{'course.'.$env{'request.course.id'}.'.num'},
                  $env{'request.course.id'}.'.'.$symb);
    if ($symb) {
        my $prefix=$env{'request.course.id'}.'.'.$symb.'.0.';
        my $qtype=$qparms{$prefix.'questiontype'};
        my $qtext=$qparms{$prefix.'questiontext'};
        my $hint=$qparms{$prefix.'hinttext'};
        my %values = ();
        my %foils = ();
        if (($qtype eq 'radio') || ($qtype eq 'option')) {
            my $maxfoils=$qparms{$prefix.'maxfoils'};
            my $randomize=$qparms{$prefix.'randomize'};
            if ($qtype eq 'option') {
                my $options=$qparms{$prefix.'options'};
                %values = &evaloptionhash($options);
                $output .= qq|
<problem>
  <optionresponse max="$maxfoils" randomize="$randomize">
    <foilgroup options="$options">
|;
                for (my $k=0; $k<10; $k++) {
                    my $iter = $k+1;
                    $output .= '   <foil name="foil'.$k.'" value="'.$qparms{$prefix.'value'.$iter}.'"';
                    $output .= ' location="'.$qparms{$prefix.'position'.$iter}.'" ';
                    $output .= '><startouttext />'.$qparms{$prefix.'text'.$iter}.'<endouttext /></foil>'."\n";
                }
                chomp($output);
                $output .= qq|
    </foilgroup>
|;
                if ($hint) {
                    $output .= '
    <hintgroup>
     <hintpart on="default">
      <startouttext />'.$hint.'<endouttext/>
     </hintpart>
    </hintgroup>';
                }
                $output .= qq|
  </optionresponse>
</problem>
|;
            } else {
                $output .= qq|
<problem>
  <radiobuttonresponse max="$maxfoils" randomize="$randomize">
   <foilgroup>
|;
                for (my $k=0; $k<10; $k++) {
                    my $iter = $k+1;
                    $output .= '   <foil name="foil'.$k.'" value="'.$qparms{$prefix.'value'.$iter}.'"';
                    $output .= ' location="'.$qparms{$prefix.'position'.$iter}.'" ';
                    $output .= '><startouttext />'.$qparms{$prefix.'text'.$iter}.'<endouttext /></foil>'."\n";
                }
                chomp($output);
                $output .= qq|
   </foilgroup>
|;
                if ($hint) {
                    $output .= '
   <hintgroup>
    <hintpart on="default">
     <startouttext />'.$hint.'<endouttext/>
    </hintpart>
   </hintgroup>';
                }
                $output .= qq|
  </radiobuttonresponse>
</problem>
|;
            }
        } elsif ($qtype eq 'stringanswer') {
            my $stringanswer = $qparms{$prefix.'stringanswer'};
            my $stringtype=$qparms{$prefix.'stringtype'};
            $output .= qq|
<problem>
  <stringresponse answer="$stringanswer" type="$stringtype">
    <textline>
    </textline>
            |;
            if ($hint) {
                $output .= '
   <hintgroup>
    <hintpart on="default">
     <startouttext />'.$hint.'<endouttext/>
    </hintpart>
   </hintgroup>';
            }
            $output .= qq|
  </stringresponse>
</problem>
|;
        } else {
            $output .= qq|
<problem>
  <startouttext />$qtext<endouttext />
  <essayresponse>
  <textfield></textfield>
  </essayresponse>
</problem>
|;
        }
    }
    return $output;
}

sub evaloptionhash {
    my $options=shift;
    $options=~s/^\(\'//;
    $options=~s/\'\)$//;
    my %returnhash=();
    foreach (split(/\'\,\'/,$options)) {
        $returnhash{$_}=$_;
    }
    return %returnhash;
}

sub external {
    my ($symb,$title) = @_;
    my $output;
    if ($symb =~  m-\.sequence___\d+___ext(.+)$-) {
        my $exturl = &unescape($1);
        $output = qq|
<html>
<head><title>$title</title>
</head>
<frameset rows="0,*" border="0">
<frame src='' />
<frame src="http://$exturl" name="external" />
</frameset>
</html>
        |;
    }
    return $output;
}

sub templatedpage {
    my ($content_type,$timestamp,$count,$uploads,$udom,$uname) = @_;
    my $cdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    my $cnum = $env{'course.'.$env{'request.course.id'}.'.num'};  
    my $output = '
<'.$content_type.'>';
    my %syllabusdata=();
    my %syllabusfields=();
    if ($content_type eq 'syllabus') {
        %syllabusfields=&Apache::lonlocal::texthash(
           'aaa_instructorinfo' => 'Instructor Information',
           'bbb_description'    => 'Course Description',
           'ccc_prereq'         => 'Prerequisites',
           'cdc_classhours'     => 'Class Hours',
           'ddd_officehours'    => 'Office Hours',
           'eee_helproom'       => 'Helproom Hours',
           'efe_projectinfo'    => 'Project Information',
           'fff_examinfo'       => 'Exam Information',
           'fgf_deadlines'      => 'Deadlines',
           'ggg_grading'        => 'Grading Information',
           'hhh_readings'       => 'Readings',
           'iii_coursepack'     => 'Coursepack',
           'jjj_weblinks'       => 'Web Links',
           'kkk_textbook'       => 'Textbook',
           'lll_includeurl'     => 'URLs To Include in Syllabus'
        );
        %syllabusdata = &Apache::lonnet::dump('syllabus',$cdom,$cnum);

    } elsif ($content_type eq 'simplepage') {
        %syllabusfields=&Apache::lonlocal::texthash(
           'aaa_title'         => 'Page Title',
           'bbb_content'       => 'Content',
           'ccc_webreferences' => 'Web References'
        );
        %syllabusdata = &Apache::lonnet::dump('smppage_'.$timestamp,$cdom,$cnum);
    } elsif ($content_type eq 'bulletinboard') {
        %syllabusfields=&Apache::lonlocal::texthash(
           'aaa_title'         => 'Topic',
           'bbb_content'       => 'Task',
           'ccc_webreferences' => 'Web References'
        );
        %syllabusdata = &Apache::lonnet::dump('bulletinpage_'.$timestamp,$cdom,$cnum);
    } elsif ($content_type eq 'aboutme') {
        %syllabusdata=&Apache::lonnet::dump('aboutme',$udom,$uname);
        %syllabusfields=&Apache::lonlocal::texthash(
           'aaa_contactinfo'   => 'Contact Information',
           'bbb_aboutme'       => 'Personal Information',
           'ccc_webreferences' => 'Web References'
        );
        $output .= qq|
  <username>$uname</username>
  <domain>$udom</domain>
|;
    }
    foreach (sort keys %syllabusfields) {
        $output .= qq|
<$_>
 <name>$syllabusfields{$_}</name>
 <value>$syllabusdata{$_}</value>
</$_>|;
    }
    if (defined($syllabusdata{'uploaded.photourl'})) {
        if ($syllabusdata{'uploaded.photourl'} =~  m-/([^/]+)$-) {
            push @$uploads, $syllabusdata{'uploaded.photourl'};
        }
        $output .= '
<photo>
 <filename>'.$count.'/'.$1.'</filename>
</photo>';
    }
    $output .= '
</'.$content_type.'>';
    return $output;
}

1;
