# The LearningOnline Network with CAPA
# 
# $Id: imsimport.pm,v 1.33 2010/09/26 02:10:49 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::imsimport;

use strict;
use Apache::Constants qw(:common :http :methods);
use Apache::loncacc;
use Apache::loncommon();
use Apache::lonnet;
use Apache::imsprocessor;
use Apache::lonlocal;
use HTML::Parser;
use HTML::Entities();
use Apache::lonlocal;
use Apache::lonupload;
use File::Basename();
use LONCAPA;

# ----------------------------------------------------------------  Jscript One
sub jscript_one {
    my ($fullpath,$jsref,$formname) = @_;

    my %body_layout = ('rightmargin'  => "0",
		       'leftmargin'   => "0",
		       'marginwidth'  => "0",
		       'topmargin'    => "0",
		       'marginheight' => "0");
    my $start_page = 
	&Apache::loncommon::start_page('Create IMS import directory',undef,
				       {'only_body'   => 1,
					'add_entries' => \%body_layout,
					'js_ready'    => 1,});
    my $end_page = 
	&Apache::loncommon::end_page({'js_ready' => 1,});

    my %lt = &Apache::lonlocal::texthash( 
               ddir => 'You must choose a destination directory for the import',
               cmss => 'You must choose the Course Management System from which the IMS package was exported',
               loca => 'Location:',
               newd => 'New Directory',
               nndi => 'Enter the name of the new directory where you will store the contents of your IMS package.',
               go => 'Go', 
             );
    $$jsref = <<"END_OF_ONE";
function verify() {
 if ((document.forms.$formname.newdir.value == '')  || (!document.forms.$formname.newdir.value)) {
   alert('$lt{'ddir'}')
   return false
 }
 if (document.forms.$formname.source.selectedIndex == 0) {
   alert('$lt{'cmss'}');
   return false
 }
 return true
}

function nextPage() {
  if (verify()) {
    document.forms.$formname.submit();
  }
}

function createWin() {
  document.$formname.newdir.value = "";
  newWindow = window.open("","CreateDir","HEIGHT=400,WIDTH=750,scrollbars=yes")
  newWindow.document.open()
  newWindow.document.write('$start_page')
  newWindow.document.write("\\n<img border='0' src='/adm/lonInterFace/author.jpg' alt='[Author Header]' />\\n")
  newWindow.document.write("<table border='0' cellspacing='0' cellpadding='0' width='600'>\\n")
  newWindow.document.write("<tr><td width='2'>&nbsp;</td><td width='3'>&nbsp;</td>\\n")
  newWindow.document.write("<td><h3>$lt{'loca'} <tt>$fullpath</tt></h3><h3>$lt{'newd'}</h3></td></tr>\\n")
  newWindow.document.write("<tr><td width='2'>&nbsp;</td><td width='3'>&nbsp;</td>\\n")
  newWindow.document.write("<td><form name='fileaction' action='/adm/cfile' method='post'>\\n")
  newWindow.document.write("$lt{'nndi'}<br /><br />")
  newWindow.document.write("<input type='hidden' name='filename' value='$fullpath' />")
  newWindow.document.write("<input type='hidden' name='action' value='newdir' />")
  newWindow.document.write("<input type='hidden' name='callingmode' value='imsimport' />")
  newWindow.document.write("$fullpath<input type='text' name='newfilename' value='' />")
  newWindow.document.write("<input type='button' value='$lt{'go'}' onClick='document.fileaction.submit();' />")
  newWindow.document.write("</td></tr>\\n")
  newWindow.document.write("</table>")
  newWindow.document.write('$end_page')
  newWindow.document.close()
  newWindow.focus()
}

END_OF_ONE

}

# ----------------------------------------------------------------  Jscript Two
sub jscript_two {
    my ($javascript,$user,$dom,$numcrs) = @_;
    my %crsentry = ();
    my $course_list;
    my $title_list;
    my @crslist = ();
    &get_ccroles($user,$dom,\%crsentry,\@crslist);
    if (@crslist > 0) {
        $crsentry{$crslist[0]} =~ s/("|,)//g;
        $title_list = '"'.$crsentry{$crslist[0]}.'"';
        if (@crslist > 1) {
            for (my $i=1; $i<@crslist; $i++) {
                $crsentry{$crslist[$i]} =~ s/("|,)//g;
                $title_list .= ',"'.$crsentry{$crslist[$i]}.'"';
            }
        }
    }
    $course_list = '"'.join('","',@crslist).'"';
    $$numcrs = @crslist;

    $$javascript = qq#

function checkCourse() {
  courseID_array = new Array($course_list)
  courseTitle_array = new Array($title_list)
  var step2Form = document.forms.pickoptions
  var conditionType = step2Form.conditions.value
  var curVal = step2Form.targetcourse.options[step2Form.targetcourse.selectedIndex].value
  if (curVal == -1) {
      if ( conditionType == 'both'  )  {
          if ( step2Form.board.checked == true || step2Form.users.checked == true ) {
              setCourse(step2Form,'add')
          }
      }
      if ( conditionType == 'users'  )  {
          if ( step2Form.users.checked == true ) {
              setCourse(step2Form,'add')
          }
      }
      if ( conditionType == 'board'  )  {
          if ( step2Form.board.checked == true ) {
              setCourse(step2Form,'add')
          }
      }
  }
  else { 
      if ( conditionType == 'both'  )  {
          if ( step2Form.board.checked == false && step2Form.users.checked == false ) {
              setCourse(step2Form,'clear')
          }
      }
      if ( conditionType == 'users'  )  {
          if ( step2Form.users.checked == false ) {
              setCourse(step2Form,'clear')
          }
      }
      if ( conditionType == 'board'  )  {
          if ( step2Form.board.checked == false ) {
              setCourse(step2Form,'clear')
          }
      }
  }
}

function setCourse(step2Form,call) {
    step2Form.targetcourse.length = 0
    if (call == 'add') {
        step2Form.targetcourse.length = 0
        step2Form.targetcourse.options[0] = new Option("Please Select","0",true,true)
        for (var i=0; i<courseID_array.length; i++) {
            step2Form.targetcourse.options[i+1] = new Option(courseTitle_array[i],courseID_array[i],false,false)
        }
        step2Form.targetcourse.selectedIndex = 0
    }
    else {
        step2Form.targetcourse.options[0] = new Option("Not required","-1",true,true)
        step2Form.targetcourse.selectedIndex = 0
    }
}


function setOptions(caller,itemnum) {
  var numCrs = $$numcrs
  var opForm = document.forms.pickoptions
  var menu = 1 + itemnum*2
  opForm.elements[menu].length = 0
  if (opForm.elements[itemnum*2].checked == true) {
    if (caller == "board") {
      opForm.elements[menu].options[0] = new Option("Select","-1",true,true)
      opForm.elements[menu].options[1] = new Option("Import topics only","topics",true,true)
      opForm.elements[menu].options[2] = new Option("Import topics + posts (with author)","allpost",true,true)
      opForm.elements[menu].options[3] = new Option("Import topics + posts (no author)","allanon",true,true)
    }
    else { 
      if (caller == "users") {
        opForm.elements[menu].length = 0
        opForm.elements[menu].options[0] = new Option("Select","-1",true,true)
        opForm.elements[menu].options[1] = new Option("Enroll students only","students",true,true)
        opForm.elements[menu].options[2] = new Option("Enroll all users","all",true,true)
      }
    }
  }
  else {
    opForm.elements[menu].options[0] = new Option("Not required","0",true,true)
  }
  opForm.elements[menu].selectedIndex = 0
  if (numCrs > 0) {
      checkCourse()
  }
}

function verify(caller) {
  var numCrs = $$numcrs
  var opForm = document.forms.pickoptions
  var totcheck = 0;
  var totchg = 0;
  for (var i=0; i<caller; i++) {
    if (opForm.elements[2*i].checked == true) {
      totcheck ++
      if (opForm.elements[2*i].name == "board") { 
        if (opForm.elements[2*i+1].selectedIndex == 0) {     
          alert("You must select one of the additional options when importing Discussion Boards ")
          return false
        }
        if (numCrs == 0) {
            opForm.elements[2*i].checked = false
            totchg ++
        }
        else {
          if (opForm.targetcourse.selectedIndex == 0) {
            alert("You must select a target course when importing Discussion Boards")
            return false
          }
        }
      }
      if (opForm.elements[2*i].name == "users") {
        if (opForm.elements[2*i+1].selectedIndex == 0) {     
          alert("You must select one of the additional options when importing Enrollment")
          return false
        }
        if (numCrs == 0) {
            opForm.elements[2*i].checked = false
            totchg ++ 
        }
        else {
          if (opForm.targetcourse.selectedIndex == 0) {
            alert("You must select a target course when importing enrollment information")
            return false
          }
        }
      }
    }
  }
  if (totcheck == 0) {
    alert("You must check the Checkbox for at least one Content Type");
    return false
  }
  return true
}

function nextPage(caller) {
  if (verify(caller)) {
    document.forms.pickoptions.submit()
  }
}

#;

}

# ----------------------------------------------------------------  Jscript Three
sub jscript_three {
    my $javascript = shift;
}

# ---------------------------------------------------------------- Display One
sub display_one {
    my ($r,$uname,$fn,$fullpath,$formname) = @_;
    $r->print('<form name="'.$formname.'" method="post">'.
              &Apache::lonhtmlcommon::topic_bar(1,&mt('Specify the Course Management system used to create the package')).
        &mt('Choose the CMS used to create your IMS content package.').'&nbsp;&nbsp;
        <select name="source">
         <option value="-1" selected="selected">Please select</option>
         <option value="bb5">Blackboard 5</option>
         <option value="bb6">Blackboard 6</option>
         <option value="angel5">ANGEL 5.5</option>
         <option value="webctce4">WebCT 4 Campus Edition</option>
         <option value="webctvista4">WebCT Vista 4</option>
        </select><br />'."\n".
        &Apache::lonhtmlcommon::topic_bar(2,&mt('Create a directory where you will unpack your IMS package'))."\n".
         &mt('Create a destination LON-CAPA directory in which to store the contents of the IMS package file.').'&nbsp;&nbsp;<input type="button" name="createdir" value="Create Directory" onClick="javascript:createWin()" /><input type="hidden" name="newdir" value="" /><br /><br />
          <input type="hidden" name="uploaduname" value="'.$uname.'" />
          <input type="hidden" name="filename" value="'.$fn.'" />
          <input type="hidden" name="phase" value="three" />
          <input type="button" name="nextpage" value="'.&mt('Proceed').'" onClick="javascript:nextPage();" />&nbsp;&nbsp;&nbsp;&nbsp;
          <input type="button" name="exitpage" value="'.&mt('Exit now').'" onClick="javascript:location.href='."'$fullpath'".'" />
         </form>');
}

# ---------------------------------------------------------------- Display Two
sub display_two {
    my ($r,$zipupload,$areas,$areaname,$cmsmap,$uname,$newdir,$numcrs,$fullpath) = @_;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['folder','source']);
    my $cms = $env{'form.source'};
    my $dirname = $env{'form.newdir'};
    my $tempdir = &Apache::imsprocessor::create_tempdir('CSTR',$dirname,'');
    my $fname = &Apache::imsprocessor::uploadzip('CSTR',$tempdir,$zipupload);
    my $unzip_result = '';
    my $manifest_result = '';
    unless ($tempdir eq '') {
        $unzip_result = &Apache::imsprocessor::expand_zip($tempdir,$fname);
    }
    my %resources = ();
    my %includedres = ();
    my %includeditems = ();
    my %items = ();
    my %hrefs = ();
    my %resinfo = ();
    my %count = ();

    my %lt = &Apache::lonlocal::texthash(
                  cont => 'Choose which content types you wish to import',
                  impo => 'Import',
                  type => 'Content type',
                  addo => 'Additional options',
                  chec => 'Check Import first',
                  bbus => 'Choose a course to receive bulletin boards and user enrollment',
                  list => 'A listing of possible course targets will be displayed if import of bulletin boards and/or enrollment is checked above (step 3). If you do not plan to import either of these content types, there is no need to specify a course.',
                  chco => 'Choose course:',
                  nreq => 'Not required',
                  yodo => 'You do not have active course coordinator status in any LON-CAPA courses currently, so bulletin boards and enrollment information included in your IMS package will be discarded, regardless of your import choice for these two items above (step 3).',
                  ifyo => "If you wish to import bulletin boards and/or user information into LON-CAPA please click 'Exit now' to quit the current IMS import process, and contact your domain coordinator and request a course coordinator role in a LON-CAPA course into which you can upload bulletin boards and/or enroll users.",
                  impa => 'Import package',
                  unpa => 'Unpacking of your IMS package failed because an IMS manifest file was not located in the package',
                  proc => 'Processing of your IMS package failed because the file you uploaded could not be unzipped',
                  exit => 'Exit now',
    );

    my $counter = 0;
    my $iter = 0;
    my %count = (
                announce => 0,
                board => 0,
                doc => 0,
                extlink => 0,
                msg => 0,
                pool => 0,
                quiz => 0,
                staff => 0,
                survey => 0,
                users => 0,
                );
    my $conditions;
    if ($unzip_result eq 'ok') {
        $manifest_result = &Apache::imsprocessor::process_manifest($cms,
                            $tempdir,\%resources,\%items,\%hrefs,\%resinfo,
                            'choose',\%includedres,\%includeditems);
        if ($manifest_result eq 'ok') {
            foreach my $res (sort keys %resources) {
                if ($cms eq 'bb5' || $cms eq 'bb6' || $cms eq 'webctce4' 
                    || $cms eq 'webctvista4') {
                    foreach my $area (keys %{$$cmsmap{$cms}}) {
                        if ($resources{$res}{type} eq $$cmsmap{$cms}{$area}) {
                            $count{$area} ++;
                        }
                    }
                } elsif ($cms eq 'angel5') {
                    foreach my $area (keys %{$$cmsmap{$cms}}) {
                        if ($area eq 'doc') {
                            if (grep/^$resources{$res}{type}$/,@{$$cmsmap{$cms}{doc}}) {
                                $count{$area} ++;
                            }
                        } elsif ($resources{$res}{type} eq $$cmsmap{$cms}{$area}) {
                            $count{$area} ++;                                
                        }
                    }
                }
            }
            if ($count{board} > 0) {
                if ($count{users} > 0) {
                    $conditions = 'both';
                } else {
                    $conditions = 'board';
                }
            } elsif ($count{users} > 0) {
                $conditions = 'users';
            } else {
                $conditions = 'none';
            }

            $r->print('<form name="pickoptions" method="post">'.
                      &Apache::lonhtmlcommon::topic_bar(3,$lt{'cont'}).
                      &Apache::loncommon::start_data_table().
                      &Apache::loncommon::start_data_table_header_row().
                      '<th>'.$lt{'impo'}.'</th><th>'.$lt{'type'}.'</th><th>'.
                      $lt{'addo'}.'</th>'.
                      &Apache::loncommon::end_data_table_header_row());
            foreach my $area (@{$areas}) {
                if ($count{$area} > 0) {
                    my $count_tag = 'flag_'.$counter;
                    $r->print(&Apache::loncommon::start_data_table_row()."\n".
                              '<td><input name="'.$area.'" type="checkbox" ');
                    if ($area eq 'board' || $area eq 'users') {
                        $r->print('onClick="javascript:setOptions('."'$area','$counter'".');" ');
                    }
                    $r->print('/></td>'.
                              '<td>&nbsp;&nbsp;'.$$areaname{$area}.'&nbsp;&nbsp; - '.
                              &mt('[quant,_1,item]',$count{$area}).'</td>');
                    if ($area eq 'board') {
                        $r->print('<td>&nbsp;&nbsp;
                 <select name="db_handling">
                  <option value="-2">&lt;-- '.$lt{'chec'}.'</option>
                 </select>
                </td>');
                    } elsif ($area eq 'users') {
                        $r->print('<td>&nbsp;&nbsp;
                 <select name="user_handling">
                  <option value="-2">&lt;-- '.$lt{'chec'}.'</option>
                 </select>
                </td>');
                    } else {
                        $r->print('<td>&nbsp;&nbsp;'.&mt('None')."\n".
                                  '<input type="hidden" name="'.$count_tag.'" /></td>');
                    }
                    $counter ++;
                    $r->print(&Apache::loncommon::end_data_table_row());
                }
            }
            $r->print(&Apache::loncommon::end_data_table());
            if ($count{board} + $count{users} > 0) {
                $r->print(&Apache::lonhtmlcommon::topic_bar(4,$lt{'bbus'}));
                if ($$numcrs > 0) {
                    $r->print($lt{'list'}.'<br /><br />'.$lt{'chco'}.'&nbsp;&nbsp;'."\n".
                              '<select name="targetcourse">
                                <option value="-1">'.$lt{'nreq'}.'</option>
                               </select>');
                } else {
                    $r->print($lt{'yodo'}.' '.$lt{'ifyo'});
                }
            }
            $r->print('<br /><br />
          <input type="hidden" name="newdir" value="'.$env{'form.newdir'}.'" />
          <input type="hidden" name="conditions" value="'.$conditions.'" />
          <input type="hidden" name="source" value="'.$cms.'" />
          <input type="hidden" name="tempdir" value="'.$tempdir.'" />
          <input type="hidden" name="uploaduname" value="'.$uname.'" />
          <input type="hidden" name="filename" value="'.$fname.'" />
          <input type="hidden" name="phase" value="four" />'."\n");
            if ($count{board} == 0) {
                $r->print('<input type="hidden" name="board" value="" />'."\n");
            }
            if ($count{users} == 0) {
                $r->print('<input type="hidden" name="users" value="" />'."\n");
            }
            $r->print('<input type="button" name="nextpage" value="'.$lt{'impa'}.'" onClick="javascript:nextPage('."'$counter.'".')" />&nbsp;&nbsp;&nbsp;
           <input type="button" name="exitpage" value="'.$lt{'exit'}.'" onClick="javascript:location.href='."'$fullpath'".'" /></form>');
        } else {
            $r->print($lt{'unpa'});
        }
    } else {
        $r->print($lt{'proc'});
    }
}

# ---------------------------------------------------------------- Display Three
sub display_three {
    my ($r,$uname,$udom,$areas,$areaname,$cmsmap,$destdir,$newdir) = @_;
    my $crs = '';
    my $cdom = '';
    my $db_handling = '';
    my $timenow = time; 
    my $announce_handling = 'ok';
    my $cms = $env{'form.source'};
    if ( defined($env{'form.bb_crs'}) ) {
        ($cdom,$crs) = split/\//,$env{'form.bb_crs'};
    } 
    my $user_crs = '';
    my $user_cdom = '';
    my $user_handling = '';
    if ( defined($env{'form.user_crs'}) ) {
        ($user_cdom,$user_crs) = split/\//,$env{'form.user_crs'};
    }
    my $seqstem = "/res/$udom/$uname/$newdir";
    my %importareas = ();
    my %includedres = ();
    my %includeditems = ();
    my %randompicks = ();
    my @targets = ();
    my %resources = ();
    my %items = ();
    my %hrefs = ();
    my %urls = ();
    my %resinfo = ();
    my %total = (
                   page => 0,
                   prob => 0,
                   seq => 0,
                   board => 0,         
                   quiz => 0,
                   surv => 0,
                   file => 0,
    );

    my @pages = ();
    my @sequences = ();
    my @resrcfiles = ();
    my @assessmentfiles = ();

    my $tempdir = $env{'form.tempdir'};

    foreach my $area (@{$areas}) {
        if (defined($env{"form.$area"}) ) {
            if ($cms eq 'angel5' && $area eq 'doc') {
                foreach (@{$$cmsmap{$cms}{$area}}) {
                    $importareas{$_} = 1;
                }
            } else {
                $importareas{$$cmsmap{$cms}{$area}} = 1;
            }
            if ($area eq 'board') {
                $db_handling = $env{'form.db_handling'};
            } elsif ($area eq 'users') {
                $user_handling = $env{'form.user_handling'};
            }
        }
    }

    my %lt = &Apache::lonlocal::texthash (
                 yims => 'Your IMS package has been processed successfully.',
                 plsv => 'Please view the imported items and use the LON-CAPA editing tools to make changes.',
                 tseq => "The sequences directory contains a file named 'Top.sequence' which includes links to the items found at the top level of your IMS package. From there you can follow links to display all the imported items. Alternatively, you can browse the pages, sequences, problems and resfiles directories directly. Note if you rename a file, you will need to modify any .sequence files or .page files which include a reference to the renamed file.",
                 tfin => 'The final step in the IMS import process is to publish the materials you have imported into your Construction Space so that you can use them in a course. Once your files are published, subsequent re-publication will result in the storage of information about changes between the different versions.',
                 disp => 'Display new directory',
                 proc => 'Processing of your IMS package failed, because the IMS content package did not contain an IMS manifest file.'
             );
    my $manifest_result = &Apache::imsprocessor::process_manifest($cms,$tempdir,
                          \%resources,\%items,\%hrefs,\%resinfo,'prepare',
                          \%includedres);
    if ($manifest_result eq 'ok') {
        foreach my $res (sort keys %resources) {
            if ($importareas{$resources{$res}{type}}) {
                $includedres{$res} = 1;
                if ($resources{$res}{type} eq 'webct.manifest' || 
                     $resources{$res}{type} eq 'webct.assessment' ||
                     $resources{$res}{type} eq 'webct.question') {
                    push(@assessmentfiles,$res);
                }   
            }
        }
        foreach my $itm (sort keys %items) {
            &Apache::imsprocessor::get_imports(\%includeditems,\%items,\%resources,\%importareas,$itm);
        }
    }

    foreach my $itm (sort keys %includeditems) {
        &Apache::imsprocessor::get_parents(\%includeditems,\%items,$itm);
    }

    $manifest_result = &Apache::imsprocessor::process_manifest($cms,$tempdir,
                       \%resources,\%items,\%hrefs,\%resinfo,'build',
                       \%includedres,\%includeditems);
    if ($manifest_result eq 'ok') {
        &Apache::imsprocessor::target_resources(\%resources,\%importareas,\@targets);

        my @boards = ();
        my @announcements = ();
        my @quizzes = ();
        my @surveys = ();
        my @pools = ();
        my @groups = ();
        my %messages = ();
        my @timestamp = ();
        my %boardnum = ();
        my @topurls = ();
        my @topnames = ();
        my @packages = ();

        &Apache::imsprocessor::process_resinfo($cms,'CSTR',$tempdir,$destdir,\%items,\%resources,\@targets,\@boards,\@announcements,\@quizzes,\@surveys,\@pools,\@groups,\%messages,\@timestamp,\%boardnum,\%resinfo,$udom,$uname,$cdom,$crs,$db_handling,$user_handling,\%total,$seqstem,$seqstem,\@resrcfiles,\@packages,\%hrefs,\@pages,\@sequences,\%randompicks);

        my $copy_result = &Apache::imsprocessor::copy_resources('CSTR',$cms,\%hrefs,$tempdir,\@targets,\%urls,$crs,$cdom,$destdir,$timenow,\@assessmentfiles,\%total);
   
        &Apache::imsprocessor::build_structure($cms,'CSTR',$destdir,\%items,\%resinfo,\%resources,\@targets,\%hrefs,$udom,$uname,$newdir,$timenow,$cdom,$crs,\@timestamp,\%total,\@boards,\@announcements,\@quizzes,\@surveys,\@pools,\%boardnum,\@pages,\@sequences,\@topurls,\@topnames,\@packages,\%includeditems,\%randompicks);

        $r->print("<h3>IMS import completed</h3>");

        if ($cms eq 'angel5') {
            $r->print($lt{'yims'}.' '.&mt('A total of [quant,_1,sequence], [quant,_2,composite page], and [quant,_3,bulletin board] have been created, and [quant,_4,file] copied.',$total{seq},$total{page},$total{board},$total{file})."\n");
        } else {
            $r->print($lt{'yims'}.' '.&mt('A total of [quant,_1,sequence], [quant,_2,composite page], [quant,_3,bulletin board], [quant,_4,quiz,quizzes], [quant,_5,survey], and [quant,_6,problem] have been created, and [quant,_7,file] copied.',$total{seq},$total{page},$total{board},$total{quiz},$total{surv},$total{prob},$total{file})."\n");
        }
        $r->print('<br /><br />'.$lt{'plsv'}.' '.$lt{'tseq'}.'<br /><br />'.$lt{'tfin'}.'<br /><br /><a href="/priv/'.$uname.'/'.$newdir.'">'.$lt{'disp'}.'</a>');
        if ($destdir =~ m-^/home/$uname/public_html/-) {
            system (" rm -r -f $destdir/temp");
        }
    } elsif ($manifest_result eq 'nomanifest') {
        $r->print($lt{'proc'});
    }
}

# ---------------------------------------------------------------- Get LON-CAPA Course Coordinator roles for this user
sub get_ccroles {
    my ($user,$dom,$crsentry,$crslist) = @_;
    my %roles;
    unless ($user eq '') {
        my $ccrole = 'cc';
        %roles = &Apache::lonnet::get_my_roles($user,$dom,'userroles',undef,[$ccrole]);
    }
    my $iter = 0;
    my @codes = ();
    my %courses = ();
    my @crslist = ();
    my %descrip =();
    foreach my $key (keys(%roles)) {
        if ($key =~ m{^/($LONCAPA::domain_re)/($LONCAPA::username_re)_cc$}) {
            my $cdom = $1;
            my $crs = $2;
            my $currcode = '';
            my %settings = &Apache::lonnet::get('environment',['internal.coursecode','description'],$cdom,$crs);
            if (defined($settings{'description'}) ) {
                $descrip{$crs} = $settings{'description'};
            } else {
                $descrip{$crs} = 'Unknown';
            }
            if (defined($settings{'internal.coursecode'}) ) {
                $currcode = $settings{'internal.coursecode'};
                if ($currcode eq '') {
                    $currcode = "____".$iter;
                    $iter ++;
                }
            } else {
                $currcode = "____".$iter;
                $iter ++;
            }
            unless (grep/^$currcode$/,@codes) {
                push @codes,$currcode;
                @{$courses{$currcode}} = ();
            }
            push @{$courses{$currcode}}, $cdom.'/'.$crs;
        }
    }
    foreach my $code (sort @codes) {
        foreach my $crsdom (@{$courses{$code}}) {
            my ($cdom,$crs) = split/\//,$crsdom;
            my $showcode = '';
            unless ($code =~m/^____\d+$/) {  $showcode = $code; }
            $$crsentry{$crsdom} = $showcode.':'.$descrip{$crs};
            push @{$crslist}, $crsdom;
        }
    }
    return;
}

# ---------------------------------------------------------------- Main Handler
sub handler {
    my $r=shift;
    my $uname;
    my $udom;
    my $javascript = '';
    my $page_name = '';
    my $current_page = '';
    my $qcount = '';

# get personal information for this user
    my $user=$env{'user.name'};
    my $dom=$env{'user.domain'};

#
# re-attach user
#
    if ($env{'form.uploaduname'}) {
        $env{'form.filename'}='/priv/'.$env{'form.uploaduname'}.'/'.
            $env{'form.filename'};
    }
    ($uname,$udom)=
        &Apache::loncacc::constructaccess($env{'form.filename'},
                                          $r->dir_config('lonDefDomain'));
    unless (($uname) && ($udom)) {
        $r->log_reason($uname.' at '.$udom.
                       ' trying to publish file '.$env{'form.filename'}.
                       ' - not authorized',
                       $r->filename);
        return HTTP_NOT_ACCEPTABLE;
    }
                                                                                             
    my $fn;
    if ($env{'form.filename'}) {
        $fn=$env{'form.filename'};
        $fn=~s/^https?\:\/\/[^\/]+\///;
        $fn=~s/^\///;
        $fn=~s/(\~|priv\/)($LONCAPA::username_re)//;
        $fn=~s/\/+/\//g;
    } else {
        $r->log_reason($env{'user.name'}.' at '.$env{'user.domain'}.
                       ' unspecified filename for upload', $r->filename);
        return HTTP_NOT_FOUND;
    }
    my $zipupload = '/home/'.$uname.'/public_html'.$fn;
    my $pathname = &File::Basename::dirname($fn);
    my $fullpath = '/priv/'.$uname.$pathname;
    unless ($pathname eq '/') {
        $fullpath .= '/';
    }

    my @areas = ();
    my %cmsmap = ();
    my %areaname = ();
    my $numcrs = 0;
             
    &Apache::imsprocessor::ims_config(\@areas,\%cmsmap,\%areaname);
# ----------------------------------------------------------- Start page output
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;

    my $formname_one = 'info';
    if ($env{'form.phase'} eq 'two') {
        &jscript_one($fullpath,\$javascript,$formname_one);
    } elsif ($env{'form.phase'} eq 'three') {
        &jscript_two(\$javascript,$user,$dom,\$numcrs);
    } elsif ($env{'form.phase'} eq 'four') {
        &jscript_three(\$javascript);
    }
    $javascript = "<script type=\"text/javascript\">\n//<!--\n$javascript\n// --></script>\n";

    my $title = 'Upload IMS package to Construction Space';
    $r->print(&Apache::loncommon::start_page($title, $javascript));

    if (($uname ne $env{'user.name'}) || ($udom ne $env{'user.domain'})) {
        $r->print('<p><span class="LC_warning">'
                  .&mt('Co-Author [_1]',$uname.':'.$udom)
                  .'</span></p>'
        );
    }   
    if ($env{'form.phase'} eq 'two') {
        my $flag = &Apache::lonupload::phasetwo($r,$fn,$uname,$udom,'imsimport');
        if ($flag eq 'ok') {
            &display_one($r,$uname,$fn,$fullpath,$formname_one);
        }
    } elsif ( ($env{'form.phase'} eq 'three') || ($env{'form.phase'} eq 'four') ) {
        my $docroot = $env{'form.newdir'};
        my $newdir = '';
        if ($docroot =~ m|public_html/(.+)$|) {
            $newdir = $1;
        }
        if ($env{'form.phase'} eq 'three') {
            &display_two ($r,$zipupload,\@areas,\%areaname,\%cmsmap,$uname,$newdir,\$numcrs,$fullpath);
        } elsif ($env{'form.phase'} eq 'four') {
            &display_three ($r,$uname,$udom,\@areas,\%areaname,\%cmsmap,$docroot,$newdir);
        }
    } else {
        &Apache::lonupload::phaseone($r,$fn,$uname,$udom,'imsimport');
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}
1;
__END__
