# The LearningOnline Network with CAPA
#
# $Id: imsimportdocs.pm,v 1.29 2009/11/20 18:25:34 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::imsimportdocs;

use Apache::Constants qw(:common :http :methods);
use Apache::lonnet;
use Apache::londocs;
use Apache::loncommon;
use Apache::lonlocal;
use Apache::imsprocessor;
use LONCAPA::Configuration;
use LONCAPA::map();
use lib '/home/httpd/lib/perl/';
use LONCAPA;
 
use strict;

sub jscript_one {
    my $javascript = shift;
    $$javascript = qq#
function verify() {
 if ((document.forms.pickcms.uploadname.value == '')  || (!document.forms.pickcms.uploadname.value)) {
   alert("You must provide the name of the IMS package to be imported")
   return false
 }
 if (document.forms.pickcms.source.selectedIndex == 0) {
   alert("You must choose the Course Management System from which the IMS package was exported");
   return false
 }
 return true
}

function nextPage() {
 if (verify()) {
   document.forms.pickcms.submit()
 }
}
#;
 
}

sub jscript_two {
    my $javascript = shift;
    $$javascript = qq#
function setOptions(caller,itemnum) {
  var opForm = document.forms.pickoptions
  var menu = 1 + itemnum*2
  opForm.elements[menu].length = 0
  if (opForm.elements[itemnum*2].checked == true) {
    if (caller == "board") {
      opForm.elements[menu].options[0] = new Option("Select","-1",true,true)
      opForm.elements[menu].options[1] = new Option("Import topics only","topics",true,true)
      opForm.elements[menu].options[2] = new Option("Import topics + posts (with author)","allpost",true,true)
      opForm.elements[menu].options[3] = new Option("Import topics + posts (no author)","allanon",true,true)
    }
    else { 
      if (caller == "users") {
        opForm.elements[menu].length = 0
        opForm.elements[menu].options[0] = new Option("Select","-1",true,true)
        opForm.elements[menu].options[1] = new Option("Enroll students only","students",true,true)
        opForm.elements[menu].options[2] = new Option("Enroll all users","all",true,true)
      }
    }
  }
  else {
    opForm.elements[menu].options[0] = new Option("Not required","0",true,true)
  }
  opForm.elements[menu].selectedIndex = 0
}

function verify(caller) { 
  var opForm = document.forms.pickoptions
  var totcheck = 0;
  for (var i=0; i<caller; i++) {
    if (opForm.elements[2*i].checked == true) {
      totcheck ++
      if (opForm.elements[2*i].name == "board") { 
        if (opForm.elements[2*i+1].selectedIndex == 0) {     
          alert("You must select one of the additional options when importing Discussion Boards ")
          return false
        }
      }
      if (opForm.elements[2*i].name == "users") {
        if (opForm.elements[2*i+1].selectedIndex == 0) {     
          alert("You must select one of the additional options when importing Enrollment")
          return false
        }
      }
    }
  }
  if (totcheck == 0) {
    alert("You must check the Checkbox for at least one Content Type");
    return false
  }
  return true
}

function nextPage(caller) {
 if (verify(caller)) {
   document.forms.pickoptions.submit()
 }
}
#;
}

sub jscript_three {
    my $javascript = shift;
    $$javascript = qq|
function init(tf) {
    setTimeout("self.close()",3000)
    tf.submit();   
}
    |;
}

sub handler {
    my $r = shift;
    my $javascript = '';
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    my @areas = ();
    my %cmsmap = ();
    my %areaname = ();
    &Apache::imsprocessor::ims_config(\@areas,\%cmsmap,\%areaname);

# get course data
    my $coursenum=$env{'course.'.$env{'request.course.id'}.'.num'};
    my $coursedom=$env{'course.'.$env{'request.course.id'}.'.domain'};

# get personal data
 
    my $uname=$env{'user.name'};
    my $udom=$env{'user.domain'};
    my $plainname=&escape(
                     &Apache::loncommon::plainname($uname,$udom));

# does this user have privileges to post, etc?
    my $allowed=&Apache::lonnet::allowed('mdc',$env{'request.course.id'});
    unless ($allowed) {
        $r->print(&Apache::loncommon::start_page('Import IMS package',undef,
                                                 {'only_body' => 1,}));  
        $r->print(
            '<p class="LC_error">'
           .&mt('Modification of Course Contents Disallowed')
           .'</p><p>'
           .&mt('Your current role does not grant you the right to modify course content in this course.')
           .'</p>'
           .&Apache::loncommon::end_page()
        );
        return OK;
    }

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
       ['phase']);

    if ($env{'form.phase'} eq 'one') {    
        &jscript_one(\$javascript);
    } elsif ($env{'form.phase'} eq 'two') {
        &jscript_two(\$javascript);
    } elsif ($env{'form.phase'} eq 'three') {
        &jscript_three(\$javascript);
    }

    $javascript = 
        "<script type=\"text/javascript\">\n".
        "//<!--\n$javascript\n// --></script>\n";
    my $headline = 'Import IMS package';
    my $start_page = &Apache::loncommon::start_page($headline,
                                                    $javascript,
                                                    {'only_body' => 1,})
                    .'<h1>'.&mt($headline).'</h1>';
# print screen
    $r->print($start_page);

    if ($env{'form.phase'} eq 'one') {
        &display_one($r);       
    } elsif ($env{'form.phase'} eq 'two') {
        &display_two($r,$coursenum,\@areas,\%areaname,%cmsmap);
    } elsif ($env{'form.phase'} eq 'three') {
        &display_three($r,$coursenum,$coursedom,$uname,$udom,\@areas,%cmsmap);
    }   
    $r->print(&Apache::loncommon::end_page());
    return OK;
} 


sub display_one {
    my ($r) = @_;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['folder']);

    $r->print(
        '<form action="/adm/imsimportdocs" method="post"'
       .' enctype="multipart/form-data" name="pickcms">'
    );

    # Step 1
    $r->print(
       &Apache::lonhtmlcommon::topic_bar(
            1,&mt('Specify the Course Management system used to create the package'))
       .&mt('Please choose the CMS used to create your IMS content package:').' '
       .'<select name="source">'
       .'<option value="-1" selected="selected">'.&mt('Please select').'</option>'
       .'<option value="bb5">Blackboard 5</option>'
       .'<option value="bb6">Blackboard 6</option>'
       .'<option value="angel5">ANGEL 5.5</option>'
       .'<option value="webctce4">WebCT 4 Campus Edition</option>'
       .'</select>'
    );

    # Step 2
    $r->print(
       &Apache::lonhtmlcommon::topic_bar(
           2,&mt('Locate the IMS content package you wish to upload'))
      .'<input type="hidden" name="folder" value="'.$env{'form.folder'}.'" />'
      .'<input type="hidden" name="phase" value="two" />'
      .&mt('File:')
      .' <input type="file" name="uploadname" size="40" />'
    );

    # Buttons
    $r->print(
       '<hr />'
      .'<p>'
      .'<input type="button" name="exitpage" value="'.&mt('Cancel').'"'
      .' onclick="javascript:self.close()" />'
      .' '
      .'<input type="button" name="nextpage" value="'.&mt('Upload IMS package').'"'
      .' onclick="javascript:nextPage()" />'
      .'</p>'
    );

    $r->print('</form>');
}


sub display_two {
    my ($r,$crs,$areasref,$areaname,%cmsmap) = @_;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['folder','source']);
    my $cms = $env{'form.source'};
    my $timenow = time;
    my $tempdir = &Apache::imsprocessor::create_tempdir('DOCS',$crs,$timenow);
    my $fname = &Apache::imsprocessor::uploadzip('DOCS',$tempdir);
    my $unzip_result = '';
    my $manifest_result = '';
    unless ($tempdir eq '') {
        $unzip_result = &Apache::imsprocessor::expand_zip($tempdir,$fname);
    }
    my %resources = ();
    my %includedres = ();
    my %includeditems = ();
    my %items = ();
    my %hrefs = ();
    my %resinfo = ();
    my %count = ();
    my $counter = 0;
    my %count = (
                announce => 0,
                board => 0,
                doc => 0,
                extlink => 0,
                msg => 0,
                pool => 0,
                quiz => 0,
                staff => 0,
                survey => 0,
                users => 0,
                );

    if ($unzip_result ne 'ok') {
        $r->print(
            '<p class="LC_warning">'
           .&mt('Processing of your IMS package failed because the file you'
               .' uploaded could not be unzipped.')
           .'</p>'
        );
        return();
    }

    # Get manifest file from package
    $manifest_result = &Apache::imsprocessor::process_manifest(
                           $cms,$tempdir,\%resources,\%items,\%hrefs,
                           \%resinfo,'choose',\%includedres,\%includeditems);
    if ($manifest_result ne 'ok') {
        $r->print(
           '<p class="LC_warning">'
          .&mt('Unpacking of your IMS package failed because an IMS manifest file was not located in the package.')
          .'</p>'
        );
        return();
    }

    # Count areas depending on cms version
    foreach my $res (sort keys %resources) {
        if ($cms eq 'bb5' || $cms eq 'bb6' || $cms eq 'webctce4') {
            foreach my $area (keys %{$cmsmap{$cms}}) {
                if ($resources{$res}{type} eq $cmsmap{$cms}{$area}) {
                    $count{$area} ++;
                }
            }
        } elsif ($cms eq 'angel5') {
            foreach my $area (keys %{$cmsmap{$cms}}) {
                if ($area eq 'doc') {
                    if (grep/^$resources{$res}{type}$/,@{$cmsmap{$cms}{doc}}) {
                        $count{$area} ++;
                    }
                } elsif ($resources{$res}{type} eq $cmsmap{$cms}{$area}) {
                    $count{$area} ++;
                }
            }
        } else { # Unknown cms format
            $r->print(
                '<span class="LC_warning">'
               .&mt('Unsupported IMS format: [_1]',$cms)
               .'</span><br />'
            );
            # return();
        }
    }


    # Start output: Step 3 and step 4

    $r->print(
        '<form name="pickoptions" method="post" action="">'
       .&Apache::lonhtmlcommon::topic_bar(
            3,&mt('Choose which content types you wish to import'))
       .'<p>'
       .&mt('Check the checkboxes for all areas you wish to import from the IMS package:')
       .'</p>'
    );

    $r->print(
        &Apache::loncommon::start_data_table()
       .&Apache::loncommon::start_data_table_header_row()
       .'<th>'.&mt('Import?').'</th>'
       .'<th>'.&mt('Content type').'</th>'
       .'<th>'.&mt('Additional options').'</th>'
       .&Apache::loncommon::end_data_table_header_row()
    );

    # Display import row for each area/content type
    foreach my $area (@{$areasref}) {
        unless ($count{$area} > 0) { next };

        my $count_tag = 'flag_'.$counter;

        # Checkbox: Import?
        $r->print(
            &Apache::loncommon::start_data_table_row()
           .'<td><input name="'.$area.'" type="checkbox"'
        );
        if ($area eq 'board' || $area eq 'users') {
            $r->print(qq| onclick='javascript:setOptions("$area","$counter")'|);
        }

        $r->print(' /></td>');

        # Content Type
        $r->print(
            '<td>'
           .$$areaname{$area}.'&nbsp;&nbsp; - '
           .&mt('[quant,_1,item]',$count{$area})
           .'</td>'
        );

        # Additional Options
        $r->print('<td>');
        if ($area eq 'board') {
            $r->print(
                '<select name="db_handling">'
               .'<option value="-2">&lt;-- '.&mt('Check Import first').'</option>'
               .'</select>'
            );
        } elsif ($area eq 'users') {
            $r->print(
                '<select name="user_handling">'
               .'<option value="-2">&lt;-- '.&mt('Check Import first').'</option>'
               .'</select>'
            );
        } else {
            $r->print(
                &mt('None')
               .'<input type="hidden" name="'.$count_tag.'" />'
            );
        }
        $r->print('</td>');

        $r->print(&Apache::loncommon::end_data_table_row());
        $counter ++;
    }

    $r->print(&Apache::loncommon::end_data_table());

    $r->print(
        &Apache::lonhtmlcommon::topic_bar(
            4,&mt('Choose display options for listing of contents of top level of package'))
       .'<p>'
       .&mt('Select a display option for the package content:')
       .'</p>'
    );
    $r->print(
        '<label>'
       .'<input type="radio" name="toplevel" value="newfolder" />'
       .&mt('Display listing of contents in a new folder, with folder name:')
       .'</label>'
       .' <input type="text" name="foldername" size="15" value="'.&mt('Type Name Here').'" />'
       .'<br />'
       .'<label>'
       .'<input type="radio" name="toplevel" value="oldfolder" checked="checked" />'
       .&mt('Append listing of contents of top level of package to contents list for the current folder.')
       .'</label>'
    );

    # Buttons
    $r->print(
        '<input type="hidden" name="folder" value="'.$env{'form.folder'}.'" />'
       .'<input type="hidden" name="source" value="'.$cms.'" />'
       .'<input type="hidden" name="tempdir" value="'.$tempdir.'" />'
       .'<input type="hidden" name="phase" value="three" />'
    );
    $r->print(
        '<hr />'
       .'<p>'
       .'<input type="button" name="exitpage" value="'.&mt('Cancel').'"'
       .' onclick="javascript:self.close()" />'
       .' '
       .'<input type="button" name="nextpage" value="'.&mt('Finish Import').'"'
       .' onclick="javascript:nextPage('.$counter.')" />'
       .'</p>'
    );

   $r->print('</form>');
}


sub display_three {
    my ($r,$crs,$cdom,$uname,$udom,$areas,%cmsmap) = @_;
    my $folder = $env{'form.folder'};
    my $cms = $env{'form.source'};
    my $tempdir = $env{'form.tempdir'};
    my $longcrs = '';
    if ($crs =~ m/^(\d)(\d)(\d)/) {
        $longcrs = $1.'/'.$2.'/'.$3.'/'.$crs;
    }
    my %importareas = ();
    my %includedres = ();
    my %includeditems = ();
    my @targets = ();
    my %resources = ();
    my %items = ();
    my %hrefs = ();
    my %urls = ();
    my %resinfo = ();
    my %total = (
                 page => 0,
                 prob => 0,
                 seq => 0,
                 board => 0,         
                 quiz => 0,
                 surv => 0,
                );
    my @pages = ();
    my @sequences = ();
    my @resrcfiles = ();

    my $timenow = time;

    my $destdir = $Apache::lonnet::perlvar{'lonDocRoot'}.'/userfiles/'.$cdom.'/'.$crs.'/'.$timenow;
    my $seqstem = "/uploaded/$cdom/$crs/$timenow";
    my $db_handling = '';
    my $user_handling = '';

    my $toplevel = '';
    my $foldername = '';
    my %topitems = ();
    if (defined($env{'form.toplevel'}) ) {
        $toplevel = $env{'form.toplevel'};     
    }
    if (defined($env{'form.foldername'}) ) {
        $foldername = $env{'form.foldername'}; 
    }

    foreach my $area (@{$areas}) {
        if (defined($env{"form.$area"}) && ($env{'form.'.$area} ne '')) {
            if ($cms eq 'angel5' && $area eq 'doc') {
                foreach (@{$cmsmap{$cms}{$area}}) {
                    $importareas{$_} = 1;
                }
            } else {
                $importareas{$cmsmap{$cms}{$area}} = 1;
            }
            if ($area eq 'board') {
                $db_handling = $env{'form.db_handling'};
            } elsif ($area eq 'users') {
                $user_handling = $env{'form.user_handling'};
            }
        }
    }

    my $manifest_result = &Apache::imsprocessor::process_manifest($cms,$tempdir,\%resources,\%items,\%hrefs,\%resinfo,'prepare',\%includedres,\%includeditems);
    if ($manifest_result eq 'ok') {
        foreach my $res (sort keys %resources) {
            if ($importareas{$resources{$res}{type}}) {
                $includedres{$res} = 1;
            }
        }
        foreach my $itm (sort keys %items) {
            &Apache::imsprocessor::get_imports(\%includeditems,\%items,\%resources,\%importareas,$itm);
        }
    }
    foreach my $itm (sort keys %includeditems) {
        &Apache::imsprocessor::get_parents(\%includeditems,\%items,$itm);
    }

    $manifest_result = &Apache::imsprocessor::process_manifest($cms,$tempdir,\%resources,\%items,\%hrefs,\%resinfo,'build',\%includedres,\%includeditems);
    if ($manifest_result eq 'ok') {

        my @path = ($cdom,$crs,$timenow);
        my $fullpath = $Apache::lonnet::perlvar{'lonDocRoot'}.'/userfiles';
        foreach my $item (@path) {
            $fullpath .= '/'.$item;
            if (!-e "$fullpath") {
                mkdir("$fullpath",0770);
            }
        }
        my @namedirs = ("resfiles","sequences","pages","problems");
        foreach my $name (@namedirs) {
            if (!-e "$fullpath/$name") {
                mkdir("$fullpath/$name",0770);
            }
        }
        &Apache::imsprocessor::target_resources(\%resources,\%importareas,\@targets);

        my @boards = ();
        my @announcements = ();
        my @quizzes = ();
        my @surveys = ();
        my @pools = ();
        my @groups = ();
        my %messages = ();
        my @timestamp = ();
        my %boardnum = ();
        my @topurls = ();
        my @topnames = ();
        my @packages = ();

        &Apache::imsprocessor::process_resinfo($cms,'DOCS',$tempdir,$destdir,\%items,\%resources,\@targets,\@boards,\@announcements,\@quizzes,\@surveys,\@pools,\@groups,\%messages,\@timestamp,\%boardnum,\%resinfo,$udom,$uname,$cdom,$crs,$db_handling,$user_handling,\%total,$seqstem,$seqstem,\@resrcfiles,\@packages,\%hrefs,\@pages,\@sequences);

        my $copy_result = &Apache::imsprocessor::copy_resources('DOCS',$cms,\%hrefs,$tempdir,\@targets,\%urls,$crs,$cdom,$destdir,$timenow,\%importareas);

        &Apache::imsprocessor::build_structure($cms,'DOCS',$destdir,\%items,\%resinfo,\%resources,\@targets,\%hrefs,$udom,$uname,'',$timenow,$cdom,$crs,\@timestamp,\%total,\@boards,\@announcements,\@quizzes,\@surveys,\@pools,\%boardnum,\@pages,\@sequences,\@topurls,\@topnames,\@packages,\%includeditems);

        foreach my $item (@pages) {
            my $filename = $timenow.'/pages/'.$item;
            my $fetchresult= &Apache::lonnet::process_coursefile('propagate',$crs,$cdom,$filename,'');
        }
        foreach my $item (@sequences) {
            unless ($item eq 'Top.sequence' && $toplevel eq 'oldfolder') {
                my $filename = $timenow.'/sequences/'.$item;
                my $fetchresult= &Apache::lonnet::process_coursefile('propagate',$crs,$cdom,$filename,'');
            }
        }
        foreach my $item (@resrcfiles) {
            my $filename = $timenow.'/resfiles/'.$item;
            my $fetchresult= &Apache::lonnet::process_coursefile('propagate',$crs,$cdom,$filename,'');
        }

        my @imports = ();
        if ($toplevel eq 'oldfolder') {
            for (my $i=0; $i<@topurls; $i++) {
                my $url = &unescape($topurls[$i]);
                my $name = &unescape($topnames[$i]);
                push(@imports, [$name, $url]);
            }
        } elsif ($toplevel eq 'newfolder') {
            my $url = &unescape("/uploaded/$cdom/$crs/$timenow/sequences/Top.sequence");
            my $name = &unescape("$env{'form.foldername'}");
            push(@imports, [$name, $url]);
        }
        my $errtext='';
        my $fatal=0;
        ($errtext,$fatal)=  &Apache::londocs::mapread($crs,$cdom,$folder.'.sequence');
        if ($#LONCAPA::map::order<1) {
            $LONCAPA::map::order[0]=1;
            $LONCAPA::map::resources[1]='';
        }
        my ($errtext,$fatal)=&Apache::londocs::group_import($crs,$cdom,$folder,'sequence','imsimport',@imports);
        if ($fatal) {
            &Apache::lonnet::logthis("Fatal error during group_import.");
        }
    }
    if ($tempdir =~ m/^\/home\/httpd\/perl\/tmp\/$crs\/\d{10}/) {
        system("rm -r -f $tempdir");
    }

    # All done, display success message
    $r->print(
        '<p class="LC_success">'
       .&mt('Your import is complete.')
       .'</p>'
    );
    # Re-initialize Button
    my $initbutton =
           '<input type="button" value="'
          .&mt('re-initializing course')
          .'" onclick="javascript:init(this.form)" />';
    $r->print(
        '<form method="post" action="/adm/roles" target="loncapaclient" name="importDone">'
       .'<input type="hidden" name="orgurl" value="/adm/coursedocs" />'
       .'<input type="hidden" name="selectrole" value="1" />'
       .'<input type="hidden" name="'.$env{'request.role'}.'" value="1" />'
       .'<p class="LC_warning">'
       .&mt('Changes will become active for your current session after [_1]'
           .', or the next time you log in.'
            ,$initbutton)
       .'</p>'
       .'</form>'
    );
}

1;
__END__
