# The LearningOnline Network with CAPA
# Utilities for classifying courses based on institutional code
#
# $Id: courseclassifier.pm,v 1.11 2010/12/03 04:28:36 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::courseclassifier;

use strict;
use lib '/home/httpd/lib/perl/';
use Apache::lonnet;
use Apache::loncommon;
use Apache::lonlocal;
use LONCAPA;

sub retrieve_instcodes {
    my ($coursecodes,$codedom) = @_;
    my $totcodes;
    my %courses = &Apache::lonnet::courseiddump($codedom,'.',1,'.','.','.',                                                undef,undef,'Course');
    foreach my $course (keys(%courses)) {
        if (ref($courses{$course}) eq 'HASH') {
            if ($courses{$course}{'inst_code'} ne '') {
                $$coursecodes{$course} = $courses{$course}{'inst_code'};
                $totcodes ++;
            }
        }
    }
    return $totcodes;
}

sub sort_cats {
    my ($num,$cat_order,$codetitles,$idsarrayref,$sorted) = @_;
    my @unsorted = @{$idsarrayref};
    if (defined($$cat_order{$$codetitles[$num]})) {
        foreach my $item (@{$$cat_order{$$codetitles[$num]}}) {
            if (grep/^\Q$item\E$/,@unsorted) {
                push @{$sorted}, $item;
            }
        }
    } else {
        @{$sorted} = sort (@unsorted);
    }
}

sub recurse_list {
    my ($cid,$codetitles,$codes,$num,$idarrays) = @_;
    if ($num == 0) {
        if (!grep/^$$codes{$cid}{$$codetitles[0]}$/,@{$$idarrays{$$codetitles[0]}}) {
            push @{$$idarrays{$$codetitles[0]}}, $$codes{$cid}{$$codetitles[0]};
        }
    } elsif ($num == 1) {
        if (defined($$idarrays{$$codetitles[1]}{$$codes{$cid}{$$codetitles[0]}})) {
            if (!grep/^$$codes{$cid}{$$codetitles[1]}$/,@{$$idarrays{$$codetitles[1]}{$$codes{$cid}{$$codetitles[0]}}}) {
                push @{$$idarrays{$$codetitles[1]}{$$codes{$cid}{$$codetitles[0]}}}, $$codes{$cid}{$$codetitles[1]};
            }
        } else {
            @{$$idarrays{$$codetitles[1]}{$$codes{$cid}{$$codetitles[0]}}} = ("$$codes{$cid}{$$codetitles[1]}");
        }
    } elsif ($num == 2) {
        if (defined($$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}})) {
            if (defined($$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}})) {
                if (!grep/^$$codes{$cid}{$$codetitles[2]}$/,@{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}}) {
                    push @{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}}, $$codes{$cid}{$$codetitles[2]};
                }
            } else {
                @{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ("$$codes{$cid}{$$codetitles[2]}");            }
        } else {
            %{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}} = ();
            @{$$idarrays{$$codetitles[2]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ("$$codes{$cid}{$$codetitles[2]}");
        }
    } elsif ($num == 3) {
        if (defined($$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}})) {
            if (defined($$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}})) {
                if (defined($$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}})) {
                    if (!grep/^$$codes{$cid}{$$codetitles[3]}$/,@{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}}) {
                        push @{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}}, $$codes{$cid}{$$codetitles[3]};
                    }
                } else {
                    @{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ("$$codes{$cid}{$$codetitles[3]}");
                }
            } else {
                %{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ();
                @{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ("$$codes{$cid}{$$codetitles[3]}");
            }
        } else {
            %{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}} = ();
            %{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ();
            @{$$idarrays{$$codetitles[3]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ("$$codes{$cid}{$$codetitles[3]}");
        }
    } elsif ($num == 4) {
        if (defined($$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}})) {
            if (defined($$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}})) {
                if (defined($$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}})) {
                    if (defined($$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}})) {
                        if (!grep/^$$codes{$cid}{$$codetitles[4]}$/,@{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}}) {
                            push @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}}, $$codes{$cid}{$$codetitles[4]};
                        }
                    } else {
                        @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}} = ("$$codes{$cid}{$$codetitles[4]}");
                    }
                } else {
                    %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ();
                    @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}} = ("$$codes{$cid}{$$codetitles[4]}");
                }
            } else {
                %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ();
                %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ();
                @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}{$$codes{$cid}{$$codetitles[3]}}} = ("$$codes{$cid}{$$codetitles[4]}");
            }
        } else {
            %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}} = ();
            %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}} = ();
            %{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[2]}}} = ();
            @{$$idarrays{$$codetitles[4]}{$$codes{$cid}{$$codetitles[0]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[1]}}{$$codes{$cid}{$$codetitles[3]}}} = ("$$codes{$cid}{$$codetitles[3]}");
        }
    }
    $num ++;
    if ($num <@{$codetitles}) {
        &recurse_list($cid,$codetitles,$codes,$num,$idarrays);
    }
}

sub build_code_selections {
    my ($codes,$codetitles,$cat_titles,$cat_order,$idlist,$idnums,$idlist_titles) = @_;
    my %idarrays = ();
    for (my $i=1; $i<@{$codetitles}; $i++) {
        %{$idarrays{$$codetitles[$i]}} = ();
    }
    foreach my $cid (sort keys %{$codes}) {
        &recurse_list($cid,$codetitles,$codes,0,\%idarrays);
    }
    for (my $num=0; $num<@{$codetitles}; $num++) {
        if ($num == 0) {
            my @contents = ();
            my @contents_titles = ();
            &sort_cats($num,$cat_order,$codetitles,\@{$idarrays{$$codetitles[0]}},\@contents);
            if (defined($$cat_titles{$$codetitles[0]})) {
                foreach (@contents) {
                    push @contents_titles, $$cat_titles{$$codetitles[0]}{$_};
                }
            }
            $$idlist{$$codetitles[0]} = join('","',@contents);
            $$idnums{$$codetitles[0]} = scalar(@contents);
            if (defined($$cat_titles{$$codetitles[0]})) {
                $$idlist_titles{$$codetitles[0]} = join('","',@contents_titles);
            }
        } elsif ($num == 1) {
            %{$$idlist{$$codetitles[1]}} = ();
            %{$$idlist_titles{$$codetitles[1]}} = ();
            foreach my $key_a (keys %{$idarrays{$$codetitles[1]}}) {
                my @sorted_a = ();
                my @sorted_a_titles = ();
                &sort_cats($num,$cat_order,$codetitles,\@{$idarrays{$$codetitles[1]}{$key_a}},\@sorted_a);
                if (defined($$cat_titles{$$codetitles[1]})) {
                    foreach (@sorted_a) {
                        push @sorted_a_titles, $$cat_titles{$$codetitles[1]}{$_};
                    }
                }
                $$idlist{$$codetitles[1]}{$key_a} = join('","',@sorted_a);
                $$idnums{$$codetitles[1]}{$key_a} = scalar(@sorted_a);
                if (defined($$cat_titles{$$codetitles[1]})) {
                    $$idlist_titles{$$codetitles[1]}{$key_a} = join('","',@sorted_a_titles);
                }
            }
        } elsif ($num == 2) {
            %{$$idlist{$$codetitles[2]}} = ();
            %{$$idlist_titles{$$codetitles[2]}} = ();
            foreach my $key_a (keys %{$idarrays{$$codetitles[2]}}) {
                %{$$idlist{$$codetitles[2]}{$key_a}} = ();
                %{$$idlist_titles{$$codetitles[2]}{$key_a}} = ();
                foreach my $key_b (keys %{$idarrays{$$codetitles[2]}{$key_a}}) {
                    my @sorted_b = ();
                    my @sorted_b_titles = ();
                    &sort_cats($num,$cat_order,$codetitles,\@{$idarrays{$$codetitles[2]}{$key_a}{$key_b}},\@sorted_b);
                    if (defined($$cat_titles{$$codetitles[2]})) {
                        foreach (@sorted_b) {
                            push @sorted_b_titles, $$cat_titles{$$codetitles[2]}{$_};
                        }
                    }
                    $$idlist{$$codetitles[2]}{$key_a}{$key_b} = join('","',@sorted_b);
                    $$idnums{$$codetitles[2]}{$key_a}{$key_b} = scalar(@sorted_b);
                    if (defined($$cat_titles{$$codetitles[2]})) {
                        $$idlist_titles{$$codetitles[2]}{$key_a}{$key_b} = join('","',@sorted_b_titles);
                    }
                }
            }
        } elsif ($num == 3) {
            %{$$idlist{$$codetitles[3]}} = ();
            foreach my $key_a (keys %{$idarrays{$$codetitles[3]}}) {
                %{$$idlist{$$codetitles[3]}{$key_a}} = ();
                foreach my $key_b (keys %{$idarrays{$$codetitles[3]}{$key_a}}) {
                    %{$$idlist{$$codetitles[3]}{$key_a}{$key_b}} = ();
                    foreach my $key_c (keys %{$idarrays{$$codetitles[3]}{$key_a}{$key_b}}) {
                        my @sorted_c = ();
                        my @sorted_c_titles = ();
                        &sort_cats($num,$cat_order,$codetitles,\@{$idarrays{$$codetitles[3]}{$key_a}{$key_b}{$key_c}},\@sorted_c);
                        if (defined($$cat_titles{$$codetitles[3]})) {
                            foreach (@sorted_c) {
                                push @sorted_c_titles, $$cat_titles{$$codetitles[3]}{$_};
                            }
                        }
                        $$idlist{$$codetitles[3]}{$key_a}{$key_b}{$key_c} = join('","',@sorted_c);
                        $$idnums{$$codetitles[3]}{$key_a}{$key_b}{$key_c} = scalar(@sorted_c);
                        if (defined($$cat_titles{$$codetitles[3]})) {
                            $$idlist_titles{$$codetitles[3]}{$key_a}{$key_b}{$key_c} = join('","',@sorted_c_titles);
                        }
                    }
                }
            }
        } elsif ($num == 4) {
            %{$$idlist{$$codetitles[4]}} = ();
            foreach my $key_a (keys %{$idarrays{$$codetitles[4]}}) {
                %{$$idlist{$$codetitles[4]}{$key_a}} = ();
                foreach my $key_b (keys %{$idarrays{$$codetitles[4]}{$key_a}}) {
                    %{$$idlist{$$codetitles[4]}{$key_a}{$key_b}} = ();
                    foreach my $key_c (keys %{$idarrays{$$codetitles[4]}{$key_a}{$key_b}}) {
                        %{$$idlist{$$codetitles[4]}{$key_a}{$key_b}{$key_c}} = ();
                        foreach my $key_d (keys %{$idarrays{$$codetitles[4]}{$key_a}{$key_b}{$key_c}}) {
                            my @sorted_d = ();
                            my @sorted_d_titles = ();
                            &sort_cats($num,$cat_order,$codetitles,$idarrays{$$codetitles[4]}{$key_a}{$key_b}{$key_c}{$key_d},\@sorted_d);
                            if (defined($$cat_titles{$$codetitles[4]})) {
                                foreach (@sorted_d) {
                                    push @sorted_d_titles, $$cat_titles{$$codetitles[4]}{$_};
                                }
                            }
                            $$idlist{$$codetitles[4]}{$key_a}{$key_b}{$key_c}{$key_d} = join('","',@sorted_d);
                            $$idnums{$$codetitles[4]}{$key_a}{$key_b}{$key_c}{$key_d} = scalar(@sorted_d);
                            if (defined($$cat_titles{$$codetitles[4]})) {
                                $$idlist_titles{$$codetitles[3]}{$key_a}{$key_b}{$key_c}{$key_d} = join('","',@sorted_d_titles);
                            }
                        }
                    }
                }
            }
        }
    }
}

sub javascript_code_selections {
    my ($formname,@codetitles) = @_;
    my $numtitles = @codetitles;
    my %lt = &Apache::lonlocal::texthash(
                      Select => 'Select',
                      Pick   => 'Pick',
             );
    my $output = (<<END_OF_BLOCK);
 var display = new Array($numtitles)
 if (caller == "" || caller == "$codetitles[0]") {
     if (caller == "") {
         document.$formname.Year.length = 0
         document.$formname.Year.options[0] = new Option("$lt{'Select'}","-1",true,true)
         display[0] = new Array(idyears.length)
         for (var i=0; i<idyears.length; i++) {
             display[0][i] = idyears[i]
             if (longtitles[0] == 1) {
                 if (idyearslongs[i] != "") {
                     display[0][i] = idyearslongs[i]
                 }
             }
             else {
                 if (idyearslongs[i] != "") {
                     display[0][i] = idyears[i]
                 }
             }
             document.$formname.Year.options[i+1] = new Option(display[0][i],idyears[i],false,false)
         }
         document.$formname.Year.selectedIndex = 0;
     }
     document.$formname.Semester.length = 0
     document.$formname.Department.length = 0;
     document.$formname.Number.length = 0
     document.$formname.Department.options[0] = new Option("<-$lt{'Pick'} $codetitles[1]","-1",true,true)
     document.$formname.Number.options[0] = new Option("<-$lt{'Pick'} $codetitles[2]","-1",true,true)
     if (idyr == 0 || caller == "") {
         document.$formname.Semester.options[0] = new Option("<-$lt{'Pick'} $codetitles[0]","-1",true,true)
     }
     else {
         document.$formname.Semester.options[0] = new Option("$lt{'Select'}","-1",true,true)
         display[1] = new Array(idsems[idyr-1].length)
         for (var i=0; i<idsems[idyr-1].length; i++) {
             display[1][i] = idsems[idyr-1][i]
             if (longtitles[1] == 1) {
                 if (idsemslongs[idyr-1][i] != "") {
                     display[1][i] = idsemslongs[idyr-1][i]
                 }
             }
             document.$formname.Semester.options[i+1] = new Option(display[1][i],idsems[idyr-1][i],false,false)
         }
     }
     document.$formname.Semester.selectedIndex = 0;
 }
 if (caller == "$codetitles[1]") {
   document.$formname.Department.length = 0
   document.$formname.Number.length = 0
   document.$formname.Number.options[0] = new Option("<-Pick $codetitles[2]","-1",true,true)
   if (idsem == 0) {
     document.$formname.Department.options[0] = new Option("<-$lt{'Pick'} $codetitles[1]","-1",true,true)
   }
   else {
    document.$formname.Department.options[0] = new Option("$lt{'Select'}","-1",true,true)
    display[2] = new Array(idcodes[idyr-1][idsem-1].length)
    for (var i=0; i<idcodes[idyr-1][idsem-1].length; i++) {
      display[2][i] = idcodes[idyr-1][idsem-1][i]
      if (longtitles[2] == 1) {
          if (idcodeslongs[idyr-1][idsem-1][i] != "") {
              display[2][i] = idcodeslongs[idyr-1][idsem-1][i]
          }
      }
      document.$formname.Department.options[i+1] = new Option(display[2][i],idcodes[idyr-1][idsem-1][i],false,false)
    }
   }
   document.$formname.Department.selectedIndex = 0
 }
 if (caller == "$codetitles[2]") {
   document.$formname.Number.length = 0
   if (iddept == 0) {
     document.$formname.Number.options[0] = new Option("<-$lt{'Pick'} $codetitles[2]","-1",true,true)
   }
   else {
    document.$formname.Number.options[0] = new Option("Select","-1",true,true)
    display[3] = new Array (idcourses[idyr-1][idsem-1][iddept-1].length)
    for (var i=0; i<idcourses[idyr-1][idsem-1][iddept-1].length; i++) {
      display[3][i] = idcourses[idyr-1][idsem-1][iddept-1][i]
      if (longtitles[3] == 1) {
        if (idcourseslongs[idyr-1][idsem-1][iddept-1][i] != "") {
            display[3][i] = idcourseslongs[idyr-1][idsem-1][iddept-1][i]
        }
      }
      document.$formname.Number.options[i+1] = new Option(display[3][i],idcourses[idyr-1][idsem-1][iddept-1][i],false,false)
    }
   }
   document.$formname.Number.selectedIndex = 0
 }
}

function initialize_codes() {
    courseSet();
    return;
}
END_OF_BLOCK
}


sub javascript_definitions {
    my ($codetitles,$idlist,$idlist_titles,$idnums,$cat_titles) = @_;
    my $numtitles = @{$codetitles};
    my $longtitles = [];
    for (my $i=0; $i<$numtitles; $i++) {
       if (defined($cat_titles->{$codetitles->[$i]})) {
           $longtitles->[$i] = 1;
       } else {
           $longtitles->[$i] = 0;
       }
    }
    my $scripttext;
    if ($longtitles->[0]) {
        $scripttext =
          qq|      var idyearslongs = new Array("$idlist_titles->{$codetitles->[0]}")\n|;
    }
    $scripttext .=
          "      var idsems = new Array ($idnums->{$codetitles->[0]})\n";
    if ($longtitles->[1]) {
        $scripttext .=
          "      var idsemslongs = new Array ($idnums->{$codetitles->[0]})\n";    }
    $scripttext .=
          "      var idcodes = new Array ($idnums->{$codetitles->[0]})\n";
    if ($longtitles->[2]) {
        $scripttext .=
          "      var idcodeslongs = new Array ($idnums->{$codetitles->[0]})\n";
    }
    $scripttext .=
          "      var idcourses = new Array ($idnums->{$codetitles->[0]})\n";
    if ($longtitles->[3]) {
        $scripttext .=
          "      var idcourseslongs =  new Array ($idnums->{$codetitles->[0]})\n";
    }
    my @sort_a = split/","/,$idlist->{$codetitles->[0]};
    for (my $j=0; $j<@sort_a; $j++) {
        $scripttext .= qq| idsems[$j] = new Array("$idlist->{$codetitles->[1]}{$sort_a[$j]}")\n|;
        if ($longtitles->[1]) {
            $scripttext .= qq| idsemslongs[$j] = new Array("$idlist_titles->{$codetitles->[1]}{$sort_a[$j]}")\n|;
        }
        $scripttext .= qq| idcodes[$j] = new Array($idnums->{$codetitles->[1]}{$sort_a[$j]})\n|;
        if ($longtitles->[2]) {
            $scripttext .= qq| idcodeslongs[$j] = new Array($idnums->{$codetitles->[1]}{$sort_a[$j]})\n|;
        }
        $scripttext .= qq| idcourses[$j] = new Array($idnums->{$codetitles->[1]}{$sort_a[$j]})\n|;
        if ($longtitles->[3]) {
            $scripttext .= qq| idcourseslongs[$j] = new Array($idnums->{$codetitles->[1]}{$sort_a[$j]})\n|;
        }
        my @sort_b = split/","/,$idlist->{$codetitles->[1]}{$sort_a[$j]};
        for (my $k=0; $k<@sort_b; $k++) {
            my $idcode_entry = $idlist->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]};
            $scripttext .= qq| idcodes[$j][$k] = new Array("$idcode_entry")\n|;
            if ($longtitles->[2]) {
                my $idcodelong_entry = $idlist_titles->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]};
                $scripttext .= qq| idcodeslongs[$j][$k] = new Array("$idcodelong_entry")\n|;
            }
            $scripttext .= qq| idcourses[$j][$k] = new Array($idnums->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]})\n|;
            if ($longtitles->[3]) {
                $scripttext .= qq| idcourseslongs[$j][$k] = new Array($idnums->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]})\n|;
            }
            my @sort_c = split/","/,$idlist->{$codetitles->[2]}{$sort_a[$j]}{$sort_b[$k]};
            for (my $l=0; $l<@sort_c; $l++) {
                my $idcourse_entry = $idlist->{$codetitles->[3]}{$sort_a[$j]}{$sort_b[$k]}{$sort_c[$l]};
                $scripttext .= qq| idcourses[$j][$k][$l] = new Array("$idcourse_entry")\n|;
                if ($longtitles->[3]) {
                    my $idcourselong_entry = $idlist_titles->{$codetitles->[3]}{$sort_a[$j]}{$sort_b[$k]}{$sort_c[$l]};
                    $scripttext .= qq| idcourseslongs[$j][$k][$l] = new Array("$idcourselong_entry")\n|;
                }
            }
        }
    }
    return ($scripttext,$longtitles);
}

sub courseset_js_start {
    my ($formname,$longtitles_str,$allidlist) = @_;
    my $output = <<END;

function courseSet(caller) {
    var longtitles = new Array ("$longtitles_str");
    var idyr = document.$formname.Year.selectedIndex
    var idsem  = document.$formname.Semester.selectedIndex
    var iddept = document.$formname.Department.selectedIndex
    var idclass = document.$formname.Number.selectedIndex
    var idyears = new Array("$allidlist");
END
    return $output;
}

sub instcode_selectors_data {
    my ($codedom,$formname,$cat_items,$codetitles,$cat_titles,$cat_order,$officialjs) = @_;
    my ($jscript,%coursecodes,%codes,%idlist,%idnums,%idlist_titles,
        %by_year,%by_sem,%by_dept);
    my ($numtitles,$lasttitle);
    my $caller = 'global';
    my $totcodes = &retrieve_instcodes(\%coursecodes,$codedom);
    if ($totcodes > 0) {
        if (&Apache::lonnet::auto_instcode_format($caller,$codedom,\%coursecodes,
                           \%codes,$codetitles,$cat_titles,$cat_order) eq 'ok') {
            &build_code_selections(\%codes,$codetitles,$cat_titles,$cat_order,
                                   \%idlist,\%idnums,\%idlist_titles);
            my ($scripttext,$longtitles) = 
                &javascript_definitions($codetitles,\%idlist,\%idlist_titles,
                                        \%idnums,$cat_titles);
            my $longtitles_str = join('","',@{$longtitles});
            my $allidlist = $idlist{$codetitles->[0]};
            $numtitles = @{$codetitles};
            $lasttitle = $numtitles;
            if ($numtitles > 4) {
                $lasttitle = 4;
            }
            if ($numtitles == 0) {
                if (!defined($env{'form.state'})) {
                    $env{'form.state'} = 'listing';
                }
            } else {
                my @data = ('top');
                for (my $k=0; $k<$lasttitle; $k++) {
                    my $cat = $codetitles->[$k];
                    my $level = 1;
                    $level = &recurse_options($codetitles->[$k],$idlist{$codetitles->[$k]},$level,$cat,$cat_items,\@data,\%by_year,\%by_sem,\%by_dept);
                }
                $scripttext .= &build_javascript(\%by_year,\%by_sem,\%by_dept,$cat_order,$codetitles);
                if ($officialjs) {
                    $jscript .= '

function toggleOfficial() {';
                    for (my $i=0; $i<@{$codetitles}-1; $i++) {
                        $jscript .= '
            document.'.$formname.'.'.$codetitles->[$i].'.selectedIndex = 0;';
                    }
    $jscript .=  '
}

function setOfficial(caller) {
   if (typeof(caller) != "undefined") {
       if (caller.options[caller.selectedIndex].value != 0) {
           if (document.'.$formname.'.official.length > 0) {
               for (var j=0; j<document.'.$formname.'.official.length; j++) {
                   if (document.'.$formname.'.official[j].value == "on") {
                       document.'.$formname.'.official[j].checked = true;
                   }
               }
            }
        }
    }
    return;
}

';

                    $officialjs = 'setOfficial(caller);';
                }
                $jscript .= &javascript_select_filler($formname,$scripttext,$codetitles,$longtitles_str,$allidlist,$officialjs);
                if ($env{'form.state'} eq 'listing') {
                    $jscript .= '
function setElements() {
';
                    for (my $i=0; $i<@{$codetitles}-1; $i++) {
                        if ($env{'form.'.$codetitles->[$i]} != -1) {
                            $jscript .= '
    for (var j=0; j<document.'.$formname.'.'.$codetitles->[$i].'.length; j++) {
        if (document.'.$formname.'.'.$codetitles->[$i].'[j].value == "'.$env{'form.'.$codetitles->[$i]}.'") {
            document.'.$formname.'.'.$codetitles->[$i].'.selectedIndex = j;
        }
    }
';
                        }
                    }
                    $jscript .= '   courseSet()'."\n";
                    if ($env{'form.'.$codetitles->[-1]} != -1) {
                        $jscript .= '
    for (var j=0; j<document.'.$formname.'.'.$codetitles->[-1].'.length; j++) {
        if (document.'.$formname.'.'.$codetitles->[-1].'[j].value == "'.$env{'form.'.$codetitles->[-1]}.'") {
            document.'.$formname.'.'.$codetitles->[-1].'.selectedIndex = j;
        }
    }
';
                    }
                    $jscript .= '}';
                }
            }
        }
    }
    return ($jscript,$totcodes,$numtitles,$lasttitle);
}

sub build_instcode_selectors {
    my ($numtitles,$lasttitle,$cat_items,$codetitles,$cat_titles,$cat_order) = @_;
    my $output;
    my @standardnames = &Apache::loncommon::get_standard_codeitems();
    if ($numtitles > 0) {
        $output .= '<table><tr>';
        for (my $k=0; $k<$lasttitle-1; $k++) {
            my (@items,@unsorted);
            if (ref($cat_items->{$codetitles->[$k]}) eq 'ARRAY') {
                @unsorted = @{$cat_items->{$codetitles->[$k]}};
            }
            &sort_cats($k,$cat_order,$codetitles,\@unsorted,\@items);
            my @longitems;
            if (defined($cat_titles->{$codetitles->[$k]})) {
                foreach my $item (@items) {
                    push(@longitems,$cat_titles->{$codetitles->[$k]}{$item});
                }
            } else {
                @longitems = @items;
            }
            $output .= '<td align="center">'.$codetitles->[$k].'<br />'."\n".
                       '<select name="'.$standardnames[$k].'" onChange="courseSet(this)"'.
                       '>'."\n".'<option value="0">'.&mt('All').'</option>'."\n";
            for (my $i=0; $i<@items; $i++) {
                if ($longitems[$i] eq '') {
                    $longitems[$i] = $items[$i];
                }
                $output .= ' <option value="'.$items[$i].'">'.$longitems[$i].'</option>';
            }
            $output .= '</select></td>';
        }
        $output .= '<td align="center">'.$codetitles->[$lasttitle-1].'<br />'."\n".
                   '<select name="'.$standardnames[$lasttitle-1].'">'."\n".
                   '<option value="0">'.&mt('All')."\n".
                   '</option>'."\n".'</select>'."\n".
                   '</td></tr></table>'."\n";
        if ($numtitles > 4) {
            $output .= '<br /><br />'.$codetitles->[$numtitles-1].'<br />'."\n".
                       '<input type="text" name="'.$standardnames[$numtitles-1].
                       '" /><br />'."\n";
        }
        $output .= '<br />';
    }
    return $output;
}

sub recurse_options {
    my ($currkey,$currlist,$level,$cat,$cat_options,$data,$by_year,$by_sem,$by_dept) = @_;
    if (ref($currlist) eq 'HASH') {
        $level ++;
        foreach my $key (sort(keys(%{$currlist}))) {
            $$data[$level-1]= $key;
            &recurse_options($key,$currlist->{$key},$level,$cat,$cat_options,$data,$by_year,$by_sem,$by_dept);
        }
    } else {
        $level --;
        my @contents = split(/","/,$currlist);
        foreach my $item (@contents) {
            if (!grep(/^\Q$item\E$/,@{$cat_options->{$cat}})) {
                push(@{$cat_options->{$cat}},$item);
            }
            if ($level == 3) {
                if (!grep/^\Q$item\E$/,@{$by_year->{$data->[1]}->{$currkey}}) {
                    push(@{$by_year->{$data->[1]}->{$currkey}},$item);
                }
                if (!grep/^\Q$item\E$/,@{$by_sem->{$data->[2]}->{$currkey}}) {
                    push(@{$by_sem->{$data->[2]}->{$currkey}},$item);
                }
                if (!grep/^\Q$item\E$/,@{$by_dept->{$currkey}}) {
                    push(@{$by_dept->{$currkey}},$item);
                }

            }
        }
    }
    return $level;
}

sub build_javascript {
    my ($by_year,$by_sem,$by_dept,$cat_order,$codetitles) = @_;
    my @unsorted = keys(%{$by_year});
    my @sorted_yrs;
    &sort_cats('0',$cat_order,$codetitles,\@unsorted,\@sorted_yrs);    my $output = 'var idcse_by_yr_year = new Array("'.join('","',@sorted_yrs).'");'."\n".
                 'var idcse_by_yr_dept = new Array('.scalar(@sorted_yrs).');'."\n".
                 'var idcse_by_yr_num = new Array('.scalar(@sorted_yrs).');'."\n";
    for (my $i=0; $i<@sorted_yrs; $i++) {
        my $numkeys = keys(%{$by_year->{$sorted_yrs[$i]}});
        $output .= " idcse_by_yr_num[$i] = new Array($numkeys);\n";
        if (ref($by_year->{$sorted_yrs[$i]}) eq 'HASH') {
            @unsorted = keys(%{$by_year->{$sorted_yrs[$i]}});
            my @sorted_depts;
            &Apache::courseclassifier::sort_cats('2',$cat_order,$codetitles,\@unsorted,\@sorted_depts);
            $output .= qq| idcse_by_yr_dept[$i] = new Array ("|.join('","',@sorted_depts).'");'."\n";
            for (my $j=0; $j<@sorted_depts; $j++) {
                $output .= qq| idcse_by_yr_num[$i][$j] = new Array ("|;
                $output .= join('","',sort(@{$by_year->{$sorted_yrs[$i]}->{$sorted_depts[$j]}})).'");'."\n";
            }
        }
    }
    @unsorted = keys(%{$by_sem});
    my @sorted_sems;
    &sort_cats('1',$cat_order,$codetitles,\@unsorted,\@sorted_sems);
    $output .=  'idcse_by_sem_sems = new Array("'.join('","',@sorted_sems).'");'."\n".
                'idcse_by_sem_dept = new Array('.scalar(@sorted_sems).');'."\n".
                'idcse_by_sem_num = new Array('.scalar(@sorted_sems).');'."\n";
    for (my $i=0; $i<@sorted_sems; $i++) {
        my $numkeys = keys(%{$by_sem->{$sorted_sems[$i]}});
        $output .= " idcse_by_sem_num[$i] = new Array($numkeys);\n";
        if (ref($by_sem->{$sorted_sems[$i]}) eq 'HASH') {
            @unsorted = keys(%{$by_sem->{$sorted_sems[$i]}});
            my @sorted_depts;
            &sort_cats('2',$cat_order,$codetitles,\@unsorted,\@sorted_depts);
            $output .= qq| idcse_by_sem_dept[$i] = new Array("|.join('","',@sorted_depts).'");'."\n";
            for (my $j=0; $j<@sorted_depts; $j++) {
                $output .= qq| idcse_by_sem_num[$i][$j] = new Array ("|.join('","',sort(@{$by_sem->{$sorted_sems[$i]}->{$sorted_depts[$j]}})).'");'."\n";
            }
        }
    }
    @unsorted = keys(%{$by_dept});
    my @sorted_deps;
    &sort_cats('2',$cat_order,$codetitles,\@unsorted,\@sorted_deps);
    $output .= 'idcse_by_dep = new Array('.scalar(@sorted_deps).');'."\n";
    for (my $k=0; $k<@sorted_deps; $k++) {
        $output .= qq| idcse_by_dep[$k] = new Array ("|.join('","',sort(@{$by_dept->{$sorted_deps[$k]}})).'");'."\n";
    }
    return $output;
}

sub javascript_select_filler {
    my ($formname,$scripttext,$codetitles,$longtitles_str,$allidlist,$officialjs) = @_;
    my $output = <<END;

function courseSet(caller) {
    var longtitles = new Array ("$longtitles_str");
    var valyr = document.$formname.Year.options[document.$formname.Year.selectedIndex].value
    var valsem  = document.$formname.Semester.options[document.$formname.Semester.selectedIndex].value
    var valdept = document.$formname.Department.options[document.$formname.Department.selectedIndex].value
    var valclass = document.$formname.Number.options[document.$formname.Number.selectedIndex].value
    var idyears = new Array("$allidlist");
    var idyr = -1;
    var idsem = -1;
    var iddept = -1;
    document.$formname.Number.length = 0;

    $scripttext

    selYear = document.$formname.Year.selectedIndex-1;
    selSemester = document.$formname.Semester.selectedIndex-1;
    selDepartment = document.$formname.Department.selectedIndex-1;
    if (selYear == -1) {
        if (selSemester == -1) {
            if (selDepartment > -1) {
                document.$formname.Number.options[0] =  new Option('All','0',false,false);
                for (var k=0; k<idcse_by_dep[selDepartment].length; k++) {
                    document.$formname.Number.options[k+1] = new Option(idcse_by_dep[selDepartment][k],idcse_by_dep[selDepartment][k],false,false);

                }
            }
            else {
                document.$formname.Number.options[0] = new Option("All","0",true,true);
            }
        }
        else {
            if (selDepartment > -1) {
                for (var i=0; i<idcse_by_sem_sems.length; i++) {
                    if (idcse_by_sem_sems[i] == valsem) {
                        idsem = i;
                    }
                }
                if (idsem != -1) {
                    for (var i=0; i<idcse_by_sem_dept[idsem].length; i++) {
                        if (idcse_by_sem_dept[idsem][i] == valdept) {
                            iddept = i;
                        }
                    }
                }
                if (iddept != -1) {
                    document.$formname.Number.options[0] =  new Option('All','0',false,false);
                    for (var k=0; k<idcse_by_sem_num[idsem][iddept].length; k++) {
                        document.$formname.Number.options[k+1] = new Option(idcse_by_sem_num[idsem][iddept][k],idcse_by_sem_num[idsem][iddept][k],false,false);
                    }
                }
                else {
                    document.$formname.Number.options[0] =  new Option('No courses','0',true,true);
                }
            }
            else {
                document.$formname.Number.options[0] = new Option("All","0",true,true);
            }
        }
    }
    else {
        if (selSemester == -1) {
            if (selDepartment > -1) {
                for (var i=0; i<idcse_by_yr_year.length; i++) {
                    if (idcse_by_yr_year[i] == valyr) {
                        idyr = i;
                    }
                }
                if (idyr != -1) {
                    for (var i=0; i<idcse_by_yr_dept[idyr].length; i++) {
                        if (idcse_by_yr_dept[idyr][i] == valdept) {
                            iddept = i;
                        }
                    }
                }
                if (iddept != -1) {
                    document.$formname.Number.options[0] =  new Option('All','0',false,false);
                    for (var k=0; k<idcse_by_yr_num[idyr][iddept].length; k++) {
                        document.$formname.Number.options[k+1] = new Option(idcse_by_yr_num[idyr][iddept][k],idcse_by_yr_num[idyr][iddept][k],false,false);
                    }
                }
                else {
                    document.$formname.Number.options[0] =  new Option('No courses','0',true,true);
                }
            }
            else {
                document.$formname.Number.options[0] = new Option("All","0",true,true);
            }
        }
        else {
            if (selDepartment > -1) {
                for (var k=0; k<idyears.length; k++) {
                    if (idyears[k] == valyr) {
                        idyr = k;
                    }
                }
                if (idyr != -1) {
                    for (var k=0; k<idsems[idyr].length; k++) {
                        if (idsems[idyr][k] == valsem) {
                            idsem = k;
                        }
                    }
                }
                if (idsem != -1) {
                    for (var k=0; k<idcodes[idyr][idsem].length; k++) {
                        if (idcodes[idyr][idsem][k] == valdept) {
                            iddept = k;
                        }
                    }
                }
                if (iddept != -1) {
                    document.$formname.Number.options[0] =  new Option('All','0',false,false);
                    for (var i=0; i<idcourses[idyr][idsem][iddept].length; i++) {
                        var display = idcourses[idyr][idsem][iddept][i];
                        if (longtitles[3] == 1) {
                            if (idcourseslongs[idyr][idsem][iddept][i] != "") {
                                display = idcourseslongs[idyr][idsem][iddept][i]
                            }
                        }
                        document.$formname.Number.options[i+1] = new Option(display,idcourses[idyr][idsem][iddept][i],false,false)
                    }
                }
                else {
                    document.$formname.Number.options[0] =  new Option('No courses','0',true,true);
                }
            }
            else {
                document.$formname.Number.options[0] =  new Option('All','0',true,true);
            }
        }
        document.$formname.Number.selectedIndex = 0
    }
    $officialjs
}
END
    return $output;
}

sub instcode_search_str {
    my ($domain,$numtitles,$codetitles) = @_;
    my $instcode;
    if (defined($numtitles) && $numtitles == 0) {
        $instcode = '.+';
    } else {
        my (%codedefaults,@code_order);
        my $defaults_result =
            &Apache::lonnet::auto_instcode_defaults($domain,\%codedefaults,
                                                    \@code_order);
        my @standardnames = &Apache::loncommon::get_standard_codeitems();
        my %local_to_standard;
        if (ref($codetitles) eq 'ARRAY') {
            for (my $i=0; $i<@{$codetitles}; $i++) {
                $local_to_standard{$codetitles->[$i]} = $standardnames[$i];
            }
        }
        if ($defaults_result eq 'ok') {
            $instcode ='^';
            foreach my $loctitle (@code_order) {
                my $item = $local_to_standard{$loctitle};
                if ($item ne '') {
                    if ($env{'form.'.$item} eq '0' ) {
                        $instcode .= $codedefaults{$item};
                    } else {
                        $instcode .= $env{'form.'.$item};
                    }
                } else {
                    $instcode .= '.+';
                }
            }
            $instcode .= '$';
        } else {
            $instcode = '.+';
        }
    }
    return $instcode;
}

sub instcode_from_selectors {
    my ($cdom) = @_;
    my $instcode;
    my $caller = 'global';
    my (%coursecodes,%codes,@codetitles,%cat_titles,%cat_order,
        %codedefaults,@code_order);
    my $format_reply =
        &Apache::lonnet::auto_instcode_format($caller,$cdom,\%coursecodes,
                            \%codes,\@codetitles,\%cat_titles,\%cat_order);
    my $defaults_result =
        &Apache::lonnet::auto_instcode_defaults($cdom,\%codedefaults,
                                                \@code_order);
    if (($defaults_result eq 'ok') && ($format_reply eq 'ok')) {
        my @standardnames = &Apache::loncommon::get_standard_codeitems();
        my %local_to_standard;
        for (my $i=0; $i<@codetitles; $i++) {
            $local_to_standard{$codetitles[$i]} = $standardnames[$i];
        }
        foreach my $loctitle (@code_order) {
            my $category = $local_to_standard{$loctitle};
            if ($category ne '') {
                if ($env{'form.'.$category} eq '-1' ) {
                    $instcode .= $codedefaults{$category};
                } else {
                    $instcode .= $env{'form.'.$category};
                }
            } else {
                $instcode .= '.+';
            }
        }
    }
    return $instcode;
}

1;

