# The LearningOnline Network
# Bulletin Board Handler
#
# $Id: lonbulletin.pm,v 1.62 2010/10/27 01:00:38 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonbulletin;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lonnet;
use Apache::lontexconvert;
use Apache::lonfeedback;
use Apache::lonlocal;
use Apache::lonhtmlcommon;
use HTML::Entities();
use LONCAPA;

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;
    my $target=$env{'form.grade_target'};

# ------------------------------------------------------------ Print the screen
    if ($target eq 'tex') {
        $r->print(&Apache::lonprintout::print_latex_header($env{'form.latex_type'}));
    }
    my (undef,undef,undef,undef,$marker)=split(/\//,$r->uri);
# Is this even in a course?
    if (!$env{'request.course.id'}) {
        &Apache::loncommon::simple_error_page($r,'Not in a course',
                                              'Not in a course');
        return OK;
    }

    $marker=~s/\D//g;

    if (!$marker) {
        &Apache::loncommon::simple_error_page($r,'Invalid Call',
                                              'Invalid Call');
        return OK;
    }

    my $dom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    my $crs = $env{'course.'.$env{'request.course.id'}.'.num'};
    my ($group,$grp_desc);

# --------------------------------------------------------- The syllabus fields
    my %syllabusfields=&Apache::lonlocal::texthash(
       'aaa_title'         => 'Topic',
       'bbb_content'       => 'Task',
       'ccc_webreferences' => 'Web References');

# ------------------------------------------------------------ Get Query String
    &Apache::loncommon::get_unprocessed_cgi
                ($ENV{'QUERY_STRING'},['forcestudent','forceedit','register',
                                       'origpage','group','ref']);
# ----------------------------------------------------- Force menu registration
    my %addentries;
    if ($env{'form.origpage'}) {
        $addentries{'onload'} = "document.location='#newpost';";
    }
# --------------------------------------------------------------- Force Student
    my $forcestudent='';
    if ($env{'form.forcestudent'}) { $forcestudent='student'; }

    my $forceedit='';
    if ($env{'form.forceedit'}) { $forceedit='edit'; }
    my $refarg = '';
    if (exists($env{'form.ref'})) { $refarg = 'ref='.$env{'form.ref'}; }

    my %syllabus=&Apache::lonnet::dump('bulletinpage_'.$marker,$dom,$crs);

    my $boardurl = $r->uri;
    if ($boardurl =~ m|/adm/\Q$dom\E/\Q$crs\E/\d+/bulletinboard|) {
        if (!exists($syllabus{'group'})) {
            &Apache::loncommon::simple_error_page($r,'Group information missing',
                                                 'Group information missing');

            return OK;
        } else {
            $group = $syllabus{'group'};
            if ($group eq '') {
                &Apache::loncommon::simple_error_page($r,'Invalid group',
                                                     'Invalid group');
                return OK;
            }
            my %curr_groups = &Apache::longroup::coursegroups($dom,$crs,$group);
            if (!defined($curr_groups{$group})) {
                &Apache::loncommon::simple_error_page($r,'Invalid group',
                                                     'Invalid group');
                return OK;
            } else {
                my %content = &Apache::longroup::get_group_settings(
                                                          $curr_groups{$group});
                $grp_desc = &unescape($content{'description'});
            }
        }
    }

# --------------------------------------- There is such a user, get environment
    if ($target ne 'tex') {
        my $course_or_group;
        if($group eq '') {
            $course_or_group="Course";
        } else {
            $course_or_group="Group";
        }
        my $start_page =
            &Apache::loncommon::start_page("$course_or_group Discussion Board",undef,
                                           {'function'       => $forcestudent,
                                            'add_entries'    => \%addentries,
                                            'domain'         => $dom,
                                            'force_register' =>
                                                $env{'form.register'}});
        $r->print($start_page);
        if ($group ne '' && $env{'form.group'} eq $group) {
            my $gpterm =  &Apache::loncommon::group_term();
            my $ucgpterm = $gpterm;
            $ucgpterm =~ s/^(\w)/uc($1)/e;
            my ($groupboards,$boards) =
                &Apache::longroup::get_group_bbinfo($dom,$crs,$group,$boardurl);
            my $boardtitle;
            if ((ref($groupboards) eq 'ARRAY') && (@{$groupboards} > 0)) {
                $boardtitle = $$boards{$$groupboards[0]}{'title'};
            }
            $boardurl .= '?register=1&amp;group='.$group;
            $r->print(&groupboard_breadcrumbs($dom,$crs,$group,$refarg,$gpterm,
                                $ucgpterm,$grp_desc,$boardurl,$boardtitle));
        }
    }
    my ($allowed);
    if ($group ne '') {
        $allowed=&Apache::lonnet::allowed('mdg',$env{'request.course.id'}.($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:''));
        if (!$allowed) {
            $allowed = &Apache::lonnet::allowed('cgb',$env{'request.course.id'}.
                                                '/'.$group);
        }
        if (!$allowed) {
            if ((!&Apache::lonnet::allowed('vcg',$env{'request.course.id'}.($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:''))) &&
               (!&Apache::lonnet::allowed('vgb',$env{'request.course.id'}.
                                                '/'.$group))) {
                 &print_end_page($r,$target);
                 return OK;
            }
        }
    } else {
        $allowed=&Apache::lonnet::allowed('mdc',$env{'request.course.id'});
    }

    my $privileged=$allowed;
    if (($syllabus{'uploaded.lastmodified'}) && (!$forceedit)) {
        $forcestudent='student';
    }
    if ($forcestudent or $target eq 'tex') { $allowed=0; }

    if ($allowed) {
        my $query_str = 'forcestudent=1';
        if (($group ne '') && ($env{'form.group'} eq $group)) {
            $query_str.='&amp;group='.$group.'&amp;'.$refarg;
        }
        if ($env{'form.register'}) {
            $query_str .= '&amp;register='.$env{'form.register'};
        }
        #Function Box for Edit Mode.
        my $functionbox = &Apache::lonhtmlcommon::start_funclist();
        $functionbox .=  &Apache::lonhtmlcommon::add_item_funclist(
                             '<a href="'.$r->uri.'?'.$query_str.'">'.&mt('Show Student View').'</a>'.
                              &Apache::loncommon::help_open_topic('Uploaded_Templates_PublicView'));
        $functionbox.=&Apache::lonhtmlcommon::end_funclist();
        $r->print(&Apache::loncommon::head_subbox($functionbox).&Apache::loncommon::help_open_topic('Uploaded_Templates_TextBoxes',&mt('Help with filling in text boxes')));
    } elsif ($privileged and $target ne 'tex') {
        my $query_str = 'forceedit=edit';
        if (($group ne '') && ($env{'form.group'} eq $group)) {
            $query_str.='&amp;group='.$group.'&amp;'.$refarg;
        }
        if ($env{'form.register'}) {
            $query_str .= '&amp;register='.$env{'form.register'};
        }
        #Functionbox for Student view.
        my $functionbox = &Apache::lonhtmlcommon::start_funclist();
        $functionbox .=  &Apache::lonhtmlcommon::add_item_funclist(
                             "<a href='".$r->uri.'?'.$query_str."'>".&mt('Edit')."</a>");
        $functionbox.=&Apache::lonhtmlcommon::end_funclist();
        $r->print(&Apache::loncommon::head_subbox($functionbox));
    }

    if (($env{'form.uploaddoc.filename'}) &&
        ($env{'form.storeupl'}) && ($allowed)) {
        if ($env{'form.uploaddoc.filename'}=~/\.(gif|jpg|png|jpeg)$/i) {
            if ($syllabus{'uploaded.photourl'}) {
                &Apache::lonnet::removeuploadedurl($syllabus{'uploaded.photourl'});
            }
            if ($group ne '') {
                $syllabus{'uploaded.photourl'}=
                    &Apache::lonnet::userfileupload('uploaddoc','coursedoc',
                                                    'bulletin/'.$group.'/'.$marker);
            } else {
                $syllabus{'uploaded.photourl'}=
                    &Apache::lonnet::userfileupload('uploaddoc','coursedoc',
                                                      'bulletin/'.$marker);
            }
        }
        $syllabus{'uploaded.lastmodified'}=time;
        &Apache::lonnet::put('bulletinpage_'.$marker,\%syllabus,$dom,$crs);
    }
    if (($allowed) && ($env{'form.storesyl'})) {
        foreach my $syl_field (keys(%syllabusfields)) {
            my $field=$env{'form.'.$syl_field};
            $field=~s/\s+$//s;
            $field=&Apache::lonfeedback::clear_out_html($field,1);
            $syllabus{$syl_field}=$field;
        }
        $syllabus{'uploaded.lastmodified'}=time;
        &Apache::lonnet::put('bulletinpage_'.$marker,\%syllabus,$dom,$crs);
    }

# ---------------------------------------------------------------- Get discussion board
    if (($syllabus{'uploaded.lastmodified'}) || ($allowed)) {
        #Print Topic as Heading
        my $titletext=&HTML::Entities::encode($syllabus{'aaa_title'},'<>&"');;
        if ($target ne 'tex') {
            $r->print('<h2>'.$titletext.'</h2>');
        } else {
            $r->print('\\\\\textbf{'.&Apache::lonxml::xmlparse($r,'tex',$titletext).'}\\\\');
        }
        #Outputbox and Inputbox for Topic
        if ($allowed) {
            $r->print('<form method="post" action="" enctype="multipart/form-data">');
            &Apache::lontemplate::print_start_template($r,&mt('Title'),'LC_Box');
            $r->print($titletext);
			$r->print("<br /><div>");
			&Apache::lontemplate::print_textarea_template($r, $syllabus{'aaa_title'},
				'aaa_title', Apache::lontemplate->RICH_TEXT_ALWAYS_OFF);
			&Apache::lontemplate::print_saveall_template($r);
			$r->print("</div>");
			&Apache::lontemplate::print_end_template($r);
        }
        if ($syllabus{'uploaded.photourl'}) {
            &Apache::lonnet::allowuploaded('/adm/syllabus',
                                           $syllabus{'uploaded.photourl'});
        }
        #Outputbox and Inputbox for Image upload
        if ($allowed) {
        	my $message = '<img src="'.$syllabus{'uploaded.photourl'}.'" alt="'.&mt('Image').'"/>';
        	&Apache::lontemplate::print_start_template($r, &mt('Upload a Photo'),'LC_Box');
            $r->print($message);
            $r->print("<br /><br />");
            $r->print(
                '<input type="hidden" name="forceedit" value="edit" />'.
                '<input type="file" name="uploaddoc" size="50" />'.
                '<input type="submit" name="storeupl" value="'.&mt('Upload').'" />'.
                '<input type="hidden" name="forceedit" value="edit" />');
            &Apache::lontemplate::print_end_template($r);
        }
        #Image in Student view.
        elsif($syllabus{'uploaded.photourl'} && $target ne 'tex'){
            $r->print('<img src="'.$syllabus{'uploaded.photourl'}.'" alt="'.&mt('Image').'"/>');
        }
        
        my %custom_handlers = ( 'aaa_title' => sub {} );
		&Apache::lontemplate::print_template_fields($r, \%syllabus, \%syllabusfields, 
			$target, $allowed, Apache::lontemplate->RICH_TEXT_DETECT_HTML, \%custom_handlers);
        if ($allowed) {
            $r->print('</form>'.
            &Apache::lonhtmlcommon::htmlareaselectactive());
        }
        if ($target ne 'tex'){
            $r->print('<br/><br/><hr/><br/>');
        }
        else {
            $r->print(&Apache::lonxml::xmlparse($r,'tex','<br/><br/><hr/><br/>'));
        }
    } else {
        if ($target ne 'tex') {
           $r->print('<p>'.&mt('No page information provided.').'</p>');
        }
    }
    #Lists discussion posts and box for a new discussion post.
    if ($target ne 'tex') {
        $r->print(&Apache::lonfeedback::list_discussion
                      ('board','OPEN','bulletin___'.$marker.'___'.
                       $r->uri,undef,$group));
    } else {
        $r->print('\\\\'.&Apache::lonxml::xmlparse($r,'tex',&Apache::lonfeedback::list_discussion
                     ('board','OPEN','bulletin___'.$marker.'___'.
                      $r->uri,undef,$group)));
    }
    &print_end_page($r,$target);
    return OK;
}

sub print_end_page {
    my ($r,$target) = @_;
    if ($target ne 'tex') {
        $r->print(&Apache::loncommon::end_page());
    } else {
        $r->print('\end{document}');
    }
}

sub groupboard_breadcrumbs {
    my ($cdom,$cnum,$group,$refarg,$gpterm,$ucgpterm,$description,$boardurl,
        $boardtitle)= @_;
    &Apache::lonhtmlcommon::clear_breadcrumbs();
    if ($refarg ne '') {
        &Apache::lonhtmlcommon::add_breadcrumb
            ({href=>"/adm/coursegroups",
              text=>"Groups",
              title=>"View course groups"});
    }
    &Apache::lonhtmlcommon::add_breadcrumb
        ({href=>"/adm/$cdom/$cnum/$group/smppg?$refarg",
          text=>"$ucgpterm: $description",
          title=>"Go to group's home page"},
         {href=>"/adm/groupboards?group=$group&amp;$refarg",
          text=>"Discussion Boards",
          title=>"Display group discussion boards"},
         {href=>"$boardurl",
          text=>"$boardtitle",
          title=>"$boardtitle"},
        );
    my $output .= &Apache::lonhtmlcommon::breadcrumbs(&mt('[_1] discussion boards - [_2]',$gpterm,$description));
    return $output;
}

1;
__END__
