# The LearningOnline Network with CAPA
# generate frame-based help system
#
# $Id: lonhelpmenu.pm,v 1.39 2009/11/10 19:13:00 jms Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonhelpmenu;

use strict;
use lib qw(/home/httpd/lib/perl);
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonlocal;
use Apache::lonnet;
use lib '/home/httpd/lib/perl/';
use LONCAPA;

sub handler {
    my ($r) = @_;
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['page','faq','bug','topic','component_help','origurl','stayonpage']);
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;

    if ($r->header_only) {
        return OK;
    }
    my $faq = $env{'form.faq'};
    my $bug = $env{'form.bug'};
    my $topic = $env{'form.topic'};
    my $component_help = $env{'form.component_help'};
    my $origurl = $env{'form.origurl'};
    my $stayOnPage = $env{'form.stayonpage'};
    my $component_url = $component_help;
    if ($component_url) {
        $component_url = '/adm/help/'.$component_url.'.hlp';
    }
    my $bugurl = $Apache::lonnet::perlvar{'BugzillaHost'};
    $bugurl .= 'enter_bug.cgi?product=LON-CAPA&bug_file_loc='.$origurl;
    if ($bug) {
        $bugurl .= '&component='.$bug;
    }
    my $faqbaseurl = $Apache::lonnet::perlvar{'FAQHost'};
    my $requestmail = $Apache::lonnet::perlvar{'lonSupportEMail'};
    if ($env{'form.page'} eq 'banner') {
        &display_help_banner($r,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail,$stayOnPage);
    } elsif ($env{'form.page'} eq 'body') {
        &display_help_mainpage($r,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail);
    }
    return OK;
}

sub display_help_banner {
    my ($r,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail,$stayOnPage) = @_;
    my $location=&Apache::loncommon::lonhttpdurl("/adm");
    my $dom = $env{'request.role.domain'};
    my %helpconfig = &Apache::lonnet::get_dom('configuration',['helpsettings'],$dom);
    my $scripttag = '';
    if ($requestmail =~ m/^[^\@]+\@[^\@]+$/) {
        my $displayurl = &escape($origurl);
        $scripttag = (<<"SCRIPT_ONE");
<script>
function gohelpdesk() {
    var actiontype = null;
    try {
        actiontype = parent.bodyframe.document.logproblem.action.value;
    }
    catch(error) {
        parent.bodyframe.location = "/adm/support?origurl=$displayurl";
        return;
    }
    if (actiontype) {
        var loc = parent.bodyframe.location.href;
        if (loc.indexOf("/adm/support") > -1) {
            if (parent.bodyframe.document.logproblem.action.value == "process") {
                if (validmail(parent.bodyframe.document.logproblem.email) == false) {
                    alert("The e-mail address you entered: "+parent.bodyframe.document.logproblem.email.value+" is not a valid e-mail address.");
                    return;
                }
                parent.bodyframe.document.logproblem.submit();
                return;
            }
        }
        parent.bodyframe.location = "/adm/support?origurl=$displayurl";
        return;
    }
}
SCRIPT_ONE
        $scripttag .= (<<'SCRIPT_TWO');
function validmail(field) {
    var str = field.value;
    if (window.RegExp) {
        var reg1str = "(@.*@)|(\\.\\.)|(@\\.)|(\\.@)|(^\\.)";
        var reg2str = "^.+\\@(\\[?)[a-zA-Z0-9\\-\\.]+\\.([a-zA-Z]{2,3}|[0-9]{1,3})(\\]?)$"; //"
        var reg1 = new RegExp(reg1str);
        var reg2 = new RegExp(reg2str);
        if (!reg1.test(str) && reg2.test(str)) {
            return true;
        }
        return false;
    }
    else
    {

        if(str.indexOf("@") >= 0) {
            return true;
        }
        return false;
    }
}
</script>
SCRIPT_TWO
    }

    my %body_layout = 
	('rightmargin'  => "0",
	 'leftmargin'   => "0",
	 'marginwidth'  => "0",
	 'topmargin'    => "1",
	 'marginheight' => "1");
    my $start_page = 
	&Apache::loncommon::start_page('',$scripttag,
				       {'add_entries' => \%body_layout,
					'only_body'   => 1,});
    $r->print($start_page);

    my $width = ($stayOnPage) ? '95%' : '600';
    $r->print('<table id="LC_helpmenu" width="'.$width.'">');

    my $general_help = &Apache::loncommon::general_help();
    $r->print(<<END);
  <tr height="50">
   <td width='5'>&nbsp;</td>
   <td>
    <fieldset><legend><img src="$location/lonIcons/minilogo.gif" height='20' width='29' valign='bottom' />&nbsp;&nbsp;LON-CAPA help/support</legend>
 <table id="LC_helpmenu_links">
   <tr>
	<td><span class="LC_nobreak"><a href="/adm/help/$general_help.hlp" target="bodyframe">
		  <img src="$location/help/help.png" border="0" alt="(General help)" valign="middle" />&nbsp;General Help</a>&nbsp;</span></td>
END
    if ($component_url) {
	$r->print("<td><span class=\"LC_nobreak\"><a href=\"$component_url\" target=\"bodyframe\">".
		  '<img src="'.$location.'/help/help.png" border="0" alt="(Topic help)" valign="middle" />&nbsp;'.$topic.'</a>&nbsp;</span></td>');
    }
    if ($requestmail =~ m/^[^\@]+\@[^\@]+$/) {
        $r->print('
            <td><span class="LC_nobreak">&nbsp;<a href="javascript:gohelpdesk()"><img src="'.$location.'/lonIcons/helpdesk.gif" border="0" alt="(Ask helpdesk)" valign="middle" />&nbsp;Ask helpdesk</a>&nbsp;</span></td>');
    }
    if ($faq && $env{'user.adv'}) {
        $r->print(<<END);
             <td><span class="LC_nobreak">&nbsp;<a href="$faqbaseurl/fom/cache/$faq.html" target="bodyframe"><img src="$location/lonMisc/smallFAQ.gif" border="0" alt="(FAQ)" valign="middle" />&nbsp;FAQ</a>&nbsp;</span>
            </td>
END
    }
    if ($env{'user.adv'}) {
    	if ($helpconfig{'helpsettings'}{'submitbugs'} eq '1' ||
    		$helpconfig{'helpsettings'}{'submitbugs'} eq '' ) {
        	$r->print(<<END);
            	<td><span class="LC_nobreak"&nbsp;<b><a href="$bugurl" target="bodyframe"><img src="$location/lonMisc/smallBug.gif" border="0" alt="(Report a bug)" valign="middle" />&nbsp;Report a bug</a>&nbsp;</b></span></td>
END
		}
    }
    if ($stayOnPage) {
        $r->print(<<END);
            <td><span class="LC_nobreak">&nbsp;<a href="$origurl" target="_top"><img src="$location/lonIcons/move_up.gif" border="0" alt="(Return to last location)" valign="middle" />&nbsp;Return to last location</a>&nbsp;</span></td>
END
    } else {
        $r->print(<<END);
            <td><span class="LC_nobreak"&nbsp;<a href="javascript:window.close()" target="_top"><img src="$location/lonIcons/closepage.gif" border="0" alt="(Close window)" valign="bottom" />&nbsp;Close</a>&nbsp;</span></td>
END
    }
    $r->print(<<END);
  </tr>
 </table>
</fieldset>
  </td>
  <td width='100%'>&nbsp;</td>
 </tr>
 <tr height='5'>
  <td colspan='3' height='5'>&nbsp;</td>
 </tr>
</table>
END
    $r->print(&Apache::loncommon::end_page());
}

sub display_help_mainpage {
    my ($r,$faq,$bug,$topic,$component_url,$origurl,$bugurl,$faqbaseurl,$requestmail) = @_;

    my %lt =&Apache::lonlocal::texthash(
        'topp' => 'Topic Page',
        'chen' => 'Choose an entry below to go directly to a relevant help page',
        'orto' => 'or to submit a help request to the LON-CAPA support staff at your institution.',
        'vthp' => 'Visit the help page for ',
        'disp' => 'Display the page in the inline help system that covers this topic.',
        'crac' => 'Create an account for yourself in the LON-CAPA Bugzilla tracking system, if you wish to report bugs you have encountered in the LON-CAPA software, or if you have suggestions for improvements in LON-CAPA.',
        'inhs' => 'Topical help system for',
        'cont' => 'Contact the LON-CAPA support team',
        'suhr' => 'Submit a help request to the team responsible for LON-CAPA support at this institution.',
        'stuq' => 'Questions about course content should not be directed to the support team, but instead should be sent to the course instructor',
        'faqo' => 'FAQ-O-Matic Help system',
        'tfaq' => 'The FAQ-O-Matic is a compendium of answers provided to common questions asked by users of LON-CAPA over the past couple of years.',
        'lbug' => 'LON-CAPA Bugzilla bug/feature request tracking system',
        'crea' => 'Create an account for yourself in the LON-CAPA Bugzilla tracking system, if you wish to report bugs you have encountered in the LON-CAPA software,or if you have suggestions for improvements in LON-CAPA.',
        'suim' => ' Suggested improvements may include additional functionality, improved usability, or changes to wording used in LON-CAPA pages, including the embedded help system.'
    );

    my %body_layout = 
	('topmargin'    => "0",
	 'marginheight' => "0");
    my $start_page =
	&Apache::loncommon::start_page('Help Content',undef,
				       {'add_entries' => \%body_layout,
					'only_body'   => 1,});
    $r->print($start_page);
    $r->print('<b>'.$lt{'chen'});
    if ($requestmail =~ m/^[^\@]+\@[^\@]+$/) {
        $r->print(', '.$lt{'orto'});
    } else {
        $r->print(".");
    }
    $r->print('</b>');
    if ($topic) {
        if ( ($component_url) || ($env{'user.adv'}) ) {
            if ($component_url) {
                $r->print("
          <ul>
           <li><a href=\"$component_url\">$lt{'vthp'} $topic</a></li>
          </ul>
          <p>$lt{'disp'}</p>
                ");
            }
        }
    }
    if ($requestmail =~ m/^[^\@]+\@[^\@]+$/) {
        $r->print("
          <ul>
           <li><a href=\"/adm/support?origurl=".&escape($origurl)."\">$lt{'cont'}</a></li>
          </ul>
          <p>$lt{'suhr'}");
         unless ($env{'user.adv'}) {
             $r->print('<br /><b>'.&mt('Note').'</b>: '.$lt{'stuq'}.'. '.&mt('This can be done using the').' <a href="/adm/communicate" target="_top">'.&mt('COM').'</a> '.&mt('button, or the FDBK button when viewing a content page.'));
         }
         $r->print("</p>");
    }
    if ($faqbaseurl && $env{'user.adv'}) {
        if (!defined($faq) ||$faq eq '') {
            $faq = '1';
        }
        $r->print("
          <ul>
           <li><a href=\"$faqbaseurl/fom/cache/$faq.html\">$lt{'faqo'}</a></li>
          </ul>
          <p>$lt{'tfaq'}</p>
        ");
    }
    if ($bugurl && $env{'user.adv'}) {
        $bugurl .= '?'.$bug;
        $r->print("
          <ul>
           <li><a href=\"$bugurl\">$lt{'lbug'}</a></li>
          </ul>
          <p>$lt{'crea'} $lt{'suim'}</p>
        ");
    }
    $r->print(&Apache::loncommon::end_page());
}

1;
