# The LearningOnline Network
# Preferences
#
# $Id: lonpreferences.pm,v 1.186.2.4 2010/08/15 00:10:08 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# This package uses the "londes.js" javascript code. 
#
# TODOs that have to be completed:
#    interface with lonnet to change the password
 
package Apache::lonpreferences;

use strict;
use LONCAPA;
use Apache::Constants qw(:common);
use Apache::File;
use Crypt::DES;
use DynaLoader; # for Crypt::DES version
use Apache::loncommon();
use Apache::lonhtmlcommon();
use Apache::lonlocal;
use Apache::lonnet;
use LONCAPA::lonauthcgi();
use LONCAPA();

#
# Write lonnet::passwd to do the call below.
# Use:
#   my $answer=reply("encrypt:passwd:$udom:$uname:$upass",$tryserver);
#
##################################################
#          password associated functions         #
##################################################
sub des_keys {
    # Make a new key for DES encryption.
    # Each key has two parts which are returned separately.
    # Please note:  Each key must be passed through the &hex function
    # before it is output to the web browser.  The hex versions cannot
    # be used to decrypt.
    my @hexstr=('0','1','2','3','4','5','6','7',
                '8','9','a','b','c','d','e','f');
    my $lkey='';
    for (0..7) {
        $lkey.=$hexstr[rand(15)];
    }
    my $ukey='';
    for (0..7) {
        $ukey.=$hexstr[rand(15)];
    }
    return ($lkey,$ukey);
}

sub des_decrypt {
    my ($key,$cyphertext) = @_;
    my $keybin=pack("H16",$key);
    my $cypher;
    if ($Crypt::DES::VERSION>=2.03) {
        $cypher=new Crypt::DES $keybin;
    } else {
        $cypher=new DES $keybin;
    }
    my $plaintext=
	$cypher->decrypt(unpack("a8",pack("H16",substr($cyphertext,0,16))));
    $plaintext.=
	$cypher->decrypt(unpack("a8",pack("H16",substr($cyphertext,16,16))));
    $plaintext=substr($plaintext,1,ord(substr($plaintext,0,1)) );
    return $plaintext;
}

################################################################
#                       Handler subroutines                    #
################################################################

################################################################
#         Language Change Subroutines                          #
################################################################

sub wysiwygchanger {
    my $r = shift;
    Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changewysiwyg',
                text => 'Change WYSIWYG Preferences'});
    $r->print(Apache::loncommon::start_page('Content Display Settings'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Change WYSIWYG Preferences'));

    my %userenv = &Apache::lonnet::get
        ('environment',['wysiwygeditor']);
    my $onselect='checked="checked"';
    my $offselect='';
    if ($userenv{'wysiwygeditor'} eq 'on') {
	$onselect='';
	$offselect='checked="checked"';
    }
    my $switchoff=&mt('Disable WYSIWYG editor');
    my $switchon=&mt('Enable WYSIWYG editor');
    my $warning='';
    if ($env{'user.adv'}) {
       $warning.='<p class="LC_warning">'.&mt("The WYSIWYG editor only supports simple HTML and is in many cases unsuited for advanced authoring. In a number of cases, it may destroy advanced authoring involving LaTeX and script function calls.")."</p>";
    }
    $r->print(<<ENDLSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="set_wysiwyg" />
$warning
<br />
<label><input type="radio" name="wysiwyg" value="off" $onselect /> $switchoff</label><br />
<label><input type="radio" name="wysiwyg" value="on" $offselect /> $switchon</label>
ENDLSCREEN
    $r->print('<br /><input type="submit" value="'.&mt('Save').'" />');
}


sub verify_and_change_wysiwyg {
    my $r = shift;
    my $newsetting=$env{'form.wysiwyg'};
    &Apache::lonnet::put('environment',{'wysiwygeditor' => $newsetting});
    &Apache::lonnet::appenv({'environment.wysiwygeditor' => $newsetting});
    my $message=&Apache::lonhtmlcommon::confirm_success(&mt('Set [_1] to [_2]','<i>'.&mt('WYSIWYG Editor').'</i>','<tt>'.&mt($newsetting).'</tt>'));
    $message=&Apache::loncommon::confirmwrapper($message);
    &print_main_menu($r,$message);
}

################################################################
#         Language Change Subroutines                          #
################################################################
sub languagechanger {
    my $r = shift;
    
    Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changelanguages',
                text => 'Change Language'});
    $r->print(Apache::loncommon::start_page('Content Display Settings'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Change Language')); 
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['languages']);
    my $language=$userenv{'languages'};

    my $pref=&mt('Preferred language');
    my %langchoices=('' => 'No language preference');
    foreach (&Apache::loncommon::languageids()) {
	if (&Apache::loncommon::supportedlanguagecode($_)) {
	    $langchoices{&Apache::loncommon::supportedlanguagecode($_)}
	               = &Apache::loncommon::plainlanguagedescription($_);
	}
    }
    %langchoices = &Apache::lonlocal::texthash(%langchoices);
    my $selectionbox=
           &Apache::loncommon::select_form(
               $language,
               'language',
               \%langchoices);
    $r->print(<<ENDLSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_languages" />
<br />$pref: $selectionbox
ENDLSCREEN
    $r->print('<br /><input type="submit" value="'.&mt('Save').'" />');
}


sub verify_and_change_languages {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
# Screenname
    my $newlanguage  = $env{'form.language'};
    $newlanguage=~s/[^\-\w]//g;
    my $message='';
    if ($newlanguage) {
        &Apache::lonnet::put('environment',{'languages' => $newlanguage});
        &Apache::lonnet::appenv({'environment.languages' => $newlanguage});
        $message=&Apache::lonhtmlcommon::confirm_success(
            &mt('Set [_1] to [_2]',
                '<i>'.&mt('Preferred language').'</i>',
                '<tt>"'.$newlanguage.'"</tt>.'))
           .'<br />'
           .&mt('The change will become active on the next page.');
    } else {
        &Apache::lonnet::del('environment',['languages']);
        &Apache::lonnet::delenv('environment.languages');
        $message=&Apache::lonhtmlcommon::confirm_success(&mt('Reset [_1]','<i>'.&mt('Preferred language').'</i>'));
    }
    $message=&Apache::loncommon::confirmwrapper($message);
    &Apache::loncommon::flush_langs_cache($user,$domain);
    &print_main_menu($r, $message);
}

################################################################
#         Tex Engine Change Subroutines                        #
################################################################
sub texenginechanger {
    my $r = shift;
    Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changetexenginepref',
                text => 'Math display settings'});
    $r->print(Apache::loncommon::start_page('Content Display Settings'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Math display settings'));
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get('environment',['texengine']);
    my $texengine=$userenv{'texengine'};

    my %mathchoices=('' => 'Default',
		     'tth' => 'tth (TeX to HTML)',
		     #'ttm' => 'TeX to MathML',
		     'jsMath' => 'jsMath',
		     'mimetex' => 'mimetex (Convert to Images)',
                     'raw' => 'Raw (Screen Reader)'
                     );
    %mathchoices = &Apache::lonlocal::texthash(%mathchoices);
    my $selectionbox=
           &Apache::loncommon::select_form(
               $texengine,
               'texengine',
               \%mathchoices);
    my $jsMath_start=&Apache::lontexconvert::jsMath_header();
    my %lt=&Apache::lonlocal::texthash(
      'headline' => 'Change how math is displayed',
      'preftxt'  => 'Preferred method to display math',
      'change'   => 'Save',
      'exmpl'    => 'Examples',
      'jsmath'   => 'jsMath:',
      'tth'      => 'tth (TeX to HTML):',
      'mimetex'  => 'mimetex (Convert to Images):',
    );

    my $jsMathWarning='<p>'
                     .'<div class="LC_warning">'
                     .&mt("It looks like you don't have the TeX math fonts installed.")
                     .'</div>'
                     .'<div>'
                     .&mt('The jsMath example on this page may not look right without them. '
                         .'The [_1]jsMath Home Page[_2] has information on how to download the '
                         .'needed fonts. In the meantime, jsMath will do the best it can '
                         .'with the fonts you have, but it may not be pretty and some equations '
                         .'may not be rendered correctly.'
                         ,'<a href="http://www.math.union.edu/locate/jsMath/" target="_blank">'
                         ,'</a>')
                     .'</div>'
                     .'</p>';

    $r->print(<<ENDLSCREEN);
<h2>$lt{'headline'}</h2>
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_texengine" />
<p>
$lt{'preftxt'}: $selectionbox 
<br />
<input type="submit" value="$lt{'change'}" />
</p>
</form>
<br />
<hr />
$lt{'exmpl'}

<h3>$lt{'jsmath'}</h3> 
<p>
$jsMath_start
<script type="text/javascript" language="JavaScript">
if (jsMath.nofonts == 1) {
    document.writeln($jsMathWarning);
}
</script>
<iframe src="/res/adm/pages/math_example.tex?inhibitmenu=yes&texengine=jsMath" width="400" height="120"></iframe>
</p>

<h3>$lt{'mimetex'}</h3>
<p>
<iframe src="/res/adm/pages/math_example.tex?inhibitmenu=yes&texengine=mimetex" width="400" height="100"></iframe>
</p>

<h3>$lt{'tth'}</h3>
<p>
<iframe src="/res/adm/pages/math_example.tex?inhibitmenu=yes&texengine=tth" width="400" height="220"></iframe>
</p>
ENDLSCREEN
    if ($env{'environment.texengine'} ne 'jsMath') {
	$r->print('<script type="text/javascript" language="JavaScript">jsMath.Process()</script>');
    }
}


sub verify_and_change_texengine {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
# Screenname
    my $newtexengine  = $env{'form.texengine'};
    $newtexengine=~s/[^\-\w]//g;
    if ($newtexengine eq 'ttm') {
	&Apache::lonnet::appenv({'browser.mathml' => 1});
    } else {
	if ($env{'environment.texengine'} eq 'ttm') {
	    &Apache::lonnet::appenv({'browser.mathml' => 0});
	}
    }
    my $message='';
    if ($newtexengine) {
        &Apache::lonnet::put('environment',{'texengine' => $newtexengine});
        &Apache::lonnet::appenv({'environment.texengine' => $newtexengine});
        $message=&Apache::lonhtmlcommon::confirm_success(&mt('Set [_1] to [_2]','<i>'.&mt('Preferred method to display Math').'</i>','<tt>"'.$newtexengine.'"</tt>'));
    } else {
        &Apache::lonnet::del('environment',['texengine']);
        &Apache::lonnet::delenv('environment.texengine');
        $message=&Apache::lonhtmlcommon::confirm_success(&mt('Reset [_1]','<i>'.&mt('Preferred method to display Math').'</i>'));
    }
    $message=&Apache::loncommon::confirmwrapper($message);
    &print_main_menu($r, $message);
}

################################################################
#         Roles Page Preference Change Subroutines         #
################################################################
sub rolesprefchanger {
    my $r = shift;
    my $role    = ($env{'user.adv'} ? 'Role' : 'Course');
    my $lc_role = ($env{'user.adv'} ? 'role' : 'course');
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['recentroles','recentrolesn']);
    Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changerolespref',
                text => 'Change '.$role.' Page Pref'});
    $r->print(Apache::loncommon::start_page('Content Display Settings'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Change '.$role.' Page Pref'));
    my $hotlist_flag=$userenv{'recentroles'};
    my $hotlist_n=$userenv{'recentrolesn'};
    my $checked;
    if ($hotlist_flag) {
	$checked = 'checked="checked"';
    }
    
    if (!$hotlist_n) { $hotlist_n=3; }
    my $options;
    for (my $i=1; $i<10; $i++) {
	my $select;
	if ($hotlist_n == $i) { $select = 'selected="selected"'; }
	$options .= "<option $select>$i</option>\n";
    }

# Get list of recent roles and display with checkbox in front
    my $roles_check_list = '';
    my $role_key='';
    if ($env{'environment.recentroles'}) {
        my %recent_roles =
               &Apache::lonhtmlcommon::get_recent('roles',$env{'environment.recentrolesn'});
        my %frozen_roles =
               &Apache::lonhtmlcommon::get_recent_frozen('roles',$env{'environment.recentrolesn'});
        
        my %role_text = &rolespref_get_role_text([keys(%recent_roles)]);
        my @sorted_roles = sort {$role_text{$a} cmp $role_text{$b}} keys(%role_text);

        $roles_check_list .=
	    &Apache::loncommon::start_data_table().
	    &Apache::loncommon::start_data_table_header_row().
	    "<th>".&mt('Freeze '.$role)."</th>".
	    "<th>".&mt($role)."</td>".
	    &Apache::loncommon::end_data_table_header_row().
	    "\n";
	my $count;
        foreach $role_key (@sorted_roles) {
            my $checked = "";
            my $value = $recent_roles{$role_key};
            if ($frozen_roles{$role_key}) {
                $checked = ' checked="checked"';
            }
	    $count++;
            $roles_check_list .=
		&Apache::loncommon::start_data_table_row().
		'<td class="LC_table_cell_checkbox">'.
		"<input type=\"checkbox\"$checked name=\"freezeroles\"".
		" id=\"freezeroles$count\" value=\"$role_key\" /></td>".
		"<td><label for=\"freezeroles$count\">".
		"$role_text{$role_key}</label></td>".
		&Apache::loncommon::end_data_table_row(). "\n";
        }
        $roles_check_list .= "</table>\n";
    }

    $r->print('
<p>'.&mt('Some LON-CAPA users have a long list of '.$lc_role.'s. The Recent '.$role.'s Hotlist feature keeps track of the last N '.$lc_role.'s which have been visited and places a table of these at the top of the '.$lc_role.'s page. People with very few '.$lc_role.'s should leave this feature disabled.').'
</p>
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_rolespref" />
<br />'.
'<h2>'.&mt('Recent '.$role.'s Hotlist').'</h2>'.
&Apache::lonhtmlcommon::start_pick_box().
&Apache::lonhtmlcommon::row_title('<label for="Hotlist">'.&mt('Enable Recent '.$role.'s Hotlist').'</label>').
'<input id="Hotlist" type="checkbox"'.$checked.' name="recentroles" value="true" />'.
&Apache::lonhtmlcommon::row_closure().
&Apache::lonhtmlcommon::row_title('<label for="NumberOfRoles">'.&mt('Number of '.$role.'s in Hotlist').'</label>').
'<select name="recentrolesn" size="1" id ="NumberOfRoles">'.
$options.
'</select>'.
&Apache::lonhtmlcommon::row_closure(1).
&Apache::lonhtmlcommon::end_pick_box().
'<br/><h2>'.&mt('Freeze Roles').'</h2>'.
'<p>'.&mt('This list below can be used to <q>freeze</q> '.$lc_role.'s on your screen. Those marked as frozen will not be removed from the list, even if they have not been used recently.').'
</p>
'.$roles_check_list.'
<br />
<input type="submit" value="'.&mt('Save').'" />
</form>');
}

sub rolespref_get_role_text {
# Get a line of text for each role
    my ($roles) = @_;
    my %roletext = ();

    foreach my $item (@$roles) {
# get course information
        my ($role,$rest) = split(/\./, $item);
        my $trole = "";
        $trole = &Apache::lonnet::plaintext($role);
        my ($tdomain,$other,$tsection)= split(/\//,Apache::lonnet::declutter($rest));
        my $tother = '-';
        if ($role =~ /^(cc|st|in|ta|ep|cr)/ ) {
            my %newhash=&Apache::lonnet::coursedescription($tdomain."_".$other);
            $tother = " - ".$newhash{'description'};
        } elsif ($role =~ /dc/) {
            $tother = "";
        } else {
            $tother = " - $other";
        }
 
        my $section="";
        if ($tsection) {
            $section = " - Section/Group: $tsection";
        }
        $roletext{$item} = $tdomain." - ".$trole.$tother.$section;
    }
    return %roletext;
}

sub verify_and_change_rolespref {
    my $r = shift;
    my $role = ($env{'user.adv'} ? 'Role' : 'Course');
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
# Recent Roles Hotlist Flag
    my $hotlist_flag  = $env{'form.recentroles'};
    my $hotlist_n  = $env{'form.recentrolesn'};
    my $message='<hr />';
    if ($hotlist_flag) {
        &Apache::lonnet::put('environment',{'recentroles' => $hotlist_flag});
        &Apache::lonnet::appenv({'environment.recentroles' => $hotlist_flag});
        $message=&Apache::lonhtmlcommon::confirm_success(&mt('Recent '.$role.'s Hotlist is Enabled.')." ".&mt('Display [_1] Most Recent '.$role.'s.',$hotlist_n));
    } else {
        &Apache::lonnet::del('environment',['recentroles']);
        &Apache::lonnet::delenv('environment.recentroles');
        $message=&Apache::lonhtmlcommon::confirm_success(&mt('Recent '.$role.'s Hotlist is Disabled'));
    }
    if ($hotlist_n) {
        &Apache::lonnet::put('environment',{'recentrolesn' => $hotlist_n});
        &Apache::lonnet::appenv({'environment.recentrolesn' => $hotlist_n});
    }

# Get list of froze roles and list of recent roles
    my @freeze_list = &Apache::loncommon::get_env_multiple('form.freezeroles');
    my %freeze = ();
    my %roletext = ();

    foreach my $key (@freeze_list) {
        $freeze{$key}='1';
    }

    my %recent_roles =
        &Apache::lonhtmlcommon::get_recent('roles',$env{'environment.recentrolesn'});
    my %frozen_roles =
        &Apache::lonhtmlcommon::get_recent_frozen('roles',$env{'environment.recentrolesn'});
    my %role_text = &rolespref_get_role_text([keys(%recent_roles)]);

# Unset any roles that were previously frozen but aren't in list
    foreach my $role_key (sort(keys(%recent_roles))) {
        if (($frozen_roles{$role_key}) && (!exists($freeze{$role_key}))) {
	    $message .= "<br />".&Apache::lonhtmlcommon::confirm_success(&mt('Unfreezing '.$role.': [_1]','<i>'.$role_text{$role_key}.'</i>'));
	    &Apache::lonhtmlcommon::store_recent('roles',$role_key,' ',0);
        }
    }

# Freeze selected roles
    foreach my $role_key (@freeze_list) {
        if (!$frozen_roles{$role_key}) {
             $message .= "<br />".
             &Apache::lonhtmlcommon::confirm_success(&mt('Freezing '.$role.': [_1]','<i>'.$role_text{$role_key}.'</i>'));
             &Apache::lonhtmlcommon::store_recent('roles',
                                          $role_key,' ',1);
        }
    }
    $message=&Apache::loncommon::confirmwrapper($message);
    &print_main_menu($r, $message);
}



################################################################
#         Anonymous Discussion Name Change Subroutines         #
################################################################
sub screennamechanger {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['screenname','nickname']);
    my $screenname=$userenv{'screenname'};
    my $nickname=$userenv{'nickname'};
    Apache::lonhtmlcommon::add_breadcrumb(
		{ href => '/adm/preferences?action=changescreenname',
                  text => 'Change Screen Name'});
    $r->print(Apache::loncommon::start_page('Personal Data'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Change Screen Name'));
    $r->print('<p>'
             .&mt('Change the name that is displayed in your posts.')
             .'</p>'
    );
    $r->print('<form name="prefs" action="/adm/preferences" method="post">'
             .'<input type="hidden" name="action" value="verify_and_change_screenname" />'
             .&Apache::lonhtmlcommon::start_pick_box()
             .&Apache::lonhtmlcommon::row_title(&mt('Screenname').' '.&mt('(shown if you post anonymously)'))
             .'<input type="text" size="20" value="'.$screenname.'" name="screenname" />'
             .&Apache::lonhtmlcommon::row_closure()
             .&Apache::lonhtmlcommon::row_title(&mt('Nickname').' '.&mt('(shown if you post non-anonymously)'))
             .'<input type="text" size="20" value="'.$nickname.'" name="nickname" />'
             .&Apache::lonhtmlcommon::row_closure()
             .&Apache::lonhtmlcommon::row_title()
             .'<input type="submit" value="'.&mt('Save').'" />'
             .&Apache::lonhtmlcommon::row_closure(1)
             .&Apache::lonhtmlcommon::end_pick_box()
             .'</form>'
    );
}

sub verify_and_change_screenname {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
# Screenname
    my $newscreen  = $env{'form.screenname'};
    $newscreen=~s/[^ \w]//g;
    my $message='';
    if ($newscreen) {
        &Apache::lonnet::put('environment',{'screenname' => $newscreen});
        &Apache::lonnet::appenv({'environment.screenname' => $newscreen});
        $message=&Apache::lonhtmlcommon::confirm_success(&mt('Set [_1] to [_2]','<i>'.&mt('Screenname').'</i>','<tt>"'.$newscreen.'"</tt>'));
    } else {
        &Apache::lonnet::del('environment',['screenname']);
        &Apache::lonnet::delenv('environment.screenname');
        $message=&Apache::lonhtmlcommon::confirm_success(&mt('Reset [_1]','<i>'.&mt('Screenname').'</i>'));
    }
# Nickname
    $message.='<br />';
    $newscreen  = $env{'form.nickname'};
    $newscreen=~s/[^ \w]//g;
    if ($newscreen) {
        &Apache::lonnet::put('environment',{'nickname' => $newscreen});
        &Apache::lonnet::appenv({'environment.nickname' => $newscreen});
        $message.=&Apache::lonhtmlcommon::confirm_success(&mt('Set [_1] to [_2]','<i>'.&mt('Nickname').'</i>','<tt>"'.$newscreen.'"</tt>'));
    } else {
        &Apache::lonnet::del('environment',['nickname']);
        &Apache::lonnet::delenv('environment.nickname');
        $message.=&Apache::lonhtmlcommon::confirm_success(&mt('Reset [_1]','<i>'.&mt('Nickname').'</i>'));
    }
    &Apache::lonnet::devalidate_cache_new('namescache',$user.':'.$domain);
    $message=&Apache::loncommon::confirmwrapper($message);
    &print_main_menu($r, $message);
}

################################################################
#                     Clicker Subroutines                      #
################################################################

sub clickerchanger {
    my $r = shift;
    &Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changeclicker',
                text => 'Register Clicker'});
    $r->print(Apache::loncommon::start_page('Other'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Register Clicker'));
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['clickers']);
    my $clickers=$userenv{'clickers'};
    $clickers=~s/\,/\n/gs;
    my $text=&mt('Enter response device ("clicker") numbers');
    my $change=&mt('Save');
    my $helplink=&Apache::loncommon::help_open_topic('Clicker_Registration',&mt('Locating your clicker ID'));
    $r->print(<<ENDSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_clicker" />
<label>$helplink<br /><br />$text<br />
<textarea name="clickers" rows="5" cols="20">$clickers</textarea>
</label>
<br />
<input type="submit" value="$change" />
</form>
ENDSCREEN
}

sub verify_and_change_clicker {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my $newclickers  = $env{'form.clickers'};
    $newclickers=~s/[^\w\:\-]+/\,/gs;
    $newclickers=~tr/a-z/A-Z/;
    $newclickers=~s/[\:\-]+/\-/g;
    $newclickers=~s/\,+/\,/g;
    $newclickers=~s/^\,//;
    $newclickers=~s/\,$//;
    &Apache::lonnet::put('environment',{'clickers' => $newclickers});
    &Apache::lonnet::appenv({'environment.clickers' => $newclickers});
    my $message=&Apache::lonhtmlcommon::confirm_success(&mt('Registering clickers: [_1]',$newclickers));
    $message=&Apache::loncommon::confirmwrapper($message);
    &print_main_menu($r, $message);
}

################################################################
#               Domcoord Access Subroutines                    #
################################################################

sub domcoordchanger {
    my $r = shift;
    &Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changedomcoord',
                text => 'Restrict Domain Coordinator Access'});
    $r->print(Apache::loncommon::start_page('Restrict Domain Coordinator Access'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Restrict Domain Coordinator Access'));
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['domcoord.author']);
    my $constchecked='';
    if ($userenv{'domcoord.author'} eq 'blocked') {
       $constchecked=' checked="checked"';
    }
    my $text=&mt('By default, the Domain Coordinator can enter your construction space.');
    my $construction=&mt('Block access to construction space');
    my $change=&mt('Save');
    $r->print(<<ENDSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_domcoord" />
$text<br />
<label><input type="checkbox" name="construction"$constchecked />$construction</label><br />
<input type="submit" value="$change" />
</form>
ENDSCREEN
}

sub verify_and_change_domcoord {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %domcoord=('domcoord.author' => '');
    if ($env{'form.construction'}) { $domcoord{'domcoord.author'}='blocked'; }
    &Apache::lonnet::put('environment',\%domcoord);
    &Apache::lonnet::appenv({'environment.domcoord.author' => $domcoord{'domcoord.author'}});
    my $status='';
    if ($domcoord{'domcoord.author'} eq 'blocked') {
        $status=&mt('on');
    } else {
        $status=&mt('off');
    }
    my $message=&Apache::lonhtmlcommon::confirm_success(&mt('Set [_1] to [_2]','<i>'.&mt('Block access to construction space').'</i>','<tt>'.$status.'</tt>'));
    $message=&Apache::loncommon::confirmwrapper($message);
    &print_main_menu($r,$message);
}

#################################################################
##                      Lock Subroutines                        #
#################################################################

sub lockwarning {
    my $r = shift;
    my $title=&mt('Action locked');
    my $texttop=&mt('LON-CAPA is currently performing the following actions:');
    my $textbottom=&mt('Changing roles or logging out may result in data corruption.');
    my ($num,%which)=&Apache::lonnet::get_locks();
    my $which='';
    foreach my $id (keys %which) {
       $which.='<li>'.$which{$id}.'</li>';
    }
    my $change=&mt('Override');
    $r->print(<<ENDSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_locks" />
<h1>$title</h1>
$texttop
<ul>
$which
</ul>
$textbottom
<input type="submit" value="$change" />
</form>
ENDSCREEN
}

sub verify_and_change_lockwarning {
    my $r = shift;
    &Apache::lonnet::remove_all_locks();
    $r->print(&mt('Cleared locks.'));
}


################################################################
#         Message Forward                                      #
################################################################

sub msgforwardchanger {
    my ($r,$message) = @_;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get('environment',['msgforward','notification','critnotification','notifywithhtml']);
    my $msgforward=$userenv{'msgforward'};
    my %lt = &Apache::lonlocal::texthash(
                                          all   => 'All',
                                          crit  => 'Critical only',
                                          reg   => 'Non-critical only',
                                          foad  => 'Forward to account(s)',
                                          fwdm  => 'Forward messages to other account(s) in LON-CAPA',
                                          noti  => 'E-mail notification of LON-CAPA messages',
                                          foad_exmpl => 'e.g. <tt>userA:domain1,userB:domain2,...</tt>',
                                          mnot  => 'E-mail address(es) which should be notified about new LON-CAPA messages',
                                          mnot_exmpl => 'e.g. <tt>joe@doe.com</tt>',
                                          chg   => 'Save',
                                          email => 'The e-mail address entered in row ',
                                          notv => 'is not a valid e-mail address',
                                          toen => "To enter multiple addresses, enter one address at a time, click 'Change' and then add the next one", 
                                          prme => 'Back',
                                        );
    Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changemsgforward',
		text => 'Messages & Notifications'});
    $r->print(Apache::loncommon::start_page('Messages &amp; Notifications'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Messages &amp; Notifications'));
    my $forwardingHelp = &Apache::loncommon::help_open_topic("Prefs_Forwarding");
    my $notificationHelp = &Apache::loncommon::help_open_topic("Prefs_Notification");
    my $criticalMessageHelp = &Apache::loncommon::help_open_topic("Course_Critical_Message");
    my @allow_html = split(/,/,$userenv{'notifywithhtml'});
    my %allnot = &get_notifications(\%userenv);
    my $validatescript = &Apache::lonhtmlcommon::javascript_valid_email();
    my $jscript = qq|
<script type="text/javascript" language="JavaScript">
function validate() {
    for (var i=0; i<document.prefs.numnotify.value; i++) {
        var checkaddress = 0;
        var addr = document.prefs.elements['address_'+i].value;
        var rownum = i+1;
        if (i < document.prefs.numnotify.value-1) {
            if (document.prefs.elements['modify_notify_'+i].checked) {
                checkaddress = 1;
            }
        } else {
            if (document.prefs.elements['add_notify_'+i].checked == true) { 
                checkaddress = 1;
            }
        }
        if (checkaddress == 1)  {
            var addr = document.prefs.elements['address_'+i].value;
            if (validmail(document.prefs.elements['address_'+i]) == false) {
                var multimsg = '';
                if (addr.indexOf(",") >= 0) {
                    multimsg = "\\n($lt{'toen'}).";
                }
                alert("$lt{'email'} "+rownum+" ('"+addr+"') $lt{'notv'}."+multimsg);
                return;
            }
        }
    }
    document.prefs.submit();
}

function address_changes (adnum) {
     if (!document.prefs.elements['del_notify_'+adnum].checked) { 
         document.prefs.elements['modify_notify_'+adnum].checked = true;
     }   
}

function new_address(adnum) {
     document.prefs.elements['add_notify_'+adnum].checked = true;
}

function delete_address(adnum) {
     if (document.prefs.elements['del_notify_'+adnum].checked) {
          document.prefs.elements['modify_notify_'+adnum].checked = false;
     }
}

function modify_address(adnum) {
    if (document.prefs.elements['modify_notify_'+adnum].checked) {
        document.prefs.elements['del_notify_'+adnum].checked = false;
    }
} 

$validatescript
</script>
|;
    $r->print(<<ENDMSG);
$jscript
$message
<h3>$lt{'fwdm'} $forwardingHelp</h3>
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_msgforward" />
$lt{'foad'} ($lt{'foad_exmpl'}):
<input type="text" size="40" value="$msgforward" name="msgforward" />
<br /><br />
<h3>$lt{'noti'} $notificationHelp</h3>
$lt{'mnot'} ($lt{'mnot_exmpl'}):<br />
ENDMSG
    my @sortforwards = sort (keys(%allnot));
    my $output = &Apache::loncommon::start_data_table().
                 &Apache::loncommon::start_data_table_header_row().
                 '<th>&nbsp;</th>'.
                 '<th>'.&mt('Action').'</th>'.
                 '<th>'.&mt('Notification address').'</th><th>'.
                 &mt('Types of message for which notification is sent').
                 $criticalMessageHelp.'</th><th>'.
                 &mt('Excerpt retains HTML tags in message').'</th>'.
                 &Apache::loncommon::end_data_table_header_row();
    my $num = 0;
    my $counter = 1;
    foreach my $item (@sortforwards) {
        $output .= &Apache::loncommon::start_data_table_row().
                   '<td><b>'.$counter.'</b></td>'.
                   '<td><span class="LC_nobreak"><label>'.
                   '<input type="checkbox" name="modify_notify_'.
                   $num.'" onclick="javscript:modify_address('."'$num'".')" />'.
                   &mt('Modify').'</label></span>&nbsp;&nbsp; '.
                   '<span class="LC_nobreak"><label>'.
                   '<input type="checkbox" name="del_notify_'.$num.
                   '" onclick="javscript:delete_address('."'$num'".')" />'.
                   &mt('Delete').'</label></span></td>'.
                   '<td><input type="text" value="'.$item.'" name="address_'.
                   $num.'" onFocus="javascript:address_changes('."'$num'".
                   ')" /></td><td>';
        my %chk;
        if (defined($allnot{$item}{'crit'})) {
            if (defined($allnot{$item}{'reg'})) {
                $chk{'all'} = 'checked="checked" ';
            } else {
                $chk{'crit'} = 'checked="checked" ';
            }
        } else {
            $chk{'reg'} = 'checked="checked" ';
        }
        foreach my $type ('all','crit','reg') {
            $output .= '<span class="LC_nobreak"><label>'.
                       '<input type="radio" name="notify_type_'.$num. 
                       '" value="'.$type.'" '.$chk{$type}.
                       ' onchange="javascript:address_changes('."'$num'".')" />'.
                       $lt{$type}.'</label></span>'.('&nbsp;' x4);
        }
        my $htmlon = '';
        my $htmloff = '';
        if (grep/^\Q$item\E/,@allow_html) {
            $htmlon = 'checked="checked" '; 
        } else {
            $htmloff = 'checked="checked" ';
        }
        $output .= '</td><td><label><input type="radio" name="html_'.$num.
                   '" value="1" '.$htmlon.
                   ' onchange="javascript:address_changes('."'$num'".')" />'.
                   &mt('Yes').'</label>'.('&nbsp;' x3).
                   '<label><input type="radio" name="html_'.$num.'" value="0" '.
                   $htmloff. ' onchange="javascript:address_changes('."'$num'".
')" />'.
                   &mt('No').'</label></td>'.
                   &Apache::loncommon::end_data_table_row();
        $num ++;
        $counter ++;
    }
    my %defchk = (
                   all => 'checked="checked" ',
                   crit => '',
                   reg => '',
                 );
    $output .= &Apache::loncommon::start_data_table_row().
               '<td><b>'.$counter.'</b></td>'.
               '<td><span class="LC_nobreak"><label>'.
               '<input type="checkbox" name="add_notify_'.$num.
               '" value="1" />'.&mt('Add new address').'</label></span></td>'.
               '<td><input type="text" value="" name="address_'.$num.
               '" onFocus="javascript:new_address('."'$num'".')" /></td><td>';
    foreach my $type ('all','crit','reg') {
        $output .= '<span class="LC_nobreak"><label>'.
                   '<input type="radio" name="notify_type_'.$num.
                   '" value="'.$type.'" '.$defchk{$type}.'/>'.
                   $lt{$type}.'</label></span>'.('&nbsp;' x4);
    }
    $output .= '</td><td><label><input type="radio" name="html_'.$num.
               '" value="1" />'.&mt('Yes').'</label>'.('&nbsp;' x3).
               '<label><input type="radio" name="html_'.$num.'" value="0" '.
               ' checked="checked" />'.
               &mt('No').'</label></td>'.
               &Apache::loncommon::end_data_table_row().
               &Apache::loncommon::end_data_table();
    $num ++;
    $r->print($output);
    $r->print(qq|
<br /><hr />
<input type="hidden" name="numnotify" value="$num" />
<input type="button" value="$lt{'prme'}" onclick="location.href='/adm/preferences'" />
<input type="button" value="$lt{'chg'}" onclick="javascript:validate()" />
</form>
|);

}

sub get_notifications {
    my ($userenv) = @_;
    my %allnot;
    my @critnot = split(/,/,$userenv->{'critnotification'});
    my @regnot = split(/,/,$userenv->{'notification'});
    foreach my $item (@critnot) {
        $allnot{$item}{crit} = 1;
    }
    foreach my $item (@regnot) {
        $allnot{$item}{reg} = 1;
    }
    return %allnot;
}

sub verify_and_change_msgforward {
    my $r = shift;
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my $newscreen  = '';
    my $message='';
    foreach my $recip (split(/\,/,$env{'form.msgforward'})) {
        my ($msuser,$msdomain);
        if ($recip =~ /:/) {
            ($msuser,$msdomain)=split(':',$recip);
        } else {
            ($msuser,$msdomain)=split(/\@/,$recip);
        }
        $msuser = &LONCAPA::clean_username($msuser);
        $msdomain = &LONCAPA::clean_domain($msdomain);
        if (($msuser) && ($msdomain)) {
	    if (&Apache::lonnet::homeserver($msuser,$msdomain) ne 'no_host') {
                $newscreen.=$msuser.':'.$msdomain.',';
	    } else {
                $message.= &mt('No such user: ').'<tt>'.$msuser.':'.$msdomain.'</tt><br />';
            }
        }
    }
    $newscreen=~s/\,$//;
    if ($newscreen) {
        &Apache::lonnet::put('environment',{'msgforward' => $newscreen});
        &Apache::lonnet::appenv({'environment.msgforward' => $newscreen});
        $message .= &Apache::lonhtmlcommon::confirm_success(&mt('Set message forwarding to ').'<tt>"'.$newscreen.'"</tt>.<br />');
    } else {
        &Apache::lonnet::del('environment',['msgforward']);
        &Apache::lonnet::delenv('environment.msgforward');
        $message.= &Apache::lonhtmlcommon::confirm_success(&mt("Set message forwarding to 'off'.").'<br />');
    }
    my $critnotification;
    my $notification;
    my $notify_with_html;
    my $lastnotify = $env{'form.numnotify'}-1;
    my $totaladdresses = 0;
    for (my $i=0; $i<$env{'form.numnotify'}; $i++) {
        if ((!defined($env{'form.del_notify_'.$i})) &&  
           ((($i==$lastnotify) && ($env{'form.add_notify_'.$lastnotify} == 1)) ||
            ($i<$lastnotify))) {
            if (defined($env{'form.address_'.$i})) {
                if ($env{'form.notify_type_'.$i} eq 'all') {
                    $critnotification .= $env{'form.address_'.$i}.',';
                    $notification .= $env{'form.address_'.$i}.',';
                } elsif ($env{'form.notify_type_'.$i} eq 'crit') {
                    $critnotification .= $env{'form.address_'.$i}.',';
                } elsif ($env{'form.notify_type_'.$i} eq 'reg') {
                    $notification .= $env{'form.address_'.$i}.','; 
                }
                if ($env{'form.html_'.$i} eq '1') {
		    $notify_with_html .= $env{'form.address_'.$i}.',';       	
                }
                $totaladdresses ++;
            }
        }
    }
    $critnotification =~ s/,$//;
    $critnotification=~s/\s//gs;
    $notification =~ s/,$//;
    $notification=~s/\s//gs;
    $notify_with_html =~ s/,$//;
    $notify_with_html =~ s/\s//gs;
    if ($notification) {
        &Apache::lonnet::put('environment',{'notification' => $notification});
        &Apache::lonnet::appenv({'environment.notification' => $notification});
        $message.=&Apache::lonhtmlcommon::confirm_success(&mt('Set non-critical message notification address(es) to ').'<tt>"'.$notification.'"</tt>.<br />');
    } else {
        &Apache::lonnet::del('environment',['notification']);
        &Apache::lonnet::delenv('environment.notification');
        $message.=&Apache::lonhtmlcommon::confirm_success(&mt("Set non-critical message notification to 'off'.").'<br />');
    }
    if ($critnotification) {
        &Apache::lonnet::put('environment',{'critnotification' => $critnotification});
        &Apache::lonnet::appenv({'environment.critnotification' => $critnotification});
        $message.=&Apache::lonhtmlcommon::confirm_success(&mt('Set critical message notification address(es) to ').'<tt>"'.$critnotification.'"</tt>.<br />');
    } else {
        &Apache::lonnet::del('environment',['critnotification']);
        &Apache::lonnet::delenv('environment.critnotification');
        $message.=&Apache::lonhtmlcommon::confirm_success(&mt("Set critical message notification to 'off'.").'<br />');
    }
    if ($critnotification || $notification) {
        if ($notify_with_html) {
            &Apache::lonnet::put('environment',{'notifywithhtml' => $notify_with_html});
            &Apache::lonnet::appenv({'environment.notifywithhtml' => $notify_with_html});
            $message.=&Apache::lonhtmlcommon::confirm_success(&mt('Set address(es) to receive excerpts with html retained ').'<tt>"'.$notify_with_html.'"</tt>.');
        } else {
            &Apache::lonnet::del('environment',['notifywithhtml']);
            &Apache::lonnet::delenv('environment.notifywithhtml');
            if ($totaladdresses == 1) {
                $message.=&Apache::lonhtmlcommon::confirm_success(&mt("Set notification address to receive excerpts with html stripped."));
            } else {
                $message.=&Apache::lonhtmlcommon::confirm_success(&mt("Set all notification addresses to receive excerpts with html stripped."));
            }
        }
    } else {
        &Apache::lonnet::del('environment',['notifywithhtml']);
        &Apache::lonnet::delenv('environment.notifywithhtml');
    }
    &Apache::loncommon::flush_email_cache($user,$domain);
    $message=&Apache::loncommon::confirmwrapper($message);
    &msgforwardchanger($r,$message);
}

################################################################
#         Colors                                               #
################################################################

sub colorschanger {
    my $r = shift;
    Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changecolors',
                text => 'Change Colors'});
    $r->print(Apache::loncommon::start_page('Page Display Settings'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Change Colors'));
# figure out colors
    my $function=&Apache::loncommon::get_users_function();
    my $domain=&Apache::loncommon::determinedomain();
    my %colortypes=&Apache::lonlocal::texthash(
        'pgbg'     => 'Page Background Color',
        'tabbg'    => 'Header Background Color',
        'sidebg'   => 'Header Border Color',
        'font'     => 'Font Color',
        'fontmenu' => 'Font Menu Color',
        'link'     => 'Un-Visited Link Color',
        'vlink'    => 'Visited Link Color',
        'alink'    => 'Active Link Color',
    );
    my $start_data_table = &Apache::loncommon::start_data_table();
    my $chtable='';
    foreach my $item (sort(keys(%colortypes))) {
       my $curcol=&Apache::loncommon::designparm($function.'.'.$item,$domain);
       $chtable.=&Apache::loncommon::start_data_table_row().
	   '<td>'.$colortypes{$item}.'</td><td style="background: '.$curcol.
        '">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td><input name="'.$item.
        '" size="10" value="'.$curcol.
'" /></td><td><a href="javascript:pjump('."'color_custom','".$colortypes{$item}.
"','".$curcol."','"
	    .$item."','parmform.pres','psub'".');">'.&mt('Select').'</a></td>'.
	    &Apache::loncommon::end_data_table_row()."\n";
    }
    my $end_data_table = &Apache::loncommon::end_data_table();
    my $pjump_def = &Apache::lonhtmlcommon::pjump_javascript_definition();
    my $savebutton = &mt('Save');
    my $resetbutton = &mt('Reset All');
    my $resetbuttondesc = &mt('Reset All Colors to Default');
    $r->print(<<ENDCOL);
<script type="text/javascript" language="JavaScript">

    function pclose() {
        parmwin=window.open("/adm/rat/empty.html","LONCAPAparms",
                 "height=350,width=350,scrollbars=no,menubar=no");
        parmwin.close();
    }

    $pjump_def

    function psub() {
        pclose();
        if (document.parmform.pres_marker.value!='') {
            if (document.parmform.pres_type.value!='') {
                eval('document.prefs.'+
                     document.parmform.pres_marker.value+
		     '.value=document.parmform.pres_value.value;');
	    }
        } else {
            document.parmform.pres_value.value='';
            document.parmform.pres_marker.value='';
        }
    }


</script>
<form name="parmform">
<input type="hidden" name="pres_marker" />
<input type="hidden" name="pres_type" />
<input type="hidden" name="pres_value" />
</form>
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_colors" />
$start_data_table
$chtable
$end_data_table
</table>
<p>
<input type="submit" value="$savebutton" />
<input type="submit" name="resetall" value="$resetbutton" title="$resetbuttondesc" />
</p>
</form>
ENDCOL
}

sub verify_and_change_colors {
    my $r = shift;
# figure out colors
    my $function=&Apache::loncommon::get_users_function();
    my $domain=&Apache::loncommon::determinedomain();
    my %colortypes=&Apache::lonlocal::texthash(
        'pgbg'     => 'Page Background Color',
        'tabbg'    => 'Header Background Color',
        'sidebg'   => 'Header Border Color',
        'font'     => 'Font Color',
	'fontmenu' => 'Font Menu Color',
        'link'     => 'Un-Visited Link Color',
        'vlink'    => 'Visited Link Color',
        'alink'    => 'Active Link Color',
    );

    my $message='';
    foreach my $item (keys %colortypes) {
        my $color=$env{'form.'.$item};
        my $entry='color.'.$function.'.'.$item;
	if (($color=~/^\#[0-9A-Fa-f]{6}$/) && (!$env{'form.resetall'})) {
	    &Apache::lonnet::put('environment',{$entry => $color});
	    &Apache::lonnet::appenv({'environment.'.$entry => $color});
            $message.=&Apache::lonhtmlcommon::confirm_success(&mt('Set [_1] to [_2]','<i>'.$colortypes{$item}.'</i>','<tt>"'.$color.'"</tt>'))
                    .'<br />';
	} else {
	    &Apache::lonnet::del('environment',[$entry]);
	    &Apache::lonnet::delenv('environment.'.$entry);
            $message.=&Apache::lonhtmlcommon::confirm_success(&mt('Reset [_1]','<i>'.$colortypes{$item}.'</i>'))
                     .'<br />';
	}
    }
    $message=&Apache::loncommon::confirmwrapper($message);

    my $now = time;
    &Apache::lonnet::put('environment',{'color.timestamp' => $now});
    &Apache::lonnet::appenv({'environment.color.timestamp' => $now});

    &print_main_menu($r, $message);
}

######################################################
#            password handler subroutines            #
######################################################
sub passwordchanger {
    my ($r,$errormessage,$caller,$mailtoken) = @_;
    # This function is a bit of a mess....
    # Passwords are encrypted using londes.js (DES encryption)
    $errormessage = ($errormessage || '');
    my ($user,$domain,$currentpass,$defdom);
    &Apache::lonhtmlcommon::add_breadcrumb(
		{ href => '/adm/preferences?action=changepass',
                  text => 'Change Password'});
    unless ($caller eq 'reset_by_email') {
        $r->print(Apache::loncommon::start_page('Personal Data'));
        $r->print(Apache::lonhtmlcommon::breadcrumbs('Change Password'));
    }
    if ((!defined($caller)) || ($caller eq 'preferences')) {
        $user = $env{'user.name'};
        $domain = $env{'user.domain'};
        if (!defined($caller)) {
            $caller = 'preferences';
        }
    } elsif ($caller eq 'reset_by_email') {
            $defdom = $r->dir_config('lonDefDomain');
            my %data = &Apache::lonnet::tmpget($mailtoken);
            if (keys(%data) == 0) {
                $r->print(&mt('Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a [_1]new request[_2] for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.'
                             ,'<a href="/adm/resetpw">','</a>')
                );
                return;
            }
            if (defined($data{time})) {
                if (time - $data{'time'} < 7200) {
                    $user = $data{'username'};
                    $domain = $data{'domain'};
                    $currentpass = $data{'temppasswd'};
                } else {
                    $r->print(&mt('Sorry, the token generated when you requested a password reset has expired.').'<br />');
                    return;
                }
            } else {
                $r->print(&mt('Sorry, the URL generated when you requested reset of your password contained incomplete information.').'<br />');
                return;
            }
   } else {
        $r->print(&mt('Page requested in unexpected context').'<br />');
        return;
    }
    my $currentauth=&Apache::lonnet::queryauthenticate($user,$domain);
    # Check for authentication types that allow changing of the password.
    return if ($currentauth !~ /^(unix|internal):/);
    #
    # Generate keys
    my ($lkey_cpass ,$ukey_cpass ) = &des_keys();
    my ($lkey_npass1,$ukey_npass1) = &des_keys();
    my ($lkey_npass2,$ukey_npass2) = &des_keys();
    # Store the keys in the log files
    my $lonhost = $r->dir_config('lonHostID');
    my $logtoken=Apache::lonnet::reply('tmpput:'
				       .$ukey_cpass  . $lkey_cpass .'&'
				       .$ukey_npass1 . $lkey_npass1.'&'
				       .$ukey_npass2 . $lkey_npass2,
				       $lonhost);
    # Hexify the keys for output as javascript variables
    my %hexkey;
    $hexkey{'ukey_cpass'}  = hex($ukey_cpass);
    $hexkey{'lkey_cpass'}  = hex($lkey_cpass);
    $hexkey{'ukey_npass1'} = hex($ukey_npass1);
    $hexkey{'lkey_npass1'} = hex($lkey_npass1);
    $hexkey{'ukey_npass2'} = hex($ukey_npass2);
    $hexkey{'lkey_npass2'} = hex($lkey_npass2);
    # Output javascript to deal with passwords
    # Output DES javascript
    {
	my $include = $r->dir_config('lonIncludes');
	my $jsh=Apache::File->new($include."/londes.js");
	$r->print(<$jsh>);
    }
    $r->print(&jscript_send($caller));
    $r->print(<<ENDFORM);
$errormessage

<p>
<!-- We separate the forms into 'server' and 'client' in order to
     ensure that unencrypted passwords will not be sent out by a
     crappy browser -->
ENDFORM
    $r->print(&server_form($logtoken,$caller,$mailtoken));
    $r->print(&client_form($caller,\%hexkey,$currentpass,$defdom));

    #
    return;
}

sub jscript_send {
    my ($caller) = @_;
    my $output = qq|
<script type="text/javascript" language="JavaScript">

    function send() {
        uextkey=this.document.client.elements.ukey_cpass.value;
        lextkey=this.document.client.elements.lkey_cpass.value;
        initkeys();

        this.document.pserver.elements.currentpass.value
            =crypted(this.document.client.elements.currentpass.value);

        uextkey=this.document.client.elements.ukey_npass1.value;
        lextkey=this.document.client.elements.lkey_npass1.value;
        initkeys();
        this.document.pserver.elements.newpass_1.value
            =crypted(this.document.client.elements.newpass_1.value);

        uextkey=this.document.client.elements.ukey_npass2.value;
        lextkey=this.document.client.elements.lkey_npass2.value;
        initkeys();
        this.document.pserver.elements.newpass_2.value
            =crypted(this.document.client.elements.newpass_2.value);
|;
    if ($caller eq 'reset_by_email') {
        $output .= qq|
        this.document.pserver.elements.uname.value =
                   this.document.client.elements.uname.value;
        this.document.pserver.elements.udom.value =
                   this.document.client.elements.udom.options[this.document.client.elements.udom.selectedIndex].value;
        this.document.pserver.elements.email.value =
                   this.document.client.elements.email.value;
|;
    }
    $ output .= qq|
        this.document.pserver.submit();
    }
</script>
|;
}

sub client_form {
    my ($caller,$hexkey,$currentpass,$defdom) = @_;
    my %lt=&Apache::lonlocal::texthash(
                'email' => 'E-mail Address',
                'username' => 'Username',
                'domain' => 'Domain',
                'currentpass' => 'Current Password',
                'newpass' => 'New Password',
                'confirmpass' => 'Confirm Password',
                'changepass' => 'Save',
    );

    my $output = '<form name="client">'
                .&Apache::lonhtmlcommon::start_pick_box();
    if ($caller eq 'reset_by_email') {
        $output .= &Apache::lonhtmlcommon::row_title(
                       '<label for="email">'.$lt{'email'}.'</label>')
                  .'<input type="text" name="email" size="30" />'
                  .&Apache::lonhtmlcommon::row_closure()
                  .&Apache::lonhtmlcommon::row_title(
                       '<label for="uname">'.$lt{'username'}.'</label>')
                  .'<input type="text" name="uname" size="15" />'
                  .'<input type="hidden" name="currentpass" value="'.$currentpass.'" />'
                  .&Apache::lonhtmlcommon::row_closure()
                  .&Apache::lonhtmlcommon::row_title(
                       '<label for="udom">'.$lt{'domain'}.'</label>')
                  .&Apache::loncommon::select_dom_form($defdom,'udom')
                  .&Apache::lonhtmlcommon::row_closure();
    } else {
        $output .= &Apache::lonhtmlcommon::row_title(
                       '<label for="currentpass">'.$lt{'currentpass'}.'</label>')
                  .'<input type="password" name="currentpass" size="10"/>'
                  .&Apache::lonhtmlcommon::row_closure();
    }
    $output .= &Apache::lonhtmlcommon::row_title(
                   '<label for="newpass_1">'.$lt{'newpass'}.'</label>')
              .'<input type="password" name="newpass_1" size="10" />'
              .&Apache::lonhtmlcommon::row_closure()
              .&Apache::lonhtmlcommon::row_title(
                   '<label for="newpass_2">'.$lt{'confirmpass'}.'</label>')
              .'<input type="password" name="newpass_2" size="10" />'
              .&Apache::lonhtmlcommon::row_closure(1)
              .&Apache::lonhtmlcommon::end_pick_box();
    $output .= '<p><input type="button" value="'.$lt{'changepass'}.'" onClick="send();" /></p>'
              .qq|
<input type="hidden" name="ukey_cpass"  value="$hexkey->{'ukey_cpass'}" />
<input type="hidden" name="lkey_cpass"  value="$hexkey->{'lkey_cpass'}" />
<input type="hidden" name="ukey_npass1" value="$hexkey->{'ukey_npass1'}" />
<input type="hidden" name="lkey_npass1" value="$hexkey->{'lkey_npass1'}" />
<input type="hidden" name="ukey_npass2" value="$hexkey->{'ukey_npass2'}" />
<input type="hidden" name="lkey_npass2" value="$hexkey->{'lkey_npass2'}" />
</form>
</p>
|;
    return $output;
}

sub server_form {
    my ($logtoken,$caller,$mailtoken) = @_;
    my $action = '/adm/preferences';
    if ($caller eq 'reset_by_email') {
        $action = '/adm/resetpw';
    }
    my $output = qq|
<form name="pserver" action="$action" method="post">
<input type="hidden" name="logtoken"    value="$logtoken" />
<input type="hidden" name="currentpass" value="" />
<input type="hidden" name="newpass_1"   value="" />
<input type="hidden" name="newpass_2"   value="" />
    |;
    if ($caller eq 'reset_by_email') {
        $output .=  qq|
<input type="hidden" name="token"   value="$mailtoken" />
<input type="hidden" name="uname"   value="" />
<input type="hidden" name="udom"   value="" />
<input type="hidden" name="email"   value="" />

|;
    }
    $output .= qq|
<input type="hidden" name="action" value="verify_and_change_pass" />
</form>
|;
    return $output;
}

sub verify_and_change_password {
    my ($r,$caller,$mailtoken) = @_;
    my ($user,$domain,$homeserver);
    if ($caller eq 'reset_by_email') {
        $user       = $env{'form.uname'};
        $domain     = $env{'form.udom'};
        if ($user ne '' && $domain ne '') {
            $homeserver = &Apache::lonnet::homeserver($user,$domain);
            if ($homeserver eq 'no_host') {
        &passwordchanger($r,"<p>\n<span class='LC_error'>".
                         &mt("Invalid username and/or domain")."</span>\n</p>",
                         $caller,$mailtoken);
                return 1;
            }
        } else {
            &passwordchanger($r,"<p>\n<span class='LC_error'>".
                             &mt("Username and domain were blank")."</span>\n</p>",
                             $caller,$mailtoken);
            return 1;
        }
    } else {
        $user       = $env{'user.name'};
        $domain     = $env{'user.domain'};
        $homeserver = $env{'user.home'};
    }
    my $currentauth=&Apache::lonnet::queryauthenticate($user,$domain);
    # Check for authentication types that allow changing of the password.
    if ($currentauth !~ /^(unix|internal):/) {
        if ($caller eq 'reset_by_email') {
            &passwordchanger($r,"<p>\n<span class='LC_error'>".
                             &mt("Authentication type for this user can not be changed by this mechanism").
                             "</span>\n</p>",
                              $caller,$mailtoken);
            return 1;
        } else {
            return;
        }
    }
    #
    my $currentpass = $env{'form.currentpass'}; 
    my $newpass1    = $env{'form.newpass_1'}; 
    my $newpass2    = $env{'form.newpass_2'};
    my $logtoken    = $env{'form.logtoken'};
    # Check for empty data 
    unless (defined($currentpass) && 
	    defined($newpass1)    && 
	    defined($newpass2)    ){
	&passwordchanger($r,"<p>\n<span class='LC_error'>".
			 &mt("One or more password fields were blank").
                         "</span>\n</p>",$caller,$mailtoken);
	return;
    }
    # Get the keys
    my $lonhost = $r->dir_config('lonHostID');
    my $tmpinfo = Apache::lonnet::reply('tmpget:'.$logtoken,$lonhost);
    if (($tmpinfo=~/^error/) || ($tmpinfo eq 'con_lost')) {
        # I do not a have a better idea about how to handle this
        my $tryagain_text = &mt('Please log out and try again.');
        if ($caller eq 'reset_by_email') {
            $tryagain_text = &mt('Please try again later.');
        }
        my $unable=&mt("Unable to retrieve saved token for password decryption");
	$r->print(<<ENDERROR);
<p>
<span class="LC_error">$unable.  $tryagain_text</span>
</p>
ENDERROR
        # Probably should log an error here
        return 1;
    }
    my ($ckey,$n1key,$n2key)=split(/&/,$tmpinfo);
    # 
    $currentpass = &des_decrypt($ckey ,$currentpass);
    $newpass1    = &des_decrypt($n1key,$newpass1);
    $newpass2    = &des_decrypt($n2key,$newpass2);
    #
    if ($caller eq 'reset_by_email') {
        my %data = &Apache::lonnet::tmpget($mailtoken);
        if (keys(%data) == 0) {
            &passwordchanger($r,
                         '<span class="LC_error">'.
                         &mt('Could not verify current authentication.').'  '.
                         &mt('Please try again.').'</span>',$caller,$mailtoken);
            return 1;
        }
        if ($currentpass ne $data{'temppasswd'}) {
            &passwordchanger($r,
                         '<span class="LC_error">'.
                         &mt('Could not verify current authentication.').'  '.
                         &mt('Please try again.').'</span>',$caller,$mailtoken);
            return 1;
        }
    } 
    if ($newpass1 ne $newpass2) {
	&passwordchanger($r,
			 '<span class="LC_error">'.
			 &mt('The new passwords you entered do not match.').'  '.
			 &mt('Please try again.').'</span>',$caller,$mailtoken);
	return 1;
    }
    if (length($newpass1) < 7) {
	&passwordchanger($r,
			 '<span class="LC_error">'.
			 &mt('Passwords must be a minimum of 7 characters long.').'  '.
			 &mt('Please try again.').'</span>',$caller,$mailtoken);
	return 1;
    }
    #
    # Check for bad characters
    my $badpassword = 0;
    foreach (split(//,$newpass1)) {
	$badpassword = 1 if ((ord($_)<32)||(ord($_)>126));
    }
    if ($badpassword) {
	# I can't figure out how to enter bad characters on my browser.
	my $errormessage ='<span class="LC_error">'.
           &mt('The password you entered contained illegal characters.').'<br />'.
           &mt('Valid characters are').(<<"ENDERROR");
: space and <br />
<pre>
!&quot;\#$%&amp;\'()*+,-./0123456789:;&lt;=&gt;?\@
ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_\`abcdefghijklmnopqrstuvwxyz{|}~
</pre></span>
ENDERROR
        &passwordchanger($r,$errormessage,$caller,$mailtoken);
        return 1;
    }
    # 
    # Change the password (finally)
    my $result = &Apache::lonnet::changepass
	($user,$domain,$currentpass,$newpass1,$homeserver,$caller);
    # Inform the user the password has (not?) been changed
    my $message;
    if ($result =~ /^ok$/) {
        $message = &Apache::lonhtmlcommon::confirm_success(&mt('The password for user [_1] was successfully changed.','<i>'.$user.'</i>'));
        $message = &Apache::loncommon::confirmwrapper($message);
        if ($caller eq 'reset_by_email') {
            $r->print($message.'<br />');
        } else {
            &print_main_menu($r, $message);
        }
    } else {
	# error error: run in circles, scream and shout
        if ($caller eq 'reset_by_email') {
            if (!$result) {
                return 1;
            } else {
                return $result;
            }
        } else {
            $message = &Apache::lonhtmlcommon::confirm_success(
                &mt("The password for user [_1] was not changed.",'<i>'.$user.'</i>').' '.&mt('Please make sure your old password was entered correctly.'),1);
            $message=&Apache::loncommon::confirmwrapper($message);
            &print_main_menu($r, $message);
        }
    }
    return;
}

################################################################
#            discussion display subroutines 
################################################################
sub discussionchanger {
    my $r = shift;
    Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changediscussions',
                text => 'Change Discussion Preferences'});
    $r->print(Apache::loncommon::start_page('Change Discussion Preferences'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Change Discussion Preferences'));
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get
        ('environment',['discdisplay','discmarkread']);
    my $discdisp = 'allposts';
    my $discmark = 'onmark';

    if (defined($userenv{'discdisplay'})) {
        unless ($userenv{'discdisplay'} eq '') { 
            $discdisp = $userenv{'discdisplay'};
        }
    }
    if (defined($userenv{'discmarkread'})) {
        unless ($userenv{'discmarkread'} eq '') { 
            $discmark = $userenv{'discmarkread'};
        }
    }

    my $newdisp = 'unread';
    my $newmark = 'ondisp';

    my $function = &Apache::loncommon::get_users_function();
    my $color = &Apache::loncommon::designparm($function.'.tabbg',
                                                    $env{'user.domain'});
    my %lt = &Apache::lonlocal::texthash(
        'pref' => 'Display Preference',
        'curr' => 'Current setting ',
        'actn' => 'Action',
        'sdpf' => 'Set display preferences for discussion posts for both discussion boards and individual resources in all your courses.',
        'prca' => 'Preferences can be set that determine',
        'whpo' => 'Which posts are displayed when you display a discussion board or resource, and',
        'unwh' => 'Under what circumstances posts are identfied as "New"',
        'allposts' => 'All posts',
        'unread' => 'New posts only',
        'ondisp' => 'Once displayed',
        'onmark' => 'Once marked as read',
        'disa' => 'Posts displayed?',
        'npmr' => 'New posts cease to be identified as "New"?',
        'thde'  => 'The preferences you set here can be overridden within each individual discussion.',
        'chgt' => 'Change to '
    );
    my $dispchange = $lt{'unread'};
    my $markchange = $lt{'ondisp'};
    my $currdisp = $lt{'allposts'};
    my $currmark = $lt{'onmark'};

    if ($discdisp eq 'unread') {
        $dispchange = $lt{'allposts'};
        $currdisp = $lt{'unread'};
        $newdisp = 'allposts';
    }

    if ($discmark eq 'ondisp') {
        $markchange = $lt{'onmark'};
        $currmark = $lt{'ondisp'};
        $newmark = 'onmark';
    }

    $r->print(<<"END");
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_discussion" />
<br />
$lt{'sdpf'}<br /> $lt{'prca'}  <ol><li>$lt{'whpo'}</li><li>$lt{'unwh'}</li></ol> 
END

    $r->print('<p class="LC_info">'.$lt{'thde'}.'</p>');

    $r->print(&Apache::loncommon::start_data_table());
    $r->print(<<"END");
       <tr>
        <th>$lt{'pref'}</th>
        <th>$lt{'curr'}</th>
        <th>$lt{'actn'}?</th>
       </tr>
END
    $r->print(&Apache::loncommon::start_data_table_row());
    $r->print(<<"END");
       <td>$lt{'disa'}</td>
       <td>$lt{$discdisp}</td>
       <td><label><input type="checkbox" name="discdisp" /><input type="hidden" name="newdisp" value="$newdisp" />&nbsp;$lt{'chgt'} "$dispchange"</label></td>
END
    $r->print(&Apache::loncommon::end_data_table_row().
	      &Apache::loncommon::start_data_table_row());
    $r->print(<<"END");
       <td>$lt{'npmr'}</td>
       <td>$lt{$discmark}</td>
       <td><label><input type="checkbox" name="discmark" /><input type="hidden" name="newmark" value="$newmark" />&nbsp;$lt{'chgt'} "$markchange"</label></td>
      </tr>
END
    $r->print(&Apache::loncommon::end_data_table_row().
	      &Apache::loncommon::end_data_table());

    $r->print('<br />'
             .'<input type="submit" name="sub" value="'.&mt('Save').'" />'
             .'</form>'
    );
}
                                                                                                                
sub verify_and_change_discussion {
    my $r = shift;
    my $user     = $env{'user.name'};
    my $domain   = $env{'user.domain'};
    my $message='';
    if (defined($env{'form.discdisp'}) ) {
        my $newdisp  = $env{'form.newdisp'};
        if ($newdisp eq 'unread') {
            $message .=&Apache::lonhtmlcommon::confirm_success(&mt('In discussions: only new posts will be displayed.')).'<br />';
            &Apache::lonnet::put('environment',{'discdisplay' => $newdisp});
            &Apache::lonnet::appenv({'environment.discdisplay' => $newdisp});
        } else {
            $message .= &Apache::lonhtmlcommon::confirm_success(&mt('In discussions: all posts will be displayed.')).'<br />';
            &Apache::lonnet::del('environment',['discdisplay']);
            &Apache::lonnet::delenv('environment.discdisplay');
        }
    }
    if (defined($env{'form.discmark'}) ) {
        my $newmark = $env{'form.newmark'};
        if ($newmark eq 'ondisp') {
            $message.=&Apache::lonhtmlcommon::confirm_success(&mt('In discussions: new posts will be cease to be identified as "NEW" after display.')).'<br />';
            &Apache::lonnet::put('environment',{'discmarkread' => $newmark});
            &Apache::lonnet::appenv({'environment.discmarkread' => $newmark});
        } else {
            $message.=&Apache::lonhtmlcommon::confirm_success(&mt('In discussions: posts will be identified as "NEW" until marked as read by the reader.')).'<br />';
            &Apache::lonnet::del('environment',['discmarkread']);
            &Apache::lonnet::delenv('environment.discmarkread');
        }
    }
    $message=&Apache::loncommon::confirmwrapper($message);
    &print_main_menu($r, $message);
}

################################################################
# Subroutines for page display on course access (Course Coordinators)
################################################################
sub coursedisplaychanger {
    my $r = shift;
    &Apache::lonhtmlcommon::add_breadcrumb(
	    {	href => '/adm/preferences?action=changecourseinit',
                text => 'Change Course Init. Pref.'});
    $r->print(Apache::loncommon::start_page('Change Course Initialization Preference'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Change Course Init. Pref.'));
    my $user       = $env{'user.name'};
    my $domain     = $env{'user.domain'};
    my %userenv = &Apache::lonnet::get('environment',['course_init_display']);
    my $currvalue = 'whatsnew';
    my $firstselect = '';
    my $whatsnewselect = 'checked="checked"';
    if (exists($userenv{'course_init_display'})) {
        if ($userenv{'course_init_display'} eq 'firstres') {
            $currvalue = 'firstres';
            $firstselect = 'checked="checked"';
	    $whatsnewselect = '';
        }
    }
    my %pagenames = &Apache::lonlocal::texthash(
                       firstres => 'First resource',
                       whatsnew => "What's New Page",
                    );
    my $whatsnew_off=&mt('Display the [_1]first resource[_2] in the course.','<b>','</b>');
    my $whatsnew_on=&mt("Display the [_1]What's New Page[_2] - a summary of items in the course which require attention.",'<b>','</b>');

    $r->print('<br /><b>'
             .&mt('Set the default page to be displayed when you select a course role')
             .'</b>&nbsp;'
             .&mt('(Currently: [_1])',$pagenames{$currvalue})
             .'<br />'
             .&mt("The global user preference you set for your courses can be overridden in an individual course by setting a course specific setting via the [_1]What's New Page[_2] in the course.",'<i>','</i>')
             .'<br /><br />'
    );
    $r->print(<<ENDLSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_coursepage" />
<br />
<label><input type="radio" name="newdisp" value="firstres" $firstselect /> $whatsnew_off</label><br />
<label><input type="radio" name="newdisp" value="whatsnew" $whatsnewselect /> $whatsnew_on</label><input type="hidden" name="refpage" value="$env{'form.refpage'}" />
ENDLSCREEN
    $r->print('<br /><br /><input type="submit" value="'.&mt('Save').'" />
</form>');
}

sub verify_and_change_coursepage {
    my $r = shift;
    my $message='';
    my %lt = &Apache::lonlocal::texthash(
        'defs' => 'Default now set',
        'when' => 'when you select a course role from the roles screen',
        'ywbt' => 'you will be taken to the start of the course.',
        'apwb' => 'a page will be displayed that lists items in the course that may require action from you.',
        'gtts' => 'Go to the start of the course',
        'dasp' => "Display the What's New Page", 
    );
    my $newdisp  = $env{'form.newdisp'};
    $message = '<b>'.$lt{'defs'}.'</b>: '.$lt{'when'}.', ';
    if ($newdisp eq 'firstres') {
        $message .= $lt{'ywbt'}.'<br />';
        &Apache::lonnet::put('environment',{'course_init_display' => $newdisp});
        &Apache::lonnet::appenv({'environment.course_init_display' => $newdisp});
    } else {
        $message .= $lt{'apwb'}.'<br />';
        &Apache::lonnet::del('environment',['course_init_display']);
        &Apache::lonnet::delenv('environment.course_init_display');
    }
    my $refpage = $env{'form.refpage'};
    if (($env{'request.course.fn'}) && ($env{'request.course.id'})) {
        if ($newdisp eq 'firstres') {
            my $cdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
            my $cnum = $env{'course.'.$env{'request.course.id'}.'.num'}; 
            my ($furl,$ferr)=
                &Apache::lonuserstate::readmap($cdom.'/'.$cnum);
            $message .= '<br /><a href="'.$furl.'">'.$lt{'gtts'}.' <i>'.&mt('now').'</i></a>';
        } else {
            $message .= '<br /><a href="/adm/whatsnew?refpage='.
                        $refpage.'">'.$lt{'dasp'}.'</a>';
        }
    }
    $message = &Apache::lonhtmlcommon::confirm_success($message);
    $message = &Apache::loncommon::confirmwrapper($message);
    &print_main_menu($r,$message);
}

sub lockednameschanger {
    my $r = shift;
    &Apache::lonhtmlcommon::add_breadcrumb(
            {   href => '/adm/preferences?action=changelockednames',
                text => 'Automatic name changes'});
    $r->print(Apache::loncommon::start_page('Automatic name changes'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Allow/disallow name updates'));
    my %userenv = &Apache::lonnet::get('environment',['lockedname']);
    my $lockedname='';
    if (&can_toggle_namelocking()) {
        if ($userenv{'lockedname'}) {
            $lockedname = ' checked="checked"';
        }
        my %updateable;
        my %domconfig =
            &Apache::lonnet::get_dom('configuration',['autoupdate'],$env{'user.domain'});
        if (ref($domconfig{'autoupdate'}) eq 'HASH') {
            if ($domconfig{'autoupdate'}{'run'}) {
                my @inststatuses = split(':',$env{'environment.inststatus'});
                unless (@inststatuses) {
                    @inststatuses = ('default');
                }
                %updateable = &updateable_userinfo($domconfig{'autoupdate'},\@inststatuses);
            }
        }
        if (keys(%updateable)) {
            my %longnames = &Apache::lonlocal::texthash (
                                firstname  => 'First Name',
                                middlename => 'Middle Name',
                                lastname   => 'Last Name',
                            );
            my $text=&mt('By default, based on your institutional affiliation, your LON-CAPA account can be automatically updated nightly based on directory information from your institution.').'<br />'.&mt('The following may be updated, unless you disallow updates:').
                     '<ul>';
           foreach my $item ('firstname','middlename','lastname') {
               if ($updateable{$item}) {
                   $text .= '<li>'.$longnames{$item}.'</li>';
               }
           }
           $text .= '</ul>'; 
           my $locking=&mt('Disallow automatic updates to name information for your LON-CAPA account');
           my $change=&mt('Save');
           $r->print(<<ENDSCREEN);
<form name="prefs" action="/adm/preferences" method="post">
<input type="hidden" name="action" value="verify_and_change_lockednames" />
$text<br />
<label><input type="checkbox" value="1" name="lockednames"$lockedname />$locking</label><br />
<input type="submit" value="$change" />
</form>
ENDSCREEN
        } else {
            my $message = &mt('Based on your institutional affiliation no name information is automatically updated for your LON-CAPA account.');
            &print_main_menu($r,$message);
        }
    } else {
        my $message = &mt('You are not permitted to set a user preference for automatic name updates for your LON-CAPA account.');
        &print_main_menu($r,$message);
    }
}

sub verify_and_change_lockednames {
    my $r = shift;
    my $message;
    if (&can_toggle_namelocking()) {
        my $newlockedname = $env{'form.lockednames'};
        $newlockedname =~ s/\D//g;
        my $currlockedname = $env{'environment.lockedname'};
        if ($newlockedname ne $currlockedname) {
            if ($newlockedname) {
                if (&Apache::lonnet::put('environment',{lockedname => $newlockedname}) eq 'ok') {
                    &Apache::lonnet::appenv({'environment.lockedname' => $newlockedname});
                }
            } elsif (&Apache::lonnet::del('environment',['lockedname']) eq 'ok') {
                &Apache::lonnet::delenv('environment.lockedname');
            }
        }
        my $status='';
        if ($newlockedname) {
            $status=&mt('disallowed');
        } else {
            $status=&mt('allowed');
        }
        $message=&Apache::lonhtmlcommon::confirm_success(&mt('[_1] set to [_2]','<i>'.&mt('Automatic update of first, middle and last names if institutional directory information indicates changes').'</i>','<tt>'.$status.'</tt>'));
        $message=&Apache::loncommon::confirmwrapper($message);
    }
    &print_main_menu($r,$message);
}

sub print_main_menu {
    my ($r, $message) = @_;
    # Determine current authentication method
    my $user = $env{'user.name'};
    my $domain = $env{'user.domain'};
    my $currentauth=&Apache::lonnet::queryauthenticate($user,$domain);

    # build the data structure for menu generation
my $aboutmeurl='/adm/'.$env{'user.domain'}.'/'.$env{'user.name'}.'/aboutme';
my $role = ($env{'user.adv'} ? 'Roles' : 'Course');
my %permissions;
if (&Apache::lonnet::usertools_access($user,$domain,'aboutme')) {
    $permissions{'aboutme'} = 'F';
}
my @menu=
    ({	categorytitle=>'Personal Data',
	items =>[
	    {	linktext => 'Personal Information Page',
		url => $aboutmeurl,
		permission => $permissions{'aboutme'},
		#help => 'Prefs_About_Me',
		icon => 'system-users.png',
		linktitle => 'Edit information about yourself that should be displayed on your public profile.'
	    },
	    {	linktext => 'Screen Name',
		url => '/adm/preferences?action=changescreenname',
		permission => 'F',
		#help => 'Prefs_Screen_Name_Nickname',
		icon => 'preferences-desktop-font.png',
		linktitle => 'Change the name that is displayed in your posts.'
	    },
		]
    },
    {	categorytitle=>'Content Display Settings',
	items =>[
	    {	linktext => 'Language',
		url => '/adm/preferences?action=changelanguages',
		permission => 'F',
		#help => 'Prefs_Language',
		icon => 'preferences-desktop-locale.png',
		linktitle => 'Choose the default language for this user.'
	    },
	    {	linktext => $role.' Page',
		url => '/adm/preferences?action=changerolespref',
		permission => 'F',
		#help => '',
		icon => 'role_hotlist.png',
		linktitle => 'Configure the roles hotlist.'
	    },
	    {	linktext => 'Math display settings',
		url => '/adm/preferences?action=changetexenginepref',
		permission => 'F',
		#help => '',
		icon => 'dismath.png',
		linktitle => 'Change how math is displayed.'
	    },
		]
    },
    {	categorytitle=>'Page Display Settings',
	items =>[
	    {	linktext => 'Color Scheme',
		url => '/adm/preferences?action=changecolors',
		permission => 'F',
		#help => 'Change_Colors',
		icon => 'preferences-desktop-theme.png',
		linktitle => 'Change LON-CAPA default colors.'
	    },
		]
    },
    {	categorytitle=>'Messages &amp; Notifications',
	items =>[
	    {	linktext => 'Messages &amp; Notifications',
		url => '/adm/preferences?action=changemsgforward',
		permission => 'F',
		#help => 'Prefs_Messages',
		icon => 'mail-reply-all.png',
		linktitle => 'Change messageforwarding or notifications settings.'
	    },
	    {	linktext => 'Discussion Display',
		url => '/adm/preferences?action=changediscussions',
		permission => 'F',
		#help => 'Change_Discussion_Display',
		icon => 'mail-message-new.png',
		linktitle => 'Set display preferences for discussion posts for both discussion boards and individual resources in all your courses.'
	    },
		]
    },
    {	categorytitle=>'Other',
	items =>[
	    {	linktext => 'Register Response Devices (&quot;Clickers&quot;)',
		url => '/adm/preferences?action=changeclicker',
		permission => 'F',
		#help => '',
		icon => 'network-workgroup.png',
		linktitle => 'Register your clicker.'
	    },
		]
    },
    );

    if ($currentauth =~ /^(unix|internal):/) {
push(@{ $menu[0]->{items} }, {
	linktext => 'Password',
	url => '/adm/preferences?action=changepass',
	permission => 'F',
	#help => 'Change_Password',
	icon => 'emblem-readonly.png',
	linktitle => 'Change your password.',
	});
    }
    if ($env{'environment.remote'} eq 'off') {
push(@{ $menu[1]->{items} }, {
        linktext => 'Launch Remote Control',
        url => '/adm/remote?url=/adm/preferences&amp;action=launch',
        permission => 'F',
        #help => '',
        icon => 'remotecontrol.png',
        linktitle => 'Launch the remote control for LON-CAPA.',
        });
    }else{
push(@{ $menu[1]->{items} }, {
        linktext => 'Collapse Remote Control',
        url => '/adm/remote?url=/adm/preferences&amp;action=collapse',
        permission => 'F',
        #help => '',
        icon => 'remotecontrol.png',
        linktitle => 'Collapse the remote control for LON-CAPA.',
        });
    }


    if (&can_toggle_namelocking()) {
        push(@{ $menu[0]->{items} }, {
        linktext => 'Automatic name changes',
        url => '/adm/preferences?action=changelockednames',
        permission => 'F',
        #help => '',
        icon => 'system-lock-screen.png',
        linktitle => 'Allow/disallow propagation of name changes from institutional directory service',
        });
    }

    my %author_roles = &Apache::lonnet::get_my_roles($user,$domain,'userroles','',['au']);
    if (keys(%author_roles) > 0) {
push(@{ $menu[4]->{items} }, {
	linktext => 'Restrict Domain Coordinator Access',
	url => '/adm/preferences?action=changedomcoord',
	permission => 'F',
	#help => '',
	icon => 'system-lock-screen.png',
	linktitle => 'Restrict domain coordinator access.',
	});
    }

    if (&Apache::lonnet::allowed('whn',$env{'request.course.id'})
	|| &Apache::lonnet::allowed('whn',$env{'request.course.id'}.'/'
				    .$env{'request.course.sec'})) {
push(@{ $menu[4]->{items} }, {
	linktext => 'Course Initialization',
	url => '/adm/preferences?action=changecourseinit',
	permission => 'F',
	#help => '',
	icon => 'course_ini.png',
	linktitle => 'Set the default page to be displayed when you select a course role.',
	});

    }
    if (&can_toggle_debug()) {
push(@{ $menu[4]->{items} }, {
	linktext => 'Toggle Debug Messages (Currently '.($env{'user.debug'} ? 'on)' : 'off)'),
	url => '/adm/preferences?action=debugtoggle',
	permission => 'F',
	#help => '',
	icon => 'blog.png',
	linktitle => 'Toggle Debug Messages.',
	});
    }

    $r->print(&Apache::loncommon::start_page('My Space'));
    $r->print(Apache::lonhtmlcommon::breadcrumbs('Change Preferences'));
    $r->print($message);
    $r->print(Apache::lonhtmlcommon::generate_menu(@menu));
    $r->print(Apache::loncommon::end_page());
}

######################################################
#            other handler subroutines               #
######################################################

################################################################
#                          Main handler                        #
################################################################
sub handler {    
    my $r = shift;
    Apache::loncommon::content_type($r,'text/html');
    # Some pages contain DES keys and should not be cached.
    Apache::loncommon::no_cache($r);
    $r->send_http_header;
    return OK if $r->header_only;
    #
    Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                                   ['action','wysiwyg','returnurl','refpage']);
    #
    Apache::lonhtmlcommon::clear_breadcrumbs();
    Apache::lonhtmlcommon::add_breadcrumb
        ({href => '/adm/preferences',
          text => 'Set User Preferences',
          help =>
          'Prefs_About_Me,Prefs_Language,Prefs_Screen_Name_Nickname,Change_Colors,Change_Password,Prefs_Messages,Change_Discussion_Display'});
    if(!exists $env{'form.action'}) {
	    &print_main_menu($r);
    }elsif($env{'form.action'} eq 'changepass'){
        &passwordchanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_pass'){
        &verify_and_change_password($r);
    }elsif($env{'form.action'} eq 'changescreenname'){
        &screennamechanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_screenname'){
        &verify_and_change_screenname($r);
    }elsif($env{'form.action'} eq 'changemsgforward'){
        &msgforwardchanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_msgforward'){
        &verify_and_change_msgforward($r);
    }elsif($env{'form.action'} eq 'changecolors'){
        &colorschanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_colors'){
        &verify_and_change_colors($r);
    }elsif($env{'form.action'} eq 'changelanguages'){
        &languagechanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_languages'){
        &verify_and_change_languages($r);
    }elsif($env{'form.action'} eq 'changewysiwyg'){
        &wysiwygchanger($r);
    }elsif($env{'form.action'} eq 'set_wysiwyg'){
        &verify_and_change_wysiwyg($r);
    }elsif($env{'form.action'} eq 'changediscussions'){
        &discussionchanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_discussion'){
        &verify_and_change_discussion($r);
    }elsif($env{'form.action'} eq 'changerolespref'){
        &rolesprefchanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_rolespref'){
        &verify_and_change_rolespref($r);
    }elsif($env{'form.action'} eq 'changetexenginepref'){
        &texenginechanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_texengine'){
        &verify_and_change_texengine($r);
    }elsif($env{'form.action'} eq 'changeclicker'){
        &clickerchanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_clicker'){
        &verify_and_change_clicker($r);
    }elsif($env{'form.action'} eq 'changedomcoord'){
        &domcoordchanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_domcoord'){
        &verify_and_change_domcoord($r);
    }elsif($env{'form.action'} eq 'lockwarning'){
        &lockwarning($r);
    }elsif($env{'form.action'} eq 'verify_and_change_locks'){
        &verify_and_change_lockwarning($r);
    }elsif($env{'form.action'} eq 'changecourseinit'){
        &coursedisplaychanger($r);
    }elsif($env{'form.action'} eq 'verify_and_change_coursepage'){
        &verify_and_change_coursepage($r);
    }elsif($env{'form.action'} eq 'debugtoggle'){
        if (&can_toggle_debug()) {
            &toggle_debug();
        }
	&print_main_menu($r);
    } elsif ($env{'form.action'} eq 'changelockednames') {
        &lockednameschanger($r);
    } elsif ($env{'form.action'} eq 'verify_and_change_lockednames') {
        &verify_and_change_lockednames($r);
    }

    # Properly end the HTML page of all preference pages
    # started in each sub routine
    # Exception: print_main_menu has its own end_page call
    unless (!exists $env{'form.action'} ||
            $env{'form.action'} eq 'debugtoggle') {
        $r->print(&Apache::loncommon::end_page());
    }

    return OK;
}

sub toggle_debug {
    if ($env{'user.debug'}) {
        &Apache::lonnet::delenv('user.debug');
    } else {
        &Apache::lonnet::appenv({'user.debug' => 1});
    }
}

sub can_toggle_debug {
    my $can_toggle = 0;
    my $page = 'toggledebug';
    if (&LONCAPA::lonauthcgi::can_view($page)) {
        $can_toggle = 1;
    } elsif (&LONCAPA::lonauthcgi::check_ipbased_access($page)) {
        $can_toggle = 1;
    }
    return $can_toggle;
}

sub can_toggle_namelocking {
    my $lockablenames;
    my %domconfig =
        &Apache::lonnet::get_dom('configuration',['autoupdate'],$env{'user.domain'});
    if (ref($domconfig{'autoupdate'}) eq 'HASH') {
        if ($domconfig{'autoupdate'}{'run'}) {
            my @inststatuses = split(':',$env{'environment.inststatus'});
            unless (@inststatuses) {
                @inststatuses = ('default');
            }
            my %updateable = &updateable_userinfo($domconfig{'autoupdate'},\@inststatuses);
            if ($updateable{'lastname'} || $updateable{'firstname'} ||
                $updateable{'middlename'}) { 
                if (ref($domconfig{'autoupdate'}{'lockablenames'}) eq 'ARRAY') {
                    unless (@inststatuses) {
                        @inststatuses = ('default');
                    }
                    foreach my $status (@inststatuses) {
                        if (grep(/^\Q$status\E$/,@{$domconfig{'autoupdate'}{'lockablenames'}})) {
                            $lockablenames = 1;
                            last;
                        }
                    }
                }
            }
        }
    }
    return $lockablenames;
}

sub updateable_userinfo {
    my ($autoupdate,$inststatuses) = @_;
    my %updateable;
    return %updateable unless ((ref($autoupdate) eq 'HASH') && 
                               (ref($inststatuses) eq 'ARRAY'));
    if (ref($autoupdate->{'fields'}) eq 'HASH') {
        foreach my $status (@{$inststatuses}) {
            if (ref($autoupdate->{'fields'}{$status}) eq 'ARRAY') {
                foreach my $field (@{$autoupdate->{'fields'}{$status}}) {
                    $updateable{$field} = 1;
                }
            }
        }
    }
    return %updateable;
}

1;
__END__
