# The LearningOnline Network with CAPA
# Wrapper for external and binary files as standalone resources
#
# $Id: lonwrapper.pm,v 1.40 2011/01/03 14:19:41 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#


package Apache::lonwrapper;

use strict;
use Apache::Constants qw(:common);
use Apache::lonenc();
use Apache::lonnet;

# ================================================================ Main Handler
sub wrapper {
    my $url = shift;

    my $startpage =  Apache::loncommon::start_page('Menu',undef,
					  { 'force_register' =>1, 'bgcolor'   => '#FFFFFF',}) ;
    my $endpage =  Apache::loncommon::end_page();

    my $script = Apache::lonhtmlcommon::scripttag(<<SCRIPT );
    \$(document).ready( function() {
        \$(window).unbind('resize').resize(function(){
            var header = \$('.LC_head_subbox')[0] ?  \$('.LC_head_subbox') 
                                                  :  \$('#LC_breadcrumbs');
            var pos = header.height() + header.position().top + 5;
            \$('.LC_iframecontainer').css('top', pos);
        });
    });
    window.onload = function(){  \$(window).trigger('resize') }; 
SCRIPT

    # javascript will position the iframe if window was resized (or zoomed)
    return <<ENDFRAME;
    $startpage
    $script
    <div class="LC_iframecontainer">
        <iframe src="$url">No iframe support!</iframe>
    </div>
    $endpage
ENDFRAME
}

sub handler {
    my $r=shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;

    return OK if $r->header_only;

    my $url = $r->uri;
    my $is_ext;

    for ($url){
        s|^/adm/wrapper||;
        $is_ext = $_ =~ s|^/ext/|http://|;         
        s|http://https://|https://|;
        s|&colon;|:|g;              
    }

#
# Actual URL
#
    if ($url=~/\.(problem|exam|quiz|assess|survey|form|library)$/) {
#
# This is uploaded homework
#
        $env{'request.state'}='uploaded';
        &Apache::lonhomework::renderpage($r,$url);
    } else {
#
# This is not homework
#
        if ($is_ext) {
            $ENV{'QUERY_STRING'} =~ s/(^|\&)symb=[^\&]*/$1/;
            $ENV{'QUERY_STRING'} =~ s/\&$//;  
        }

        unless ($ENV{'QUERY_STRING'} eq '') {
            $url.=(($url=~/\?/)?'&':'?').$ENV{'QUERY_STRING'};
        }

        # encrypt url if not external
        &Apache::lonenc::check_encrypt(\$url) if $url !~ /^https?\:/ ;

        $r->print( wrapper($url) );

    } # not just the menu
    
    return OK;
} # handler

1;
__END__

=pod

=head1 NAME

Apache::lonwrapper - External and binary file management.

=head1 SYNOPSIS

Wrapper for external and binary files as standalone resources. Edit handler for rat maps; TeX content handler.

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=head1 Subroutines

=over

=item wrapper($url)

Wraps $url in an iframe and generates a page for it.
Returns markup for the entire page.

=item handler()

=back

=cut







