/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public class Sheet
extends ProteinStructure {
    AminoPolymer aminoPolymer;
    Vector3f widthUnitVector;
    Vector3f heightUnitVector;

    Sheet(AminoPolymer aminoPolymer, int n, int n2) {
        super(aminoPolymer, (byte)2, n, n2);
        this.aminoPolymer = aminoPolymer;
    }

    public void calcAxis() {
        if (this.axisA != null) {
            return;
        }
        if (this.monomerCount == 2) {
            this.axisA = this.aminoPolymer.getLeadPoint(this.monomerIndexFirst);
            this.axisB = this.aminoPolymer.getLeadPoint(this.monomerIndexFirst + 1);
        } else {
            this.axisA = new Point3f();
            this.aminoPolymer.getLeadMidPoint(this.monomerIndexFirst + 1, this.axisA);
            this.axisB = new Point3f();
            this.aminoPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount - 1, this.axisB);
        }
        this.axisUnitVector = new Vector3f();
        this.axisUnitVector.sub((Tuple3f)this.axisB, (Tuple3f)this.axisA);
        this.axisUnitVector.normalize();
        Point3f point3f = new Point3f();
        this.aminoPolymer.getLeadMidPoint(this.monomerIndexFirst, point3f);
        if (!this.lowerNeighborIsHelixOrSheet()) {
            Graphics3D.projectOntoAxis((Point3f)point3f, (Point3f)this.axisA, (Vector3f)this.axisUnitVector, (Vector3f)this.vectorProjection);
        }
        Point3f point3f2 = new Point3f();
        this.aminoPolymer.getLeadMidPoint(this.monomerIndexFirst + this.monomerCount, point3f2);
        if (!this.upperNeighborIsHelixOrSheet()) {
            Graphics3D.projectOntoAxis((Point3f)point3f2, (Point3f)this.axisA, (Vector3f)this.axisUnitVector, (Vector3f)this.vectorProjection);
        }
        this.axisA = point3f;
        this.axisB = point3f2;
    }

    void calcSheetUnitVectors() {
        if (this.widthUnitVector == null) {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            AminoMonomer aminoMonomer = (AminoMonomer)this.aminoPolymer.monomers[this.monomerIndexFirst];
            vector3f2.sub((Tuple3f)aminoMonomer.getCarbonylOxygenAtomPoint(), (Tuple3f)aminoMonomer.getCarbonylCarbonAtomPoint());
            int n = this.monomerCount;
            while (--n > 0) {
                aminoMonomer = (AminoMonomer)this.aminoPolymer.monomers[n];
                vector3f.sub((Tuple3f)aminoMonomer.getCarbonylOxygenAtomPoint(), (Tuple3f)aminoMonomer.getCarbonylCarbonAtomPoint());
                if (vector3f2.angle(vector3f) < 1.5707964f) {
                    vector3f2.add((Tuple3f)vector3f);
                    continue;
                }
                vector3f2.sub((Tuple3f)vector3f);
            }
            this.heightUnitVector = vector3f;
            this.heightUnitVector.cross(this.axisUnitVector, vector3f2);
            this.heightUnitVector.normalize();
            this.widthUnitVector = vector3f2;
            this.widthUnitVector.cross(this.axisUnitVector, this.heightUnitVector);
        }
    }

    public Vector3f getWidthUnitVector() {
        if (this.widthUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.widthUnitVector;
    }

    public Vector3f getHeightUnitVector() {
        if (this.heightUnitVector == null) {
            this.calcSheetUnitVectors();
        }
        return this.heightUnitVector;
    }
}

