/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.e.g;
import edu.jas.e.p;
import edu.jas.e.q;
import edu.jas.poly.AlgebraicNumber;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AlgebraicNumberRing
implements q {
    public final GenPolynomialRing a;
    public final GenPolynomial a;
    protected int a = -1;

    public AlgebraicNumberRing(GenPolynomial genPolynomial) {
        this.a = genPolynomial.a;
        this.a = genPolynomial;
        if (this.a.a > 1) {
            throw new IllegalArgumentException("only univariate polynomials allowed");
        }
    }

    public AlgebraicNumberRing(GenPolynomial genPolynomial, boolean bl2) {
        this.a = genPolynomial.a;
        this.a = genPolynomial;
        int n2 = this.a = bl2 ? 1 : 0;
        if (this.a.a > 1) {
            throw new IllegalArgumentException("only univariate polynomials allowed");
        }
    }

    public GenPolynomial getModul() {
        return this.a;
    }

    public AlgebraicNumber copy(AlgebraicNumber algebraicNumber) {
        return new AlgebraicNumber(this, algebraicNumber.a);
    }

    public AlgebraicNumber getZERO() {
        return new AlgebraicNumber(this, this.a.getZERO());
    }

    public AlgebraicNumber getONE() {
        return new AlgebraicNumber(this, this.a.getONE());
    }

    public AlgebraicNumber getGenerator() {
        return new AlgebraicNumber(this, this.a.univariate(0));
    }

    public List generators() {
        List list = this.a.generators();
        ArrayList<AlgebraicNumber> arrayList = new ArrayList<AlgebraicNumber>(list.size());
        for (GenPolynomial genPolynomial : list) {
            arrayList.add(new AlgebraicNumber(this, genPolynomial));
        }
        return arrayList;
    }

    public boolean isFinite() {
        return this.a.a.isFinite();
    }

    public boolean isCommutative() {
        return this.a.isCommutative();
    }

    public boolean isAssociative() {
        return this.a.isAssociative();
    }

    public boolean isField() {
        if (this.a > 0) {
            return true;
        }
        if (this.a == 0) {
            return false;
        }
        if (!this.a.a.isField()) {
            this.a = 0;
            return false;
        }
        return false;
    }

    public void setField(boolean bl2) {
        if (this.a > 0 && bl2) {
            return;
        }
        if (this.a == 0 && !bl2) {
            return;
        }
        this.a = bl2 ? 1 : 0;
    }

    public int getField() {
        return this.a;
    }

    public BigInteger characteristic() {
        return this.a.characteristic();
    }

    public AlgebraicNumber fromInteger(BigInteger bigInteger) {
        return new AlgebraicNumber(this, this.a.fromInteger(bigInteger));
    }

    public AlgebraicNumber fromInteger(long l2) {
        return new AlgebraicNumber(this, this.a.fromInteger(l2));
    }

    public String toString() {
        return "AlgebraicNumberRing[ " + this.a.toString() + " | isField=" + this.a + " :: " + this.a.toString() + " ]";
    }

    public String toScript() {
        return "AN(" + this.a.toScript() + ")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlgebraicNumberRing)) {
            return false;
        }
        AlgebraicNumberRing algebraicNumberRing = null;
        try {
            algebraicNumberRing = (AlgebraicNumberRing)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (algebraicNumberRing == null) {
            return false;
        }
        return this.a.equals(algebraicNumberRing.a);
    }

    public int hashCode() {
        return 37 * this.a.hashCode() + this.a.hashCode();
    }

    public AlgebraicNumber random(int n2) {
        GenPolynomial genPolynomial = this.a.random(n2).monic();
        return new AlgebraicNumber(this, genPolynomial);
    }

    public AlgebraicNumber random(int n2, Random random) {
        GenPolynomial genPolynomial = this.a.random(n2, random).monic();
        return new AlgebraicNumber(this, genPolynomial);
    }

    public AlgebraicNumber parse(String string) {
        GenPolynomial genPolynomial = this.a.parse(string);
        return new AlgebraicNumber(this, genPolynomial);
    }

    public AlgebraicNumber parse(Reader reader) {
        GenPolynomial genPolynomial = this.a.parse(reader);
        return new AlgebraicNumber(this, genPolynomial);
    }

    public AlgebraicNumber chineseRemainder(AlgebraicNumber algebraicNumber, AlgebraicNumber algebraicNumber2, AlgebraicNumber algebraicNumber3) {
        AlgebraicNumber algebraicNumber4;
        AlgebraicNumber algebraicNumber5;
        if (algebraicNumber.a.a.compareTo(algebraicNumber3.a.a) < 1) {
            System.out.println("AlgebraicNumber error " + algebraicNumber + ", " + algebraicNumber3);
        }
        if ((algebraicNumber5 = algebraicNumber3.subtract(algebraicNumber4 = new AlgebraicNumber(algebraicNumber3.a, algebraicNumber.a))).isZERO()) {
            return new AlgebraicNumber(this, algebraicNumber.a);
        }
        algebraicNumber4 = algebraicNumber5.multiply(algebraicNumber2);
        GenPolynomial genPolynomial = algebraicNumber.a.a.multiply(algebraicNumber4.a);
        genPolynomial = genPolynomial.sum(algebraicNumber.a);
        return new AlgebraicNumber(this, genPolynomial);
    }

    public AlgebraicNumber interpolate(AlgebraicNumber algebraicNumber, g g2, g g3, g g4) {
        g g5 = (g)PolyUtil.evaluateMain(this.a.a, algebraicNumber.a, (p)g3);
        g g6 = (g)g4.subtract(g5);
        if (g6.isZERO()) {
            return new AlgebraicNumber(this, algebraicNumber.a);
        }
        g5 = (g)g6.multiply(g2);
        GenPolynomial genPolynomial = algebraicNumber.a.a.multiply(g5);
        genPolynomial = genPolynomial.sum(algebraicNumber.a);
        return new AlgebraicNumber(this, genPolynomial);
    }

    public int depth() {
        AlgebraicNumberRing algebraicNumberRing = this;
        int n2 = 1;
        q q2 = algebraicNumberRing.a.a;
        if (q2 instanceof AlgebraicNumberRing) {
            algebraicNumberRing = (AlgebraicNumberRing)q2;
            n2 += algebraicNumberRing.depth();
        }
        return n2;
    }

    public long extensionDegree() {
        long l2 = this.a.degree(0);
        return l2;
    }

    public long totalExtensionDegree() {
        long l2 = this.a.degree(0);
        AlgebraicNumberRing algebraicNumberRing = this;
        q q2 = algebraicNumberRing.a.a;
        if (q2 instanceof AlgebraicNumberRing) {
            algebraicNumberRing = (AlgebraicNumberRing)q2;
            l2 = l2 == 0L ? algebraicNumberRing.totalExtensionDegree() : (l2 *= algebraicNumberRing.totalExtensionDegree());
        }
        return l2;
    }
}

