/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ExpVectorByte
extends ExpVector {
    final byte[] a;
    public static long a = 63L;
    public static long b = -64L;

    public ExpVectorByte(int n2) {
        this(new byte[n2]);
    }

    public ExpVectorByte(int n2, int n3, byte by2) {
        this(n2);
        this.a[n3] = by2;
    }

    public ExpVectorByte(int n2, int n3, long l2) {
        this(n2);
        if (l2 >= a || l2 <= b) {
            throw new IllegalArgumentException("exponent to large: " + l2);
        }
        this.a[n3] = (byte)l2;
    }

    protected ExpVectorByte(byte[] byArray) {
        this.a = byArray;
    }

    public ExpVectorByte(long[] lArray) {
        this(lArray.length);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (lArray[i2] >= a || lArray[i2] <= b) {
                throw new IllegalArgumentException("exponent to large: " + lArray[i2]);
            }
            this.a[i2] = (byte)lArray[i2];
        }
    }

    public ExpVectorByte(String string) {
        Vector<Byte> vector = new Vector<Byte>();
        string = string.trim();
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41, n2 + 1);
        if (n2 >= 0 && n3 >= 0) {
            byte by2;
            String string2;
            int n4;
            ++n2;
            while ((n4 = string.indexOf(44, n2)) >= 0) {
                string2 = string.substring(n2, n4);
                by2 = Byte.parseByte(string2);
                vector.add(new Byte(by2));
                n2 = n4 + 1;
            }
            if (n2 <= n3) {
                string2 = string.substring(n2, n3);
                by2 = Byte.parseByte(string2);
                vector.add(new Byte(by2));
            }
            int n5 = vector.size();
            this.a = new byte[n5];
            for (int i2 = 0; i2 < n5; ++i2) {
                this.a[i2] = (Byte)vector.elementAt(i2);
            }
        } else {
            this.a = null;
        }
    }

    public ExpVectorByte clone() {
        byte[] byArray = new byte[this.a.length];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        return new ExpVectorByte(byArray);
    }

    long[] getVal() {
        long[] lArray = new long[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            lArray[i2] = this.a[i2];
        }
        return lArray;
    }

    public long getVal(int n2) {
        return this.a[n2];
    }

    protected long setVal(int n2, long l2) {
        byte by2 = this.a[n2];
        if (l2 >= a || l2 <= b) {
            throw new IllegalArgumentException("exponent to large: " + l2);
        }
        this.a[n2] = (byte)l2;
        this.a = (byte[])false;
        return by2;
    }

    protected byte setVal(int n2, byte by2) {
        byte by3 = this.a[n2];
        this.a[n2] = by2;
        this.a = (byte[])false;
        return by3;
    }

    public int length() {
        return this.a.length;
    }

    public ExpVectorByte extend(int n2, int n3, long l2) {
        byte[] byArray = new byte[this.a.length + n2];
        System.arraycopy(this.a, 0, byArray, n2, this.a.length);
        if (n3 >= n2) {
            throw new RuntimeException("i " + n2 + " <= j " + n3 + " invalid");
        }
        if (l2 >= a || l2 <= b) {
            throw new IllegalArgumentException("exponent to large: " + l2);
        }
        byArray[n3] = (byte)l2;
        return new ExpVectorByte(byArray);
    }

    public ExpVectorByte extendLower(int n2, int n3, long l2) {
        byte[] byArray = new byte[this.a.length + n2];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        if (n3 >= n2) {
            throw new RuntimeException("i " + n2 + " <= j " + n3 + " invalid");
        }
        byArray[this.a.length + n3] = (byte)l2;
        return new ExpVectorByte(byArray);
    }

    public ExpVectorByte contract(int n2, int n3) {
        if (n2 + n3 > this.a.length) {
            throw new RuntimeException("len " + n3 + " > val.len " + this.a.length);
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.a, n2, byArray, 0, n3);
        return new ExpVectorByte(byArray);
    }

    public ExpVectorByte reverse() {
        byte[] byArray = new byte[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            byArray[i2] = this.a[this.a.length - 1 - i2];
        }
        return new ExpVectorByte(byArray);
    }

    public ExpVectorByte reverse(int n2) {
        int n3;
        if (n2 <= 0 || n2 > this.a.length) {
            return this;
        }
        byte[] byArray = new byte[this.a.length];
        for (n3 = 0; n3 < n2; ++n3) {
            byArray[n3] = this.a[n2 - 1 - n3];
        }
        for (n3 = n2; n3 < this.a.length; ++n3) {
            byArray[n3] = this.a[n3];
        }
        return new ExpVectorByte(byArray);
    }

    public ExpVectorByte combine(ExpVector expVector) {
        if (expVector == null || expVector.length() == 0) {
            return this;
        }
        ExpVectorByte expVectorByte = (ExpVectorByte)expVector;
        if (this.a.length == 0) {
            return expVectorByte;
        }
        byte[] byArray = new byte[this.a.length + expVectorByte.a.length];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        System.arraycopy(expVectorByte.a, 0, byArray, this.a.length, expVectorByte.a.length);
        return new ExpVectorByte(byArray);
    }

    public String toString() {
        return super.toString() + ":byte";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExpVectorByte)) {
            return false;
        }
        ExpVectorByte expVectorByte = (ExpVectorByte)object;
        int n2 = this.invLexCompareTo(expVectorByte);
        return 0 == n2;
    }

    public ExpVectorByte abs() {
        byte[] byArray = this.a;
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = (long)byArray[i2] >= 0L ? byArray[i2] : (byte)(-byArray[i2]);
        }
        return new ExpVectorByte(byArray2);
    }

    public ExpVectorByte negate() {
        byte[] byArray = this.a;
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray2[i2] = -byArray[i2];
        }
        return new ExpVectorByte(byArray2);
    }

    public ExpVectorByte sum(ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] + byArray2[i2]);
        }
        return new ExpVectorByte(byArray3);
    }

    public ExpVectorByte subtract(ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = (byte)(byArray[i2] - byArray2[i2]);
        }
        return new ExpVectorByte(byArray3);
    }

    public ExpVectorByte subst(int n2, byte by2) {
        ExpVectorByte expVectorByte = this.clone();
        long l2 = expVectorByte.setVal(n2, by2);
        return expVectorByte;
    }

    public ExpVectorByte subst(int n2, long l2) {
        ExpVectorByte expVectorByte = this.clone();
        long l3 = expVectorByte.setVal(n2, l2);
        return expVectorByte;
    }

    public int signum() {
        int n2 = 0;
        byte[] byArray = this.a;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] < 0) {
                return -1;
            }
            if (byArray[i2] <= 0) continue;
            n2 = 1;
        }
        return n2;
    }

    public long totalDeg() {
        long l2 = 0L;
        byte[] byArray = this.a;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            l2 += (long)byArray[i2];
        }
        return l2;
    }

    public long maxDeg() {
        long l2 = 0L;
        byte[] byArray = this.a;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if ((long)byArray[i2] <= l2) continue;
            l2 = byArray[i2];
        }
        return l2;
    }

    public long weightDeg(long[][] lArray) {
        if (lArray == null || lArray.length == 0) {
            return this.totalDeg();
        }
        long l2 = 0L;
        byte[] byArray = this.a;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long[] lArray2 = lArray[i2];
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                l2 += lArray2[i3] * (long)byArray[i3];
            }
        }
        return l2;
    }

    public ExpVectorByte lcm(ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = byArray[i2] >= byArray2[i2] ? byArray[i2] : byArray2[i2];
        }
        return new ExpVectorByte(byArray3);
    }

    public ExpVectorByte gcd(ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        byte[] byArray3 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray3[i2] = byArray[i2] <= byArray2[i2] ? byArray[i2] : byArray2[i2];
        }
        return new ExpVectorByte(byArray3);
    }

    public int[] dependencyOnVariables() {
        byte[] byArray = this.a;
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] <= 0) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        if (n2 == 0) {
            return nArray;
        }
        int n3 = 0;
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            if (byArray[i3] <= 0) continue;
            nArray[n3] = i3;
            ++n3;
        }
        return nArray;
    }

    public boolean multipleOf(ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        boolean bl2 = true;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] >= byArray2[i2]) continue;
            return false;
        }
        return bl2;
    }

    public int compareTo(ExpVector expVector) {
        return this.invLexCompareTo(expVector);
    }

    public int invLexCompareTo(ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] > byArray2[i2]) {
                return 1;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            return -1;
        }
        return n2;
    }

    public int invLexCompareTo(ExpVector expVector, int n2, int n3) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (byArray[i2] > byArray2[i2]) {
                return 1;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            return -1;
        }
        return n4;
    }

    public int invGradCompareTo(ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] > byArray2[i2]) {
                n2 = 1;
                break;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            n2 = -1;
            break;
        }
        if (n2 == 0) {
            return n2;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (int i3 = i2; i3 < byArray.length; ++i3) {
            l2 += (long)byArray[i3];
            l3 += (long)byArray2[i3];
        }
        if (l2 > l3) {
            n2 = 1;
        } else if (l2 < l3) {
            n2 = -1;
        }
        return n2;
    }

    public int invGradCompareTo(ExpVector expVector, int n2, int n3) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (byArray[i2] > byArray2[i2]) {
                n4 = 1;
                break;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            n4 = -1;
            break;
        }
        if (n4 == 0) {
            return n4;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (int i3 = i2; i3 < n3; ++i3) {
            l2 += (long)byArray[i3];
            l3 += (long)byArray2[i3];
        }
        if (l2 > l3) {
            n4 = 1;
        } else if (l2 < l3) {
            n4 = -1;
        }
        return n4;
    }

    public int revInvLexCompareTo(ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n2 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            if (byArray[i2] > byArray2[i2]) {
                return 1;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            return -1;
        }
        return n2;
    }

    public int revInvLexCompareTo(ExpVector expVector, int n2, int n3) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n4 = 0;
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (byArray[i2] > byArray2[i2]) {
                return 1;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            return -1;
        }
        return n4;
    }

    public int revInvGradCompareTo(ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n2 = 0;
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            if (byArray[i2] > byArray2[i2]) {
                n2 = 1;
                break;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            n2 = -1;
            break;
        }
        if (n2 == 0) {
            return n2;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (int i3 = i2; i3 >= 0; --i3) {
            l2 += (long)byArray[i3];
            l3 += (long)byArray2[i3];
        }
        if (l2 > l3) {
            n2 = 1;
        } else if (l2 < l3) {
            n2 = -1;
        }
        return n2;
    }

    public int revInvGradCompareTo(ExpVector expVector, int n2, int n3) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n4 = 0;
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (byArray[i2] > byArray2[i2]) {
                n4 = 1;
                break;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            n4 = -1;
            break;
        }
        if (n4 == 0) {
            return n4;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (int i3 = i2; i3 >= n2; --i3) {
            l2 += (long)byArray[i3];
            l3 += (long)byArray2[i3];
        }
        if (l2 > l3) {
            n4 = 1;
        } else if (l2 < l3) {
            n4 = -1;
        }
        return n4;
    }

    public int invWeightCompareTo(long[][] lArray, ExpVector expVector) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n2 = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] > byArray2[i2]) {
                n2 = 1;
                break;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            n2 = -1;
            break;
        }
        if (n2 == 0) {
            return n2;
        }
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            long[] lArray2 = lArray[i3];
            long l2 = 0L;
            long l3 = 0L;
            for (int i4 = i2; i4 < byArray.length; ++i4) {
                l2 += lArray2[i4] * (long)byArray[i4];
                l3 += lArray2[i4] * (long)byArray2[i4];
            }
            if (l2 > l3) {
                return 1;
            }
            if (l2 >= l3) continue;
            return -1;
        }
        return n2;
    }

    public int invWeightCompareTo(long[][] lArray, ExpVector expVector, int n2, int n3) {
        byte[] byArray = this.a;
        byte[] byArray2 = ((ExpVectorByte)expVector).a;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (byArray[i2] > byArray2[i2]) {
                n4 = 1;
                break;
            }
            if (byArray[i2] >= byArray2[i2]) continue;
            n4 = -1;
            break;
        }
        if (n4 == 0) {
            return n4;
        }
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            long[] lArray2 = lArray[i3];
            long l2 = 0L;
            long l3 = 0L;
            for (int i4 = i2; i4 < n3; ++i4) {
                l2 += lArray2[i4] * (long)byArray[i4];
                l3 += lArray2[i4] * (long)byArray2[i4];
            }
            if (l2 > l3) {
                return 1;
            }
            if (l2 >= l3) continue;
            return -1;
        }
        return n4;
    }
}

