/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ExpVectorShort
extends ExpVector {
    final short[] a;
    public static long a = 16383L;
    public static long b = -16384L;

    public ExpVectorShort(int n2) {
        this(new short[n2]);
    }

    public ExpVectorShort(int n2, int n3, short s2) {
        this(n2);
        this.a[n3] = s2;
    }

    public ExpVectorShort(int n2, int n3, long l2) {
        this(n2);
        if (l2 >= a || l2 <= b) {
            throw new IllegalArgumentException("exponent to large: " + l2);
        }
        this.a[n3] = (short)l2;
    }

    protected ExpVectorShort(short[] sArray) {
        this.a = sArray;
    }

    public ExpVectorShort(long[] lArray) {
        this(lArray.length);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (lArray[i2] >= a || lArray[i2] <= b) {
                throw new IllegalArgumentException("exponent to large: " + lArray[i2]);
            }
            this.a[i2] = (short)lArray[i2];
        }
    }

    public ExpVectorShort(String string) {
        Vector<Short> vector = new Vector<Short>();
        string = string.trim();
        int n2 = string.indexOf(40);
        int n3 = string.indexOf(41, n2 + 1);
        if (n2 >= 0 && n3 >= 0) {
            short s2;
            String string2;
            int n4;
            ++n2;
            while ((n4 = string.indexOf(44, n2)) >= 0) {
                string2 = string.substring(n2, n4);
                s2 = Short.parseShort(string2);
                vector.add(new Short(s2));
                n2 = n4 + 1;
            }
            if (n2 <= n3) {
                string2 = string.substring(n2, n3);
                s2 = Short.parseShort(string2);
                vector.add(new Short(s2));
            }
            int n5 = vector.size();
            this.a = new short[n5];
            for (int i2 = 0; i2 < n5; ++i2) {
                this.a[i2] = (Short)vector.elementAt(i2);
            }
        } else {
            this.a = null;
        }
    }

    public ExpVectorShort clone() {
        short[] sArray = new short[this.a.length];
        System.arraycopy(this.a, 0, sArray, 0, this.a.length);
        return new ExpVectorShort(sArray);
    }

    long[] getVal() {
        long[] lArray = new long[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            lArray[i2] = this.a[i2];
        }
        return lArray;
    }

    public long getVal(int n2) {
        return this.a[n2];
    }

    protected long setVal(int n2, long l2) {
        short s2 = this.a[n2];
        if (l2 >= a || l2 <= b) {
            throw new IllegalArgumentException("exponent to large: " + l2);
        }
        this.a[n2] = (short)l2;
        this.a = (short[])false;
        return s2;
    }

    protected short setVal(int n2, short s2) {
        short s3 = this.a[n2];
        this.a[n2] = s2;
        this.a = (short[])false;
        return s3;
    }

    public int length() {
        return this.a.length;
    }

    public ExpVectorShort extend(int n2, int n3, long l2) {
        short[] sArray = new short[this.a.length + n2];
        System.arraycopy(this.a, 0, sArray, n2, this.a.length);
        if (n3 >= n2) {
            throw new RuntimeException("i " + n2 + " <= j " + n3 + " invalid");
        }
        if (l2 >= a || l2 <= b) {
            throw new IllegalArgumentException("exponent to large: " + l2);
        }
        sArray[n3] = (short)l2;
        return new ExpVectorShort(sArray);
    }

    public ExpVectorShort extendLower(int n2, int n3, long l2) {
        short[] sArray = new short[this.a.length + n2];
        System.arraycopy(this.a, 0, sArray, 0, this.a.length);
        if (n3 >= n2) {
            throw new RuntimeException("i " + n2 + " <= j " + n3 + " invalid");
        }
        sArray[this.a.length + n3] = (short)l2;
        return new ExpVectorShort(sArray);
    }

    public ExpVectorShort contract(int n2, int n3) {
        if (n2 + n3 > this.a.length) {
            throw new RuntimeException("len " + n3 + " > val.len " + this.a.length);
        }
        short[] sArray = new short[n3];
        System.arraycopy(this.a, n2, sArray, 0, n3);
        return new ExpVectorShort(sArray);
    }

    public ExpVectorShort reverse() {
        short[] sArray = new short[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            sArray[i2] = this.a[this.a.length - 1 - i2];
        }
        return new ExpVectorShort(sArray);
    }

    public ExpVectorShort reverse(int n2) {
        int n3;
        if (n2 <= 0 || n2 > this.a.length) {
            return this;
        }
        short[] sArray = new short[this.a.length];
        for (n3 = 0; n3 < n2; ++n3) {
            sArray[n3] = this.a[n2 - 1 - n3];
        }
        for (n3 = n2; n3 < this.a.length; ++n3) {
            sArray[n3] = this.a[n3];
        }
        return new ExpVectorShort(sArray);
    }

    public ExpVectorShort combine(ExpVector expVector) {
        if (expVector == null || expVector.length() == 0) {
            return this;
        }
        ExpVectorShort expVectorShort = (ExpVectorShort)expVector;
        if (this.a.length == 0) {
            return expVectorShort;
        }
        short[] sArray = new short[this.a.length + expVectorShort.a.length];
        System.arraycopy(this.a, 0, sArray, 0, this.a.length);
        System.arraycopy(expVectorShort.a, 0, sArray, this.a.length, expVectorShort.a.length);
        return new ExpVectorShort(sArray);
    }

    public String toString() {
        return super.toString() + ":short";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExpVectorShort)) {
            return false;
        }
        ExpVectorShort expVectorShort = (ExpVectorShort)object;
        int n2 = this.invLexCompareTo(expVectorShort);
        return 0 == n2;
    }

    public ExpVectorShort abs() {
        short[] sArray = this.a;
        short[] sArray2 = new short[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray2[i2] = (long)sArray[i2] >= 0L ? sArray[i2] : (short)(-sArray[i2]);
        }
        return new ExpVectorShort(sArray2);
    }

    public ExpVectorShort negate() {
        short[] sArray = this.a;
        short[] sArray2 = new short[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray2[i2] = -sArray[i2];
        }
        return new ExpVectorShort(sArray2);
    }

    public ExpVectorShort sum(ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        short[] sArray3 = new short[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray3[i2] = (short)(sArray[i2] + sArray2[i2]);
        }
        return new ExpVectorShort(sArray3);
    }

    public ExpVectorShort subtract(ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        short[] sArray3 = new short[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray3[i2] = (short)(sArray[i2] - sArray2[i2]);
        }
        return new ExpVectorShort(sArray3);
    }

    public ExpVectorShort subst(int n2, short s2) {
        ExpVectorShort expVectorShort = this.clone();
        long l2 = expVectorShort.setVal(n2, s2);
        return expVectorShort;
    }

    public ExpVectorShort subst(int n2, long l2) {
        ExpVectorShort expVectorShort = this.clone();
        long l3 = expVectorShort.setVal(n2, l2);
        return expVectorShort;
    }

    public int signum() {
        int n2 = 0;
        short[] sArray = this.a;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] < 0) {
                return -1;
            }
            if (sArray[i2] <= 0) continue;
            n2 = 1;
        }
        return n2;
    }

    public long totalDeg() {
        long l2 = 0L;
        short[] sArray = this.a;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            l2 += (long)sArray[i2];
        }
        return l2;
    }

    public long maxDeg() {
        long l2 = 0L;
        short[] sArray = this.a;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if ((long)sArray[i2] <= l2) continue;
            l2 = sArray[i2];
        }
        return l2;
    }

    public long weightDeg(long[][] lArray) {
        if (lArray == null || lArray.length == 0) {
            return this.totalDeg();
        }
        long l2 = 0L;
        short[] sArray = this.a;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long[] lArray2 = lArray[i2];
            for (int i3 = 0; i3 < sArray.length; ++i3) {
                l2 += lArray2[i3] * (long)sArray[i3];
            }
        }
        return l2;
    }

    public ExpVectorShort lcm(ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        short[] sArray3 = new short[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray3[i2] = sArray[i2] >= sArray2[i2] ? sArray[i2] : sArray2[i2];
        }
        return new ExpVectorShort(sArray3);
    }

    public ExpVectorShort gcd(ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        short[] sArray3 = new short[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sArray3[i2] = sArray[i2] <= sArray2[i2] ? sArray[i2] : sArray2[i2];
        }
        return new ExpVectorShort(sArray3);
    }

    public int[] dependencyOnVariables() {
        short[] sArray = this.a;
        int n2 = 0;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] <= 0) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        if (n2 == 0) {
            return nArray;
        }
        int n3 = 0;
        for (int i3 = 0; i3 < sArray.length; ++i3) {
            if (sArray[i3] <= 0) continue;
            nArray[n3] = i3;
            ++n3;
        }
        return nArray;
    }

    public boolean multipleOf(ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        boolean bl2 = true;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] >= sArray2[i2]) continue;
            return false;
        }
        return bl2;
    }

    public int compareTo(ExpVector expVector) {
        return this.invLexCompareTo(expVector);
    }

    public int invLexCompareTo(ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n2 = 0;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] > sArray2[i2]) {
                return 1;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            return -1;
        }
        return n2;
    }

    public int invLexCompareTo(ExpVector expVector, int n2, int n3) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (sArray[i2] > sArray2[i2]) {
                return 1;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            return -1;
        }
        return n4;
    }

    public int invGradCompareTo(ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n2 = 0;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] > sArray2[i2]) {
                n2 = 1;
                break;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            n2 = -1;
            break;
        }
        if (n2 == 0) {
            return n2;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (int i3 = i2; i3 < sArray.length; ++i3) {
            l2 += (long)sArray[i3];
            l3 += (long)sArray2[i3];
        }
        if (l2 > l3) {
            n2 = 1;
        } else if (l2 < l3) {
            n2 = -1;
        }
        return n2;
    }

    public int invGradCompareTo(ExpVector expVector, int n2, int n3) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (sArray[i2] > sArray2[i2]) {
                n4 = 1;
                break;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            n4 = -1;
            break;
        }
        if (n4 == 0) {
            return n4;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (int i3 = i2; i3 < n3; ++i3) {
            l2 += (long)sArray[i3];
            l3 += (long)sArray2[i3];
        }
        if (l2 > l3) {
            n4 = 1;
        } else if (l2 < l3) {
            n4 = -1;
        }
        return n4;
    }

    public int revInvLexCompareTo(ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n2 = 0;
        for (int i2 = sArray.length - 1; i2 >= 0; --i2) {
            if (sArray[i2] > sArray2[i2]) {
                return 1;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            return -1;
        }
        return n2;
    }

    public int revInvLexCompareTo(ExpVector expVector, int n2, int n3) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n4 = 0;
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (sArray[i2] > sArray2[i2]) {
                return 1;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            return -1;
        }
        return n4;
    }

    public int revInvGradCompareTo(ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n2 = 0;
        for (int i2 = sArray.length - 1; i2 >= 0; --i2) {
            if (sArray[i2] > sArray2[i2]) {
                n2 = 1;
                break;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            n2 = -1;
            break;
        }
        if (n2 == 0) {
            return n2;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (int i3 = i2; i3 >= 0; --i3) {
            l2 += (long)sArray[i3];
            l3 += (long)sArray2[i3];
        }
        if (l2 > l3) {
            n2 = 1;
        } else if (l2 < l3) {
            n2 = -1;
        }
        return n2;
    }

    public int revInvGradCompareTo(ExpVector expVector, int n2, int n3) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n4 = 0;
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (sArray[i2] > sArray2[i2]) {
                n4 = 1;
                break;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            n4 = -1;
            break;
        }
        if (n4 == 0) {
            return n4;
        }
        long l2 = 0L;
        long l3 = 0L;
        for (int i3 = i2; i3 >= n2; --i3) {
            l2 += (long)sArray[i3];
            l3 += (long)sArray2[i3];
        }
        if (l2 > l3) {
            n4 = 1;
        } else if (l2 < l3) {
            n4 = -1;
        }
        return n4;
    }

    public int invWeightCompareTo(long[][] lArray, ExpVector expVector) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n2 = 0;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] > sArray2[i2]) {
                n2 = 1;
                break;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            n2 = -1;
            break;
        }
        if (n2 == 0) {
            return n2;
        }
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            long[] lArray2 = lArray[i3];
            long l2 = 0L;
            long l3 = 0L;
            for (int i4 = i2; i4 < sArray.length; ++i4) {
                l2 += lArray2[i4] * (long)sArray[i4];
                l3 += lArray2[i4] * (long)sArray2[i4];
            }
            if (l2 > l3) {
                return 1;
            }
            if (l2 >= l3) continue;
            return -1;
        }
        return n2;
    }

    public int invWeightCompareTo(long[][] lArray, ExpVector expVector, int n2, int n3) {
        short[] sArray = this.a;
        short[] sArray2 = ((ExpVectorShort)expVector).a;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (sArray[i2] > sArray2[i2]) {
                n4 = 1;
                break;
            }
            if (sArray[i2] >= sArray2[i2]) continue;
            n4 = -1;
            break;
        }
        if (n4 == 0) {
            return n4;
        }
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            long[] lArray2 = lArray[i3];
            long l2 = 0L;
            long l3 = 0L;
            for (int i4 = i2; i4 < n3; ++i4) {
                l2 += lArray2[i4] * (long)sArray[i4];
                l3 += lArray2[i4] * (long)sArray2[i4];
            }
            if (l2 > l3) {
                return 1;
            }
            if (l2 >= l3) continue;
            return -1;
        }
        return n4;
    }
}

