/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.b.c;
import edu.jas.b.e;
import edu.jas.e.a;
import edu.jas.e.d;
import edu.jas.e.h;
import edu.jas.e.i;
import edu.jas.e.p;
import edu.jas.e.q;
import edu.jas.e.s;
import edu.jas.poly.AlgToPoly;
import edu.jas.poly.AlgebToCompl;
import edu.jas.poly.AlgebraicNumberRing;
import edu.jas.poly.CoeffToAlg;
import edu.jas.poly.CoeffToRecAlg;
import edu.jas.poly.CompRatToDec;
import edu.jas.poly.ComplToAlgeb;
import edu.jas.poly.DistToRec;
import edu.jas.poly.EvalMain;
import edu.jas.poly.ExpVector;
import edu.jas.poly.FromInteger;
import edu.jas.poly.FromIntegerPoly;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ImagPart;
import edu.jas.poly.ImagPartComplex;
import edu.jas.poly.ModSymToInt;
import edu.jas.poly.ModToInt;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyToAlg;
import edu.jas.poly.PolyUtil$1;
import edu.jas.poly.PolyUtil$2;
import edu.jas.poly.PolyUtil$3;
import edu.jas.poly.RatToCompl;
import edu.jas.poly.RatToDec;
import edu.jas.poly.RatToInt;
import edu.jas.poly.RatToIntFactor;
import edu.jas.poly.RatToIntPoly;
import edu.jas.poly.RealPart;
import edu.jas.poly.RealPartComplex;
import edu.jas.poly.RecToDist;
import edu.jas.poly.ToComplex;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PolyUtil {
    private static final org.a.b.a a = org.a.b.a.a(PolyUtil.class);
    private static boolean b = a.a();

    public static GenPolynomial recursive(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO().clone();
        if (genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        int n2 = genPolynomialRing.a;
        GenPolynomial genPolynomial3 = (GenPolynomial)genPolynomialRing.getZEROCoefficient();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            p p2 = (p)entry.getValue();
            ExpVector expVector2 = expVector.contract(0, n2);
            ExpVector expVector3 = expVector.contract(n2, expVector.length() - n2);
            GenPolynomial genPolynomial4 = (GenPolynomial)sortedMap.get(expVector2);
            if (genPolynomial4 == null) {
                genPolynomial4 = genPolynomial3;
            }
            genPolynomial4 = genPolynomial4.sum(p2, expVector3);
            sortedMap.put(expVector2, genPolynomial4);
        }
        return genPolynomial2;
    }

    public static GenPolynomial distribute(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO().clone();
        if (genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getValue();
            for (Map.Entry entry2 : genPolynomial3.a.entrySet()) {
                ExpVector expVector2 = (ExpVector)entry2.getKey();
                p p2 = (p)entry2.getValue();
                ExpVector expVector3 = expVector.combine(expVector2);
                assert (sortedMap.get(expVector3) != null);
                sortedMap.put(expVector3, p2);
            }
        }
        return genPolynomial2;
    }

    public static List recursive(GenPolynomialRing genPolynomialRing, List list) {
        return edu.jas.g.c.a(list, new DistToRec(genPolynomialRing));
    }

    public static List distribute(GenPolynomialRing genPolynomialRing, List list) {
        return edu.jas.g.c.a(list, new RecToDist(genPolynomialRing));
    }

    public static GenPolynomial integerFromModularCoefficients(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ModSymToInt());
    }

    public static List integerFromModularCoefficients(GenPolynomialRing genPolynomialRing, List list) {
        return edu.jas.g.c.a(list, new PolyUtil$1(genPolynomialRing));
    }

    public static GenPolynomial integerFromModularCoefficientsPositive(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ModToInt());
    }

    public static GenPolynomial integerFromRationalCoefficients(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing.getZERO();
        }
        BigInteger bigInteger = null;
        int n2 = 0;
        for (e e2 : genPolynomial.a.values()) {
            BigInteger bigInteger2 = e2.b();
            if (bigInteger == null) {
                bigInteger = bigInteger2;
                n2 = bigInteger2.signum();
                continue;
            }
            BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
            bigInteger = bigInteger.multiply(bigInteger2.divide(bigInteger3));
        }
        if (n2 < 0) {
            bigInteger = bigInteger.negate();
        }
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RatToInt(bigInteger));
    }

    public static Object[] integerFromRationalCoefficientsFactor(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        Object[] objectArray = new Object[3];
        if (genPolynomial == null || genPolynomial.isZERO()) {
            objectArray[0] = BigInteger.ONE;
            objectArray[1] = BigInteger.ZERO;
            objectArray[2] = genPolynomialRing.getZERO();
            return objectArray;
        }
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        int n2 = 0;
        int n3 = 0;
        for (e e2 : genPolynomial.a.values()) {
            BigInteger bigInteger3 = e2.a();
            BigInteger bigInteger4 = e2.b();
            if (bigInteger2 == null) {
                bigInteger2 = bigInteger4;
                n2 = bigInteger4.signum();
            } else {
                BigInteger bigInteger5 = bigInteger2.gcd(bigInteger4);
                bigInteger2 = bigInteger2.multiply(bigInteger4.divide(bigInteger5));
            }
            if (bigInteger == null) {
                bigInteger = bigInteger3;
                n3 = bigInteger3.signum();
                continue;
            }
            bigInteger = bigInteger.gcd(bigInteger3);
        }
        if (n2 < 0) {
            bigInteger2 = bigInteger2.negate();
        }
        if (n3 < 0) {
            bigInteger = bigInteger.negate();
        }
        objectArray[0] = bigInteger;
        objectArray[1] = bigInteger2;
        objectArray[2] = PolyUtil.map(genPolynomialRing, genPolynomial, new RatToIntFactor(bigInteger, bigInteger2));
        return objectArray;
    }

    public static List integerFromRationalCoefficients(GenPolynomialRing genPolynomialRing, List list) {
        return edu.jas.g.c.a(list, new RatToIntPoly(genPolynomialRing));
    }

    public static GenPolynomial fromIntegerCoefficients(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new FromInteger(genPolynomialRing.a));
    }

    public static List fromIntegerCoefficients(GenPolynomialRing genPolynomialRing, List list) {
        return edu.jas.g.c.a(list, new FromIntegerPoly(genPolynomialRing));
    }

    public static GenPolynomial decimalFromRational(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RatToDec());
    }

    public static GenPolynomial complexDecimalFromRational(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CompRatToDec(genPolynomialRing.a));
    }

    public static GenPolynomial realPart(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RealPart());
    }

    public static GenPolynomial imaginaryPart(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ImagPart());
    }

    public static GenPolynomial realPartFromComplex(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RealPartComplex());
    }

    public static GenPolynomial imaginaryPartFromComplex(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ImagPartComplex());
    }

    public static GenPolynomial toComplex(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ToComplex(genPolynomialRing.a));
    }

    public static GenPolynomial complexFromRational(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new RatToCompl());
    }

    public static GenPolynomial fromAlgebraicCoefficients(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        return PolyUtil.map(genPolynomialRing, genPolynomial, new AlgToPoly());
    }

    public static GenPolynomial convertToAlgebraicCoefficients(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.a;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToAlg(algebraicNumberRing));
    }

    public static GenPolynomial convertToRecAlgebraicCoefficients(int n2, GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.a;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new CoeffToRecAlg(n2, algebraicNumberRing));
    }

    public static GenPolynomial convertRecursiveToAlgebraicCoefficients(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.a;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new PolyToAlg(algebraicNumberRing));
    }

    public static GenPolynomial complexFromAlgebraic(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        d d2 = (d)genPolynomialRing.a;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new AlgebToCompl(d2));
    }

    public static GenPolynomial algebraicFromComplex(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        AlgebraicNumberRing algebraicNumberRing = (AlgebraicNumberRing)genPolynomialRing.a;
        return PolyUtil.map(genPolynomialRing, genPolynomial, new ComplToAlgeb(algebraicNumberRing));
    }

    public static GenPolynomial chineseRemainder(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial, p p2, GenPolynomial genPolynomial2) {
        p p3;
        h h2 = (h)genPolynomialRing.a;
        GenPolynomial genPolynomial3 = genPolynomialRing.getZERO().clone();
        GenPolynomial genPolynomial4 = genPolynomial.clone();
        SortedMap sortedMap = genPolynomial4.a;
        SortedMap sortedMap2 = genPolynomial2.getMap();
        SortedMap sortedMap3 = genPolynomial3.a;
        p p4 = null;
        for (ExpVector expVector : sortedMap2.keySet()) {
            p3 = (p)sortedMap.get(expVector);
            p p5 = (p)sortedMap2.get(expVector);
            if (p3 != null) {
                sortedMap.remove(expVector);
                p4 = h2.a(p3, p2, p5);
                if (p4.isZERO()) continue;
                sortedMap3.put(expVector, p4);
                continue;
            }
            p4 = h2.a((p)genPolynomial.a.a.getZERO(), p2, p5);
            if (p4.isZERO()) continue;
            sortedMap3.put(expVector, p4);
        }
        for (ExpVector expVector : sortedMap.keySet()) {
            p3 = (p)sortedMap.get(expVector);
            p4 = h2.a(p3, p2, (p)genPolynomial2.a.a.getZERO());
            if (p4.isZERO()) continue;
            sortedMap3.put(expVector, p4);
        }
        return genPolynomial3;
    }

    public static GenPolynomial monic(GenPolynomial genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        p p2 = ((GenPolynomial)genPolynomial.leadingBaseCoefficient()).leadingBaseCoefficient();
        if (!p2.isUnit()) {
            return genPolynomial;
        }
        p p3 = (p)p2.inverse();
        GenPolynomial genPolynomial2 = (GenPolynomial)genPolynomial.a.a.getONE();
        genPolynomial2 = genPolynomial2.multiply(p3);
        return genPolynomial.multiply((p)genPolynomial2);
    }

    public static List monic(List list) {
        return edu.jas.g.c.a(list, new PolyUtil$2());
    }

    public static List leadingExpVector(List list) {
        return edu.jas.g.c.a(list, new PolyUtil$3());
    }

    public static GenPolynomial extendCoefficients(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial, int n2, long l2) {
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO().clone();
        if (genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.a;
        GenPolynomialRing genPolynomialRing3 = (GenPolynomialRing)genPolynomial.a.a;
        int n3 = genPolynomialRing2.a - genPolynomialRing3.a;
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : genPolynomial.a.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getValue();
            GenPolynomial genPolynomial4 = genPolynomial3.extend(genPolynomialRing2, n2, l2);
            sortedMap.put(expVector, genPolynomial4);
        }
        return genPolynomial2;
    }

    public static GenPolynomial toRecursive(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial) {
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO().clone();
        if (genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        int n2 = genPolynomialRing.a;
        GenPolynomial genPolynomial3 = (GenPolynomial)genPolynomialRing.getZEROCoefficient();
        GenPolynomial genPolynomial4 = (GenPolynomial)genPolynomialRing.getONECoefficient();
        SortedMap sortedMap = genPolynomial2.a;
        for (Monomial monomial : genPolynomial) {
            ExpVector expVector = monomial.a;
            p p2 = monomial.a;
            GenPolynomial genPolynomial5 = genPolynomial4.multiply(p2);
            sortedMap.put(expVector, genPolynomial5);
        }
        return genPolynomial2;
    }

    public static GenPolynomial baseRemainderPoly(GenPolynomial genPolynomial, p p2) {
        if (p2 == null || p2.isZERO()) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " division by zero");
        }
        GenPolynomial genPolynomial2 = genPolynomial.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            p p3 = (p)entry.getValue();
            p p4 = (p)p3.remainder(p2);
            sortedMap.put(expVector, p4);
        }
        return genPolynomial2;
    }

    public static GenPolynomial basePseudoRemainder(GenPolynomial genPolynomial, GenPolynomial genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " division by zero");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial.a.getZERO();
        }
        p p2 = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial genPolynomial3 = genPolynomial;
        while (!genPolynomial3.isZERO() && (expVector = genPolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial genPolynomial4;
            p p3 = genPolynomial3.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            p p4 = (p)p3.remainder(p2);
            if (p4.isZERO()) {
                p p5 = (p)p3.divide(p2);
                genPolynomial4 = genPolynomial2.multiply(p5, expVector);
            } else {
                genPolynomial3 = genPolynomial3.multiply(p2);
                genPolynomial4 = genPolynomial2.multiply(p3, expVector);
            }
            genPolynomial3 = genPolynomial3.subtract(genPolynomial4);
        }
        return genPolynomial3;
    }

    public static GenPolynomial basePseudoDivide(GenPolynomial genPolynomial, GenPolynomial genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " division by zero");
        }
        if (genPolynomial2.a.a != 1) {
            // empty if block
        }
        if (genPolynomial.isZERO() || genPolynomial2.isONE()) {
            return genPolynomial;
        }
        p p2 = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial genPolynomial3 = genPolynomial;
        GenPolynomial genPolynomial4 = genPolynomial2.a.getZERO().clone();
        while (!genPolynomial3.isZERO() && (expVector = genPolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial genPolynomial5;
            p p3 = genPolynomial3.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            p p4 = (p)p3.remainder(p2);
            if (p4.isZERO()) {
                p p5 = (p)p3.divide(p2);
                genPolynomial4 = genPolynomial4.sum(p5, expVector);
                genPolynomial5 = genPolynomial2.multiply(p5, expVector);
            } else {
                genPolynomial4 = genPolynomial4.sum(p3, expVector);
                genPolynomial4 = genPolynomial4.multiply(p2);
                genPolynomial3 = genPolynomial3.multiply(p2);
                genPolynomial5 = genPolynomial2.multiply(p3, expVector);
            }
            genPolynomial3 = genPolynomial3.subtract(genPolynomial5);
        }
        return genPolynomial4;
    }

    public static GenPolynomial[] basePseudoQuotientRemainder(GenPolynomial genPolynomial, GenPolynomial genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " division by zero");
        }
        if (genPolynomial2.a.a != 1) {
            // empty if block
        }
        GenPolynomial[] genPolynomialArray = new GenPolynomial[]{null, null};
        if (genPolynomial.isZERO() || genPolynomial2.isONE()) {
            genPolynomialArray[0] = genPolynomial;
            genPolynomialArray[1] = genPolynomial2.a.getZERO();
            return genPolynomialArray;
        }
        p p2 = genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial genPolynomial3 = genPolynomial;
        GenPolynomial genPolynomial4 = genPolynomial2.a.getZERO().clone();
        while (!genPolynomial3.isZERO() && (expVector = genPolynomial3.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial genPolynomial5;
            p p3 = genPolynomial3.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            p p4 = (p)p3.remainder(p2);
            if (p4.isZERO()) {
                p p5 = (p)p3.divide(p2);
                genPolynomial4 = genPolynomial4.sum(p5, expVector);
                genPolynomial5 = genPolynomial2.multiply(p5, expVector);
            } else {
                genPolynomial4 = genPolynomial4.sum(p3, expVector);
                genPolynomial4 = genPolynomial4.multiply(p2);
                genPolynomial3 = genPolynomial3.multiply(p2);
                genPolynomial5 = genPolynomial2.multiply(p3, expVector);
            }
            genPolynomial3 = genPolynomial3.subtract(genPolynomial5);
        }
        genPolynomialArray[0] = genPolynomial4;
        genPolynomialArray[1] = genPolynomial3;
        return genPolynomialArray;
    }

    public static GenPolynomial recursiveDivide(GenPolynomial genPolynomial, GenPolynomial genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " division by zero " + genPolynomial + ", " + genPolynomial2);
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial3 = genPolynomial.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial3.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            GenPolynomial genPolynomial4 = (GenPolynomial)entry.getValue();
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial4, genPolynomial2);
            if (!genPolynomial5.isZERO()) {
                sortedMap.put(expVector, genPolynomial5);
                continue;
            }
            System.out.println("pu, c1 = " + genPolynomial4);
            System.out.println("pu, s  = " + genPolynomial2);
            System.out.println("pu, c  = " + genPolynomial5);
            throw new RuntimeException("something is wrong");
        }
        return genPolynomial3;
    }

    public static GenPolynomial baseRecursiveDivide(GenPolynomial genPolynomial, p p2) {
        if (p2 == null || p2.isZERO()) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " division by zero " + genPolynomial + ", " + p2);
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (p2.isONE()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial2 = genPolynomial.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getValue();
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial4 = PolyUtil.coefficientBasePseudoDivide(genPolynomial3, p2);
            if (!genPolynomial4.isZERO()) {
                sortedMap.put(expVector, genPolynomial4);
                continue;
            }
            System.out.println("pu, c1 = " + genPolynomial3);
            System.out.println("pu, s  = " + p2);
            System.out.println("pu, c  = " + genPolynomial4);
            throw new RuntimeException("something is wrong");
        }
        return genPolynomial2;
    }

    public static GenPolynomial recursivePseudoRemainder(GenPolynomial genPolynomial, GenPolynomial genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " division by zero");
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial.a.getZERO();
        }
        GenPolynomial genPolynomial3 = (GenPolynomial)genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial genPolynomial4 = genPolynomial;
        while (!genPolynomial4.isZERO() && (expVector = genPolynomial4.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial genPolynomial5;
            GenPolynomial genPolynomial6 = (GenPolynomial)genPolynomial4.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            GenPolynomial genPolynomial7 = genPolynomial3;
            if (genPolynomial7.isZERO()) {
                GenPolynomial genPolynomial8 = PolyUtil.basePseudoDivide(genPolynomial6, genPolynomial3);
                genPolynomial5 = genPolynomial2.multiply(genPolynomial8, expVector);
            } else {
                genPolynomial4 = genPolynomial4.multiply((p)genPolynomial3);
                genPolynomial5 = genPolynomial2.multiply(genPolynomial6, expVector);
            }
            genPolynomial4 = genPolynomial4.subtract(genPolynomial5);
        }
        return genPolynomial4;
    }

    public static GenPolynomial recursivePseudoDivide(GenPolynomial genPolynomial, GenPolynomial genPolynomial2) {
        ExpVector expVector;
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " division by zero");
        }
        if (genPolynomial2.a.a != 1) {
            // empty if block
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial2.isONE()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial3 = (GenPolynomial)genPolynomial2.leadingBaseCoefficient();
        ExpVector expVector2 = genPolynomial2.leadingExpVector();
        GenPolynomial genPolynomial4 = genPolynomial;
        GenPolynomial genPolynomial5 = genPolynomial2.a.getZERO().clone();
        while (!genPolynomial4.isZERO() && (expVector = genPolynomial4.leadingExpVector()).multipleOf(expVector2)) {
            GenPolynomial genPolynomial6;
            GenPolynomial genPolynomial7 = (GenPolynomial)genPolynomial4.leadingBaseCoefficient();
            expVector = expVector.subtract(expVector2);
            GenPolynomial genPolynomial8 = PolyUtil.basePseudoRemainder(genPolynomial7, genPolynomial3);
            if (genPolynomial8.isZERO()) {
                GenPolynomial genPolynomial9 = PolyUtil.basePseudoDivide(genPolynomial7, genPolynomial3);
                genPolynomial5 = genPolynomial5.sum(genPolynomial9, expVector);
                genPolynomial6 = genPolynomial2.multiply(genPolynomial9, expVector);
            } else {
                genPolynomial5 = genPolynomial5.sum(genPolynomial7, expVector);
                genPolynomial5 = genPolynomial5.multiply((p)genPolynomial3);
                genPolynomial4 = genPolynomial4.multiply((p)genPolynomial3);
                genPolynomial6 = genPolynomial2.multiply(genPolynomial7, expVector);
            }
            genPolynomial4 = genPolynomial4.subtract(genPolynomial6);
        }
        return genPolynomial5;
    }

    public static GenPolynomial coefficientPseudoDivide(GenPolynomial genPolynomial, GenPolynomial genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            throw new RuntimeException(" division by zero");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial3 = genPolynomial.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial3.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial4 = (GenPolynomial)entry.getValue();
            GenPolynomial genPolynomial5 = PolyUtil.basePseudoDivide(genPolynomial4, genPolynomial2);
            if (genPolynomial5.isZERO()) {
                System.out.println(" no exact division: " + genPolynomial4 + "/" + genPolynomial2);
                continue;
            }
            sortedMap.put(expVector, genPolynomial5);
        }
        return genPolynomial3;
    }

    public static GenPolynomial coefficientBasePseudoDivide(GenPolynomial genPolynomial, p p2) {
        if (p2 == null || p2.isZERO()) {
            throw new RuntimeException(" division by zero");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial2 = genPolynomial.a.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            p p3 = (p)entry.getValue();
            p p4 = (p)p3.divide(p2);
            if (p4.isZERO()) {
                System.out.println(" no exact division: " + p3 + "/" + p2);
                continue;
            }
            sortedMap.put(expVector, p4);
        }
        return genPolynomial2;
    }

    public static GenPolynomial baseDeriviative(GenPolynomial genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.a;
        if (genPolynomialRing.a > 1) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        q q2 = genPolynomialRing.a;
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            long l2 = expVector.getVal(0);
            if (l2 <= 0L) continue;
            p p2 = (p)q2.fromInteger(l2);
            p p3 = (p)entry.getValue();
            p p4 = (p)p3.multiply(p2);
            if (p4 == null || p4.isZERO()) continue;
            ExpVector expVector2 = ExpVector.create(1, 0, l2 - 1L);
            sortedMap.put(expVector2, p4);
        }
        return genPolynomial2;
    }

    public static GenPolynomial baseIntegral(GenPolynomial genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.a;
        if (genPolynomialRing.a > 1) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        q q2 = genPolynomialRing.a;
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            long l2 = expVector.getVal(0);
            p p2 = (p)q2.fromInteger(++l2);
            p p3 = (p)entry.getValue();
            p p4 = (p)p3.divide(p2);
            if (p4 == null || p4.isZERO()) continue;
            ExpVector expVector2 = ExpVector.create(1, 0, l2);
            sortedMap.put(expVector2, p4);
        }
        return genPolynomial2;
    }

    public static GenPolynomial recursiveDeriviative(GenPolynomial genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.a;
        if (genPolynomialRing.a > 1) {
            throw new RuntimeException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.a;
        q q2 = genPolynomialRing2.a;
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : genPolynomial.getMap().entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            long l2 = expVector.getVal(0);
            if (l2 <= 0L) continue;
            p p2 = (p)q2.fromInteger(l2);
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getValue();
            GenPolynomial genPolynomial4 = genPolynomial3.multiply(p2);
            if (genPolynomial4 == null || genPolynomial4.isZERO()) continue;
            ExpVector expVector2 = ExpVector.create(1, 0, l2 - 1L);
            sortedMap.put(expVector2, genPolynomial4);
        }
        return genPolynomial2;
    }

    public static c factorBound(ExpVector expVector) {
        BigInteger bigInteger;
        int n2 = 0;
        BigInteger bigInteger2 = BigInteger.ONE;
        if (expVector == null || expVector.isZERO()) {
            return c.b;
        }
        for (int i2 = 0; i2 < expVector.length(); ++i2) {
            if (expVector.getVal(i2) <= 0L) continue;
            n2 = (int)((long)n2 + (2L * expVector.getVal(i2) - 1L));
            bigInteger = new BigInteger("" + (expVector.getVal(i2) - 1L));
            bigInteger2 = bigInteger2.multiply(bigInteger);
        }
        n2 += bigInteger2.bitCount() + 1;
        bigInteger = new BigInteger("2");
        bigInteger = bigInteger.shiftLeft(n2 /= 2);
        c c2 = new c(bigInteger);
        return c2;
    }

    public static GenPolynomial evaluateMain(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial, p p2) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing.getZERO();
        }
        if (genPolynomial.a.a != 1) {
            throw new RuntimeException("evaluateMain no univariate polynomial");
        }
        if (p2 == null || p2.isZERO()) {
            return (GenPolynomial)genPolynomial.trailingBaseCoefficient();
        }
        SortedMap sortedMap = genPolynomial.getMap();
        GenPolynomial genPolynomial2 = null;
        long l2 = -1L;
        long l3 = -1L;
        for (ExpVector expVector : sortedMap.keySet()) {
            l3 = expVector.getVal(0);
            if (genPolynomial2 == null) {
                genPolynomial2 = (GenPolynomial)sortedMap.get(expVector);
            } else {
                for (long i2 = l3; i2 < l2; ++i2) {
                    genPolynomial2 = genPolynomial2.multiply(p2);
                }
                genPolynomial2 = genPolynomial2.sum((GenPolynomial)sortedMap.get(expVector));
            }
            l2 = l3;
        }
        for (long i3 = 0L; i3 < l3; ++i3) {
            genPolynomial2 = genPolynomial2.multiply(p2);
        }
        return genPolynomial2;
    }

    public static p evaluateMain(q q2, GenPolynomial genPolynomial, p p2) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return (p)q2.getZERO();
        }
        if (genPolynomial.a.a != 1) {
            throw new RuntimeException("evaluateMain no univariate polynomial");
        }
        if (p2 == null || p2.isZERO()) {
            return genPolynomial.trailingBaseCoefficient();
        }
        SortedMap sortedMap = genPolynomial.getMap();
        i i2 = null;
        long l2 = -1L;
        long l3 = -1L;
        for (ExpVector expVector : sortedMap.keySet()) {
            l3 = expVector.getVal(0);
            if (i2 == null) {
                i2 = (p)sortedMap.get(expVector);
            } else {
                for (long i3 = l3; i3 < l2; ++i3) {
                    i2 = (p)i2.multiply(p2);
                }
                i2 = (p)i2.sum((a)sortedMap.get(expVector));
            }
            l2 = l3;
        }
        for (long i4 = 0L; i4 < l3; ++i4) {
            i2 = (p)i2.multiply(p2);
        }
        return i2;
    }

    public static List evaluateMain(q q2, List list, p p2) {
        return edu.jas.g.c.a(list, new EvalMain(q2, p2));
    }

    public static GenPolynomial evaluate(GenPolynomialRing genPolynomialRing, GenPolynomialRing genPolynomialRing2, GenPolynomialRing genPolynomialRing3, GenPolynomialRing genPolynomialRing4, GenPolynomial genPolynomial, p p2) {
        if (genPolynomialRing2.a != 1) {
            throw new RuntimeException("evaluate coefficient ring not univariate");
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing.getZERO();
        }
        Map map = genPolynomial.contract(genPolynomialRing);
        GenPolynomialRing genPolynomialRing5 = (GenPolynomialRing)genPolynomialRing2.a;
        GenPolynomial genPolynomial2 = genPolynomialRing3.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : map.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getValue();
            GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing2, genPolynomial3);
            GenPolynomial genPolynomial5 = PolyUtil.evaluateMain(genPolynomialRing5, genPolynomial4, p2);
            if (genPolynomial5 == null || genPolynomial5.isZERO()) continue;
            sortedMap.put(expVector, genPolynomial5);
        }
        GenPolynomial genPolynomial6 = PolyUtil.distribute(genPolynomialRing4, genPolynomial2);
        return genPolynomial6;
    }

    public static GenPolynomial evaluateFirst(GenPolynomialRing genPolynomialRing, GenPolynomialRing genPolynomialRing2, GenPolynomial genPolynomial, p p2) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing2.getZERO();
        }
        Map map = genPolynomial.contract(genPolynomialRing);
        GenPolynomial genPolynomial2 = genPolynomialRing2.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Map.Entry entry : map.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getValue();
            p p3 = PolyUtil.evaluateMain(genPolynomialRing.a, genPolynomial3, p2);
            if (p3 == null || p3.isZERO()) continue;
            sortedMap.put(expVector, p3);
        }
        return genPolynomial2;
    }

    public static GenPolynomial evaluateFirstRec(GenPolynomialRing genPolynomialRing, GenPolynomialRing genPolynomialRing2, GenPolynomial genPolynomial, p p2) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomialRing2.getZERO();
        }
        SortedMap sortedMap = genPolynomial.getMap();
        GenPolynomial genPolynomial2 = genPolynomialRing2.getZERO().clone();
        SortedMap sortedMap2 = genPolynomial2.a;
        for (Map.Entry entry : sortedMap.entrySet()) {
            ExpVector expVector = (ExpVector)entry.getKey();
            GenPolynomial genPolynomial3 = (GenPolynomial)entry.getValue();
            p p3 = PolyUtil.evaluateMain(genPolynomialRing.a, genPolynomial3, p2);
            if (p3 == null || p3.isZERO()) continue;
            sortedMap2.put(expVector, p3);
        }
        return genPolynomial2;
    }

    public static p evaluateAll(q q2, GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial, List list) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return (p)q2.getZERO();
        }
        if (list == null || list.size() != genPolynomialRing.a) {
            throw new RuntimeException("evaluate tuple size not equal to number of variables");
        }
        if (genPolynomialRing.a == 0) {
            return genPolynomial.trailingBaseCoefficient();
        }
        if (genPolynomialRing.a == 1) {
            return PolyUtil.evaluateMain(q2, genPolynomial, (p)list.get(0));
        }
        p p2 = (p)q2.getZERO();
        GenPolynomial genPolynomial2 = genPolynomial;
        for (int i2 = 0; i2 < genPolynomialRing.a - 1; ++i2) {
            GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(q2, 1);
            GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(q2, genPolynomialRing.a - 1 - i2);
            p p3 = (p)list.get(i2);
            GenPolynomial genPolynomial3 = PolyUtil.evaluateFirst(genPolynomialRing2, genPolynomialRing3, genPolynomial2, p3);
            if (genPolynomial3.isZERO()) {
                return p2;
            }
            genPolynomial2 = genPolynomial3;
        }
        p p4 = (p)list.get(genPolynomialRing.a - 1);
        p2 = PolyUtil.evaluateMain(q2, genPolynomial2, p4);
        return p2;
    }

    public static GenPolynomial substituteMain(GenPolynomial genPolynomial, GenPolynomial genPolynomial2) {
        return PolyUtil.substituteUnivariate(genPolynomial, genPolynomial2);
    }

    public static GenPolynomial substituteUnivariate(GenPolynomial genPolynomial, GenPolynomial genPolynomial2) {
        if (genPolynomial == null || genPolynomial2 == null) {
            return null;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.a;
        if (genPolynomialRing.a > 1 || genPolynomial2.a.a > 1) {
            throw new RuntimeException("only for univariate polynomials");
        }
        if (genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return genPolynomial;
        }
        SortedMap sortedMap = genPolynomial.getMap();
        GenPolynomial genPolynomial3 = null;
        long l2 = -1L;
        long l3 = -1L;
        for (ExpVector expVector : sortedMap.keySet()) {
            l3 = expVector.getVal(0);
            if (genPolynomial3 == null) {
                genPolynomial3 = genPolynomialRing.getZERO().sum((p)sortedMap.get(expVector));
            } else {
                for (long i2 = l3; i2 < l2; ++i2) {
                    genPolynomial3 = genPolynomial3.multiply(genPolynomial2);
                }
                genPolynomial3 = genPolynomial3.sum((p)sortedMap.get(expVector));
            }
            l2 = l3;
        }
        for (long i3 = 0L; i3 < l3; ++i3) {
            genPolynomial3 = genPolynomial3.multiply(genPolynomial2);
        }
        return genPolynomial3;
    }

    public static GenPolynomial seriesOfTaylor(GenPolynomial genPolynomial, p p2) {
        if (genPolynomial == null) {
            return null;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.a;
        if (genPolynomialRing.a > 1) {
            throw new RuntimeException("only for univariate polynomials");
        }
        if (genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return genPolynomial;
        }
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO();
        p p3 = PolyUtil.evaluateMain(genPolynomialRing.a, genPolynomial, p2);
        genPolynomial2 = genPolynomial2.sum(p3);
        long l2 = 1L;
        long l3 = 0L;
        GenPolynomial genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial);
        GenPolynomial genPolynomial4 = genPolynomialRing.getONE();
        while (!genPolynomial3.isZERO()) {
            p3 = PolyUtil.evaluateMain(genPolynomialRing.a, genPolynomial3, p2);
            GenPolynomial genPolynomial5 = genPolynomialRing.univariate(0, l3);
            genPolynomial5 = genPolynomial5.multiply(p3);
            genPolynomial5 = genPolynomial5.divide(genPolynomialRing.fromInteger(l2 *= ++l3));
            genPolynomial2 = genPolynomial2.sum(genPolynomial5);
            genPolynomial3 = PolyUtil.baseDeriviative(genPolynomial3);
        }
        return genPolynomial2;
    }

    public static GenPolynomial interpolate(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial, GenPolynomial genPolynomial2, p p2, GenPolynomial genPolynomial3, p p3) {
        GenPolynomial genPolynomial4;
        GenPolynomial genPolynomial5 = genPolynomialRing.getZERO().clone();
        GenPolynomial genPolynomial6 = genPolynomial.clone();
        SortedMap sortedMap = genPolynomial6.a;
        SortedMap sortedMap2 = genPolynomial3.getMap();
        SortedMap sortedMap3 = genPolynomial5.a;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.a;
        q q2 = genPolynomialRing2.a;
        GenPolynomial genPolynomial7 = null;
        for (ExpVector expVector : sortedMap2.keySet()) {
            genPolynomial4 = (GenPolynomial)sortedMap.get(expVector);
            p p4 = (p)sortedMap2.get(expVector);
            if (genPolynomial4 != null) {
                sortedMap.remove(expVector);
                genPolynomial7 = PolyUtil.interpolate(genPolynomialRing2, genPolynomial4, genPolynomial2, p2, p4, p3);
                if (genPolynomial7.isZERO()) continue;
                sortedMap3.put(expVector, genPolynomial7);
                continue;
            }
            genPolynomial7 = PolyUtil.interpolate(genPolynomialRing2, genPolynomialRing2.getZERO(), genPolynomial2, p2, p4, p3);
            if (genPolynomial7.isZERO()) continue;
            sortedMap3.put(expVector, genPolynomial7);
        }
        for (ExpVector expVector : sortedMap.keySet()) {
            genPolynomial4 = (GenPolynomial)sortedMap.get(expVector);
            genPolynomial7 = PolyUtil.interpolate(genPolynomialRing2, genPolynomial4, genPolynomial2, p2, (p)q2.getZERO(), p3);
            if (genPolynomial7.isZERO()) continue;
            sortedMap3.put(expVector, genPolynomial7);
        }
        return genPolynomial5;
    }

    public static GenPolynomial interpolate(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial, GenPolynomial genPolynomial2, p p2, p p3, p p4) {
        p p5 = PolyUtil.evaluateMain(genPolynomialRing.a, genPolynomial, p4);
        p p6 = (p)p3.subtract(p5);
        if (p6.isZERO()) {
            return genPolynomial;
        }
        p5 = (p)p6.multiply(p2);
        GenPolynomial genPolynomial3 = genPolynomial2.multiply(p5);
        genPolynomial3 = genPolynomial3.sum(genPolynomial);
        return genPolynomial3;
    }

    public static GenPolynomial switchVariables(GenPolynomial genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException("P == null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.a;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.a;
        GenPolynomialRing genPolynomialRing3 = new GenPolynomialRing(genPolynomialRing2.a, genPolynomialRing);
        GenPolynomial genPolynomial2 = genPolynomialRing3.getZERO();
        GenPolynomialRing genPolynomialRing4 = new GenPolynomialRing((q)genPolynomialRing3, genPolynomialRing2);
        GenPolynomial genPolynomial3 = genPolynomialRing4.getZERO().clone();
        if (genPolynomial.isZERO()) {
            return genPolynomial3;
        }
        for (Monomial monomial : genPolynomial) {
            GenPolynomial genPolynomial4 = (GenPolynomial)monomial.a;
            for (Monomial monomial2 : genPolynomial4) {
                GenPolynomial genPolynomial5 = genPolynomial2.sum(monomial2.a, monomial.a);
                genPolynomial3 = genPolynomial3.sum(genPolynomial5, monomial2.a);
            }
        }
        return genPolynomial3;
    }

    public static long coeffMaxDegree(GenPolynomial genPolynomial) {
        if (genPolynomial.isZERO()) {
            return 0L;
        }
        long l2 = 0L;
        for (GenPolynomial genPolynomial2 : genPolynomial.getMap().values()) {
            long l3 = genPolynomial2.degree();
            if (l3 <= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    public static GenPolynomial map(GenPolynomialRing genPolynomialRing, GenPolynomial genPolynomial, s s2) {
        GenPolynomial genPolynomial2 = genPolynomialRing.getZERO().clone();
        SortedMap sortedMap = genPolynomial2.a;
        for (Monomial monomial : genPolynomial) {
            p p2 = (p)s2.eval(monomial.a);
            if (p2 == null || p2.isZERO()) continue;
            sortedMap.put(monomial.a, p2);
        }
        return genPolynomial2;
    }
}

