/*
 * Decompiled with CFR 0.152.
 */
package org.mathpiper.builtin.javareflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mathpiper.builtin.f;
import org.mathpiper.builtin.javareflection.E;
import org.mathpiper.builtin.javareflection.Import;
import org.mathpiper.builtin.javareflection.U;
import org.mathpiper.d.c.c;
import org.mathpiper.d.c.d;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Invoke {
    public static final Hashtable a = new Hashtable(50);
    public static final Hashtable b = new Hashtable(50);
    public static final Hashtable c = new Hashtable(50);
    public static final Hashtable d = new Hashtable(100);
    private static boolean a = Invoke.canGetDeclaredMethods();
    static Method a = Invoke.getSetAccessibleMethod();

    public static Object peek(Object object, String string) {
        return Invoke.peek0(object.getClass(), string, object);
    }

    public static Object peekStatic(Class clazz, String string) {
        return Invoke.peek0(clazz, string, clazz);
    }

    private static Object peek0(Class clazz, String string, Object object) {
        try {
            return clazz.getField(string).get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return E.error(object + " has no field named " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            return E.error("Can't access the " + string + " field of " + object);
        }
    }

    public static Object poke(Object object, String string, Object object2) {
        return Invoke.poke0(object.getClass(), string, object, object2);
    }

    public static Object pokeStatic(Class clazz, String string, Object object) {
        return Invoke.poke0(clazz, string, clazz, object);
    }

    private static Object poke0(Class clazz, String string, Object object, Object object2) {
        try {
            clazz.getField(string).set(object, object2);
            return object2;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return E.error(object + " has no field named " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            return E.error("Can't access the " + string + " field of " + object);
        }
    }

    public static Object invokeConstructor(String string, Object[] objectArray) {
        Object[] objectArray2 = Invoke.constructorTable(string, false);
        return Invoke.invokeRawConstructor((Constructor)Invoke.findMethod(objectArray2, objectArray), objectArray);
    }

    public static Object invokeRawConstructor(Constructor constructor, Object[] objectArray) {
        try {
            return constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (InstantiationException instantiationException) {
            return E.error("Error during instantiation: ", U.list(instantiationException, constructor, objectArray));
        }
        catch (IllegalAccessException illegalAccessException) {
            return E.error("Bad constructor application:", U.list(illegalAccessException, constructor, objectArray));
        }
    }

    public static Object invokeStatic(Class clazz, String string, Object[] objectArray) {
        return Invoke.invokeMethod(clazz, clazz, string, objectArray, true, false);
    }

    public static Object invokeInstance(Object object, String string, Object[] objectArray, boolean bl2) {
        return Invoke.invokeMethod(object.getClass(), object, string, objectArray, false, bl2);
    }

    public static Object invokeMethod(Class clazz, Object object, String string, Object[] objectArray, boolean bl2, boolean bl3) {
        Object[] objectArray2 = Invoke.methodTable(clazz, string, bl2, bl3);
        return Invoke.invokeRawMethod((Method)Invoke.findMethod(objectArray2, objectArray), object, objectArray);
    }

    public static Object invokeRawMethod(Method method, Object object, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (IllegalAccessException illegalAccessException) {
            return E.error("Bad method application from a private class: ", U.list(illegalAccessException, method, objectArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (objectArray == null) {
                return E.error(illegalArgumentException + "\n " + method.toString() + "\n called with target: " + U.stringify(object) + " and a null argument vector.");
            }
            return E.error(illegalArgumentException + "\nARGUMENT MISMATCH for method \n\n  " + method.toString() + "\n called with " + U.vectorToList(objectArray));
        }
    }

    public static Object[] constructorTable(String string, boolean bl2) {
        if (bl2) {
            return Invoke.constructorTable0Priv(string);
        }
        return Invoke.constructorTable0(string);
    }

    public static Object[] constructorTable0Priv(String string) {
        Object[] objectArray = (Object[])b.get(string);
        if (objectArray == null) {
            try {
                objectArray = Invoke.methodArray(Invoke.makeAccessible(Import.classNamed(string).getDeclaredConstructors()));
            }
            catch (Exception exception) {
                objectArray = Invoke.methodArray(Import.classNamed(string).getConstructors());
            }
            b.put(string, objectArray);
        }
        if (objectArray.length == 0) {
            return (Object[])E.error("Constructor " + string + " has no methods.");
        }
        return objectArray;
    }

    public static Object[] constructorTable0(String string) {
        Object[] objectArray = (Object[])a.get(string);
        if (objectArray == null) {
            objectArray = Invoke.methodArray(Import.classNamed(string).getConstructors());
            a.put(string, objectArray);
        }
        if (objectArray.length == 0) {
            return (Object[])E.error("Constructor " + string + " has no methods.");
        }
        return objectArray;
    }

    private static Hashtable getMethodCache(boolean bl2) {
        return bl2 ? c : d;
    }

    private static Hashtable getNameTable(Hashtable hashtable, String string) {
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        if (hashtable2 != null) {
            return hashtable2;
        }
        hashtable2 = new Hashtable(10);
        hashtable.put(string, hashtable2);
        return hashtable2;
    }

    public static Hashtable getClassTable(String string, boolean bl2) {
        return Invoke.getNameTable(Invoke.getMethodCache(bl2), string);
    }

    public static Object[] getCachedMethodTable(Class clazz, String string, boolean bl2) {
        return (Object[])Invoke.getNameTable(Invoke.getMethodCache(bl2), string).get(clazz);
    }

    public static void putCachedMethodTable(Class clazz, String string, boolean bl2, Object object) {
        Invoke.getNameTable(Invoke.getMethodCache(bl2), string).put(clazz, object);
    }

    public static Object[] methodTable0(Class clazz, String string, boolean bl2, boolean bl3) {
        String string2 = bl3 ? string.concat("#") : string;
        Object[] objectArray = Invoke.getCachedMethodTable(clazz, string2, bl2);
        if (objectArray == null) {
            objectArray = Invoke.methodTableLookup(clazz, string, bl2, bl3);
            Invoke.putCachedMethodTable(clazz, string2, bl2, objectArray);
        }
        return objectArray;
    }

    public static Object[] methodTable(Class clazz, String string, boolean bl2, boolean bl3) {
        Object[] objectArray = Invoke.methodTable0(clazz, string, bl2, bl3);
        if (objectArray == null || objectArray.length == 0) {
            if (bl2) {
                return (Object[])E.error("ERROR: \nNO STATIC METHOD  OF TYPE  \n\n  (" + clazz.getName() + "." + string + " ...)");
            }
            return (Object[])E.error("ERROR: \nNO INSTANCE METHOD OF TYPE \n\n  (." + string + " " + clazz.getName() + " ...)");
        }
        return objectArray;
    }

    public static Object[] methodTableLookup(Class clazz, String string, boolean bl2, boolean bl3) {
        if (bl2) {
            return Invoke.methodTableLookupStatic(clazz, string, bl3);
        }
        return Invoke.methodTableLookupInstance(clazz, string, bl3);
    }

    public static Object[] methodTableLookupStatic(Class clazz, String string, boolean bl2) {
        Method[] methodArray = Invoke.getMethods(clazz, bl2);
        Vector<Method> vector = new Vector<Method>(methodArray.length);
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Method method = methodArray[i2];
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(string)) continue;
            vector.addElement(method);
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return Invoke.methodArray(objectArray);
    }

    public static Object[] methodTableLookupInstance(Class clazz, String string) {
        return Invoke.methodTableLookupInstance(clazz, string, false);
    }

    public static Object[] methodTableLookupInstance(Class clazz, String string, boolean bl2) {
        Vector vector = Invoke.methodVector(clazz, string, bl2);
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return Invoke.methodArray(objectArray);
    }

    public static Vector methodVector(Class clazz, String string) {
        return Invoke.methodVector(clazz, string, false);
    }

    public static Vector methodVector(Class clazz, String string, boolean bl2) {
        return Invoke.methodVectorMerge(clazz, string, new Vector(10), bl2);
    }

    public static Vector methodVectorMerge(Class clazz, String string, Vector vector) {
        return Invoke.methodVectorMerge(clazz, string, vector, false);
    }

    public static Vector methodVectorMerge(Class clazz, String string, Vector vector, boolean bl2) {
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            vector = Invoke.methodVectorMerge(clazz2, string, vector, bl2);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            vector = Invoke.methodVectorMerge(classArray[i2], string, vector, bl2);
        }
        Method[] methodArray = Invoke.getMethods(clazz, bl2);
        for (int i3 = 0; i3 < methodArray.length; ++i3) {
            Method method = methodArray[i3];
            if (Modifier.isStatic(method.getModifiers()) || !bl2 && (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) || !method.getName().equals(string)) continue;
            Invoke.maybeAdd(vector, method);
        }
        return vector;
    }

    private static void maybeAdd(Vector vector, Method method) {
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Method method2 = (Method)vector.elementAt(i2);
            if (!Invoke.parameterTypesMatch(Invoke.getParameterTypes(method), Invoke.getParameterTypes(method2))) continue;
            return;
        }
        vector.addElement(method);
    }

    private static Class[] getParameterTypes(Object object) {
        return object instanceof Method ? ((Method)object).getParameterTypes() : ((Constructor)object).getParameterTypes();
    }

    private static Object[] methodArray(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length * 2];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2 * 2] = Invoke.getParameterTypes(objectArray[i2]);
            objectArray2[i2 * 2 + 1] = objectArray[i2];
        }
        return objectArray2;
    }

    public static boolean parameterTypesMatch(Class[] classArray, Class[] classArray2) {
        if (classArray.length == classArray2.length) {
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (classArray[i2] == classArray2[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object findMethod(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length == 2) {
            return objectArray[1];
        }
        return Invoke.findMethodNoOpt(objectArray, objectArray2);
    }

    static Object findMethodNoOpt(Object[] objectArray, Object[] objectArray2) {
        int n2 = -1;
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            Class[] classArray = (Class[])objectArray[i2];
            if (!Invoke.isApplicable(classArray, objectArray2) || n2 != -1 && Invoke.moreApplicable((Class[])objectArray[n2], classArray)) continue;
            n2 = i2;
        }
        if (n2 != -1) {
            return objectArray[n2 + 1];
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 < objectArray.length; i3 += 2) {
            if (objectArray[i3 + 1] instanceof Member) {
                stringBuffer.append("   * " + objectArray[i3 + 1] + "\n");
                continue;
            }
            Class[] classArray = (Class[])objectArray[i3];
            stringBuffer.append("   * " + objectArray[i3 + 1] + " ( ");
            for (int i4 = 0; i4 < classArray.length; ++i4) {
                stringBuffer.append(classArray[i4] + " ");
            }
            stringBuffer.append(")\n");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i5 = 0; i5 < objectArray2.length; ++i5) {
            if (objectArray2[i5] == null) {
                stringBuffer2.append(" ? ");
                continue;
            }
            stringBuffer2.append(" " + objectArray2[i5].getClass() + " ");
        }
        return E.error("\n\nERROR: NO " + (objectArray[1] instanceof Member ? (objectArray[1] instanceof Method ? "METHOD" : "CONSTRUCTOR") : "PROCEDURE") + " WITH NAME\n    " + (objectArray[1] instanceof Member ? ((Member)objectArray[1]).getName() : "?") + "\n and args\n     " + U.vectorToList(objectArray2) + "\n of types \n    " + stringBuffer2.toString() + "\n\n possible alternatives are :\n" + stringBuffer.toString() + "\n\n");
    }

    public static boolean isApplicable(Class[] classArray, Object[] objectArray) {
        if (classArray.length == objectArray.length) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (Invoke.isArgApplicable(classArray[i2], objectArray[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isArgApplicable(Class clazz, Object object) {
        return object == null && Object.class.isAssignableFrom(clazz) || clazz.isInstance(object) || clazz.isPrimitive() && Invoke.primitiveWrapperType(clazz).isInstance(object);
    }

    private static Class primitiveWrapperType(Class clazz) {
        return clazz == Byte.TYPE ? Byte.class : (clazz == Long.TYPE ? Long.class : (clazz == Float.TYPE ? Float.class : (clazz == Short.TYPE ? Short.class : (clazz == Double.TYPE ? Double.class : (clazz == Boolean.TYPE ? Boolean.class : (clazz == Integer.TYPE ? Integer.class : (clazz == Character.TYPE ? Character.class : (Class)E.error("unknow primitive type: ", clazz))))))));
    }

    private static boolean moreApplicable(Class[] classArray, Class[] classArray2) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray2[i2].isAssignableFrom(classArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static Method findMethod(String string, Object object, d d2) {
        try {
            return U.toClass(object).getMethod(string, Invoke.toClassArray(d2, 0));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (Method)E.error("No method: ", U.list(string, object, d2));
        }
    }

    public static Constructor findConstructor(Object object, d d2) {
        try {
            return U.toClass(object).getConstructor(Invoke.toClassArray(d2, 0));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (Constructor)E.error("No constructor: ", U.list(object, d2));
        }
    }

    public static Constructor findConstructor(String string, Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            if (object instanceof f) {
                object = ((f)object).a();
            }
            classArray[i2] = U.toClass(object.getClass());
        }
        Constructor constructor = U.toClass(string).getConstructor(classArray);
        return constructor;
    }

    public static Class[] toClassArray(d d2, int n2) {
        if (d2.a() == null) {
            return new Class[n2];
        }
        Class[] classArray = Invoke.toClassArray(((c)d2.a()).a(), n2 + 1);
        classArray[n2] = U.toClass(d2.a());
        return classArray;
    }

    public static Method[] getMethods(Class clazz, boolean bl2) {
        Method[] methodArray = Invoke.getAllMethods(clazz, bl2);
        return methodArray == null ? clazz.getMethods() : methodArray;
    }

    private static Method[] getAllMethods(Class clazz) {
        return Invoke.getAllMethods(clazz, false);
    }

    private static Method[] getAllMethods(Class clazz, boolean bl2) {
        if (bl2) {
            try {
                return (Method[])Invoke.makeAccessible(Invoke.getAllMethods0(clazz));
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static boolean canGetDeclaredMethods() {
        try {
            Invoke.class.getDeclaredMethods();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Method[] getAllMethods0(Class clazz) {
        if (a) {
            Hashtable hashtable = new Hashtable(35);
            Invoke.collectDeclaredMethods(clazz, hashtable);
            Enumeration enumeration = hashtable.elements();
            Method[] methodArray = new Method[hashtable.size()];
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                methodArray[n2] = (Method)enumeration.nextElement();
                ++n2;
            }
            return methodArray;
        }
        return null;
    }

    private static void collectDeclaredMethods(Class clazz, Hashtable hashtable) {
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            hashtable.put(methodArray[i2], methodArray[i2]);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i3 = 0; i3 < classArray.length; ++i3) {
            Invoke.collectDeclaredMethods(classArray[i3], hashtable);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            Invoke.collectDeclaredMethods(clazz2, hashtable);
        }
    }

    private static Method getSetAccessibleMethod() {
        try {
            Class<?> clazz = Class.forName("java.lang.reflect.AccessibleObject");
            Class<?> clazz2 = Class.forName("[Ljava.lang.reflect.AccessibleObject;");
            return clazz.getMethod("setAccessible", clazz2, Boolean.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static Object[] makeAccessible(Object[] objectArray) {
        if (objectArray != null && a != null) {
            try {
                a.invoke(null, objectArray, Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectArray;
    }
}

