/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import org.jmol.atomdata.AtomIndexIterator;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.SphereIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;

class AtomIteratorWithinSet
implements AtomIndexIterator {
    ModelSet modelSet;
    SphereIterator bsptIter;
    BitSet bsSelected;
    boolean isGreaterOnly;
    int atomIndex;
    int zerobase;
    int iNext;

    AtomIteratorWithinSet() {
    }

    void initialize(ModelSet modelSet, Bspf bspf, int n, int n2, float f, BitSet bitSet, boolean bl, boolean bl2) {
        this.bsptIter = bspf.getSphereIterator(n);
        this.bsptIter.initialize(modelSet.atoms[n2], f);
        this.atomIndex = n2;
        this.bsSelected = bitSet;
        this.isGreaterOnly = bl;
        this.zerobase = bl2 ? modelSet.getFirstAtomIndexInModel(n) : 0;
    }

    public boolean hasNext() {
        while (this.bsptIter.hasMoreElements()) {
            Atom atom = (Atom)this.bsptIter.nextElement();
            this.iNext = atom.atomIndex;
            if (this.iNext == this.atomIndex || this.iNext <= (this.isGreaterOnly ? this.atomIndex : -1) || this.bsSelected != null && !this.bsSelected.get(this.iNext)) continue;
            return true;
        }
        this.iNext = -1;
        return false;
    }

    public int next() {
        return this.iNext - this.zerobase;
    }

    public void release() {
        this.bsptIter.release();
        this.bsptIter = null;
    }
}

