/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.ShapeRenderer;

public abstract class MeshRenderer
extends ShapeRenderer {
    protected Point3f[] vertices;
    protected short[] normixes;
    protected Point3i[] screens;
    protected Vector3f[] transformedVectors;
    protected int vertexCount;
    protected int lighting;
    protected boolean frontOnly;
    protected Mesh mesh;

    protected void render() {
        MeshCollection meshCollection = (MeshCollection)this.shape;
        int n = meshCollection.meshCount;
        while (--n >= 0) {
            this.render1(meshCollection.meshes[n]);
        }
    }

    public boolean render1(Mesh mesh) {
        this.mesh = mesh;
        if (!this.setVariables()) {
            return false;
        }
        this.transform();
        this.render2();
        this.viewer.freeTempScreens(this.screens);
        return true;
    }

    private boolean setVariables() {
        this.vertices = this.mesh.vertices;
        if (this.mesh == null || this.mesh.visibilityFlags == 0 || !this.g3d.setColix(this.mesh.colix) || (this.vertexCount = this.mesh.vertexCount) == 0) {
            return false;
        }
        this.normixes = this.mesh.normixes;
        if (this.normixes == null || this.vertices == null) {
            return false;
        }
        this.lighting = this.mesh.lighting;
        this.frontOnly = this.mesh.frontOnly && !this.mesh.isTwoSided;
        this.screens = this.viewer.allocTempScreens(this.vertexCount);
        this.transformedVectors = this.g3d.getTransformedVertexVectors();
        return true;
    }

    protected void transform() {
        int n = this.vertexCount;
        while (--n >= 0) {
            this.viewer.transformPoint(this.vertices[n], this.screens[n]);
        }
    }

    protected boolean isPolygonDisplayable(int n) {
        return true;
    }

    protected void render2() {
        if (this.mesh.showPoints) {
            this.renderPoints();
        }
        if (this.mesh.drawTriangles) {
            this.renderTriangles(false, false);
        }
        if (this.mesh.fillTriangles) {
            this.renderTriangles(true, this.mesh.showTriangles);
        }
    }

    protected void renderPoints() {
        int n = this.vertexCount;
        while (--n >= 0) {
            if (this.frontOnly && !(this.transformedVectors[this.normixes[n]].z >= 0.0f)) continue;
            this.g3d.fillSphereCentered(4, this.screens[n]);
        }
    }

    protected void renderTriangles(boolean bl, boolean bl2) {
        int[][] nArray = this.mesh.polygonIndexes;
        short s = this.mesh.colix;
        this.g3d.setColix(s);
        int n = this.mesh.polygonCount;
        while (--n >= 0) {
            int n2;
            if (!this.isPolygonDisplayable(n)) continue;
            int[] nArray2 = nArray[n];
            int n3 = nArray2[0];
            int n4 = nArray2[1];
            int n5 = nArray2[2];
            if (n4 == n5) {
                n2 = this.mesh.diameter > 0 ? this.mesh.diameter : (n3 == n4 ? 6 : 3);
                this.g3d.fillCylinder((byte)3, n2, this.screens[n3], this.screens[n4]);
                continue;
            }
            switch (nArray2.length) {
                case 3: {
                    if (this.frontOnly && this.transformedVectors[this.normixes[n3]].z < 0.0f && this.transformedVectors[this.normixes[n4]].z < 0.0f && this.transformedVectors[this.normixes[n5]].z < 0.0f) break;
                    if (bl) {
                        if (bl2) {
                            this.g3d.fillTriangle(this.screens[n3], s, this.normixes[n3], this.screens[n4], s, this.normixes[n4], this.screens[n5], s, this.normixes[n5], 0.1f);
                            break;
                        }
                        this.g3d.fillTriangle(this.screens[n3], s, this.normixes[n3], this.screens[n4], s, this.normixes[n4], this.screens[n5], s, this.normixes[n5]);
                        break;
                    }
                    this.g3d.drawTriangle(this.screens[n3], this.screens[n4], this.screens[n5], 7);
                    break;
                }
                case 4: {
                    n2 = nArray2[3];
                    if (this.frontOnly && this.transformedVectors[this.normixes[n3]].z < 0.0f && this.transformedVectors[this.normixes[n4]].z < 0.0f && this.transformedVectors[this.normixes[n5]].z < 0.0f && this.transformedVectors[this.normixes[n2]].z < 0.0f) break;
                    if (bl) {
                        this.g3d.fillQuadrilateral(this.screens[n3], s, this.normixes[n3], this.screens[n4], s, this.normixes[n4], this.screens[n5], s, this.normixes[n5], this.screens[n2], s, this.normixes[n2]);
                        break;
                    }
                    this.g3d.drawQuadrilateral(s, this.screens[n3], this.screens[n4], this.screens[n5], this.screens[n2]);
                }
            }
        }
    }
}

