/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.List;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.DelimiterFactory;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.MiddleAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FencedAtom
extends Atom {
    private final Atom a;
    private SymbolAtom a;
    private SymbolAtom b = null;
    private final List a = null;

    public FencedAtom(Atom atom, SymbolAtom symbolAtom, SymbolAtom symbolAtom2) {
        this(atom, symbolAtom, null, symbolAtom2);
    }

    public FencedAtom(Atom atom, SymbolAtom symbolAtom, List list, SymbolAtom symbolAtom2) {
        this.a = atom == null ? new RowAtom() : atom;
        if (symbolAtom == null || !symbolAtom.getName().equals("normaldot")) {
            this.a = symbolAtom;
        }
        if (symbolAtom2 == null || !symbolAtom2.getName().equals("normaldot")) {
            this.b = symbolAtom2;
        }
        this.a = list;
    }

    public int getLeftType() {
        return 4;
    }

    public int getRightType() {
        return 5;
    }

    private static void center(Box box, float f) {
        float f2 = box.getHeight();
        float f3 = f2 + box.getDepth();
        box.setShift(-(f3 / 2.0f - f2) - f);
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        TeXFont teXFont = teXEnvironment.getTeXFont();
        Box box = this.a.createBox(teXEnvironment);
        float f = 5.0f * SpaceAtom.getFactor(3, teXEnvironment);
        float f2 = teXFont.getAxisHeight(teXEnvironment.getStyle());
        float f3 = Math.max(box.getHeight() - f2, box.getDepth() + f2);
        float f4 = Math.max(f3 / 500.0f * 901.0f, 2.0f * f3 - f);
        HorizontalBox horizontalBox = new HorizontalBox();
        if (this.a != null) {
            for (int i = 0; i < this.a.size(); ++i) {
                MiddleAtom middleAtom = (MiddleAtom)this.a.get(i);
                if (!(middleAtom.a instanceof SymbolAtom)) continue;
                Box box2 = DelimiterFactory.create(((SymbolAtom)middleAtom.a).getName(), teXEnvironment, f4);
                FencedAtom.center(box2, f2);
                middleAtom.a = box2;
            }
            if (this.a.size() != 0) {
                box = this.a.createBox(teXEnvironment);
            }
        }
        if (this.a != null) {
            Box box3 = DelimiterFactory.create(this.a.getName(), teXEnvironment, f4);
            FencedAtom.center(box3, f2);
            horizontalBox.add(box3);
        }
        if (!(this.a instanceof SpaceAtom)) {
            horizontalBox.add(Glue.get(4, this.a.getLeftType(), teXEnvironment));
        }
        horizontalBox.add(box);
        if (!(this.a instanceof SpaceAtom)) {
            horizontalBox.add(Glue.get(this.a.getRightType(), 5, teXEnvironment));
        }
        if (this.b != null) {
            Box box4 = DelimiterFactory.create(this.b.getName(), teXEnvironment, f4);
            FencedAtom.center(box4, f2);
            horizontalBox.add(box4);
        }
        return horizontalBox;
    }
}

