/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.StrutBox;

public class HorizontalBox
extends Box {
    private float e = 0.0f;

    public HorizontalBox(Box box, float f, int n) {
        if (f != Float.POSITIVE_INFINITY) {
            float f2 = f - box.getWidth();
            if (n == 2 || n == 5) {
                StrutBox strutBox = new StrutBox(f2 / 2.0f, 0.0f, 0.0f, 0.0f);
                this.add(strutBox);
                this.add(box);
                this.add(strutBox);
            } else if (n == 0) {
                this.add(box);
                this.add(new StrutBox(f2, 0.0f, 0.0f, 0.0f));
            } else if (n == 1) {
                this.add(new StrutBox(f2, 0.0f, 0.0f, 0.0f));
                this.add(box);
            } else {
                this.add(box);
            }
        } else {
            this.add(box);
        }
    }

    public HorizontalBox(Box box) {
        this.add(box);
    }

    public HorizontalBox() {
    }

    public HorizontalBox(Color color, Color color2) {
        super(color, color2);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        this.startDraw(graphics2D, f, f2);
        float f3 = f;
        for (Box box : this.a) {
            box.draw(graphics2D, f3, f2 + box.d);
            f3 += box.getWidth();
        }
        this.endDraw(graphics2D);
    }

    public final void add(Box box) {
        this.recalculate(box);
        super.add(box);
    }

    public final void add(int n, Box box) {
        this.recalculate(box);
        super.add(n, box);
    }

    private void recalculate(Box box) {
        this.e += box.getWidth();
        this.a = Math.max(this.a, this.e);
        this.b = Math.max(this.a.size() == 0 ? Float.NEGATIVE_INFINITY : this.b, box.b - box.d);
        this.c = Math.max(this.a.size() == 0 ? Float.NEGATIVE_INFINITY : this.c, box.c + box.d);
    }

    public int getLastFontId() {
        int n = -1;
        ListIterator listIterator = this.a.listIterator(this.a.size());
        while (n == -1 && listIterator.hasPrevious()) {
            n = ((Box)listIterator.previous()).getLastFontId();
        }
        return n;
    }
}

