/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.util.StringTokenizer;
import org.scilab.forge.jlatexmath.AccentedAtom;
import org.scilab.forge.jlatexmath.ArrayOfAtoms;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.BigDelimiterAtom;
import org.scilab.forge.jlatexmath.BoldAtom;
import org.scilab.forge.jlatexmath.CedillaAtom;
import org.scilab.forge.jlatexmath.CharAtom;
import org.scilab.forge.jlatexmath.ColorAtom;
import org.scilab.forge.jlatexmath.CumulativeScriptsAtom;
import org.scilab.forge.jlatexmath.DdotsAtom;
import org.scilab.forge.jlatexmath.DefaultTeXFont;
import org.scilab.forge.jlatexmath.DoubleFramedAtom;
import org.scilab.forge.jlatexmath.FBoxAtom;
import org.scilab.forge.jlatexmath.FencedAtom;
import org.scilab.forge.jlatexmath.FractionAtom;
import org.scilab.forge.jlatexmath.GeoGebraLogoAtom;
import org.scilab.forge.jlatexmath.GraphicsAtom;
import org.scilab.forge.jlatexmath.HdotsforAtom;
import org.scilab.forge.jlatexmath.HlineAtom;
import org.scilab.forge.jlatexmath.IJAtom;
import org.scilab.forge.jlatexmath.IddotsAtom;
import org.scilab.forge.jlatexmath.ItAtom;
import org.scilab.forge.jlatexmath.JavaFontRenderingAtom;
import org.scilab.forge.jlatexmath.JavaFontRenderingBox;
import org.scilab.forge.jlatexmath.LCaronAtom;
import org.scilab.forge.jlatexmath.LaTeXAtom;
import org.scilab.forge.jlatexmath.LapedAtom;
import org.scilab.forge.jlatexmath.MathAtom;
import org.scilab.forge.jlatexmath.MatrixAtom;
import org.scilab.forge.jlatexmath.MiddleAtom;
import org.scilab.forge.jlatexmath.MonoScaleAtom;
import org.scilab.forge.jlatexmath.MulticolumnAtom;
import org.scilab.forge.jlatexmath.MultlineAtom;
import org.scilab.forge.jlatexmath.NewCommandMacro;
import org.scilab.forge.jlatexmath.NewEnvironmentMacro;
import org.scilab.forge.jlatexmath.NthRoot;
import org.scilab.forge.jlatexmath.OgonekAtom;
import org.scilab.forge.jlatexmath.OvalAtom;
import org.scilab.forge.jlatexmath.OverUnderDelimiter;
import org.scilab.forge.jlatexmath.OverlinedAtom;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.PhantomAtom;
import org.scilab.forge.jlatexmath.RaiseAtom;
import org.scilab.forge.jlatexmath.ReflectAtom;
import org.scilab.forge.jlatexmath.ResizeAtom;
import org.scilab.forge.jlatexmath.RomanAtom;
import org.scilab.forge.jlatexmath.RotateAtom;
import org.scilab.forge.jlatexmath.RowAtom;
import org.scilab.forge.jlatexmath.RuleAtom;
import org.scilab.forge.jlatexmath.ScaleAtom;
import org.scilab.forge.jlatexmath.ScriptsAtom;
import org.scilab.forge.jlatexmath.ShadowAtom;
import org.scilab.forge.jlatexmath.SmallCapAtom;
import org.scilab.forge.jlatexmath.SmashedAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.SsAtom;
import org.scilab.forge.jlatexmath.StyleAtom;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TStrokeAtom;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXFormula$FontInfos;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.TextCircledAtom;
import org.scilab.forge.jlatexmath.TextStyleAtom;
import org.scilab.forge.jlatexmath.TtAtom;
import org.scilab.forge.jlatexmath.TypedAtom;
import org.scilab.forge.jlatexmath.UnderOverArrowAtom;
import org.scilab.forge.jlatexmath.UnderOverAtom;
import org.scilab.forge.jlatexmath.UnderlinedAtom;
import org.scilab.forge.jlatexmath.UnderscoreAtom;
import org.scilab.forge.jlatexmath.VCenteredAtom;
import org.scilab.forge.jlatexmath.VRowAtom;
import org.scilab.forge.jlatexmath.VdotsAtom;
import org.scilab.forge.jlatexmath.XArrowAtom;
import org.scilab.forge.jlatexmath.b.a;
import org.scilab.forge.jlatexmath.tcaronAtom;

public class PredefMacros {
    public static final Atom Braket_macro(TeXParser teXParser, String[] stringArray) {
        String string = stringArray[1].replaceAll("\\|", "\\\\middle\\\\vert ");
        return new TeXFormula((boolean)teXParser.getIsPartial(), (String)new StringBuilder().append((String)"\\left\\langle ").append((String)string).append((String)"\\right\\rangle").toString()).a;
    }

    public static final Atom Set_macro(TeXParser teXParser, String[] stringArray) {
        String string = stringArray[1].replaceFirst("\\|", "\\\\middle\\\\vert ");
        return new TeXFormula((boolean)teXParser.getIsPartial(), (String)new StringBuilder().append((String)"\\left\\{").append((String)string).append((String)"\\right\\}").toString()).a;
    }

    public static final Atom spATbreve_macro(TeXParser teXParser, String[] stringArray) {
        VRowAtom vRowAtom = new VRowAtom(new TeXFormula((String)"\\displaystyle\\!\\breve{}").a);
        vRowAtom.setRaise(1, 0.6f);
        return new SmashedAtom(vRowAtom, null);
    }

    public static final Atom spAThat_macro(TeXParser teXParser, String[] stringArray) {
        VRowAtom vRowAtom = new VRowAtom(new TeXFormula((String)"\\displaystyle\\widehat{}").a);
        vRowAtom.setRaise(1, 0.6f);
        return new SmashedAtom(vRowAtom, null);
    }

    public static final Atom hvspace_macro(TeXParser teXParser, String[] stringArray) {
        int n;
        for (n = 0; n < stringArray[1].length() && !Character.isLetter(stringArray[1].charAt(n)); ++n) {
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(stringArray[1].substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.toString());
        }
        int n2 = n != stringArray[1].length() ? SpaceAtom.getUnit(stringArray[1].substring(n).toLowerCase()) : 3;
        if (n2 == -1) {
            throw new ParseException("Unknown unit \"" + stringArray[1].substring(n) + "\" !");
        }
        return stringArray[0].charAt(0) == 'h' ? new SpaceAtom(n2, f, 0.0f, 0.0f) : new SpaceAtom(n2, 0.0f, f, 0.0f);
    }

    public static final Atom clrlap_macro(TeXParser teXParser, String[] stringArray) {
        return new LapedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a, stringArray[0].charAt(0));
    }

    public static final Atom mathclrlap_macro(TeXParser teXParser, String[] stringArray) {
        return new LapedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a, stringArray[0].charAt(4));
    }

    public static final Atom includegraphics_macro(TeXParser teXParser, String[] stringArray) {
        return new GraphicsAtom(stringArray[1], stringArray[2]);
    }

    public static final Atom rule_macro(TeXParser teXParser, String[] stringArray) {
        float[] fArray = SpaceAtom.getLength(stringArray[1]);
        if (fArray.length == 1) {
            throw new ParseException("Error in getting width in \\rule command !");
        }
        float[] fArray2 = SpaceAtom.getLength(stringArray[2]);
        if (fArray2.length == 1) {
            throw new ParseException("Error in getting height in \\rule command !");
        }
        float[] fArray3 = SpaceAtom.getLength(stringArray[3]);
        if (fArray3.length == 1) {
            throw new ParseException("Error in getting raise in \\rule command !");
        }
        return new RuleAtom((int)fArray[0], fArray[1], (int)fArray2[0], fArray2[1], (int)fArray3[0], -fArray3[1]);
    }

    public static final Atom cfrac_macro(TeXParser teXParser, String[] stringArray) {
        int n = 2;
        if ("r".equals(stringArray[3])) {
            n = 1;
        } else if ("l".equals(stringArray[3])) {
            n = 0;
        }
        TeXFormula teXFormula = new TeXFormula(teXParser.getIsPartial(), stringArray[1], false);
        TeXFormula teXFormula2 = new TeXFormula(teXParser.getIsPartial(), stringArray[2], false);
        if (teXFormula.a == null || teXFormula2.a == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        FractionAtom fractionAtom = new FractionAtom(teXFormula.a, teXFormula2.a, true, n, 2);
        RowAtom rowAtom = new RowAtom();
        rowAtom.add(new StyleAtom(0, fractionAtom));
        return rowAtom;
    }

    public static final Atom frac_macro(TeXParser teXParser, String[] stringArray) {
        TeXFormula teXFormula = new TeXFormula(teXParser.getIsPartial(), stringArray[1], false);
        TeXFormula teXFormula2 = new TeXFormula(teXParser.getIsPartial(), stringArray[2], false);
        if (teXFormula.a == null || teXFormula2.a == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        return new FractionAtom(teXFormula.a, teXFormula2.a, true);
    }

    public static final Atom sfrac_macro(TeXParser teXParser, String[] stringArray) {
        TeXFormula teXFormula = new TeXFormula(teXParser.getIsPartial(), stringArray[1], false);
        TeXFormula teXFormula2 = new TeXFormula(teXParser.getIsPartial(), stringArray[2], false);
        if (teXFormula.a == null || teXFormula2.a == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        double d = 0.75;
        double d2 = 0.75;
        float f = 0.45f;
        float f2 = -0.3f;
        float f3 = -0.15f;
        Atom atom = SymbolAtom.get("slash");
        if (!teXParser.isMathMode()) {
            d = 0.6;
            d2 = 0.5;
            f = 0.75f;
            f2 = -0.55f;
            f3 = -0.55f;
            atom = new VRowAtom(new ScaleAtom(SymbolAtom.get("textfractionsolidus"), 1.25, 0.65));
            ((VRowAtom)atom).setRaise(1, 0.4f);
        }
        VRowAtom vRowAtom = new VRowAtom(new ScaleAtom(teXFormula.a, d, d2));
        vRowAtom.setRaise(1, f);
        RowAtom rowAtom = new RowAtom(vRowAtom);
        rowAtom.add(new SpaceAtom(0, f2, 0.0f, 0.0f));
        rowAtom.add(atom);
        rowAtom.add(new SpaceAtom(0, f3, 0.0f, 0.0f));
        rowAtom.add(new ScaleAtom(teXFormula2.a, d, d2));
        return rowAtom;
    }

    public static final Atom genfrac_macro(TeXParser teXParser, String[] stringArray) {
        TeXFormula teXFormula;
        TeXFormula teXFormula2 = new TeXFormula(teXParser.getIsPartial(), stringArray[1], false);
        SymbolAtom symbolAtom = null;
        SymbolAtom symbolAtom2 = null;
        if (teXFormula2 != null && teXFormula2.a instanceof SymbolAtom) {
            symbolAtom = (SymbolAtom)teXFormula2.a;
        }
        if ((teXFormula = new TeXFormula(teXParser.getIsPartial(), stringArray[2], false)) != null && teXFormula.a instanceof SymbolAtom) {
            symbolAtom2 = (SymbolAtom)teXFormula.a;
        }
        boolean bl = true;
        float[] fArray = SpaceAtom.getLength(stringArray[3]);
        if (stringArray[3] == null || stringArray[3].length() == 0 || fArray.length == 1) {
            fArray = new float[]{0.0f, 0.0f};
            bl = false;
        }
        int n = 0;
        if (stringArray[4].length() != 0) {
            n = Integer.parseInt(stringArray[4]);
        }
        TeXFormula teXFormula3 = new TeXFormula(teXParser.getIsPartial(), stringArray[5], false);
        TeXFormula teXFormula4 = new TeXFormula(teXParser.getIsPartial(), stringArray[6], false);
        if (teXFormula3.a == null || teXFormula4.a == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        FractionAtom fractionAtom = new FractionAtom(teXFormula3.a, teXFormula4.a, bl, (int)fArray[0], fArray[1]);
        RowAtom rowAtom = new RowAtom();
        rowAtom.add(new StyleAtom(n * 2, new FencedAtom(fractionAtom, symbolAtom, symbolAtom2)));
        return rowAtom;
    }

    public static final Atom over_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = teXParser.getFormulaAtom();
        Atom atom2 = new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), (boolean)false).a;
        if (atom == null || atom2 == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        return new FractionAtom(atom, atom2, true);
    }

    public static final Atom overwithdelims_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom;
        Atom atom2 = teXParser.getFormulaAtom();
        Atom atom3 = new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), (boolean)false).a;
        if (atom2 == null || atom3 == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        Atom atom4 = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (atom4 instanceof BigDelimiterAtom) {
            atom4 = ((BigDelimiterAtom)atom4).a;
        }
        if ((atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a) instanceof BigDelimiterAtom) {
            atom = ((BigDelimiterAtom)atom).a;
        }
        if (atom4 instanceof SymbolAtom && atom instanceof SymbolAtom) {
            return new FencedAtom(new FractionAtom(atom2, atom3, true), (SymbolAtom)atom4, (SymbolAtom)atom);
        }
        RowAtom rowAtom = new RowAtom();
        rowAtom.add(atom4);
        rowAtom.add(new FractionAtom(atom2, atom3, true));
        rowAtom.add(atom);
        return rowAtom;
    }

    public static final Atom atop_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = teXParser.getFormulaAtom();
        Atom atom2 = new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), (boolean)false).a;
        if (atom == null || atom2 == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        return new FractionAtom(atom, atom2, false);
    }

    public static final Atom atopwithdelims_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom;
        Atom atom2 = teXParser.getFormulaAtom();
        Atom atom3 = new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), (boolean)false).a;
        if (atom2 == null || atom3 == null) {
            throw new ParseException("Both numerator and denominator of a fraction can't be empty!");
        }
        Atom atom4 = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (atom4 instanceof BigDelimiterAtom) {
            atom4 = ((BigDelimiterAtom)atom4).a;
        }
        if ((atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a) instanceof BigDelimiterAtom) {
            atom = ((BigDelimiterAtom)atom).a;
        }
        if (atom4 instanceof SymbolAtom && atom instanceof SymbolAtom) {
            return new FencedAtom(new FractionAtom(atom2, atom3, false), (SymbolAtom)atom4, (SymbolAtom)atom);
        }
        RowAtom rowAtom = new RowAtom();
        rowAtom.add(atom4);
        rowAtom.add(new FractionAtom(atom2, atom3, false));
        rowAtom.add(atom);
        return rowAtom;
    }

    public static final Atom choose_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = teXParser.getFormulaAtom();
        Atom atom2 = new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), (boolean)false).a;
        if (atom == null || atom2 == null) {
            throw new ParseException("Both numerator and denominator of choose can't be empty!");
        }
        return new FencedAtom(new FractionAtom(atom, atom2, false), new SymbolAtom("lbrack", 4, true), new SymbolAtom("rbrack", 5, true));
    }

    public static final Atom binom_macro(TeXParser teXParser, String[] stringArray) {
        TeXFormula teXFormula = new TeXFormula(teXParser.getIsPartial(), stringArray[1], false);
        TeXFormula teXFormula2 = new TeXFormula(teXParser.getIsPartial(), stringArray[2], false);
        if (teXFormula.a == null || teXFormula2.a == null) {
            throw new ParseException("Both binomial coefficients must be not empty !!");
        }
        return new FencedAtom(new FractionAtom(teXFormula.a, teXFormula2.a, false), new SymbolAtom("lbrack", 4, true), new SymbolAtom("rbrack", 5, true));
    }

    public static final Atom textstyle_macros(TeXParser teXParser, String[] stringArray) {
        String string = stringArray[0];
        if ("frak".equals(stringArray[0])) {
            string = "mathfrak";
        } else if ("Bbb".equals(stringArray[0])) {
            string = "mathbb";
        } else {
            if ("bold".equals(stringArray[0])) {
                return new BoldAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
            }
            if ("cal".equals(stringArray[0])) {
                string = "mathcal";
            }
        }
        TeXFormula$FontInfos teXFormula$FontInfos = (TeXFormula$FontInfos)TeXFormula.c.get(Character.UnicodeBlock.BASIC_LATIN);
        if (teXFormula$FontInfos != null) {
            TeXFormula.c.put(Character.UnicodeBlock.BASIC_LATIN, null);
        }
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (teXFormula$FontInfos != null) {
            TeXFormula.c.put(Character.UnicodeBlock.BASIC_LATIN, teXFormula$FontInfos);
        }
        return new TextStyleAtom(atom, string);
    }

    public static final Atom mbox_macro(TeXParser teXParser, String[] stringArray) {
        String string = stringArray[1].replaceAll("_", "\\\\_");
        RomanAtom romanAtom = new RomanAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)string, (String)"mathnormal", (boolean)false, (boolean)false).a);
        return new StyleAtom(2, romanAtom);
    }

    public static final Atom text_macro(TeXParser teXParser, String[] stringArray) {
        String string = stringArray[1].replaceAll("_", "\\\\_");
        return new RomanAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)string, (String)"mathnormal", (boolean)false, (boolean)false).a);
    }

    public static final Atom underscore_macro(TeXParser teXParser, String[] stringArray) {
        return new UnderscoreAtom();
    }

    public static final Atom accent_macros(TeXParser teXParser, String[] stringArray) {
        return new AccentedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, stringArray[0]);
    }

    public static final Atom grkaccent_macro(TeXParser teXParser, String[] stringArray) {
        return new AccentedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, false);
    }

    public static final Atom accent_macro(TeXParser teXParser, String[] stringArray) {
        return new AccentedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom accentbis_macros(TeXParser teXParser, String[] stringArray) {
        String string = "";
        switch (stringArray[0].charAt(0)) {
            case '~': {
                string = "tilde";
                break;
            }
            case '\'': {
                string = "acute";
                break;
            }
            case '^': {
                string = "hat";
                break;
            }
            case '\"': {
                string = "ddot";
                break;
            }
            case '`': {
                string = "grave";
                break;
            }
            case '=': {
                string = "bar";
                break;
            }
            case '.': {
                string = "dot";
                break;
            }
            case 'u': {
                string = "breve";
                break;
            }
            case 'v': {
                string = "check";
                break;
            }
            case 'H': {
                string = "doubleacute";
                break;
            }
            case 't': {
                string = "tie";
                break;
            }
            case 'r': {
                string = "mathring";
                break;
            }
            case 'U': {
                string = "cyrbreve";
            }
        }
        return new AccentedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, string);
    }

    public static final Atom cedilla_macro(TeXParser teXParser, String[] stringArray) {
        return new CedillaAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a);
    }

    public static final Atom IJ_macro(TeXParser teXParser, String[] stringArray) {
        return new IJAtom(stringArray[0].charAt(0) == 'I');
    }

    public static final Atom TStroke_macro(TeXParser teXParser, String[] stringArray) {
        return new TStrokeAtom(stringArray[0].charAt(0) == 'T');
    }

    public static final Atom LCaron_macro(TeXParser teXParser, String[] stringArray) {
        return new LCaronAtom(stringArray[0].charAt(0) == 'L');
    }

    public static final Atom tcaron_macro(TeXParser teXParser, String[] stringArray) {
        return new tcaronAtom();
    }

    public static final Atom ogonek_macro(TeXParser teXParser, String[] stringArray) {
        return new OgonekAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a);
    }

    public static final Atom nbsp_macro(TeXParser teXParser, String[] stringArray) {
        return new SpaceAtom();
    }

    public static final Atom sqrt_macro(TeXParser teXParser, String[] stringArray) {
        if (stringArray[2] == null) {
            return new NthRoot(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, null);
        }
        return new NthRoot(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a);
    }

    public static final Atom overrightarrow_macro(TeXParser teXParser, String[] stringArray) {
        return new UnderOverArrowAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, false, true);
    }

    public static final Atom overleftarrow_macro(TeXParser teXParser, String[] stringArray) {
        return new UnderOverArrowAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, true, true);
    }

    public static final Atom overleftrightarrow_macro(TeXParser teXParser, String[] stringArray) {
        return new UnderOverArrowAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, true);
    }

    public static final Atom underrightarrow_macro(TeXParser teXParser, String[] stringArray) {
        return new UnderOverArrowAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, false, false);
    }

    public static final Atom underleftarrow_macro(TeXParser teXParser, String[] stringArray) {
        return new UnderOverArrowAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, true, false);
    }

    public static final Atom underleftrightarrow_macro(TeXParser teXParser, String[] stringArray) {
        return new UnderOverArrowAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, false);
    }

    public static final Atom xleftarrow_macro(TeXParser teXParser, String[] stringArray) {
        return new XArrowAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, true);
    }

    public static final Atom xrightarrow_macro(TeXParser teXParser, String[] stringArray) {
        return new XArrowAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, false);
    }

    public static final Atom sideset_macro(TeXParser teXParser, String[] stringArray) {
        TeXFormula teXFormula = new TeXFormula();
        teXFormula.add(new PhantomAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[3]).a, false, true, true));
        teXFormula.append(teXParser.getIsPartial(), stringArray[1]);
        teXFormula.add(new SpaceAtom(5, -0.3f, 0.0f, 0.0f));
        teXFormula.append(teXParser.getIsPartial(), stringArray[3] + "\\nolimits" + stringArray[2]);
        return new TypedAtom(0, 0, teXFormula.a);
    }

    public static final Atom prescript_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[3]).a;
        teXParser.addAtom(new ScriptsAtom(new PhantomAtom(atom, false, true, true), new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a, false));
        teXParser.addAtom(new SpaceAtom(5, -0.3f, 0.0f, 0.0f));
        return new TypedAtom(0, 0, atom);
    }

    public static final Atom underbrace_macro(TeXParser teXParser, String[] stringArray) {
        return new OverUnderDelimiter(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, null, SymbolAtom.get("rbrace"), 1, 0.0f, false);
    }

    public static final Atom overbrace_macro(TeXParser teXParser, String[] stringArray) {
        return new OverUnderDelimiter(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, null, SymbolAtom.get("lbrace"), 1, 0.0f, true);
    }

    public static final Atom underbrack_macro(TeXParser teXParser, String[] stringArray) {
        return new OverUnderDelimiter(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, null, SymbolAtom.get("rsqbrack"), 1, 0.0f, false);
    }

    public static final Atom overbrack_macro(TeXParser teXParser, String[] stringArray) {
        return new OverUnderDelimiter(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, null, SymbolAtom.get("lsqbrack"), 1, 0.0f, true);
    }

    public static final Atom underparen_macro(TeXParser teXParser, String[] stringArray) {
        return new OverUnderDelimiter(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, null, SymbolAtom.get("rbrack"), 1, 0.0f, false);
    }

    public static final Atom overparen_macro(TeXParser teXParser, String[] stringArray) {
        return new OverUnderDelimiter(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, null, SymbolAtom.get("lbrack"), 1, 0.0f, true);
    }

    public static final Atom overline_macro(TeXParser teXParser, String[] stringArray) {
        return new OverlinedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom underline_macro(TeXParser teXParser, String[] stringArray) {
        return new UnderlinedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom mathop_macro(TeXParser teXParser, String[] stringArray) {
        TypedAtom typedAtom = new TypedAtom(1, 1, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
        typedAtom.b = 0;
        return typedAtom;
    }

    public static final Atom mathpunct_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(6, 6, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom mathord_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(0, 0, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom mathrel_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(3, 3, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom mathinner_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(7, 7, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom mathbin_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(2, 2, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom mathopen_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(4, 4, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom mathclose_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(5, 5, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom joinrel_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(3, 3, new SpaceAtom(5, -2.6f, 0.0f, 0.0f));
    }

    public static final Atom smash_macro(TeXParser teXParser, String[] stringArray) {
        return new SmashedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, stringArray[2]);
    }

    public static final Atom vdots_macro(TeXParser teXParser, String[] stringArray) {
        return new VdotsAtom();
    }

    public static final Atom ddots_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(7, 7, new DdotsAtom());
    }

    public static final Atom iddots_macro(TeXParser teXParser, String[] stringArray) {
        return new TypedAtom(7, 7, new IddotsAtom());
    }

    public static final Atom nolimits_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = teXParser.getLastAtom();
        atom.b = 1;
        return atom.clone();
    }

    public static final Atom limits_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = teXParser.getLastAtom();
        atom.b = 2;
        return atom.clone();
    }

    public static final Atom normal_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = teXParser.getLastAtom();
        atom.b = 0;
        return atom.clone();
    }

    public static final Atom left_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom;
        String string = teXParser.getGroup("\\left", "\\right");
        Atom atom2 = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (atom2 instanceof BigDelimiterAtom) {
            atom2 = ((BigDelimiterAtom)atom2).a;
        }
        if ((atom = teXParser.getArgument()) instanceof BigDelimiterAtom) {
            atom = ((BigDelimiterAtom)atom).a;
        }
        if (atom2 instanceof SymbolAtom && atom instanceof SymbolAtom) {
            TeXFormula teXFormula = new TeXFormula(teXParser.getIsPartial(), string, false);
            return new FencedAtom(teXFormula.a, (SymbolAtom)atom2, teXFormula.a, (SymbolAtom)atom);
        }
        RowAtom rowAtom = new RowAtom();
        rowAtom.add(atom2);
        rowAtom.add(new TeXFormula((boolean)teXParser.getIsPartial(), (String)string, (boolean)false).a);
        rowAtom.add(atom);
        return rowAtom;
    }

    public static final Atom leftparenthesis_macro(TeXParser teXParser, String[] stringArray) {
        String string = teXParser.getGroup("\\(", "\\)");
        return new MathAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)string, (boolean)false).a, 2);
    }

    public static final Atom leftbracket_macro(TeXParser teXParser, String[] stringArray) {
        String string = teXParser.getGroup("\\[", "\\]");
        return new MathAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)string, (boolean)false).a, 0);
    }

    public static final Atom middle_macro(TeXParser teXParser, String[] stringArray) {
        return new MiddleAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a);
    }

    public static final Atom cr_macro(TeXParser teXParser, String[] stringArray) {
        if (!teXParser.isArrayMode()) {
            throw new ParseException("The token \\cr is only available in array mode !");
        }
        teXParser.addRow();
        return null;
    }

    public static final Atom backslashcr_macro(TeXParser teXParser, String[] stringArray) {
        if (teXParser.isArrayMode()) {
            teXParser.addRow();
        }
        return null;
    }

    public static final Atom intertext_macro(TeXParser teXParser, String[] stringArray) {
        if (!teXParser.isArrayMode()) {
            throw new ParseException("Bad environment for \\intertext command !");
        }
        String string = stringArray[1].replaceAll("\\^\\{\\\\prime\\}", "'");
        string = string.replaceAll("\\^\\{\\\\prime\\\\prime\\}", "''");
        RomanAtom romanAtom = new RomanAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)string, (String)"mathnormal", (boolean)false, (boolean)false).a);
        ((Atom)romanAtom).a = 11;
        teXParser.addAtom(romanAtom);
        teXParser.addRow();
        return null;
    }

    public static final Atom smallmatrixATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[1], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        return new MatrixAtom(teXParser.getIsPartial(), arrayOfAtoms, 5);
    }

    public static final Atom matrixATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[1], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        return new MatrixAtom(teXParser.getIsPartial(), arrayOfAtoms, 1);
    }

    public static final Atom multicolumn_macro(TeXParser teXParser, String[] stringArray) {
        int n = Integer.parseInt(stringArray[1]);
        teXParser.addAtom(new MulticolumnAtom(n, stringArray[2], new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[3]).a));
        ((ArrayOfAtoms)teXParser.a).addCol(n);
        return null;
    }

    public static final Atom hdotsfor_macro(TeXParser teXParser, String[] stringArray) {
        int n = Integer.parseInt(stringArray[1]);
        float f = 1.0f;
        if (stringArray[2] != null) {
            f = Float.parseFloat(stringArray[2]);
        }
        teXParser.addAtom(new HdotsforAtom(n, f));
        ((ArrayOfAtoms)teXParser.a).addCol(n);
        return null;
    }

    public static final Atom arrayATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[2], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        return new MatrixAtom(teXParser.getIsPartial(), arrayOfAtoms, stringArray[1]);
    }

    public static final Atom alignATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[1], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        return new MatrixAtom(teXParser.getIsPartial(), arrayOfAtoms, 2);
    }

    public static final Atom flalignATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[1], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        return new MatrixAtom(teXParser.getIsPartial(), arrayOfAtoms, 4);
    }

    public static final Atom alignatATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[2], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        int n = Integer.parseInt(stringArray[1]);
        if (arrayOfAtoms.a != 2 * n) {
            throw new ParseException("Bad number of equations in alignat environment !");
        }
        return new MatrixAtom(teXParser.getIsPartial(), arrayOfAtoms, 3);
    }

    public static final Atom alignedATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[1], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        return new MatrixAtom(teXParser.getIsPartial(), arrayOfAtoms, 6);
    }

    public static final Atom alignedatATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[2], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        int n = Integer.parseInt(stringArray[1]);
        if (arrayOfAtoms.a != 2 * n) {
            throw new ParseException("Bad number of equations in alignedat environment !");
        }
        return new MatrixAtom(teXParser.getIsPartial(), arrayOfAtoms, 7);
    }

    public static final Atom multlineATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[1], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        if (arrayOfAtoms.a > 1) {
            throw new ParseException("Character '&' is only available in array mode !");
        }
        if (arrayOfAtoms.a == 0) {
            return null;
        }
        return new MultlineAtom(teXParser.getIsPartial(), arrayOfAtoms, 0);
    }

    public static final Atom gatherATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[1], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        if (arrayOfAtoms.a > 1) {
            throw new ParseException("Character '&' is only available in array mode !");
        }
        if (arrayOfAtoms.a == 0) {
            return null;
        }
        return new MultlineAtom(teXParser.getIsPartial(), arrayOfAtoms, 1);
    }

    public static final Atom gatheredATATenv_macro(TeXParser teXParser, String[] stringArray) {
        ArrayOfAtoms arrayOfAtoms = new ArrayOfAtoms();
        TeXParser teXParser2 = new TeXParser(teXParser.getIsPartial(), stringArray[1], arrayOfAtoms, false);
        teXParser2.parse();
        arrayOfAtoms.checkDimensions();
        if (arrayOfAtoms.a > 1) {
            throw new ParseException("Character '&' is only available in array mode !");
        }
        if (arrayOfAtoms.a == 0) {
            return null;
        }
        return new MultlineAtom(teXParser.getIsPartial(), arrayOfAtoms, 2);
    }

    public static final Atom shoveright_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a;
        atom.c = 1;
        return atom;
    }

    public static final Atom shoveleft_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a;
        atom.c = 0;
        return atom;
    }

    public static final Atom newcommand_macro(TeXParser teXParser, String[] stringArray) {
        String string = stringArray[1];
        if (!teXParser.isValidName(string)) {
            throw new ParseException("Invalid name for the command :" + string);
        }
        Integer n = stringArray[3] == null ? new Integer(0) : Integer.valueOf(Integer.parseInt(stringArray[3]));
        if (n == null) {
            throw new ParseException("The optional argument should be an integer !");
        }
        if (stringArray[4] == null) {
            NewCommandMacro.addNewCommand(string.substring(1), stringArray[2], n);
        } else {
            NewCommandMacro.addNewCommand(string.substring(1), stringArray[2], n, stringArray[4]);
        }
        return null;
    }

    public static final Atom renewcommand_macro(TeXParser teXParser, String[] stringArray) {
        String string = stringArray[1];
        if (!teXParser.isValidName(string)) {
            throw new ParseException("Invalid name for the command :" + string);
        }
        Integer n = stringArray[3] == null ? new Integer(0) : Integer.valueOf(Integer.parseInt(stringArray[3]));
        if (n == null) {
            throw new ParseException("The optional argument should be an integer !");
        }
        NewCommandMacro.addReNewCommand(string.substring(1), stringArray[2], n);
        return null;
    }

    public static final Atom makeatletter_macro(TeXParser teXParser, String[] stringArray) {
        teXParser.makeAtLetter();
        return null;
    }

    public static final Atom makeatother_macro(TeXParser teXParser, String[] stringArray) {
        teXParser.makeAtOther();
        return null;
    }

    public static final Atom newenvironment_macro(TeXParser teXParser, String[] stringArray) {
        Integer n = stringArray[4] == null ? 0 : Integer.parseInt(stringArray[4]);
        if (n == null) {
            throw new ParseException("The optional argument should be an integer !");
        }
        NewEnvironmentMacro.addNewEnvironment(stringArray[1], stringArray[2], stringArray[3], n);
        return null;
    }

    public static final Atom renewenvironment_macro(TeXParser teXParser, String[] stringArray) {
        Integer n = stringArray[4] == null ? 0 : Integer.parseInt(stringArray[4]);
        if (n == null) {
            throw new ParseException("The optional argument should be an integer !");
        }
        NewEnvironmentMacro.addReNewEnvironment(stringArray[1], stringArray[2], stringArray[3], n);
        return null;
    }

    public static final Atom fbox_macro(TeXParser teXParser, String[] stringArray) {
        return new FBoxAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom stackrel_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[3], (boolean)false).a, 5, 0.5f, true, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, 5, 2.5f, true);
        return new TypedAtom(3, 3, underOverAtom);
    }

    public static final Atom stackbin_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[3], (boolean)false).a, 5, 0.5f, true, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, 5, 2.5f, true);
        return new TypedAtom(2, 2, underOverAtom);
    }

    public static final Atom overset_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, 5, 2.5f, true, true);
        return new TypedAtom(3, 3, underOverAtom);
    }

    public static final Atom underset_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, 5, 0.5f, true, false);
        return new TypedAtom(3, 3, underOverAtom);
    }

    public static final Atom accentset_macro(TeXParser teXParser, String[] stringArray) {
        return new AccentedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom underaccent_macro(TeXParser teXParser, String[] stringArray) {
        return new UnderOverAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2], (boolean)false).a, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, 5, 0.3f, true, false);
    }

    public static final Atom undertilde_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        return new UnderOverAtom(atom, new AccentedAtom((Atom)new PhantomAtom(atom, true, false, false), "widetilde"), 5, 0.3f, true, false);
    }

    public static final Atom boldsymbol_macro(TeXParser teXParser, String[] stringArray) {
        return new BoldAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom mathrm_macro(TeXParser teXParser, String[] stringArray) {
        return new RomanAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom rm_macro(TeXParser teXParser, String[] stringArray) {
        return new RomanAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), null, (boolean)false, (boolean)teXParser.isIgnoreWhiteSpace()).a);
    }

    public static final Atom mathbf_macro(TeXParser teXParser, String[] stringArray) {
        return new BoldAtom(new RomanAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a));
    }

    public static final Atom bf_macro(TeXParser teXParser, String[] stringArray) {
        return new BoldAtom(new RomanAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), null, (boolean)false, (boolean)teXParser.isIgnoreWhiteSpace()).a));
    }

    public static final Atom mathtt_macro(TeXParser teXParser, String[] stringArray) {
        return new TtAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom tt_macro(TeXParser teXParser, String[] stringArray) {
        return new TtAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), null, (boolean)false, (boolean)teXParser.isIgnoreWhiteSpace()).a);
    }

    public static final Atom mathit_macro(TeXParser teXParser, String[] stringArray) {
        return new ItAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom it_macro(TeXParser teXParser, String[] stringArray) {
        return new ItAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), null, (boolean)false, (boolean)teXParser.isIgnoreWhiteSpace()).a);
    }

    public static final Atom mathsf_macro(TeXParser teXParser, String[] stringArray) {
        return new SsAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom sf_macro(TeXParser teXParser, String[] stringArray) {
        return new SsAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), null, (boolean)false, (boolean)teXParser.isIgnoreWhiteSpace()).a);
    }

    public static final Atom LaTeX_macro(TeXParser teXParser, String[] stringArray) {
        return new LaTeXAtom();
    }

    public static final Atom GeoGebra_macro(TeXParser teXParser, String[] stringArray) {
        TeXFormula teXFormula = new TeXFormula("\\mathbb{G}\\mathsf{e}");
        teXFormula.add(new GeoGebraLogoAtom());
        teXFormula.add("\\mathsf{Gebra}");
        return new ColorAtom(teXFormula.a, null, new Color(102, 102, 102));
    }

    public static final Atom hphantom_macro(TeXParser teXParser, String[] stringArray) {
        return new PhantomAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, true, false, false);
    }

    public static final Atom vphantom_macro(TeXParser teXParser, String[] stringArray) {
        return new PhantomAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, false, true, true);
    }

    public static final Atom phantom_macro(TeXParser teXParser, String[] stringArray) {
        return new PhantomAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a, true, true, true);
    }

    public static final Atom big_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        return new BigDelimiterAtom((SymbolAtom)atom, 1);
    }

    public static final Atom Big_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        return new BigDelimiterAtom((SymbolAtom)atom, 2);
    }

    public static final Atom bigg_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        return new BigDelimiterAtom((SymbolAtom)atom, 3);
    }

    public static final Atom Bigg_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        return new BigDelimiterAtom((SymbolAtom)atom, 4);
    }

    public static final Atom bigl_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)atom, 1);
        ((Atom)bigDelimiterAtom).a = 4;
        return bigDelimiterAtom;
    }

    public static final Atom Bigl_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)atom, 2);
        ((Atom)bigDelimiterAtom).a = 4;
        return bigDelimiterAtom;
    }

    public static final Atom biggl_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)atom, 3);
        ((Atom)bigDelimiterAtom).a = 4;
        return bigDelimiterAtom;
    }

    public static final Atom Biggl_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)atom, 4);
        ((Atom)bigDelimiterAtom).a = 4;
        return bigDelimiterAtom;
    }

    public static final Atom bigr_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)atom, 1);
        ((Atom)bigDelimiterAtom).a = 5;
        return bigDelimiterAtom;
    }

    public static final Atom Bigr_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)atom, 2);
        ((Atom)bigDelimiterAtom).a = 5;
        return bigDelimiterAtom;
    }

    public static final Atom biggr_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)atom, 3);
        ((Atom)bigDelimiterAtom).a = 5;
        return bigDelimiterAtom;
    }

    public static final Atom Biggr_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a;
        if (!(atom instanceof SymbolAtom)) {
            return atom;
        }
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)atom, 4);
        ((Atom)bigDelimiterAtom).a = 5;
        return bigDelimiterAtom;
    }

    public static final Atom displaystyle_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), (boolean)false).a;
        return new StyleAtom(0, atom);
    }

    public static final Atom scriptstyle_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), (boolean)false).a;
        return new StyleAtom(4, atom);
    }

    public static final Atom textstyle_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), (boolean)false).a;
        return new StyleAtom(2, atom);
    }

    public static final Atom scriptscriptstyle_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), (boolean)false).a;
        return new StyleAtom(6, atom);
    }

    public static final Atom rotatebox_macro(TeXParser teXParser, String[] stringArray) {
        return new RotateAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, stringArray[1] == null ? 0.0 : Double.parseDouble(stringArray[1]), stringArray[3]);
    }

    public static final Atom reflectbox_macro(TeXParser teXParser, String[] stringArray) {
        return new ReflectAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a);
    }

    public static final Atom scalebox_macro(TeXParser teXParser, String[] stringArray) {
        return new ScaleAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, Double.parseDouble(stringArray[1]), stringArray[3] == null ? Double.parseDouble(stringArray[1]) : Double.parseDouble(stringArray[3]));
    }

    public static final Atom resizebox_macro(TeXParser teXParser, String[] stringArray) {
        return new ResizeAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[3]).a, stringArray[1], stringArray[2], false);
    }

    public static final Atom raisebox_macro(TeXParser teXParser, String[] stringArray) {
        float[] fArray = SpaceAtom.getLength(stringArray[1]);
        float[] fArray2 = SpaceAtom.getLength(stringArray[3]);
        float[] fArray3 = SpaceAtom.getLength(stringArray[4]);
        if (fArray2.length == 1 || fArray2[1] == 0.0f) {
            fArray2[0] = -1.0f;
        }
        if (fArray3.length == 1 || fArray3[1] == 0.0f) {
            fArray3[0] = -1.0f;
        }
        return new RaiseAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, (int)fArray[0], fArray[1], (int)fArray2[0], fArray2[1], (int)fArray3[0], fArray3[1]);
    }

    public static final Atom shadowbox_macro(TeXParser teXParser, String[] stringArray) {
        return new ShadowAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a);
    }

    public static final Atom ovalbox_macro(TeXParser teXParser, String[] stringArray) {
        return new OvalAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a);
    }

    public static final Atom doublebox_macro(TeXParser teXParser, String[] stringArray) {
        return new DoubleFramedAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a);
    }

    public static final Atom definecolor_macro(TeXParser teXParser, String[] stringArray) {
        Color color = null;
        if ("gray".equals(stringArray[2])) {
            float f = Float.parseFloat(stringArray[3]);
            color = new Color(f, f, f);
        } else if ("rgb".equals(stringArray[2])) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[3], ",");
            if (stringTokenizer.countTokens() != 3) {
                throw new ParseException("The color definition must have three components !");
            }
            float f = Float.parseFloat(stringTokenizer.nextToken());
            float f2 = Float.parseFloat(stringTokenizer.nextToken());
            float f3 = Float.parseFloat(stringTokenizer.nextToken());
            color = new Color(f, f2, f3);
        } else if ("cmyk".equals(stringArray[2])) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[3], ",");
            if (stringTokenizer.countTokens() != 4) {
                throw new ParseException("The color definition must have four components !");
            }
            float[] fArray = new float[4];
            for (int i = 0; i < 4; ++i) {
                fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
            }
            float f = 1.0f - fArray[3];
            color = new Color(f * (1.0f - fArray[0]), f * (1.0f - fArray[1]), f * (1.0f - fArray[2]));
        } else {
            throw new ParseException("The color model is incorrect !");
        }
        ColorAtom.a.put(stringArray[1], color);
        return null;
    }

    public static final Atom fgcolor_macro(TeXParser teXParser, String[] stringArray) {
        String string;
        String string2 = string = stringArray[1] == null ? "#000000" : stringArray[1].trim();
        if (!string.startsWith("#")) {
            string = "#" + string;
        }
        try {
            return new ColorAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, null, Color.decode(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.toString());
        }
    }

    public static final Atom bgcolor_macro(TeXParser teXParser, String[] stringArray) {
        String string;
        String string2 = string = stringArray[1] == null ? "#000000" : stringArray[1].trim();
        if (!string.startsWith("#")) {
            string = "#" + string;
        }
        try {
            return new ColorAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, Color.decode(string), null);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.toString());
        }
    }

    public static final Atom textcolor_macro(TeXParser teXParser, String[] stringArray) {
        return new ColorAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, null, (Color)ColorAtom.a.get(stringArray[1]));
    }

    public static final Atom colorbox_macro(TeXParser teXParser, String[] stringArray) {
        Color color = (Color)ColorAtom.a.get(stringArray[1]);
        return new FBoxAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[2]).a, color, color);
    }

    public static final Atom fcolorbox_macro(TeXParser teXParser, String[] stringArray) {
        return new FBoxAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[3]).a, (Color)ColorAtom.a.get(stringArray[2]), (Color)ColorAtom.a.get(stringArray[1]));
    }

    public static final Atom cong_macro(TeXParser teXParser, String[] stringArray) {
        VRowAtom vRowAtom = new VRowAtom(SymbolAtom.get("equals"));
        vRowAtom.add(new SpaceAtom(5, 0.0f, 1.5f, 0.0f));
        vRowAtom.add(SymbolAtom.get("sim"));
        vRowAtom.setRaise(5, -1.0f);
        return new TypedAtom(3, 3, vRowAtom);
    }

    public static final Atom doteq_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("equals"), SymbolAtom.get("ldotp"), 5, 3.7f, false, true);
        return new TypedAtom(3, 3, underOverAtom);
    }

    public static final Atom jlmDynamic_macro(TeXParser teXParser, String[] stringArray) {
        if (a.a()) {
            return new a(stringArray[1]);
        }
        throw new ParseException("No ExternalConverterFactory set !");
    }

    public static final Atom jlmExternalFont_macro(TeXParser teXParser, String[] stringArray) {
        JavaFontRenderingBox.setFont(stringArray[1]);
        return null;
    }

    public static final Atom jlmText_macro(TeXParser teXParser, String[] stringArray) {
        return new JavaFontRenderingAtom(stringArray[1], 0);
    }

    public static final Atom jlmTextit_macro(TeXParser teXParser, String[] stringArray) {
        return new JavaFontRenderingAtom(stringArray[1], 2);
    }

    public static final Atom jlmTextbf_macro(TeXParser teXParser, String[] stringArray) {
        return new JavaFontRenderingAtom(stringArray[1], 1);
    }

    public static final Atom jlmTextitbf_macro(TeXParser teXParser, String[] stringArray) {
        return new JavaFontRenderingAtom(stringArray[1], 3);
    }

    public static final Atom DeclareMathSizes_macro(TeXParser teXParser, String[] stringArray) {
        DefaultTeXFont.setMathSizes(Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]), Float.parseFloat(stringArray[3]), Float.parseFloat(stringArray[4]));
        return null;
    }

    public static final Atom magnification_macro(TeXParser teXParser, String[] stringArray) {
        DefaultTeXFont.setMagnification(Float.parseFloat(stringArray[1]));
        return null;
    }

    public static final Atom hline_macro(TeXParser teXParser, String[] stringArray) {
        if (!teXParser.isArrayMode()) {
            throw new ParseException("The macro \\hline is only available in array mode !");
        }
        return new HlineAtom();
    }

    public static final Atom size_macros(TeXParser teXParser, String[] stringArray) {
        float f = 1.0f;
        if ("tiny".equals(stringArray[0])) {
            f = 0.5f;
        } else if ("scriptsize".equals(stringArray[0])) {
            f = 0.7f;
        } else if ("footnotesize".equals(stringArray[0])) {
            f = 0.8f;
        } else if ("small".equals(stringArray[0])) {
            f = 0.9f;
        } else if ("normalsize".equals(stringArray[0])) {
            f = 1.0f;
        } else if ("large".equals(stringArray[0])) {
            f = 1.2f;
        } else if ("Large".equals(stringArray[0])) {
            f = 1.4f;
        } else if ("LARGE".equals(stringArray[0])) {
            f = 1.8f;
        } else if ("huge".equals(stringArray[0])) {
            f = 2.0f;
        } else if ("Huge".equals(stringArray[0])) {
            f = 2.5f;
        }
        return new MonoScaleAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), null, (boolean)false, (boolean)teXParser.isIgnoreWhiteSpace()).a, f);
    }

    public static final Atom jlatexmathcumsup_macro(TeXParser teXParser, String[] stringArray) {
        return new CumulativeScriptsAtom(teXParser.getLastAtom(), null, new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a);
    }

    public static final Atom jlatexmathcumsub_macro(TeXParser teXParser, String[] stringArray) {
        return new CumulativeScriptsAtom(teXParser.getLastAtom(), new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a, null);
    }

    public static final Atom dotminus_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("minus"), SymbolAtom.get("normaldot"), 5, -3.3f, false, true);
        return new TypedAtom(2, 2, underOverAtom);
    }

    public static final Atom ratio_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        return new TypedAtom(3, 3, underOverAtom);
    }

    public static final Atom geoprop_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(SymbolAtom.get("normaldot"));
        rowAtom.add(new SpaceAtom(5, 4.0f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("normaldot"));
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("minus"), rowAtom, 5, -3.4f, false, rowAtom, 5, -3.4f, false);
        return new TypedAtom(3, 3, underOverAtom);
    }

    public static final Atom minuscolon_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(SymbolAtom.get("minus"));
        rowAtom.add(new SpaceAtom(0, -0.22f, 0.0f, 0.0f));
        rowAtom.add(new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom minuscoloncolon_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(SymbolAtom.get("minus"));
        rowAtom.add(new SpaceAtom(0, -0.22f, 0.0f, 0.0f));
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        rowAtom.add(underOverAtom);
        rowAtom.add(underOverAtom);
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom simcolon_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(SymbolAtom.get("sim"));
        rowAtom.add(new SpaceAtom(0, -0.22f, 0.0f, 0.0f));
        rowAtom.add(new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom simcoloncolon_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(SymbolAtom.get("sim"));
        rowAtom.add(new SpaceAtom(0, -0.22f, 0.0f, 0.0f));
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        rowAtom.add(underOverAtom);
        rowAtom.add(underOverAtom);
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom approxcolon_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(SymbolAtom.get("approx"));
        rowAtom.add(new SpaceAtom(0, -0.22f, 0.0f, 0.0f));
        rowAtom.add(new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom approxcoloncolon_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(SymbolAtom.get("approx"));
        rowAtom.add(new SpaceAtom(0, -0.22f, 0.0f, 0.0f));
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        rowAtom.add(underOverAtom);
        rowAtom.add(underOverAtom);
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom equalscolon_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(SymbolAtom.get("equals"));
        rowAtom.add(new SpaceAtom(0, -0.22f, 0.0f, 0.0f));
        rowAtom.add(new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom equalscoloncolon_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(SymbolAtom.get("equals"));
        rowAtom.add(new SpaceAtom(0, -0.22f, 0.0f, 0.0f));
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        rowAtom.add(underOverAtom);
        rowAtom.add(underOverAtom);
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom colonminus_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true));
        rowAtom.add(new SpaceAtom(0, -0.75f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("minus"));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom coloncolonminus_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        RowAtom rowAtom = new RowAtom(underOverAtom);
        rowAtom.add(underOverAtom);
        rowAtom.add(new SpaceAtom(0, -0.75f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("minus"));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom colonequals_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true));
        rowAtom.add(new SpaceAtom(0, -0.75f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("equals"));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom coloncolonequals_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        RowAtom rowAtom = new RowAtom(underOverAtom);
        rowAtom.add(underOverAtom);
        rowAtom.add(new SpaceAtom(0, -0.75f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("equals"));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom coloncolon_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        RowAtom rowAtom = new RowAtom(underOverAtom);
        rowAtom.add(underOverAtom);
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom colonsim_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true));
        rowAtom.add(new SpaceAtom(0, -0.75f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("sim"));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom coloncolonsim_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        RowAtom rowAtom = new RowAtom(underOverAtom);
        rowAtom.add(underOverAtom);
        rowAtom.add(new SpaceAtom(0, -0.75f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("sim"));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom colonapprox_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true));
        rowAtom.add(new SpaceAtom(0, -0.75f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("approx"));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom coloncolonapprox_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("normaldot"), SymbolAtom.get("normaldot"), 5, 5.2f, false, true);
        RowAtom rowAtom = new RowAtom(underOverAtom);
        rowAtom.add(underOverAtom);
        rowAtom.add(new SpaceAtom(0, -0.75f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("approx"));
        return new TypedAtom(3, 3, rowAtom);
    }

    public static final Atom smallfrowneq_macro(TeXParser teXParser, String[] stringArray) {
        UnderOverAtom underOverAtom = new UnderOverAtom(SymbolAtom.get("equals"), SymbolAtom.get("smallfrown"), 5, -2.0f, true, true);
        return new TypedAtom(3, 3, underOverAtom);
    }

    public static final Atom hstrok_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(new SpaceAtom(1, -0.1f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("bar"));
        VRowAtom vRowAtom = new VRowAtom(new LapedAtom(rowAtom, 'r'));
        vRowAtom.setRaise(1, -0.1f);
        RowAtom rowAtom2 = new RowAtom(vRowAtom);
        rowAtom2.add(new RomanAtom(new CharAtom('h', teXParser.a.a)));
        return rowAtom2;
    }

    public static final Atom Hstrok_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(new SpaceAtom(1, 0.28f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("textendash"));
        VRowAtom vRowAtom = new VRowAtom(new LapedAtom(rowAtom, 'r'));
        vRowAtom.setRaise(1, 0.55f);
        RowAtom rowAtom2 = new RowAtom(vRowAtom);
        rowAtom2.add(new RomanAtom(new CharAtom('H', teXParser.a.a)));
        return rowAtom2;
    }

    public static final Atom dstrok_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(new SpaceAtom(1, 0.25f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("bar"));
        VRowAtom vRowAtom = new VRowAtom(new LapedAtom(rowAtom, 'r'));
        vRowAtom.setRaise(1, -0.1f);
        RowAtom rowAtom2 = new RowAtom(vRowAtom);
        rowAtom2.add(new RomanAtom(new CharAtom('d', teXParser.a.a)));
        return rowAtom2;
    }

    public static final Atom Dstrok_macro(TeXParser teXParser, String[] stringArray) {
        RowAtom rowAtom = new RowAtom(new SpaceAtom(1, -0.1f, 0.0f, 0.0f));
        rowAtom.add(SymbolAtom.get("bar"));
        VRowAtom vRowAtom = new VRowAtom(new LapedAtom(rowAtom, 'r'));
        vRowAtom.setRaise(1, -0.55f);
        RowAtom rowAtom2 = new RowAtom(vRowAtom);
        rowAtom2.add(new RomanAtom(new CharAtom('D', teXParser.a.a)));
        return rowAtom2;
    }

    public static final Atom kern_macro(TeXParser teXParser, String[] stringArray) {
        float[] fArray = SpaceAtom.getLength(stringArray[1]);
        return new SpaceAtom((int)fArray[0], fArray[1], 0.0f, 0.0f);
    }

    public static final Atom char_macro(TeXParser teXParser, String[] stringArray) {
        String string = stringArray[1];
        int n = 10;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            string = string.substring(2);
            n = 16;
        } else if (string.startsWith("x") || string.startsWith("X")) {
            string = string.substring(1);
            n = 16;
        } else if (string.startsWith("0")) {
            string = string.substring(1);
            n = 8;
        }
        int n2 = Integer.parseInt(string, n);
        return teXParser.convertCharacter((char)n2, true);
    }

    public static final Atom T_macro(TeXParser teXParser, String[] stringArray) {
        return new RotateAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a, 180.0, "origin=cc");
    }

    public static final Atom romannumeral_macro(TeXParser teXParser, String[] stringArray) {
        int[] nArray = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] stringArray2 = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        String string = "";
        int n = Integer.parseInt(stringArray[1].trim());
        for (int i = 0; i < nArray.length; ++i) {
            while (n >= nArray[i]) {
                string = string + stringArray2[i];
                n -= nArray[i];
            }
        }
        if (stringArray[0].charAt(0) == 'r') {
            string = string.toLowerCase();
        }
        return new TeXFormula((String)string, (boolean)false).a;
    }

    public static final Atom textcircled_macro(TeXParser teXParser, String[] stringArray) {
        return new TextCircledAtom(new RomanAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1]).a));
    }

    public static final Atom textsc_macro(TeXParser teXParser, String[] stringArray) {
        return new SmallCapAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)stringArray[1], (boolean)false).a);
    }

    public static final Atom sc_macro(TeXParser teXParser, String[] stringArray) {
        return new SmallCapAtom(new TeXFormula((boolean)teXParser.getIsPartial(), (String)teXParser.getOverArgument(), null, (boolean)false, (boolean)teXParser.isIgnoreWhiteSpace()).a);
    }

    public static final Atom quad_macro(TeXParser teXParser, String[] stringArray) {
        return new SpaceAtom(0, 1.0f, 0.0f, 0.0f);
    }

    public static final Atom muskip_macros(TeXParser teXParser, String[] stringArray) {
        int n = 0;
        if (stringArray[0].equals(",")) {
            n = 1;
        } else if (stringArray[0].equals(":")) {
            n = 2;
        } else if (stringArray[0].equals(";")) {
            n = 3;
        } else if (stringArray[0].equals("thinspace")) {
            n = 1;
        } else if (stringArray[0].equals("medspace")) {
            n = 2;
        } else if (stringArray[0].equals("thickspace")) {
            n = 3;
        } else if (stringArray[0].equals("!")) {
            n = -1;
        } else if (stringArray[0].equals("negthinspace")) {
            n = -1;
        } else if (stringArray[0].equals("negmedspace")) {
            n = -2;
        } else if (stringArray[0].equals("negthickspace")) {
            n = -3;
        }
        return new SpaceAtom(n);
    }

    public static final Atom surd_macro(TeXParser teXParser, String[] stringArray) {
        return new VCenteredAtom(SymbolAtom.get("surdsign"));
    }

    public static final Atom int_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = SymbolAtom.get("int").clone();
        atom.b = 1;
        return atom;
    }

    public static final Atom oint_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = SymbolAtom.get("oint").clone();
        atom.b = 1;
        return atom;
    }

    public static final Atom iint_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = SymbolAtom.get("int").clone();
        atom.b = 1;
        RowAtom rowAtom = new RowAtom(atom);
        rowAtom.add(new SpaceAtom(5, -6.0f, 0.0f, 0.0f));
        rowAtom.add(atom);
        rowAtom.a = true;
        return new TypedAtom(1, 1, rowAtom);
    }

    public static final Atom iiint_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = SymbolAtom.get("int").clone();
        atom.b = 1;
        RowAtom rowAtom = new RowAtom(atom);
        rowAtom.add(new SpaceAtom(5, -6.0f, 0.0f, 0.0f));
        rowAtom.add(atom);
        rowAtom.add(new SpaceAtom(5, -6.0f, 0.0f, 0.0f));
        rowAtom.add(atom);
        rowAtom.a = true;
        return new TypedAtom(1, 1, rowAtom);
    }

    public static final Atom iiiint_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = SymbolAtom.get("int").clone();
        atom.b = 1;
        RowAtom rowAtom = new RowAtom(atom);
        rowAtom.add(new SpaceAtom(5, -6.0f, 0.0f, 0.0f));
        rowAtom.add(atom);
        rowAtom.add(new SpaceAtom(5, -6.0f, 0.0f, 0.0f));
        rowAtom.add(atom);
        rowAtom.add(new SpaceAtom(5, -6.0f, 0.0f, 0.0f));
        rowAtom.add(atom);
        rowAtom.a = true;
        return new TypedAtom(1, 1, rowAtom);
    }

    public static final Atom idotsint_macro(TeXParser teXParser, String[] stringArray) {
        Atom atom = SymbolAtom.get("int").clone();
        atom.b = 1;
        RowAtom rowAtom = new RowAtom(atom);
        rowAtom.add(new SpaceAtom(5, -1.0f, 0.0f, 0.0f));
        SymbolAtom symbolAtom = SymbolAtom.get("cdotp");
        RowAtom rowAtom2 = new RowAtom(symbolAtom);
        rowAtom2.add(symbolAtom);
        rowAtom2.add(symbolAtom);
        rowAtom.add(new TypedAtom(7, 7, rowAtom2));
        rowAtom.add(new SpaceAtom(5, -1.0f, 0.0f, 0.0f));
        rowAtom.add(atom);
        rowAtom.a = true;
        return new TypedAtom(1, 1, rowAtom);
    }

    public static final Atom lmoustache_macro(TeXParser teXParser, String[] stringArray) {
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)SymbolAtom.get("lmoustache").clone(), 1);
        ((Atom)bigDelimiterAtom).a = 4;
        return bigDelimiterAtom;
    }

    public static final Atom rmoustache_macro(TeXParser teXParser, String[] stringArray) {
        BigDelimiterAtom bigDelimiterAtom = new BigDelimiterAtom((SymbolAtom)SymbolAtom.get("rmoustache").clone(), 1);
        ((Atom)bigDelimiterAtom).a = 5;
        return bigDelimiterAtom;
    }

    static {
        NewEnvironmentMacro.addNewEnvironment("array", "\\array@@env{#1}{", "}", 1);
        NewEnvironmentMacro.addNewEnvironment("tabular", "\\array@@env{#1}{", "}", 1);
        NewEnvironmentMacro.addNewEnvironment("matrix", "\\matrix@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("smallmatrix", "\\smallmatrix@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("pmatrix", "\\left(\\begin{matrix}", "\\end{matrix}\\right)", 0);
        NewEnvironmentMacro.addNewEnvironment("bmatrix", "\\left[\\begin{matrix}", "\\end{matrix}\\right]", 0);
        NewEnvironmentMacro.addNewEnvironment("Bmatrix", "\\left\\{\\begin{matrix}", "\\end{matrix}\\right\\}", 0);
        NewEnvironmentMacro.addNewEnvironment("vmatrix", "\\left|\\begin{matrix}", "\\end{matrix}\\right|", 0);
        NewEnvironmentMacro.addNewEnvironment("Vmatrix", "\\left\\|\\begin{matrix}", "\\end{matrix}\\right\\|", 0);
        NewEnvironmentMacro.addNewEnvironment("eqnarray", "\\begin{array}{rcl}", "\\end{array}", 0);
        NewEnvironmentMacro.addNewEnvironment("align", "\\align@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("flalign", "\\flalign@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("alignat", "\\alignat@@env{#1}{", "}", 1);
        NewEnvironmentMacro.addNewEnvironment("aligned", "\\aligned@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("alignedat", "\\alignedat@@env{#1}{", "}", 1);
        NewEnvironmentMacro.addNewEnvironment("multline", "\\multline@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("cases", "\\left\\{\\begin{array}{l@{\\!}l}", "\\end{array}\\right.", 0);
        NewEnvironmentMacro.addNewEnvironment("split", "\\begin{array}{rl}", "\\end{array}", 0);
        NewEnvironmentMacro.addNewEnvironment("gather", "\\gather@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("gathered", "\\gathered@@env{", "}", 0);
        NewEnvironmentMacro.addNewEnvironment("math", "\\(", "\\)", 0);
        NewEnvironmentMacro.addNewEnvironment("displaymath", "\\[", "\\]", 0);
        NewCommandMacro.addNewCommand("operatorname", "\\mathop{\\mathrm{#1}}\\nolimits ", 1);
        NewCommandMacro.addNewCommand("DeclareMathOperator", "\\newcommand{#1}{\\mathop{\\mathrm{#2}}\\nolimits}", 2);
        NewCommandMacro.addNewCommand("substack", "{\\scriptstyle\\begin{array}{c}#1\\end{array}}", 1);
        NewCommandMacro.addNewCommand("dfrac", "\\genfrac{}{}{}{}{#1}{#2}", 2);
        NewCommandMacro.addNewCommand("tfrac", "\\genfrac{}{}{}{1}{#1}{#2}", 2);
        NewCommandMacro.addNewCommand("dbinom", "\\genfrac{(}{)}{0pt}{}{#1}{#2}", 2);
        NewCommandMacro.addNewCommand("tbinom", "\\genfrac{(}{)}{0pt}{1}{#1}{#2}", 2);
        NewCommandMacro.addNewCommand("pmod", "\\qquad\\mathbin{(\\mathrm{mod}\\ #1)}", 1);
        NewCommandMacro.addNewCommand("mod", "\\qquad\\mathbin{\\mathrm{mod}\\ #1}", 1);
        NewCommandMacro.addNewCommand("pod", "\\qquad\\mathbin{(#1)}", 1);
        NewCommandMacro.addNewCommand("dddot", "\\mathop{#1}\\limits^{...}", 1);
        NewCommandMacro.addNewCommand("ddddot", "\\mathop{#1}\\limits^{....}", 1);
        NewCommandMacro.addNewCommand("spdddot", "^{\\mathrm{...}}", 0);
        NewCommandMacro.addNewCommand("spbreve", "^{\\makeatletter\\sp@breve\\makeatother}", 0);
        NewCommandMacro.addNewCommand("sphat", "^{\\makeatletter\\sp@hat\\makeatother}", 0);
        NewCommandMacro.addNewCommand("spddot", "^{\\displaystyle..}", 0);
        NewCommandMacro.addNewCommand("spcheck", "^{\\vee}", 0);
        NewCommandMacro.addNewCommand("sptilde", "^{\\sim}", 0);
        NewCommandMacro.addNewCommand("spdot", "^{\\displaystyle.}", 0);
        NewCommandMacro.addNewCommand("d", "\\underaccent{\\dot}{#1}", 1);
        NewCommandMacro.addNewCommand("b", "\\underaccent{\\bar}{#1}", 1);
        NewCommandMacro.addNewCommand("Bra", "\\left\\langle{#1}\\right\\vert", 1);
        NewCommandMacro.addNewCommand("Ket", "\\left\\vert{#1}\\right\\rangle", 1);
        NewCommandMacro.addNewCommand("textsuperscript", "{}^{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textsubscript", "{}_{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textit", "\\mathit{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textbf", "\\mathbf{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textsf", "\\mathsf{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("texttt", "\\mathtt{\\text{#1}}", 1);
        NewCommandMacro.addNewCommand("textrm", "\\text{#1}", 1);
        NewCommandMacro.addNewCommand("degree", "^\\circ", 0);
        NewCommandMacro.addNewCommand("with", "\\mathbin{\\&}", 0);
        NewCommandMacro.addNewCommand("parr", "\\mathbin{\\rotatebox[origin=c]{180}{\\&}}", 0);
    }
}

