/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.scilab.forge.jlatexmath.Box;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RotateBox
extends Box {
    protected double a;
    private Box a = 0.0;
    private float e;
    private float f;
    private float g;
    private float h;
    private float i;
    private float j;

    public RotateBox(Box box, double d, float f, float f2) {
        this.a = box;
        this.a = d * Math.PI / 180.0;
        this.b = box.b;
        this.c = box.c;
        this.a = box.a;
        double d2 = Math.sin(this.a);
        double d3 = Math.cos(this.a);
        this.i = (float)((double)f * (1.0 - d3) + (double)f2 * d2);
        this.j = (float)((double)f2 * (1.0 - d3) - (double)f * d2);
        this.e = (float)Math.max((double)(-this.b) * d2, Math.max((double)this.c * d2, Math.max((double)this.a * d3 + (double)this.c * d2, (double)this.a * d3 - (double)this.b * d2))) + this.i;
        this.f = (float)Math.min((double)(-this.b) * d2, Math.min((double)this.c * d2, Math.min((double)this.a * d3 + (double)this.c * d2, (double)this.a * d3 - (double)this.b * d2))) + this.i;
        this.g = (float)Math.max((double)this.b * d3, Math.max((double)(-this.c) * d3, Math.max((double)this.a * d2 - (double)this.c * d3, (double)this.a * d2 + (double)this.b * d3)));
        this.h = (float)Math.min((double)this.b * d3, Math.min((double)(-this.c) * d3, Math.min((double)this.a * d2 - (double)this.c * d3, (double)this.a * d2 + (double)this.b * d3)));
        this.a = this.e - this.f;
        this.b = this.g + this.j;
        this.c = -this.h - this.j;
    }

    public RotateBox(Box box, double d, Point2D.Float float_) {
        this(box, d, float_.x, float_.y);
    }

    public RotateBox(Box box, double d, int n) {
        this(box, d, RotateBox.calculateShift(box, n));
    }

    public static int getOrigin(String string) {
        if (string == null || string.length() == 0) {
            return 6;
        }
        if (string.length() == 1) {
            string = string + "c";
        }
        if (string.equals("bl") || string.equals("lb")) {
            return 0;
        }
        if (string.equals("bc") || string.equals("cb")) {
            return 1;
        }
        if (string.equals("br") || string.equals("rb")) {
            return 2;
        }
        if (string.equals("cl") || string.equals("lc")) {
            return 9;
        }
        if (string.equals("cc")) {
            return 10;
        }
        if (string.equals("cr") || string.equals("cr")) {
            return 11;
        }
        if (string.equals("tl") || string.equals("lt")) {
            return 3;
        }
        if (string.equals("tc") || string.equals("ct")) {
            return 4;
        }
        if (string.equals("tr") || string.equals("rt")) {
            return 5;
        }
        if (string.equals("Bl") || string.equals("lB")) {
            return 6;
        }
        if (string.equals("Bc") || string.equals("cB")) {
            return 8;
        }
        if (string.equals("Br") || string.equals("rB")) {
            return 7;
        }
        return 6;
    }

    private static Point2D.Float calculateShift(Box box, int n) {
        Point2D.Float float_ = new Point2D.Float(0.0f, -box.c);
        switch (n) {
            case 0: {
                float_.x = 0.0f;
                float_.y = -box.c;
                break;
            }
            case 2: {
                float_.x = box.a;
                float_.y = -box.c;
                break;
            }
            case 1: {
                float_.x = box.a / 2.0f;
                float_.y = -box.c;
                break;
            }
            case 3: {
                float_.x = 0.0f;
                float_.y = box.b;
                break;
            }
            case 5: {
                float_.x = box.a;
                float_.y = box.b;
                break;
            }
            case 4: {
                float_.x = box.a / 2.0f;
                float_.y = box.b;
                break;
            }
            case 6: {
                float_.x = 0.0f;
                float_.y = 0.0f;
                break;
            }
            case 7: {
                float_.x = box.a;
                float_.y = 0.0f;
                break;
            }
            case 8: {
                float_.x = box.a / 2.0f;
                float_.y = 0.0f;
                break;
            }
            case 9: {
                float_.x = 0.0f;
                float_.y = (box.b - box.c) / 2.0f;
                break;
            }
            case 11: {
                float_.x = box.a;
                float_.y = (box.b - box.c) / 2.0f;
                break;
            }
            case 10: {
                float_.x = box.a / 2.0f;
                float_.y = (box.b - box.c) / 2.0f;
                break;
            }
        }
        return float_;
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        this.drawDebug(graphics2D, f, f2);
        this.a.drawDebug(graphics2D, f, f2, true);
        graphics2D.rotate(-this.a, f += this.i - this.f, f2 -= this.j);
        this.a.draw(graphics2D, f, f2);
        this.a.drawDebug(graphics2D, f, f2, true);
        graphics2D.rotate(this.a, f, f2);
    }

    public int getLastFontId() {
        return this.a.getLastFontId();
    }
}

