/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import java.util.ListIterator;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.StrutBox;

class VerticalBox
extends Box {
    private float e = Float.MAX_VALUE;
    private float f = Float.MIN_VALUE;

    public VerticalBox() {
    }

    public VerticalBox(Box box, float f, int n) {
        this();
        this.add(box);
        if (n == 2) {
            StrutBox strutBox = new StrutBox(0.0f, f / 2.0f, 0.0f, 0.0f);
            super.add(0, strutBox);
            this.b += f / 2.0f;
            this.c += f / 2.0f;
            super.add(strutBox);
        } else if (n == 3) {
            this.c += f;
            super.add(new StrutBox(0.0f, f, 0.0f, 0.0f));
        } else if (n == 4) {
            this.b += f;
            super.add(0, new StrutBox(0.0f, f, 0.0f, 0.0f));
        }
    }

    public final void add(Box box) {
        super.add(box);
        if (this.a.size() == 1) {
            this.b = box.b;
            this.c = box.c;
        } else {
            this.c += box.b + box.c;
        }
        this.recalculateWidth(box);
    }

    private void recalculateWidth(Box box) {
        this.e = Math.min(this.e, box.d);
        this.f = Math.max(this.f, box.d + (box.a > 0.0f ? box.a : 0.0f));
        this.a = this.f - this.e;
    }

    public void add(int n, Box box) {
        super.add(n, box);
        if (n == 0) {
            this.c += box.c + this.b;
            this.b = box.b;
        } else {
            this.c += box.b + box.c;
        }
        this.recalculateWidth(box);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        float f3 = f2 - this.b;
        for (Box box : this.a) {
            box.draw(graphics2D, f + box.getShift() - this.e, f3 += box.getHeight());
            f3 += box.getDepth();
        }
    }

    public int getSize() {
        return this.a.size();
    }

    public int getLastFontId() {
        int n = -1;
        ListIterator listIterator = this.a.listIterator(this.a.size());
        while (n == -1 && listIterator.hasPrevious()) {
            n = ((Box)listIterator.previous()).getLastFontId();
        }
        return n;
    }
}

