# The LearningOnline Network
# Logout Handler
#
# $Id: lonlogout.pm,v 1.38 2009/05/16 13:50:04 droeschl Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

=head1 NAME

Apache::lonlogout

=head1 SYNOPSIS


This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.


=cut

package Apache::lonlogout;

use strict;
use Apache::Constants qw(:common);
use Apache::File;
use Apache::lonnet;
use Apache::lonmenu;
use CGI::Cookie();
use Apache::lonlocal;

sub handler {
    my $r = shift;

    #Check for cookie
    my $requrl=$r->uri;
    my $handle = &Apache::lonnet::check_for_valid_session($r);
    #check if cookie still valid
    if ($handle eq '') {
	$r->log_reason("Cookie $handle not valid", $r->filename); 
	return FORBIDDEN;
    }

    #we've got a valid user
    #any locks in place?
    my $locknum=&Apache::lonnet::get_locks();
    if ($locknum) { return 409; }
    #nope, go ahead
    my @profile;
    my $lonidsdir=$r->dir_config('lonIDsDir');
    &Apache::lonnet::transfer_profile_to_env($lonidsdir,$handle);
    unlink("$lonidsdir/$handle.id");
    my %temp=('logout' => time);
    &Apache::lonnet::put('email_status',\%temp);
    &Apache::lonnet::log($env{'user.domain'},
			 $env{'user.name'},
			 $env{'user.home'},
			 "Logout $ENV{'REMOTE_ADDR'}");

    &Apache::loncommon::content_type($r,'text/html');

    #expire the cookie
    my $c = new CGI::Cookie(-name    => 'lonID',
			    -value   => '',
			    -expires => '-10y',);
    $r->header_out('Set-cookie' => $c);

    $r->send_http_header;
    return OK if $r->header_only;
# -------------------------------------------------------- Menu script and info

    my $windowinfo=&Apache::lonmenu::close();
    $windowinfo.=&Apache::lonnavmaps::close();
# ---------------------------------------------------------------- Get handover
    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},['handover']);
    my $switch='';
    my $start_page='';
    my $relogmessage='';
    if ($env{'form.handover'}) {
	$switch='<meta HTTP-EQUIV="Refresh" CONTENT="0.5; url='.
	    $env{'form.handover'}.'" />';
	$start_page=&Apache::loncommon::start_page('Switching Server ...',
						   $switch);
    } else {
	$start_page=&Apache::loncommon::start_page('Logged Out',undef,
                           {'no_inline_link' => 1,
                            'no_nav_bar'     => 1,});
	
        $relogmessage.='<h1>'.&mt('Goodbye').'</h1>'
                      .'<p>'.&mt('Thank you for using LON-CAPA.').'</p>';

	if (!$env{'request.sso.norelogin'}) {
	    my $relogin_server;
	    if ($env{'request.sso.reloginserver'}) {
		$relogin_server = $env{'request.sso.reloginserver'};
	    }
	    my $login_url = $relogin_server.'/adm/'.
		($env{'request.sso.login'} ? 'roles': 'login');

            $relogmessage.='<p>'.&mt('You have been successfully logged out.').' '
                          .&mt('You can [_1]close this window[_2] now.'
                              ,'','') # ,'<a href="javascript:self.close();">','</a>')
                          .'</p>';
=pod

=head1 NOTES:

'<a href="javascript:self.close();">','</a>'

Due to security reasons in new web browsers a window could only be closed with java script, if this window has also been opend with javascript. This is not done here which means that in most cases the close link will not work. Unless we find another solution, this link should not be offered. (Stefan Bisitz, 2008-08-01)

=cut
            $relogmessage.='<p>'.&mt('[_1]Log in again[_2]'
                              ,'<a href="'.$login_url.'?domain='.$env{'user.domain'}.'">','</a>')
                          .'</p>';
        }
	my $domain = $env{'user.domain'};
        if ($env{'request.sso.login'}
	    && defined($r->dir_config("lonSSOUserLogoutMessageFile_$domain"))) {
	    open(my $fh,$r->dir_config("lonSSOUserLogoutMessageFile_$domain"));
	    $relogmessage.= join('',<$fh>);
	}
	if ($env{'request.sso.login'}
	    && defined($r->dir_config('lonSSOUserLogoutMessageFile'))) {
	    open(my $fh,$r->dir_config('lonSSOUserLogoutMessageFile'));
	    $relogmessage.= join('',<$fh>);
	}

    }
    my $end_page=&Apache::loncommon::end_page();
# --------------------------------------------------------------- Screen Output
    $r->print(<<ENDDOCUMENT);
$start_page
$windowinfo
$relogmessage
$end_page
ENDDOCUMENT
    $r->register_cleanup(\&flush_course_logs);
    return OK; 
}

sub flush_course_logs {
    &Apache::lonnet::flushcourselogs();
    return OK;
}

1;
__END__







