# The LearningOnline Network with CAPA
# external style responses
#
# $Id: externalresponse.pm,v 1.19 2011/04/29 00:32:08 www Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#



package Apache::externalresponse;
use strict;
use HTTP::Request::Common;
use Apache::loncapagrade;
use Apache::lonnet;
use Apache::lonlocal;

BEGIN {
    &Apache::lonxml::register('Apache::externalresponse',('externalresponse'));
}

=pod

=head1 FIXME (start_externalresponse)

send of response params and their current values (form good enough? what parameters to send?)
Need to get returned message displayed

=cut


sub start_externalresponse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    my $id = &Apache::response::start_response($parstack,$safeeval);

    if ($target eq 'edit') {
  	$result .=&Apache::edit::tag_start($target,$token);
	$result .=&Apache::edit::text_arg('URL:','url',$token,60).'<br />';
	$result .=&Apache::edit::text_arg(&mt('Answer:'),'answer',$token);
	$result .=&Apache::edit::text_arg(&mt('Form:'),'form',$token).'<br />';
        $result .=&Apache::edit::text_arg(&mt('Answer display:'),'answerdisplay',$token,80);
	$result .=&Apache::edit::end_row().&Apache::edit::start_spanning_row();
    } elsif ($target eq 'modified') {
	my $constructtag =
	    &Apache::edit::get_new_args($token,$parstack,$safeeval,
					'answerdisplay','answer','form','url');
	if ($constructtag) {
	    $result = &Apache::edit::rebuild_tag($token);
	}
    } elsif ($target eq 'meta') {
  	$result=&Apache::response::meta_package_write('externalresponse');
    }
    
    return $result;
}

sub end_externalresponse {
    my ($target,$token,$tagstack,$parstack,$parser,$safeeval,$style)=@_;
    my $result;
    my $part=$Apache::inputtags::part;
    my $id = $Apache::inputtags::response['-1'];
    my $increment     = 1;
    if ($target eq 'grade') {
	if (  &Apache::response::submitted('scantron') ) {
	    my $increment=&Apache::response::scored_response($part,$id);
	} elsif ( &Apache::response::submitted() ) {
	    my $response = &Apache::response::getresponse();
	    if ( $response =~ /[^\s]/) {
		my $url = &Apache::lonxml::get_param('url',$parstack,$safeeval);
		my $answer = &Apache::lonxml::get_param('answer',$parstack,$safeeval);
		my %form = &Apache::lonxml::get_param_var('form',$parstack,$safeeval);
		$form{'LONCAPA_student_response'}=$response;
		$form{'LONCAPA_correct_answer'}=$answer;
		$form{'LONCAPA_language'}=
		    &Apache::lonnet::metadata($ENV{'REQUEST_URI'},'language');
		&Apache::lonxml::debug("Asking $url, with:");
		&Apache::lonhomework::showhash(%form);
		my $ua = LWP::UserAgent->new;
		my $res = $ua->request(POST $url, \%form);
		my %previous = &Apache::response::check_for_previous($response,
								     $part,$id);
		%Apache::loncapagrade::results=();
		$Apache::lonhomework::results{"resource.$part.$id.submission"}=$response;
		if ($res->is_error()) {
		    $Apache::loncapagrade::results{'awarddetail'}='ERROR';
		} else {
		    &Apache::lonxml::register('Apache::loncapagrade',
					      ('loncapagrade'));
		    @Apache::scripttag::parser_env = @_;
		    my $result=&Apache::scripttag::xmlparse($res->{_content});
		    &Apache::lonxml::debug("Got a result of :$result:");
		}
		foreach my $key (keys(%Apache::loncapagrade::results)) {
		    $Apache::lonhomework::results{"resource.$part.$id.$key"}=
			$Apache::loncapagrade::results{$key};
		}
                $Apache::externalresponse::message=$Apache::loncapagrade::results{'message'};
		&Apache::response::handle_previous(\%previous,
						   $Apache::loncapagrade::results{'awarddetail'});
                if ($Apache::loncapagrade::results{'awarddetail'} eq 'ASSIGNED_SCORE') {
                   $Apache::lonhomework::results{"resource.$part.$id.awarded"}=
                        1.*$Apache::loncapagrade::results{"awarded"};
                }
		&Apache::lonxml::debug("response of");
		&Apache::lonhomework::showhash(%$res);
		&Apache::lonxml::debug("capagrade of");
		&Apache::lonhomework::showhash(%Apache::loncapagrade::results);
		&Apache::lonxml::debug("results of");
		&Apache::lonhomework::showhash(%Apache::lonhomework::results);
	    }
	}
    }
    if ($target eq 'web') {
	&Apache::response::setup_prior_tries_hash(\&format_prior_response);
        if (&Apache::response::show_answer()) {
           $result.='<table border="1"><tr><th>'.&mt('Your answer:').'</th></tr><tr><td><pre>'.
                    $Apache::lonhomework::history{"resource.$part.$id.submission"}.
                    '</pre></td></table><br />'.&Apache::lonxml::get_param('answerdisplay',$parstack,$safeeval).
                    '<br />';
        }
        if ($Apache::externalresponse::message) {
           $result.='<br /><table><tr><td bgcolor="#FFFFAA">'.$Apache::externalresponse::message.'</td></tr></table><br />';
        }
        $Apache::externalresponse::message='';
    }

    if ($target eq 'grade' || $target eq 'web' || $target eq 'answer' ||
	$target eq 'tex' || $target eq 'analyze') {
	&Apache::lonxml::increment_counter($increment, "$part.$id");

	if ($target eq 'analyze') {
            $Apache::lonhomework::analyze{"$part.$id.type"} = 'externalresponse';
	    &Apache::lonhomework::set_bubble_lines();
	}
    }
    &Apache::response::end_response();
    return $result;
}

sub format_prior_response {
    my ($mode,$answer) =@_;
    return '<span class="LC_prior_external">'.
	    &HTML::Entities::encode($answer,'"<>&').'</span>';
}

1;
__END__


=pod

=head1 NAME

Apache::externalresponse.pm

=head1 SYNOPSIS

Handler to evaluate externally graded responses.

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=head1 SUBROUTINES

=over

=item start_externalresponse()

=item end_externalresponse()

=item format_prior_response()

=back

=cut
