# The LearningOnline Network
# Group Bulletin Boards Manager
#
# $Id: groupboards.pm,v 1.14 2009/02/13 17:20:29 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::groupboards;

use strict;
use Apache::Constants qw(:common :http);
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonuserstate();
use LONCAPA::map();
use Apache::lonlocal;
use LONCAPA;

sub handler {
    my ($r) = @_;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    #  Needs to be in a course
    if (! ($env{'request.course.fn'})) {
        # Not in a course
        $env{'user.error.msg'}=
     "/adm/groupboards:mdg:0:0:Cannot edit or view course groups";
        return HTTP_NOT_ACCEPTABLE;
    }

    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
                        ['group','ref']);

    my $cdom = $env{'course.'.$env{'request.course.id'}.'.domain'};
    my $cnum = $env{'course.'.$env{'request.course.id'}.'.num'};
    my $now = time;
    my $crstype = &Apache::loncommon::course_type();
    my $gpterm =  &Apache::loncommon::group_term();
    my $ucgpterm = $gpterm;
    $ucgpterm =~ s/^(\w)/uc($1)/e;
    my $bodytitle = $ucgpterm.' Discussion Boards';
    my $group = $env{'form.group'};
    $group =~ s/\W//g;
    my ($description,$earlyout,$refarg);

    if (exists($env{'form.ref'})) {
        $refarg = 'ref='.$env{'form.ref'};
    }

    &Apache::lonhtmlcommon::clear_breadcrumbs();
    if (!defined($group)) {
        $earlyout = &mt('No [_1] defined, so there are no [_1] discussion boards to display',$gpterm);
        $r->print(&display_error($cdom,$cnum,$group,$description,$gpterm,
                                 $ucgpterm,$bodytitle,$earlyout,$refarg));
        return OK;
    }
    my %curr_groups = &Apache::longroup::coursegroups($cdom,$cnum,$group);
    if (!defined($curr_groups{$group})) {
        $earlyout = &mt('Invalid group');
        $r->print(&display_error($cdom,$cnum,$group,$description,$gpterm,
                                 $ucgpterm,$bodytitle,$earlyout,$refarg));
        return OK;
    }
    my %content = &Apache::longroup::get_group_settings($curr_groups{$group});
    $description = &unescape($content{'description'});

    my $can_create=&Apache::lonnet::allowed('cgb',$env{'request.course.id'}.
                                            '/'.$group);
    my $can_view = &Apache::lonnet::allowed('vcg',$env{'request.course.id'}.($env{'request.course.sec'}?'/'.$env{'request.course.sec'}:''));

    if (!$can_view) {
        $can_view = &Apache::lonnet::allowed('vgb',$env{'request.course.id'}.
                                          '/'.$group);
    }
    if (!$can_view) {
        $earlyout=&mt('You do not have privileges to view discussion boards in this [_1]',$gpterm);
        $r->print(&display_error($cdom,$cnum,$group,$description,$gpterm,
                                 $ucgpterm,$bodytitle,$earlyout,$refarg));
        return OK;
    }
    if (defined($env{'form.newbul'})) {
        if (($can_create) || (&Apache::lonnet::allowed('mdg',$env{'request.course.id'}))) {
            $r->print(&boards_header($cdom,$cnum,$group,$description,$gpterm,
                                     $ucgpterm,$bodytitle,$refarg));
            my ($outcome,$newurl,$bbtitle,$dellockoutcome) = 
		&create_board($cdom,$cnum,$group,$env{'form.newbul'});
            if ($outcome eq 'ok') {
                my ($furl,$ferr)= &Apache::lonuserstate::readmap($cdom.'/'.$cnum);
                $r->print(&mt('The new discussion board was added successfully.<br />'));
                $r->print('<table border="0"><tr><td>'.
                          '<a href="'.$newurl.'?group='.$group.'&amp;'.$refarg.
                          '">'.&mt('Edit [_1] board',$bbtitle).'</a></td>'.
                           '<td>&nbsp;&nbsp;</td><td>'.
                          '<a href="/adm/groupboards?group='.$group.'&amp;'.
                          $refarg.'">'.&mt('View all group discussion boards').
                          '</a></td></tr></table>');
                if ($dellockoutcome ne 'ok') {
                    $r->print(&mt('There was a problem removing a lockfile for the group ([_1]). This may prevent creation of additional bulletin boards in this group.  Please contact the system administrator for your LON-CAPA domain.'));
                }
            } else {
                $r->print(&mt('There was a problem creating the new discussion board - [_1]','<span class="LC_error">'.$outcome.'</span>').'<br /><a href="/adm/groupboards?group='.$group.'">'.
                         &mt('Return to discussion boards').'</a>');
            }
            $r->print(&Apache::loncommon::end_page());
            return OK;
        }
    }
    my $jscript;
    if (($can_create) || (&Apache::lonnet::allowed('mdg',$env{'request.course.id'}))) {
        $jscript = qq|
<script type="text/javascript">
function makebulboard() {
   var title=prompt('Discussion Board Title');
   if (title) {
    this.document.forms.newbb.newbul.value=title;
    this.document.forms.newbb.submit();
   }
}
</script>
|;
    }
    $r->print(&boards_header($cdom,$cnum,$group,$description,$gpterm,$ucgpterm,
                             $bodytitle,$refarg,$jscript));
    my ($groupboards,$boards) = &Apache::longroup::get_group_bbinfo($cdom,$cnum,
                                                                    $group);
    if (($can_create) || (&Apache::lonnet::allowed('mdg',$env{'request.course.id'}))) {
        $r->print('<br /><form method="post" name="newbb" action="/adm/groupboards">'.
                  "\n".'<input type="button" name="bbbutton" value="'.
                  &mt('New Discussion Board').
                  '" onClick="javascript:makebulboard();" />'."\n".
                  '<input type="hidden" name="newbul" />'."\n".
                  '<input type="hidden" name="group" value="'.$group.'" />'.
                  '<input type="hidden" name="ref" value="'.$env{'form.ref'}.'" />'.
                  "\n".'</form><br />');
    }
    if (@{$groupboards} > 0) {
        $r->print('<br />'
                 .&Apache::loncommon::start_data_table()
                 .&Apache::loncommon::start_data_table_header_row()
                 .'<th>'.&mt('Discussion Boards').'</th>'
                 .&Apache::loncommon::end_data_table_header_row()
        );
        foreach my $board (@{$groupboards}) {
            my $board_url = $$boards{$board}{'url'};
            if ($board_url =~ /\?/) {
                $board_url .= '&amp;group='.$group;
            } else {
                $board_url .= '?group='.$group;
            }
            $r->print(&Apache::loncommon::start_data_table_row()
                     .'<td>'
                     .'<a href="'.$board_url.'&amp;'.$refarg.'">'
                     .$$boards{$board}{'title'}.'</a>'
                     .'</td>'
                     .&Apache::loncommon::end_data_table_row()
            );
        }
        $r->print(&Apache::loncommon::end_data_table());
    } else {
        $r->print('<p class="LC_info">'
                 .&mt('There are currently no discussion boards in this '.$gpterm.'.',)
                 .'</p>'
        );
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

sub create_board {
    my ($cdom,$cnum,$group,$bbtitle) = @_;
    my ($outcome,$boardid,$newurl);
    $bbtitle=&unescape($bbtitle);
    # get lock on nohist_groupboards file
    my $lockhash = {
                  $group."\0".'locked_boardids' => $env{'user.name'}.
                                                       ':'.$env{'user.domain'},
                   };
    my $tries = 0;
    my $gotlock = &Apache::lonnet::newput('nohist_groupboards',$lockhash,$cdom,$cnum);
    my $dellockoutcome;
    while (($gotlock ne 'ok') && $tries <3) {
        $tries ++;
        sleep 1;
        $gotlock = &Apache::lonnet::newput('nohist_groupboards',$lockhash,$cdom,$cnum);
    }
    if ($gotlock eq 'ok') {
       my %curr_boards = &Apache::lonnet::dump('nohist_groupboards',$cdom,$cnum,$group);
       $boardid = time;
       my $idtries = 0;
       while(exists($curr_boards{$group."\0".$boardid}) && $idtries < 20) {
           $boardid ++;
           $idtries ++;
       }
       if (!exists($curr_boards{$group."\0".$boardid})) {
           my %new_board = (
                          $group."\0".$boardid => $env{'user.name'}.':'.
                                                  $env{'user.domain'},
           );
           my $putresult = &Apache::lonnet::put('nohist_groupboards',\%new_board,
                                                $cdom,$cnum);
           if ($putresult ne 'ok') {
               $outcome = 'error saving new board: '.$putresult;
           } else {
               $newurl = '/adm/'.$cdom.'/'.$cnum.'/'.$boardid.
                         '/bulletinboard';
           }
       } else {
            $outcome = ('error: no unique ID for the new board available.');
       }
       #  remove lock
       my @del_lock = ($group."\0".'locked_boardids');
       $dellockoutcome = &Apache::lonnet::del('nohist_groupboards',\@del_lock,$cdom,$cnum);
    } else {
        $outcome = "error: could not obtain lockfile\n";
        $dellockoutcome = 'ok';
    }
    if (!$newurl) {
        return ($outcome,$newurl,$bbtitle,$dellockoutcome);
    }
    $newurl=&unescape($newurl);
    # need to check here if group_boards_$group.sequence is in the course
    # if not - add it as an item in group_folder_$group.sequence 
    my $allbbsmap = &Apache::longroup::get_bbfolder_url($cdom,$cnum,$group);
    if ($allbbsmap =~ m|^/uploaded|) {
        my ($errtext,$fatal)=&LONCAPA::map::mapread($allbbsmap);
        if (!$fatal) {
            my $newidx=&LONCAPA::map::getresidx($newurl);
            $LONCAPA::map::resources[$newidx]=$bbtitle.':'.$newurl.
                                                   ':false:normal:res';
            push(@LONCAPA::map::order,$newidx);
            my ($errtext,$fatal)=&LONCAPA::map::storemap($allbbsmap,1);
            if ($fatal) {
                $outcome = "error: failed to save discussion boards map - $errtext\n";
            } else {
                my %boardinfo = (
                  'group' => $group,
                );
                $outcome = &Apache::lonnet::put('bulletinpage_'.$boardid,
                                                \%boardinfo,$cdom,$cnum);
            }
        } else {
            $outcome = "error: failed to read all discussion boards map - $errtext\n";
        }
    } else {
        $outcome = 'error: discussion boards folder absent, '.
                   'or in unexpected location - '.$allbbsmap."\n";
    }
    return ($outcome,$newurl,$bbtitle,$dellockoutcome);
}

sub display_error {
    my ($cdom,$cnum,$group,$description,$gpterm,$ucgpterm,$bodytitle,$earlyout,
        $refarg)=@_;
    my $output = &boards_header($cdom,$cnum,$group,$description,$gpterm,
                                $ucgpterm,$bodytitle,$refarg);
    $output .= $earlyout;
    $output .= &Apache::loncommon::end_page();
    return $output;
}

sub boards_header {
    my ($cdom,$cnum,$group,$description,$gpterm,$ucgpterm,$bodytitle,$refarg,
        $jscript)=@_;
    my $output = &Apache::loncommon::start_page($bodytitle,$jscript);
    if ($refarg) {
        &Apache::lonhtmlcommon::add_breadcrumb
        ({href=>"/adm/coursegroups",
          text=>"Groups",
          title=>"View course groups"},);
    }
    &Apache::lonhtmlcommon::add_breadcrumb
        ({href=>"/adm/$cdom/$cnum/$group/smppg?$refarg",
          text=>"$ucgpterm: $description",
          title=>"Go to group's home page"},
         {href=>"/adm/groupboards?group=$group&amp;$refarg",
          text=>"Discussion Boards",
          title=>"Display group discussion boards"},);
    $output .= &Apache::lonhtmlcommon::breadcrumbs(&mt('[_1] discussion boards - [_2]',$gpterm,$description));
    return $output;
}

1;
