# The LearningOnline Network
# Syllabus
#
# $Id: lonsyllabus.pm,v 1.110 2010/08/07 19:23:51 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonsyllabus;

use strict;
use Apache::lontemplate;
use Apache::Constants qw(:common);
use Apache::loncommon;
use Apache::lonnet;
use Apache::lontexconvert;
use Apache::lonfeedback;
use Apache::lonannounce;
use Apache::lonlocal;
use Apache::lonhtmlcommon;
use Apache::lonspeller();
use HTML::Entities();

sub handler {
    my $r = shift;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    my $target=$env{'form.grade_target'};
# --------------------------------------------------- Get course info from URL
    my (undef,undef,$cdom,$cnum)=split(/\//,$r->uri);
# ------------------------------------------------------------ Get query string
    &Apache::loncommon::get_unprocessed_cgi
                        ($ENV{'QUERY_STRING'},['forcestudent','register','forceedit']);
# ----------------------------------------------------- Is this even a course?
    my $homeserver=&Apache::lonnet::homeserver($cnum,$cdom);
    if ($homeserver eq 'no_host') {
        &Apache::loncommon::content_type($r,'text/html');
        $r->send_http_header;
        &Apache::loncommon::simple_error_page($r,'No syllabus available',
                          'No syllabus available');
        return OK;
    }
# ------------------------------------- There is such a course, get environment
    my %courseenv=&Apache::lonnet::dump('environment',$cdom,$cnum);

# ------------------------------------------------------------ Print the screen

    if ($target eq 'tex') {
        $r->print(&Apache::lonprintout::print_latex_header($env{'form.latex_type'}));
    }
# -------------------------------------------------- Let's see who handles this
    my $externalsyllabus=$courseenv{'externalsyllabus'};

    if ($externalsyllabus=~/\w/) {
        $r->print( Apache::lonwrapper::wrapper($externalsyllabus) );
        return OK;
    }

# ------------------------------ The buck stops here: internal syllabus display
# --------------------------------------------------------- The syllabus fields
    my %syllabusfields=&Apache::lonlocal::texthash(
       'aaa_instructorinfo' => 'Instructor Information',
       'bbb_description'    => 'Course Description',
       'ccc_prereq'         => 'Prerequisites',
       'cdc_classhours'     => 'Class Hours',
       'ddd_officehours'    => 'Office Hours',
       'eee_helproom'       => 'Helproom Hours',
       'efe_projectinfo'    => 'Project Information',
       'fff_examinfo'       => 'Exam Information',
       'fgf_deadlines'      => 'Deadlines',
       'ggg_grading'        => 'Grading Information',
       'hhh_readings'       => 'Readings',
       'iii_coursepack'     => 'Coursepack',
       'jjj_weblinks'       => 'Web Links',
       'kkk_textbook'       => 'Textbook',
       'lll_includeurl'     => 'URLs To Include in Syllabus');
# --------------------------------------------------------------- Force Student
    my $forcestudent='';
    if ($env{'form.forcestudent'}) { $forcestudent='student'; };
    my $forceedit='';
    if ($env{'form.forceedit'}) { $forceedit='edit'; }

# ----------------------------------------------------------------- Make header
    if ($target ne 'tex') {
        my $rss_link = &Apache::lonrss::rss_link($cnum,$cdom);
        my $js;
        if ($env{'form.backto'} eq 'coursecatalog') {
            $js .= <<"ENDSCRIPT";

<script type="text/javascript">
function ToCatalog(caller) {
    numidx = getIndexByName('coursenum');
        if (numidx > -1) {
            if (caller != 'details') {
                document.backtocat.elements[numidx].value = '';
            }
        }
    document.backtocat.submit();
}

function getIndexByName(item) {
    for (var i=0;i<document.backtocat.elements.length;i++) {
        if (document.backtocat.elements[i].name == item) {
            return i;
        }
    }
    return -1;
}

</script>

ENDSCRIPT
        }
        my $start_page =
         &Apache::loncommon::start_page("Syllabus", $rss_link.$js,
                       {'function'       => undef,
                        'domain'         => $cdom,
                        'force_register' =>
                        $env{'form.register'},});

        $r->print($start_page);
        if ($env{'form.backto'} eq 'coursecatalog') {
            &Apache::lonhtmlcommon::clear_breadcrumbs();
            &Apache::lonhtmlcommon::add_breadcrumb
                ({href=>"javascript:ToCatalog()",
                text=>"Course/Community Catalog"});
            if ($env{'form.coursenum'} ne '') {
                &Apache::lonhtmlcommon::add_breadcrumb
                    ({href=>"javascript:ToCatalog('details')",
                    text=>"Course details"});
            }
            &Apache::lonhtmlcommon::add_breadcrumb
                ({href=>$r->uri,
                text=>"Course syllabus"});
            $r->print(&Apache::lonhtmlcommon::breadcrumbs());
        }
    }
# ---------------------------------------------------------- Load syllabus info
    my %syllabus=&Apache::lonnet::dump('syllabus',$cdom,$cnum);
    my $allowed=0;
    my $privileged=0;

# This handler might be called anonymously ...
# ----------------------------------------------------- Only if not public call
    if ($env{'user.environment'}) {
# does this user have privileges to post, etc?
        if ($env{'request.course.id'}
        && $cdom eq $env{'course.'.$env{'request.course.id'}.'.domain'}
        && $cnum eq $env{'course.'.$env{'request.course.id'}.'.num'}) {
            $allowed=&Apache::lonnet::allowed('mdc',$env{'request.course.id'});
            $privileged=$allowed;
            if (($syllabus{'uploaded.lastmodified'}) && (!$forceedit)) {
                $forcestudent='student';
            }
            if ($forcestudent or $target eq 'tex') { $allowed=0; }
        }
		#store what the user typed in
        if (($allowed) && ($env{'form.storesyl'})) {
            foreach my $syl_field (keys(%syllabusfields)) {
                my $field=$env{'form.'.$syl_field};
                chomp($field);
                $field=~s/\s+$//s;
                $field=~s/^\s+//s;
                $field=~s/\<br\s*\/*\>$//s;
                $field=&Apache::lonfeedback::clear_out_html($field,1);
				#here it will be stored
                $syllabus{$syl_field}=$field;
                if ($syl_field eq 'lll_includeurl') { # clean up included URLs
                    my $field='';
                    foreach my $value (split(/\n/,$syllabus{$syl_field})) {
                        my $url=$value;
# get rid of leading and trailing spaces
                        $url=~s/^\s+//;
                        $url=~s/\s+$//;
                        if ($url=~m|^https?\://([^/]+)/(.+)$|) {
                            my $host = $1;
                            my $remainder=$2;
# remove the hostname from internal URLs
                            my $hostname = &Apache::lonnet::hostname($host);
                            my %all_hostnames = &Apache::lonnet::all_hostnames();
                            foreach my $possible_host (keys(%all_hostnames)) {
                                if ($possible_host =~ /\Q$hostname\E/i) {
                                    $url=$remainder;
                                }
                            }
                        }
# norm internal URLs
                        unless ($url=~/^https?\:/) {
                            $url=&Apache::lonnet::clutter($url);
                        }
# re-assemble field
                        if ($url) {
                            $field.=$url."\n";
                        }
                    }
                    $syllabus{$syl_field}=$field;
                }
            }
            $syllabus{'uploaded.domain'}=$env{'user.domain'};
            $syllabus{'uploaded.name'}=$env{'user.name'};
            $syllabus{'uploaded.lastmodified'}=time;
            &Apache::lonnet::put('syllabus',\%syllabus,$cdom,$cnum);
        }
    }

#--------Functions
    if( ($allowed || $privileged) && $target ne 'tex') {
        my $functions=&Apache::lonhtmlcommon::start_funclist();
        if ($allowed) {
			#if you have the register flag, keep it
			if($env{'form.register'} == 1) {
            	$functions.=&Apache::lonhtmlcommon::add_item_funclist(
                          '<a href="'.$r->uri.'?forcestudent=1&amp;register=1">'
                           .&mt('Show Public View').'</a>'
                           .&Apache::loncommon::help_open_topic(
                                'Uploaded_Templates_PublicView'));
			} else {
            	$functions.=&Apache::lonhtmlcommon::add_item_funclist(
                          '<a href="'.$r->uri.'?forcestudent=1">'
                           .&mt('Show Public View').'</a>'
                           .&Apache::loncommon::help_open_topic(
                                'Uploaded_Templates_PublicView'));
			}
        } elsif ($privileged) {
			if($env{'form.register'} == 1) {
	            $functions.=&Apache::lonhtmlcommon::add_item_funclist(
                           '<a href="'.$r->uri.'?forceedit=1&amp;register=1">'
                            .&mt('Edit').'</a>');
			} else {
	            $functions.=&Apache::lonhtmlcommon::add_item_funclist(
                           '<a href="'.$r->uri.'?forceedit=1">'
                            .&mt('Edit').'</a>');
			}
        }

        $functions.=&Apache::lonhtmlcommon::end_funclist();
        $r->print(&Apache::loncommon::head_subbox($functions));
    }

#---------------------Print External URL Syllabus Info and Help Text
    if( ($allowed) && ($target ne 'tex') ) {
        my $protocol = $Apache::lonnet::protocol{$homeserver};
          $protocol = 'http' if ($protocol ne 'https');
        $r->print('<p class="LC_info">'
                 .&mt('This syllabus can be publicly viewed at [_1]'
                     ,'<tt>'.$protocol.'://'.&Apache::lonnet::hostname($homeserver).$r->uri.'</tt>')
                 .'&nbsp;'.&Apache::loncommon::help_open_topic('Syllabus_ExtLink')
                 .'</p>'
                 .'<p class="LC_info">'
                 .&mt('Instead of using this template you can specify an external URL as Syllabus in the [_1]Course Configuration[_2].'
                     ,'<a href="/adm/courseprefs?actions=courseinfo&amp;phase=display">','</a>')
                 .'</p>'
        );
        #-Print Help Text
        $r->print(&Apache::loncommon::help_open_topic( 
                        'Uploaded_Templates_TextBoxes',
                        &mt('Help with filling in text boxes')));
    }

#----------Print last update
    my $lastmod=$syllabus{'uploaded.lastmodified'};
    $lastmod=($lastmod?&Apache::lonlocal::locallocaltime($lastmod):&mt('never'));
    my $who;
    if (($env{'user.name'} ne 'public') && ($env{'user.domain'} ne 'public')) {
        $who = &Apache::loncommon::aboutmewrapper(
                   &Apache::loncommon::plainname($syllabus{'uploaded.name'},
                   $syllabus{'uploaded.domain'}),$syllabus{'uploaded.name'},
                   $syllabus{'uploaded.domain'});
    } else {
        # Public user?
        # Only display name of user, but no link to personal information page
        $who = &Apache::loncommon::plainname(
                   $syllabus{'uploaded.name'},
                   $syllabus{'uploaded.domain'});
    }

    if ($target ne 'tex') {
        $r->print('<div class="LC_info">'.&mt('Last updated').': '.
            $lastmod . ' '.
            ($who ? &mt('by').' '.$who
                           : '' ) .
             '</div>' );

    } else {
        $r->print('\\\\ '.&mt('Last updated').': '.$lastmod.' '.
            ($who? &mt('by').'\\\\ '.
                    &Apache::loncommon::plainname($syllabus{'uploaded.name'},$syllabus{'uploaded.domain'})
                  :'')
             .'\\\\');
    }
#----------------------------Print Headtitle
    if ($target ne 'tex') {
        $r->print('<h1>'.$courseenv{'description'}.'</h1>');
        $r->print('<h3>'.  &Apache::lonnet::domain($cdom,'description').'</h3>');
    } else {
        $r->print('\noindent{\large\textbf{'.$courseenv{'description'}.'}}\\\\\\\\\textbf{'.
        &Apache::lonnet::domain($cdom,'description').'}\\\\');
    }
# -------------------------------------------------------- Get course personnel
    my %coursepersonnel=&Apache::lonnet::get_course_adv_roles($cdom.'/'.$cnum);
    if ($target ne 'tex') {
        $r->print(&Apache::lonhtmlcommon::start_pick_box());
    } else {
        $r->print('\begin{tabular}{|p{0.45\textwidth}|p{0.45\textwidth}|}\hline');
    }
    my @personnel=sort(keys(%coursepersonnel));
    my $lastpers=$personnel[$#personnel];
    foreach my $element (@personnel) {
        if ($target ne 'tex') {
            $r->print(&Apache::lonhtmlcommon::row_title($element));
        } else {
            $r->print(' '.&Apache::lonxml::xmlparse($r,'tex',$element).' & ');
        }
        foreach (split(/\,/,$coursepersonnel{$element})) {
            my ($puname,$pudom)=split(/\:/,$_);
            if ($target ne 'tex') {
                my $courseperson = &Apache::loncommon::plainname($puname,$pudom);
                if (($env{'user.name'} eq '') || ($env{'user.name'} eq 'public') ||
                    ($env{'user.domain'} eq '') || ($env{'user.domain'} eq 'public')) {
                    $r->print(' '.$courseperson);
                } else {
                    $r->print(' '.&Apache::loncommon::aboutmewrapper($courseperson,
                              $puname,$pudom));
                }
            } else {
                $r->print(' '.&Apache::loncommon::plainname($puname,
                              $pudom).' ');
            }
        }
        if ($target ne 'tex') {
            my $lastclose=$element eq $lastpers?1:0;
            $r->print(&Apache::lonhtmlcommon::row_closure($lastclose));
        } else {
            $r->print('\\\\ \hline');
        }
    }
    if ($target ne 'tex') {
        $r->print(&Apache::lonhtmlcommon::end_pick_box());
    } else {
        $r->print('\end{tabular}\\\\');
    }
# -------------------------------------------------------------- Announcements?
    my $day = &Apache::lonannounce::showday(time,2,
             &Apache::lonannounce::readcalendar($cdom.'_'.$cnum));
    if ($target ne 'tex') {
        if ($allowed) {
            &Apache::lontemplate::print_start_template($r,&mt('RSS Feeds and Blogs'),'LC_Box');
            $r->print(&Apache::lonrss::advertisefeeds($cnum,$cdom,$forceedit));
            my $editurl= &Apache::lonnet::absolute_url().'/adm/'.$cdom.'/'.$cnum.'/_rss.html';
            $r->print( '<a href="'.$editurl.'">'.&mt('New RSS Feed or Blog').'</a>');
            &Apache::lontemplate::print_end_template($r);
        } elsif (&Apache::lonrss::advertisefeeds($cnum,$cdom) ne '') {
            &Apache::lontemplate::print_start_template($r,&mt('RSS Feeds and Blogs'),'LC_Box');
            $r->print(&Apache::lonrss::advertisefeeds($cnum,$cdom,$forceedit));
            &Apache::lontemplate::print_end_template($r);
        }

    } else {
        $r->print(&Apache::lonxml::xmlparse($r,'tex',$day));
    }
# ---------------------------------------------------------------- Get syllabus
    if (($syllabus{'uploaded.lastmodified'}) || ($allowed)) {
        if ($allowed) {
            $r->print('<form method="post" action="">'.
            '<input type="hidden" name="forceedit" value="edit" />');
        }
		my $url_include_handler = sub {
			my ($r, $field, $message, $group, $data_ref, $fields_ref, $target, $allowed) = @_;
			my %data = %{$data_ref};
			my %fields = %{$fields_ref};
			my $urls=$message;
			$message='';
			foreach my $filelink (split(/\n/,$urls)) {
				my $output='';
			   # embed style?
				my ($curfext)=($filelink=~/\.([^\.]+)$/);
				my $embstyle=&Apache::loncommon::fileembstyle($curfext);
				if (($embstyle eq 'ssi') || ($curfext=~/\/$/)) {# make ssi call and remove everything but the body contents
					$output=&Apache::lonnet::ssi_body($filelink);
				} elsif ($embstyle eq 'img') {# embed as an image
					$output='<img src="'.$filelink.'" />';
				}
				if ($output ne '') {
					   if ($target ne 'tex') {
						   $message.='<p>'.$output.'</p>';
					   } else {
						   $message.=' '.&Apache::lonxml::xmlparse($r,'tex','<p>'.$output.'</p>').' ';
					   }
				}
			}
			if ($allowed) {
				 &Apache::lonfeedback::newline_to_br(\$urls);
				 &Apache::lontemplate::print_start_template($r,$fields{$field}.
						  &Apache::loncommon::help_open_topic('Syllabus_URLs'),'LC_Box');
				 $r->print($urls);
				 $r->print("<br /><div>");
				 &Apache::lontemplate::print_textarea_template($r, $data{$field},
					$field, Apache::lontemplate->RICH_TEXT_ALWAYS_OFF);
				 &Apache::lontemplate::print_saveall_template($r);                         
				 $r->print("</div>");
				 &Apache::lontemplate::print_end_template($r);

			} else {
				$r->print($message);
			}
		};
		my %custom_hash = ( 'lll_includeurl' => $url_include_handler );
		&Apache::lontemplate::print_template_fields($r, \%syllabus, \%syllabusfields, 
			$target, $allowed, Apache::lontemplate->RICH_TEXT_DETECT_HTML, \%custom_hash);
        if ($allowed) {
            $r->print('</form>'.
            &Apache::lonhtmlcommon::htmlareaselectactive());
        }
    } else {
        if ($target ne 'tex') {$r->print('<p>');} else {$r->print('\par ');}
        $r->print(&mt('No syllabus information provided.'));
        if ($target ne 'tex') {$r->print('</p>');}
    }
    if ($target ne 'tex') {
        if ($env{'form.backto'} eq 'coursecatalog') {
            $r->print('<form name="backtocat" method="post" action="/adm/coursecatalog">'.
                      &Apache::lonhtmlcommon::echo_form_input(['backto','courseid']).
                      '</form>');
        }
        $r->print(&Apache::loncommon::end_page());
    } else {
        $r->print('\end{document}');
    }
    return OK;
}

1;
__END__
