/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolViewer;
import org.jmol.applet.Jvm12;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;

class Console
implements ActionListener,
WindowListener {
    final JTextArea input = new ControlEnterTextArea();
    final JTextPane output = new JTextPane();
    final Document outputDocument = this.output.getDocument();
    final JFrame jf = new JFrame(GT._("Jmol Script Console"));
    final JButton runButton = new JButton(GT._("Execute"));
    final JButton clearOutButton = new JButton(GT._("Clear Output"));
    final JButton clearInButton = new JButton(GT._("Clear Input"));
    final JButton historyButton = new JButton(GT._("History"));
    final JButton stateButton = new JButton(GT._("State"));
    final JButton loadButton = new JButton(GT._("Load"));
    final SimpleAttributeSet attributesCommand = new SimpleAttributeSet();
    final JmolViewer viewer;
    final Jvm12 jvm12;

    Console(Component component, JmolViewer jmolViewer, Jvm12 jvm12) {
        this.viewer = jmolViewer;
        this.jvm12 = jvm12;
        Logger.debug((String)"Console constructor");
        this.setupInput();
        this.setupOutput();
        JScrollPane jScrollPane = new JScrollPane(this.input);
        jScrollPane.setMinimumSize(new Dimension(2, 100));
        JScrollPane jScrollPane2 = new JScrollPane(this.output);
        jScrollPane2.setMinimumSize(new Dimension(2, 100));
        Container container = this.jf.getContentPane();
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane2, jScrollPane);
        jSplitPane.setResizeWeight(0.9);
        jSplitPane.setDividerLocation(200);
        container.setLayout(new BoxLayout(container, 1));
        jSplitPane.setAlignmentX(0.5f);
        container.add(jSplitPane);
        Container container2 = new Container();
        container2.setLayout(new BoxLayout(container2, 0));
        container2.add(Box.createGlue());
        container2.add(this.runButton);
        container2.add(this.loadButton);
        container2.add(this.clearInButton);
        container2.add(this.clearOutButton);
        container2.add(this.historyButton);
        container2.add(this.stateButton);
        container2.add(Box.createGlue());
        container.add(container2);
        JLabel jLabel = new JLabel(GT._("press CTRL-ENTER for new line or paste model data and press Load"), 0);
        jLabel.setAlignmentX(0.5f);
        container.add(jLabel);
        this.runButton.addActionListener(this);
        this.clearInButton.addActionListener(this);
        this.clearOutButton.addActionListener(this);
        this.historyButton.addActionListener(this);
        this.stateButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        ((Component)this.jf).setSize(550, 400);
        this.jf.addWindowListener(this);
    }

    void setupInput() {
        this.input.setLineWrap(true);
        this.input.setWrapStyleWord(true);
        Keymap keymap = this.input.getKeymap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(65, 1);
        keymap.removeKeyStrokeBinding(keyStroke);
    }

    void setupOutput() {
        this.output.setEditable(false);
        StyleConstants.setBold(this.attributesCommand, true);
    }

    void setVisible(boolean bl) {
        if (Logger.isActiveLevel((int)0)) {
            Logger.debug((String)("Console.setVisible(" + bl + ")"));
        }
        ((Component)this.jf).setVisible(bl);
        this.input.requestFocus();
    }

    void output(String string) {
        this.output(string, null);
    }

    void output(String string, AttributeSet attributeSet) {
        if (string == null || string.length() == 0) {
            this.output.setText("");
            return;
        }
        if (string.charAt(string.length() - 1) != '\n') {
            string = string + "\n";
        }
        try {
            this.outputDocument.insertString(this.outputDocument.getLength(), string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.output.setCaretPosition(this.outputDocument.getLength());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.runButton) {
            this.execute();
        }
        if (object == this.clearInButton) {
            this.input.setText("");
        }
        if (object == this.clearOutButton) {
            this.output.setText("");
        }
        if (object == this.historyButton) {
            this.output.setText(this.viewer.getSetHistory(Integer.MAX_VALUE));
        }
        if (object == this.stateButton) {
            this.output.setText(this.viewer.getStateInfo());
        }
        if (object == this.loadButton) {
            this.viewer.loadInline(this.input.getText());
        }
    }

    void execute() {
        String string = this.input.getText();
        this.input.setText(null);
        this.output(string, this.attributesCommand);
        String string2 = this.viewer.script(string);
        if (string2 != null) {
            this.output(string2);
        }
        this.input.requestFocus();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.jvm12.console = null;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.jvm12.console = null;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    class ControlEnterTextArea
    extends JTextArea {
        ControlEnterTextArea() {
        }

        public void processComponentKeyEvent(KeyEvent keyEvent) {
            switch (keyEvent.getID()) {
                case 401: {
                    if (keyEvent.getKeyCode() == 10 && !keyEvent.isControlDown()) {
                        Console.this.execute();
                        return;
                    }
                    if (keyEvent.getKeyCode() == 38) {
                        this.recallCommand(true);
                        return;
                    }
                    if (keyEvent.getKeyCode() != 40) break;
                    this.recallCommand(false);
                    return;
                }
                case 402: {
                    if (keyEvent.getKeyCode() != 10 || keyEvent.isControlDown()) break;
                    return;
                }
            }
            if (keyEvent.getKeyCode() == 10) {
                keyEvent.setModifiers(0);
            }
            super.processComponentKeyEvent(keyEvent);
        }

        private void recallCommand(boolean bl) {
            String string = Console.this.viewer.getSetHistory(bl ? -1 : 1);
            if (string == null) {
                return;
            }
            this.setText(string);
        }
    }
}

