/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Shade3D;
import org.jmol.geodesic.Geodesic;
import org.jmol.util.BitSetUtil;

class Normix3D {
    static final int NORMIX_GEODESIC_LEVEL = 3;
    private static final int normixCount = Geodesic.getVertexCount(3);
    private static final Vector3f[] vertexVectors = Geodesic.getVertexVectors();
    private static final short[][] faceVertexesArrays = Geodesic.getFaceVertexesArrays();
    private static final short[][] neighborVertexesArrays = Geodesic.getNeighborVertexesArrays();
    private final Vector3f[] transformedVectors;
    private final byte[] intensities;
    private final byte[] intensities2Sided;
    private static short[][] faceNormixesArrays;
    private static final boolean TIMINGS = false;
    private static final boolean DEBUG_WITH_SEQUENTIAL_SEARCH = false;
    private final Matrix3f rotationMatrix = new Matrix3f();
    final BitSet bsConsidered = new BitSet();
    short[] inverseNormixes;
    private static final boolean DEBUG_FACE_VECTORS = false;

    Normix3D() {
        this.intensities = new byte[normixCount];
        this.intensities2Sided = new byte[normixCount];
        this.transformedVectors = new Vector3f[normixCount];
        int n = normixCount;
        while (--n >= 0) {
            this.transformedVectors[n] = new Vector3f();
        }
    }

    short getNormix(Vector3f vector3f) {
        return this.getNormix(vector3f.x, vector3f.y, vector3f.z, 3);
    }

    Vector3f getVector(short s) {
        return vertexVectors[s];
    }

    short getNormix(double d, double d2, double d3, int n) {
        double d4;
        short s;
        if (d3 >= 0.0) {
            s = 0;
            d4 = d3 - 1.0;
        } else {
            s = 11;
            d4 = d3 - -1.0;
        }
        BitSetUtil.clear(this.bsConsidered);
        this.bsConsidered.set(s);
        double d5 = d * d + d2 * d2 + d4 * d4;
        for (int i = 0; i <= n; ++i) {
            short[] sArray = neighborVertexesArrays[i];
            int n2 = 6 * s;
            int n3 = n2 + (s < 12 ? 5 : 6);
            while (--n3 >= n2) {
                short s2 = sArray[n3];
                if (this.bsConsidered.get(s2)) continue;
                this.bsConsidered.set(s2);
                Vector3f vector3f = vertexVectors[s2];
                double d6 = (double)vector3f.x - d;
                double d7 = d6 * d6;
                if (d7 >= d5 || (d7 += (d6 = (double)vector3f.y - d2) * d6) >= d5 || (d7 += (d6 = (double)vector3f.z - d3) * d6) >= d5) continue;
                s = s2;
                d5 = d7;
            }
        }
        return s;
    }

    void calculateInverseNormixes() {
        this.inverseNormixes = new short[normixCount];
        int n = normixCount;
        while (--n >= 0) {
            Vector3f vector3f = vertexVectors[n];
            this.inverseNormixes[n] = this.getNormix(-vector3f.x, -vector3f.y, -vector3f.z, 3);
        }
        n = normixCount;
        while (--n >= 0) {
            if (this.inverseNormixes[this.inverseNormixes[n]] == n) continue;
            throw new NullPointerException();
        }
    }

    byte getIntensity(short s) {
        if (s < 0) {
            return this.intensities2Sided[~s];
        }
        return this.intensities[s];
    }

    void setRotationMatrix(Matrix3f matrix3f) {
        this.rotationMatrix.set(matrix3f);
        int n = normixCount;
        while (--n >= 0) {
            byte by;
            Vector3f vector3f = this.transformedVectors[n];
            matrix3f.transform((Tuple3f)vertexVectors[n], (Tuple3f)vector3f);
            float f = vector3f.x;
            float f2 = -vector3f.y;
            float f3 = vector3f.z;
            this.intensities[n] = by = Shade3D.calcIntensityNormalized(f, f2, f3);
            if (f3 >= 0.0f) {
                this.intensities2Sided[n] = by;
                continue;
            }
            this.intensities2Sided[n] = Shade3D.calcIntensityNormalized(-f, -f2, -f3);
        }
    }

    Vector3f[] getTransformedVectors() {
        return this.transformedVectors;
    }

    short[] getFaceNormixes(int n) {
        short[] sArray;
        if (faceNormixesArrays == null) {
            faceNormixesArrays = new short[4][];
        }
        if ((sArray = faceNormixesArrays[n]) != null) {
            return sArray;
        }
        return this.calcFaceNormixes(n);
    }

    static double dist2(Vector3f vector3f, Vector3f vector3f2) {
        double d = vector3f.x - vector3f2.x;
        double d2 = vector3f.y - vector3f2.y;
        double d3 = vector3f.z - vector3f2.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    static double dist2(Vector3f vector3f, double d, double d2, double d3) {
        double d4 = (double)vector3f.x - d;
        double d5 = (double)vector3f.y - d2;
        double d6 = (double)vector3f.z - d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    private synchronized short[] calcFaceNormixes(int n) {
        short[] sArray = faceNormixesArrays[n];
        if (sArray != null) {
            return sArray;
        }
        Vector3f vector3f = new Vector3f();
        short[] sArray2 = faceVertexesArrays[n];
        int n2 = sArray2.length;
        int n3 = n2 / 3;
        sArray = new short[n3];
        int n4 = n3;
        while (--n4 >= 0) {
            short s;
            Vector3f vector3f2 = vertexVectors[sArray2[--n2]];
            Vector3f vector3f3 = vertexVectors[sArray2[--n2]];
            Vector3f vector3f4 = vertexVectors[sArray2[--n2]];
            vector3f.add((Tuple3f)vector3f2, (Tuple3f)vector3f3);
            vector3f.add((Tuple3f)vector3f4);
            sArray[n4] = s = this.getNormix(vector3f);
        }
        Normix3D.faceNormixesArrays[n] = sArray;
        return sArray;
    }

    boolean isDirectedTowardsCamera(short s) {
        return s < 0 || this.transformedVectors[s].z > 0.0f;
    }
}

