/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.viewer.JmolConstants;

public class QchemReader
extends AtomSetCollectionReader {
    int atomCount;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("qchem");
        try {
            int n = 0;
            while (this.readLine() != null) {
                if (this.line.indexOf("Standard Nuclear Orientation") >= 0) {
                    this.readAtoms();
                } else {
                    if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
                        this.readFrequencies();
                        break;
                    }
                    if (this.line.indexOf("Mulliken Net Atomic Charges") >= 0) {
                        this.readPartialCharges();
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void readAtoms() throws Exception {
        this.atomSetCollection.discardPreviousAtoms();
        this.atomCount = 0;
        this.discardLines(2);
        while (this.readLine() != null && !this.line.startsWith(" --")) {
            String string;
            String[] stringArray = this.getTokens();
            if (stringArray.length < 5 || JmolConstants.elementNumberFromSymbol(string = stringArray[1]) < 1) continue;
            float f = this.parseFloat(stringArray[2]);
            float f2 = this.parseFloat(stringArray[3]);
            float f3 = this.parseFloat(stringArray[4]);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string;
            atom.x = f;
            atom.y = f2;
            atom.z = f3;
            ++this.atomCount;
        }
    }

    void readFrequencies() throws Exception {
        int n = 1;
        this.discardLinesUntilStartsWith(" Frequency:");
        while (this.line != null && this.line.startsWith(" Frequency:")) {
            String[] stringArray = this.getTokens();
            int n2 = stringArray.length - 1;
            this.discardLines(4);
            for (int i = 0; i < this.atomCount; ++i) {
                this.readLine();
                String[] stringArray2 = this.getTokens();
                int n3 = 0;
                for (int j = 0; j < n2; ++j) {
                    float f = this.parseFloat(stringArray2[++n3]);
                    float f2 = this.parseFloat(stringArray2[++n3]);
                    float f3 = this.parseFloat(stringArray2[++n3]);
                    this.recordAtomVector(n + j, i + 1, f, f2, f3);
                }
            }
            this.discardLines(1);
            n += 3;
            this.readLine();
        }
    }

    void recordAtomVector(int n, int n2, float f, float f2, float f3) throws Exception {
        if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) {
            return;
        }
        if (n2 <= 0 || n2 > this.atomCount) {
            return;
        }
        if (n2 == 1 && n > 1) {
            this.atomSetCollection.cloneFirstAtomSet();
        }
        Atom atom = this.atomSetCollection.getAtom((n - 1) * this.atomCount + n2 - 1);
        atom.vectorX = f;
        atom.vectorY = f2;
        atom.vectorZ = f3;
    }

    void readPartialCharges() throws Exception {
        this.discardLines(3);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount && this.readLine() != null; ++i) {
            atomArray[i].partialCharge = this.parseFloat(this.getTokens()[2]);
        }
    }
}

