/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.shape.Closest;
import org.jmol.util.Logger;

public abstract class Monomer
extends Group {
    BioPolymer bioPolymer;
    protected final byte[] offsets;
    int monomerIndex;

    protected Monomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3);
        this.offsets = byArray;
    }

    void setBioPolymer(BioPolymer bioPolymer, int n) {
        this.bioPolymer = bioPolymer;
        this.monomerIndex = n;
    }

    public int getSelectedMonomerCount() {
        return this.bioPolymer.getSelectedMonomerCount();
    }

    public int getSelectedMonomerIndex() {
        return this.monomerIndex >= 0 && this.bioPolymer.isMonomerSelected(this.monomerIndex) ? this.monomerIndex : -1;
    }

    BioPolymer getBioPolymer() {
        return this.bioPolymer;
    }

    public int getBioPolymerLength() {
        return this.bioPolymer == null ? 0 : this.bioPolymer.monomerCount;
    }

    public int getBioPolymerIndex() {
        return this.monomerIndex;
    }

    protected static byte[] scanForOffsets(int n, int[] nArray, byte[] byArray) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4;
            int n5;
            byte by = byArray[n3];
            if (by < 0) {
                n5 = nArray[~by];
            } else {
                n5 = nArray[by];
                if (n5 < 0) {
                    return null;
                }
            }
            if (n5 < 0) {
                n4 = 255;
            } else {
                n4 = n5 - n;
                if (n4 < 0 || n4 > 254) {
                    Logger.warn("Monomer.scanForOffsets i=" + n3 + " atomID=" + by + " atomIndex:" + n5 + " firstAtomIndex:" + n + " offset out of 0-254 range. Groups aren't organized correctly. Is this really a protein?: " + n4);
                    if (by < 0) {
                        n4 = 255;
                    }
                }
            }
            byArray2[n3] = (byte)n4;
        }
        return byArray2;
    }

    public boolean isDna() {
        return false;
    }

    public boolean isRna() {
        return false;
    }

    public final boolean isProtein() {
        return this instanceof AlphaMonomer;
    }

    public final boolean isNucleic() {
        return this instanceof PhosphorusMonomer;
    }

    void setStructure(ProteinStructure proteinStructure) {
    }

    public ProteinStructure getProteinStructure() {
        return null;
    }

    public byte getProteinStructureType() {
        return 0;
    }

    public boolean isHelix() {
        return false;
    }

    public boolean isSheet() {
        return false;
    }

    protected final Atom getAtomFromOffsetIndex(int n) {
        if (n > this.offsets.length) {
            return null;
        }
        int n2 = this.offsets[n] & 0xFF;
        if (n2 == 255) {
            return null;
        }
        return this.chain.getAtom(this.firstAtomIndex + n2);
    }

    protected final Point3f getAtomPointFromOffsetIndex(int n) {
        return this.getAtomFromOffsetIndex(n);
    }

    protected final Atom getSpecialAtom(byte[] byArray, byte by) {
        int n = byArray.length;
        while (--n >= 0) {
            byte by2 = byArray[n];
            if (by2 < 0) {
                by2 = -by2;
            }
            if (by != by2) continue;
            int n2 = this.offsets[n] & 0xFF;
            if (n2 == 255) {
                return null;
            }
            return this.chain.getAtom(this.firstAtomIndex + n2);
        }
        return null;
    }

    protected final Point3f getSpecialAtomPoint(byte[] byArray, byte by) {
        int n = byArray.length;
        while (--n >= 0) {
            byte by2 = byArray[n];
            if (by2 < 0) {
                by2 = -by2;
            }
            if (by != by2) continue;
            int n2 = this.offsets[n] & 0xFF;
            if (n2 == 255) {
                return null;
            }
            return this.chain.getAtom(this.firstAtomIndex + n2);
        }
        return null;
    }

    final int getLeadAtomIndex() {
        return this.firstAtomIndex + (this.offsets[0] & 0xFF);
    }

    public final Atom getLeadAtom() {
        return this.getAtomFromOffsetIndex(0);
    }

    final Point3f getLeadAtomPoint() {
        return this.getAtomPointFromOffsetIndex(0);
    }

    public final Atom getWingAtom() {
        return this.getAtomFromOffsetIndex(1);
    }

    public final Point3f getWingAtomPoint() {
        return this.getAtomPointFromOffsetIndex(1);
    }

    final Point3f getPointAtomPoint() {
        return this.getAtomPointFromOffsetIndex(3);
    }

    Atom getInitiatorAtom() {
        return this.getLeadAtom();
    }

    Atom getTerminatorAtom() {
        return this.getLeadAtom();
    }

    abstract boolean isConnectedAfter(Monomer var1);

    void findNearestAtomIndex(int n, int n2, Closest closest, short s, short s2) {
    }

    public Hashtable getMyInfo() {
        ProteinStructure proteinStructure;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("chain", "" + this.chain.getChainID());
        int n = this.getSeqNumber();
        char c = this.getInsertionCode();
        if (n > 0) {
            hashtable.put("sequenceNumber", new Integer(n));
        }
        if (c != '\u0000') {
            hashtable.put("insertionCode", "" + c);
        }
        hashtable.put("atomInfo1", this.chain.getAtom(this.firstAtomIndex).getInfo());
        hashtable.put("atomInfo2", this.chain.getAtom(this.lastAtomIndex).getInfo());
        hashtable.put("_apt1", new Integer(this.firstAtomIndex));
        hashtable.put("_apt2", new Integer(this.lastAtomIndex));
        if (!Float.isNaN(this.phi)) {
            hashtable.put("phi", new Float(this.phi));
        }
        if (!Float.isNaN(this.psi)) {
            hashtable.put("psi", new Float(this.psi));
        }
        if ((proteinStructure = this.getProteinStructure()) != null) {
            hashtable.put("structureId", new Integer(proteinStructure.uniqueID));
            hashtable.put("structureType", Monomer.getStructureTypeName(proteinStructure.type));
        }
        hashtable.put("shapeVisibilityFlags", new Integer(this.shapeVisibilityFlags));
        return hashtable;
    }

    static String getStructureTypeName(byte by) {
        switch (by) {
            case 3: {
                return "helix";
            }
            case 2: {
                return "sheet";
            }
            case 1: {
                return "turn";
            }
            case 4: {
                return "DNA";
            }
            case 5: {
                return "RNA";
            }
        }
        return by + "?";
    }

    final void updateOffsetsForAlternativeLocations(BitSet bitSet, int n) {
        this.chain.updateOffsetsForAlternativeLocations(bitSet, n, this.offsets, this.firstAtomIndex, this.lastAtomIndex);
    }

    final void getMonomerSequenceAtoms(BitSet bitSet, BitSet bitSet2) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!bitSet.get(i)) continue;
            bitSet2.set(i);
        }
    }
}

