/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.Shape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public abstract class MeshCollection
extends Shape {
    public int meshCount;
    public Mesh[] meshes = new Mesh[4];
    public Mesh currentMesh;
    public int modelCount;
    public boolean isFixed;
    public String script;
    public int nUnnamed;
    public short colix;
    public String myType;
    public boolean explicitID;
    public String[] title;
    protected boolean allowMesh = true;

    private Mesh setMesh(String string) {
        if (string == null) {
            this.currentMesh = null;
            return null;
        }
        int n = this.getIndexFromName(string);
        if (n >= 0) {
            this.currentMesh = this.meshes[n];
        } else {
            this.allocMesh(string);
        }
        if (this.currentMesh.thisID == null) {
            this.currentMesh.thisID = this.myType + ++this.nUnnamed;
        }
        return this.currentMesh;
    }

    public void allocMesh(String string) {
        this.meshes = (Mesh[])ArrayUtil.ensureLength(this.meshes, this.meshCount + 1);
        Mesh mesh = new Mesh(string, this.g3d, this.colix);
        this.meshes[this.meshCount++] = mesh;
        this.currentMesh = mesh;
    }

    public void initShape() {
        super.initShape();
        this.colix = (short)5;
        this.modelCount = this.viewer.getModelCount();
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.isActiveLevel(0)) {
            Logger.debug("MeshCollection.setProperty(" + string + "," + object + ")");
        }
        if ("init" == string) {
            this.title = null;
            return;
        }
        if ("thisID" == string) {
            String string2 = (String)object;
            this.setMesh(string2);
            this.explicitID = string2 != null && !string2.equals("+PREVIOUS_MESH+");
            return;
        }
        if ("title" == string) {
            if (object == null) {
                this.title = null;
            } else if (object instanceof String[]) {
                this.title = (String[])object;
            } else {
                int n = 1;
                String string3 = (String)object;
                int n2 = string3.length();
                while (--n2 >= 0) {
                    if (string3.charAt(n2) != '|') continue;
                    ++n;
                }
                this.title = new String[n];
                n = 0;
                n2 = -1;
                for (int i = 0; i < string3.length(); ++i) {
                    if (string3.charAt(i) != '|') continue;
                    this.title[n++] = string3.substring(n2 + 1, i);
                    n2 = i;
                }
                this.title[n] = string3.substring(n2 + 1);
            }
            return;
        }
        if ("delete" == string) {
            this.deleteMesh();
            return;
        }
        if ("reset" == string) {
            String string4 = (String)object;
            if (this.setMesh(string4) == null) {
                return;
            }
            this.deleteMesh();
            this.setMesh(string4);
            return;
        }
        if ("on" == string) {
            if (this.currentMesh != null) {
                this.currentMesh.visible = true;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].visible = true;
                }
            }
            return;
        }
        if ("off" == string) {
            if (this.currentMesh != null) {
                this.currentMesh.visible = false;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].visible = false;
                }
            }
            return;
        }
        if ("color" == string) {
            if (object == null) {
                return;
            }
            this.colix = Graphics3D.getColix(object);
            if (this.currentMesh != null) {
                this.currentMesh.colix = this.colix;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].colix = this.colix;
                }
            }
            return;
        }
        if ("translucency" == string) {
            boolean bl = ((String)object).equals("translucent");
            if (this.currentMesh != null) {
                this.currentMesh.setTranslucent(bl, this.translucentLevel);
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].setTranslucent(bl, this.translucentLevel);
                }
            }
            return;
        }
        boolean bl = "nodots" == string;
        if (bl || "dots" == string) {
            boolean bl2;
            boolean bl3 = bl2 = !bl && object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.showPoints = bl2;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].showPoints = bl2;
                }
            }
            return;
        }
        bl = "nomesh" == string;
        if (bl || "mesh" == string) {
            boolean bl4;
            boolean bl5 = bl4 = !bl && object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.drawTriangles = bl4;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].drawTriangles = bl4;
                }
            }
            return;
        }
        bl = "nofill" == string;
        if (bl || "fill" == string) {
            boolean bl6;
            boolean bl7 = bl6 = !bl && object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.fillTriangles = bl6;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].fillTriangles = bl6;
                }
            }
            return;
        }
        if ("triangles" == string) {
            boolean bl8;
            boolean bl9 = bl8 = object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.showTriangles = bl8;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].showTriangles = bl8;
                }
            }
            return;
        }
        if ("frontOnly" == string) {
            boolean bl10;
            boolean bl11 = bl10 = object == Boolean.TRUE;
            if (this.currentMesh != null) {
                this.currentMesh.frontOnly = bl10;
            } else {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.meshes[n].frontOnly = bl10;
                }
            }
            return;
        }
        bl = "lighting" == string;
        if (bl || Parser.isOneOf(string, "backlit;frontlit;fulllit")) {
            int n;
            int n3 = bl ? (Integer)object : ("frontlit" == string ? 0 : (n = "backlit" == string ? 1 : 2));
            if (this.currentMesh != null) {
                this.currentMesh.setLighting(n);
            } else {
                int n4 = this.meshCount;
                while (--n4 >= 0) {
                    this.meshes[n4].setLighting(n);
                }
            }
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public Object getProperty(String string, int n) {
        if (string == "count") {
            return new Integer(this.meshCount);
        }
        if (string == "ID") {
            return this.currentMesh == null ? (String)null : this.currentMesh.thisID;
        }
        if (string == "list") {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            for (int i = 0; i < this.meshCount; ++i) {
                if (this.meshes[i] == null || this.meshes[i].vertexCount == 0) continue;
                Mesh mesh = this.meshes[i];
                stringBuffer.append(++n2).append(" id:" + mesh.thisID).append("; model:" + this.viewer.getModelNumberDotted(mesh.modelIndex)).append("; vertices:" + mesh.vertexCount).append("; polygons:" + mesh.polygonCount).append("; visible:" + mesh.visible);
                if (mesh.title != null) {
                    String string2 = "";
                    for (int j = 0; j < mesh.title.length; ++j) {
                        string2 = string2 + (j == 0 ? "; title:" : " | ") + mesh.title[j];
                    }
                    if (string2.length() > 100) {
                        string2 = string2.substring(0, 100) + "...";
                    }
                    stringBuffer.append(string2);
                }
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private void deleteMesh() {
        if (this.explicitID && this.currentMesh != null) {
            int n = this.meshCount;
            while (this.meshes[--n] != this.currentMesh) {
            }
            this.deleteMesh(n);
        } else {
            int n = this.meshCount;
            while (--n >= 0) {
                this.meshes[n] = null;
            }
            this.meshCount = 0;
            this.nUnnamed = 0;
        }
        this.currentMesh = null;
    }

    public void deleteMesh(int n) {
        for (int i = n + 1; i < this.meshCount; ++i) {
            this.meshes[i - 1] = this.meshes[i];
        }
        this.meshes[--this.meshCount] = null;
    }

    public int getIndexFromName(String string) {
        if (string.equals("+PREVIOUS_MESH+")) {
            return this.meshCount - 1;
        }
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n] == null || !string.equals(this.meshes[n].thisID)) continue;
            return n;
        }
        return -1;
    }

    public void setModelIndex(int n, int n2) {
        if (this.currentMesh == null) {
            return;
        }
        this.currentMesh.visible = true;
        this.currentMesh.atomIndex = n;
        this.currentMesh.modelIndex = this.currentMesh.atomIndex >= 0 ? this.viewer.getAtomModelIndex(n) : (this.isFixed ? -1 : (n2 >= 0 ? n2 : this.viewer.getCurrentModelIndex()));
        this.currentMesh.scriptCommand = this.script;
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.meshCount; ++i) {
            String string = this.meshes[i].scriptCommand;
            if (string == null) continue;
            Mesh mesh = this.meshes[i];
            if (mesh.modelIndex > 0 && this.modelCount > 1) {
                Shape.appendCmd(stringBuffer, "frame " + this.viewer.getModelNumber(mesh.modelIndex));
            }
            stringBuffer.append(string).append("\n");
            if (string.charAt(0) == '#') continue;
            if (this.allowMesh) {
                Shape.appendCmd(stringBuffer, mesh.getState(this.myType));
            }
            if (!mesh.isColorSolid) continue;
            Shape.appendCmd(stringBuffer, this.getColorCommand("$" + mesh.thisID, mesh.colix));
        }
        return stringBuffer.toString();
    }

    public void setVisibilityFlags(BitSet bitSet) {
        int n = this.meshCount;
        while (--n >= 0) {
            Mesh mesh = this.meshes[n];
            mesh.visibilityFlags = mesh.visible && mesh.isValid && (mesh.modelIndex < 0 || bitSet.get(mesh.modelIndex) && (mesh.atomIndex < 0 || !this.modelSet.isAtomHidden(mesh.atomIndex))) ? this.myVisibilityFlag : 0;
        }
    }
}

