/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.shape.MeshRenderer;
import org.jmol.shapespecial.Draw;
import org.jmol.shapespecial.DrawMesh;

public class DrawRenderer
extends MeshRenderer {
    private int drawType;
    private DrawMesh dmesh;
    private final Point3i pt0 = new Point3i();
    private final Point3i pt3 = new Point3i();
    private final Point3i xyz = new Point3i();

    protected void render() {
        Draw draw = (Draw)this.shape;
        int n = draw.meshCount;
        while (--n >= 0) {
            this.dmesh = (DrawMesh)draw.meshes[n];
            this.render1(this.dmesh);
            this.renderInfo();
        }
    }

    protected boolean isPolygonDisplayable(int n) {
        return this.dmesh.polygonIndexes[n].length > 0 && (this.dmesh.modelFlags == null || this.dmesh.modelFlags[n] != 0);
    }

    protected void render2() {
        boolean bl = this.viewer.getPickingMode() == 4;
        this.drawType = this.dmesh.drawType;
        if ((this.drawType == 17 || this.drawType == 15) && this.vertexCount >= 2) {
            int n = this.dmesh.diameter > 0 ? this.dmesh.diameter : 3;
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.vertexCount - 1) {
                this.g3d.fillHermite(5, n, n, n, this.screens[n3], this.screens[n2], this.screens[n2 + 1], this.screens[n2 + (n2 + 2 == this.vertexCount ? 1 : 2)]);
                n3 = n2++;
            }
        }
        switch (this.drawType) {
            case 15: {
                Point3i point3i = this.screens[this.vertexCount - 2];
                Point3i point3i2 = this.screens[this.vertexCount - 1];
                Vector3f vector3f = new Vector3f(point3i2.x - point3i.x, point3i2.y - point3i.y, point3i2.z - point3i.z);
                int n = this.dmesh.diameter > 0 ? this.dmesh.diameter : 3;
                float f = vector3f.length();
                if (!(f > 0.0f)) break;
                vector3f.scale(5.0f / f);
                this.pt0.x = point3i2.x - (int)Math.floor(4.0f * vector3f.x);
                this.pt0.y = point3i2.y - (int)Math.floor(4.0f * vector3f.y);
                this.pt0.z = point3i2.z - (int)Math.floor(4.0f * vector3f.z);
                this.pt3.x = point3i2.x + (int)Math.floor(vector3f.x);
                this.pt3.y = point3i2.y + (int)Math.floor(vector3f.y);
                this.pt3.z = point3i2.z + (int)Math.floor(vector3f.z);
                this.g3d.fillCone((byte)2, n * 5, this.pt0, this.pt3);
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            default: {
                super.render2();
            }
        }
        if (bl) {
            this.renderHandles();
        }
    }

    private void renderHandles() {
        block0 : switch (this.drawType) {
            case -1: 
            case 1: 
            case 2: 
            case 4: 
            case 15: 
            case 16: 
            case 17: {
                int n = this.dmesh.polygonCount;
                while (--n >= 0) {
                    int[] nArray;
                    if (!this.isPolygonDisplayable(n) || (nArray = this.dmesh.polygonIndexes[n]) == null) continue;
                    int n2 = nArray.length;
                    while (--n2 >= 0) {
                        int n3 = nArray[n2];
                        this.g3d.fillScreenedCircleCentered((short)23, 10, this.screens[n3].x, this.screens[n3].y, this.screens[n3].z);
                    }
                    break block0;
                }
                break;
            }
        }
    }

    private void renderInfo() {
        if (this.dmesh == null || this.dmesh.title == null || this.dmesh.visibilityFlags == 0 || this.viewer.getDrawHover() || !this.g3d.setColix(this.viewer.getColixBackgroundContrast())) {
            return;
        }
        byte by = this.g3d.getFontFid("SansSerif", 14);
        this.g3d.setFont(by);
        if (this.dmesh.title[0].length() > 0) {
            this.viewer.transformPoint(this.vertices[0], this.xyz);
            this.g3d.drawString(this.dmesh.title[0], null, this.xyz.x + 5, this.xyz.y - 5, this.xyz.z, this.xyz.z);
        }
    }
}

