#!/usr/bin/perl

# postscripttest.pl - script to test for necessary postscript tools on system
#
# $Id: postscripttest.pl,v 1.2 2003/02/03 18:03:52 harris41 Exp $
#
###

=pod

=head1 NAME

B<postscripttest.pl> - Test for necessary postscript tools on system

=cut

# Written to help LON-CAPA (The LearningOnline Network with CAPA)
#
# YEAR=2002

=pod

=head1 SYNOPSIS

perl postscripttest.pl

This script is ordinarily located inside the LON-CAPA source code tree.
This script is normally invoked by test-related targets inside
F<loncapa/loncom/build/Makefile>.

=head1 DESCRIPTION

This program tests the status of postscript utilities on a LON-CAPA server.
For instance, the ps2pdf utility is critically important for providing
the manual in a pdf format.

=head1 AUTHOR

This software is distributed under the General Public License,
version 2, June 1991 (which is the same terms as LON-CAPA).

This is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This software is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this software; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

=cut

# =================================== Process version information of this file.
my $VERSION = sprintf("%d.%02d", q$Revision: 1.2 $ =~ /(\d+)\.(\d+)/);

print('Running postscripttest.pl, version '.$VERSION.'.'."\n");
print('(Test for needed utilities like ps2pdf.)'."\n");

my $ps2pdf_flag=0;
foreach my $dir (split(/\:/,$ENV{'PATH'})) {
    next if /^\/home/;
    if (-x "$dir/ps2pdf") {
	$ps2pdf_flag="$dir/ps2pdf";
    }
}
if ($ps2pdf_flag) {
    print("Checking for ps2pdf...found at ${ps2pdf_flag}.\n");
}
else {
    print("**** ERROR **** Cannot find ps2pdf in the path!\n");
    exit(1);
}
