#!/usr/bin/perl
$|=1;
# Runs loncron
# $Id: loncron.pl,v 1.7 2008/12/25 01:56:03 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;

use lib '/home/httpd/lib/perl/';
use Apache::lonlocal;
use LONCAPA::Configuration;
use LONCAPA::loncgi;
use LONCAPA::lonauthcgi;

print("Content-type: text/html\n\n");

&main();

sub main {
    if (!&LONCAPA::lonauthcgi::check_ipbased_access('loncron')) {
        if (!&LONCAPA::loncgi::check_cookie_and_load_env()) {
            &Apache::lonlocal::get_language_handle();
            print(&LONCAPA::loncgi::missing_cookie_msg());
            return;
        }

        if (!&LONCAPA::lonauthcgi::can_view('loncron')) {
            &Apache::lonlocal::get_language_handle();
            print(&LONCAPA::lonauthcgi::unauthorized_msg('loncron'));
            return;
        }
    }

    &Apache::lonlocal::get_language_handle();
    print '<html><body bgcolor="#FFFFFF"><h1>'.
          &Apache::lonlocal::mt('Running loncron ...').'</h1>'.
          &Apache::lonlocal::mt('Please be patient').'<p><pre>'."\n";
    open (DFH,"/home/httpd/perl/loncron --noemail|");
    while (my $line=<DFH>) { 
        print "$line";
    }
    close(DFH);
    print '</pre></p><p><a href="/lon-status/">'.&Apache::lonlocal::mt('Status Report').
          '</a></p>';
    print '<p><a href="/lon-status/loncstatus.txt">'.&Apache::lonlocal::mt('LONC report.').
          '</a></p>';
    print '<p><a href="/lon-status/londstatus.txt">'.&Apache::lonlocal::mt('LOND report').
          '</a></p></body></html>';
    return;
}
