#!/usr/bin/perl
$|=1;
# Take machine online
#
# $Id: takeonline.pl,v 1.4 2008/12/25 01:56:03 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;
use lib '/home/httpd/lib/perl/';
use Apache::lonlocal;
use LONCAPA::loncgi;
use LONCAPA::lonauthcgi;

print "Content-type: text/html\n\n";

&main();

sub main {
    if (!&LONCAPA::lonauthcgi::check_ipbased_access('takeonline')) {
        if (!&LONCAPA::loncgi::check_cookie_and_load_env()) {
            &Apache::lonlocal::get_language_handle();
            print &LONCAPA::loncgi::missing_cookie_msg();
            return;
        }

        if (!&LONCAPA::lonauthcgi::can_view('takeonline')) {
            &Apache::lonlocal::get_language_handle();
            print &LONCAPA::lonauthcgi::unauthorized_msg('takeonline');
            return;
        }
    }

    &Apache::lonlocal::get_language_handle();

    print '<html><body bgcolor="#FFFFFF"><h1>'.&Apache::lonlocal::mt('Take Online').'</h1>';
    system('cp /home/httpd/html/origindex.html /home/httpd/html/index.html');
    system('rm /home/httpd/html/lon-status/reroute.txt');
    print '</body></html>';
}
