#
# $Id: user_login_count.pl,v 1.3 2005/04/07 03:58:02 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;
use File::Find;
use POSIX qw(strftime);
use lib '/home/httpd/lib/perl/';
use LONCAPA::Configuration;
use Date::Manip;

my $start_time=&UnixDate("Aug 30th 00:00:00 2004","%s");
my @counts=('1','10','100','1000','10000','100000','250000');
my @ignored_users=('^itds\d+$');


sub only_user_activitylog_files {
    print (join("\n",@_));
    return 1;
}

my %data;
my $numusers;
sub process_activitylog_file {
    if ($File::Find::dir=~m|/\d/\d/\d/|) { return; }
    if ($_ ne 'activity.log') {	return; }
    open(FILE,"<$File::Find::name");
    $numusers++;
    my $user=(split('/',$File::Find::dir))[-1];
    foreach my $expr (@ignored_users) {
	if ($user=~/$expr/) { print("\nignoring $user\n"); return; }
    }
    while (my $line=<FILE>) {
	if ($line !~ /Login/) { next; }
	my ($date)=split(':',$line,2);
	if ($date > $start_time) { $data{$user}++; }
    }
    if ($numusers%100 == 0) {
	print "\b\b\b\b\b\b\b\b\b\b\b\b\b\bDid $user";
    }
}

sub print_data {
    my $total_login=0;
    my %byday;
    print("\n");
  my $i=0;
    foreach my $key (sort {$data{$b} <=> $data{$a}} (keys(%data))) {
        $i++;
        print "$key -> $data{$key}\n";
        if ($i>50) { last; }
    }

}

$|=1;
sub main {
    my $perlvar=LONCAPA::Configuration::read_conf('loncapa.conf');
    find(
         {
#          preprocess => \&only_user_activitylog_files,
#          wanted     => \&print_filename,
#          wanted     => \&log_metadata,
	     wanted     => \&process_activitylog_file,
	 }, 
         $perlvar->{'lonUsersDir'}.'/'.$perlvar->{'lonDefDomain'});
    &print_data();
}
&main();

