# The LearningOnline Network with CAPA
#
# $Id: lonhelp.pm,v 1.40 2011/01/04 21:53:23 raeburn Exp $
#
# .tex help system web server handler
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# .tex file help handler


package Apache::lonhelp;

use strict;
use Apache::Constants qw(:common :http);
use Apache::File();
use Apache::loncommon();
use Apache::lonacc();
use Apache::lontexconvert();
use Apache::lonnavmaps; # for advancedUser
use Apache::lonlocal;
use Apache::lonnet;
use tth();
use GDBM_File();
use lib '/home/httpd/lib/perl/';
use LONCAPA;
 

# This sub takes the name of a label in, and converts it to something
# that is a valid anchor name.

sub processLabelName {
    my ($name) = @_;
    $name =~ tr/a-zA-Z0-9/_/cs;
    return $name;
}

# Serve out the text
sub servetext {
    my ($r,$text) = @_;
    my $bugs=&Apache::loncommon::help_open_bug('Documentation',&mt('Report a documentation bug'));
    my $morehelp;#=&Apache::loncommon::help_open_menu(undef,undef,1,undef,undef,undef,undef,'Help and Assistance Menu');
    my $header=&mt('LON-CAPA Help');
    $r->print(<<HEADER);
    <h3 style="font: sans-serif"><img align="right" alt="help logo"
    src="/adm/help/gif/lonhelpheader.gif"/>$header</h3><hr />
    <!-- BEGIN -->
HEADER

    $r->print($text);

    if (&Apache::lonnavmaps::advancedUser()) {
	my $search=&mt('Search LON-CAPA help');
        my $query=&mt('Search');
	my $uri = $r->uri;
	$r->print(<<FOOTER);
    <hr /><form action="$uri" method="post">
<label>$search: <input type="text" name="searchterm" size="40" /></label><input type="submit" value="$query" />
</form>
<br />
$bugs
$morehelp
FOOTER
 
    }

    $r->print(<<ENDBODY);
    <!-- END -->
ENDBODY

}

# Render takes a tex fragment, transforms it for TtH, and returns the
# HTML equivalent
sub render {
    my ($tex, $docroot) = @_;
    tie (my %fragmentLabels, 'GDBM_File', $docroot . '/adm/help/fragmentLabels.gdbm', 0, 0);

    # This tells TtH what to do with captions, labels, and other
    # things
    $tex = "\\documentclass{article}\n" . $tex;

    # We process these ourselves because TtH can't handle then without
    # LaTeX .aux files
    # absolute paths for use with help.loncapa.org
    $tex =~ s|  \\ref\{([^}]*)\}
             |
              my $label=$1;
              my $icon='/adm/help/help.png';
              my $ext;
              if ($1!~/\.hlp$/) {
                  if (($1 =~ /^\w+\.manual\.pdf$/) && (-e $docroot.'/adm/help/'.$1)) {
                     $icon = '/adm/lonIcons/pdf.gif';
                  } elsif ((!exists($fragmentLabels{$1})) && ($1!~/\.hlp$/)) {
	             &Apache::lonnet::logthis("ERROR: $1 not a valid help label");
                     $label='Error';
                  } else {
                     $label=substr($fragmentLabels{$1}, 0, -4);
                     $ext = '.hlp#' . &processLabelName($1);
		  }
	      } else {
		  $label=~s/\.hlp$//;
                  $ext = '.hlp#' . &processLabelName($1);
	      }
             '\\begin{html}<a href="/adm/help/'.
              $label .
              $ext . 
             '"><img src="'.$icon.'" border="0" /></a>' .
             '\\end{html}'
             |gxe;

    # Backslashes
    $tex =~ s|\\textbackslash|###BACKSLASH###|g;

    # Figures leftover without captions
    $tex =~ s|  \\includegraphics(\[[^]]*\])*\{([^}]*)\}
             |  '\\begin{html}<img src="/adm/help/gif/' . $2 . '.gif" border="2"'.
                ' bordercolor="#000000"/>\\end{html}'
             |gxe;


    $tex=&Apache::lontexconvert::tth_converted(\$tex);
    
    # Finish backslashes
    $tex =~ s/###BACKSLASH###/'\\'/ge;
 
    # Fix the pretty quotes
    $tex =~ s/('')|(``)/&quot;/g; #" to get emacs syntax highlighter happy

    # For some reason all captions come out as "Figure 0:", so
    # just duck the issue...

    $tex =~ s/Figure 0://g;
    $tex.=$Apache::lontexconvert::errorstring;
    untie %fragmentLabels;

    return $tex;
}

sub listmatches {
    my ($docroot,$term,$subdir) =@_;
    unless ($subdir) { $subdir=''; }
    my $output='';
    opendir(DIR,$docroot.'/adm/help/tex/'.$subdir);
    foreach my $filename (sort readdir(DIR)) {
	if ($filename=~/\.tex$/) {
	    open(FH,$docroot.'/adm/help/tex/'.$subdir.$filename);
	    my $quote='';
	    while (my $line=<FH>) {
		if ($line=~/\Q$term\E/i) {
		    $line=~s/\\\w+//gs;
		    $line=~s/\{//gs;
		    $line=~s/\}//gs;
		    $line=~s/\\/ /gs;
                    $line=~s/\</\&lt\;/gs;
                    $line=~s/\>/\&gt\;/gs;
		    $line=~s/(\Q$term\E)/\<b\>$1\<\/b\>/gsi;
		    $quote.='<br />...'.$line.'...';
		}
	    }
	    close(FH);
	    if ($quote) {
		my $title=$filename;
                $title=~s/\_/ /gs;
                $title=~s/\.tex$//;
                $filename=~s/\.tex$/\.hlp/;
		$output.='<li><a href="/adm/help/tex/'.$subdir.$filename.'">'.$title.'</a>'.$quote.'</li>';
	    }
	}
    }
    closedir(DIR);
    return (($output?'<ul>'.$output.'</ul>':&mt('"[_1]" not found',$term)),$output);
}

sub handler {
     my $r = shift;

     my $docroot = $r->dir_config('lonDocRoot');

     &Apache::lonlocal::get_language_handle($r);
     &Apache::loncommon::content_type($r,"text/html");
     my $start_page=
	 &Apache::loncommon::start_page('LON-CAPA Help',undef,
					{'only_body' => 1,});
     my $text='';
     if ($env{'form.searchterm'}=~/\w/) {
	 ($text,my $matches)=&listmatches($docroot,$env{'form.searchterm'},&Apache::lonlocal::current_language().'/');
         if ($matches) {
             my ($englishresult,$englishmatches)=&listmatches($docroot,$env{'form.searchterm'});
             if ($englishmatches) {
                $text.='<hr />'.$englishresult;
             }
         } else {
             $text=&listmatches($docroot,$env{'form.searchterm'}); 
         }
     } else {
	 my $filenames = &unescape(substr($ENV{'REQUEST_URI'} , 
					  rindex($ENV{'REQUEST_URI'}, '/') + 1, -4));
	 
	 # Security check on the file; the whole filename must consist
	 # of nothing but alphanums, ' ,, or ., or the file
	 # will be "not found", no matter what.
	 
	 return HTTP_NOT_FOUND if ($filenames !~ /\A[-0-9a-zA-z_'',:.]+\Z/);
	 
	 # Join together the tex files, return HTTP_NOT_FOUND if any of
	 # them are not found
	 my $tex = '';
	 # Since in insertlist.tab I want to specify multiple files,
	 # and insertlist.tab also uses commas, I need something else
	 # so replace : with ,
	 $filenames =~ s/:/,/g;
	 my @files = split(/,/, $filenames);
	 
	 for my $filename (@files) {
	     if (-e $docroot.'/adm/help/tex/'.
		 &Apache::lonlocal::current_language().'/'.
		 $filename.'.tex') {
		 $filename=&Apache::lonlocal::current_language().'/'.$filename;
	     }
	     (my $file = Apache::File->new($docroot
					   . '/adm/help/tex/'.$filename.'.tex'))
	         or return HTTP_NOT_FOUND;
	     $tex .= join('', <$file>);
	 }

	 $text = &render($tex, $docroot);
     }

     $r->send_http_header;
     $r->print($start_page);
     &servetext($r,$text);
     $r->print(&Apache::loncommon::end_page());

     return OK;
}

1;
