# The LearningOnline Network with CAPA
# displays the main menu
#
# $Id: lonmainmenu.pm,v 1.8 2009/07/13 08:24:21 www Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
#
# There are two parameters controlling the action of this module:
#
# browser.interface - if this is 'textual', it overrides the second parameter
# and goes to screen reader PDA mode
#
# environment.remote - if this is 'on', the routines controll the remote
# control, otherwise they render the main window controls; ignored it
# browser.interface is 'textual'
#

package Apache::lonmainmenu;

use strict;
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonnet;
use Apache::lonmenu();

sub handler {
    my $r = shift;
    &Apache::loncommon::no_cache($r);
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    my $form;
    if ($env{'environment.remote'} ne 'off') {
	$form=&Apache::lonmenu::serverform();
    }

    my $script_tag;
    if ($env{'environment.remote'} ne 'off') {
        my $utility=&Apache::lonmenu::utilityfunctions('/adm/menu');
        $script_tag=(<<ENDSCRIPT);
<script type="text/javascript">
$utility
</script>
ENDSCRIPT
    }
# ---- Print the screen, pretend to be in text mode to generate text-based menu
# temporarily set interface to "faketextual" and remote to "off", which renders
# the main menu
    $env{'browser.interface'}='faketextual';
    $env{'environment.remote'}='off';

    $r->print(&Apache::loncommon::start_page( 'Main Menu',
                                              $script_tag,
                                              {'bread_crumbs' => 1}));
    $r->print(&Apache::lonmenu::inlinemenu().$form);
    $r->print(&Apache::loncommon::end_page());
    return OK;
}


1;
__END__







